/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.client.socket;

import android.os.Handler;
import android.os.Looper;
import io.getstream.chat.android.client.logger.ChatLogger;
import io.getstream.chat.android.client.logger.TaggedLogger;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001cB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010\u0017\u001a\u00020\nH\u0002J\u0006\u0010\u0018\u001a\u00020\u0014J\b\u0010\u0012\u001a\u00020\u0014H\u0002J\b\u0010\u0019\u001a\u00020\u0014H\u0002J\u0006\u0010\u001a\u001a\u00020\u0014J\u0006\u0010\u001b\u001a\u00020\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lio/getstream/chat/android/client/socket/HealthMonitor;", "", "healthCallback", "Lio/getstream/chat/android/client/socket/HealthMonitor$HealthCallback;", "(Lio/getstream/chat/android/client/socket/HealthMonitor$HealthCallback;)V", "consecutiveFailures", "", "delayHandler", "Landroid/os/Handler;", "disconnected", "", "healthCheck", "Ljava/lang/Runnable;", "lastEventDate", "Ljava/util/Date;", "logger", "Lio/getstream/chat/android/client/logger/TaggedLogger;", "monitor", "reconnect", "ack", "", "getRetryInterval", "", "needToReconnect", "onDisconnected", "resetHealthMonitor", "start", "stop", "HealthCallback", "stream-chat-android-client_release"})
public final class HealthMonitor {
    private final Handler delayHandler;
    private int consecutiveFailures;
    private boolean disconnected;
    private Date lastEventDate;
    private final TaggedLogger logger;
    private final Runnable reconnect;
    private final Runnable healthCheck;
    private final Runnable monitor;
    private final HealthCallback healthCallback;

    public final void start() {
        this.lastEventDate = new Date();
        this.disconnected = false;
        this.resetHealthMonitor();
    }

    public final void stop() {
        this.delayHandler.removeCallbacks(this.monitor);
        this.delayHandler.removeCallbacks(this.reconnect);
        this.delayHandler.removeCallbacks(this.healthCheck);
    }

    public final void ack() {
        this.lastEventDate = new Date();
        this.delayHandler.removeCallbacks(this.reconnect);
        this.disconnected = false;
        this.consecutiveFailures = 0;
    }

    public final void onDisconnected() {
        this.disconnected = true;
        this.resetHealthMonitor();
    }

    private final void resetHealthMonitor() {
        this.stop();
        this.delayHandler.postDelayed(this.monitor, 1000L);
    }

    private final void reconnect() {
        this.stop();
        HealthMonitor healthMonitor2 = this;
        ++healthMonitor2.consecutiveFailures;
        long retryInterval = this.getRetryInterval(healthMonitor2.consecutiveFailures);
        this.logger.logI("Next connection attempt in " + retryInterval + " ms");
        this.delayHandler.postDelayed(this.reconnect, retryInterval);
    }

    private final boolean needToReconnect() {
        return this.disconnected || new Date().getTime() - this.lastEventDate.getTime() >= 30000L;
    }

    private final long getRetryInterval(int consecutiveFailures) {
        int n = 500 + consecutiveFailures * 2000;
        int n2 = 25000;
        int n3 = 0;
        int max = Math.min(n, n2);
        n2 = 250;
        n3 = (consecutiveFailures - 1) * 2000;
        boolean bl = false;
        n2 = Math.max(n2, n3);
        n3 = 25000;
        bl = false;
        int min = Math.min(n2, n3);
        double d = Math.random() * (double)(max - min) + (double)min;
        bl = false;
        return (long)Math.floor(d);
    }

    public HealthMonitor(@NotNull HealthCallback healthCallback) {
        Intrinsics.checkNotNullParameter((Object)healthCallback, (String)"healthCallback");
        this.healthCallback = healthCallback;
        this.delayHandler = new Handler(Looper.getMainLooper());
        this.lastEventDate = new Date();
        this.logger = ChatLogger.Companion.get("SocketMonitor");
        this.reconnect = new Runnable(this){
            final /* synthetic */ HealthMonitor this$0;

            public final void run() {
                if (HealthMonitor.access$needToReconnect(this.this$0)) {
                    HealthMonitor.access$getHealthCallback$p(this.this$0).reconnect();
                }
            }
            {
                this.this$0 = healthMonitor2;
            }
        };
        this.healthCheck = new Runnable(this){
            final /* synthetic */ HealthMonitor this$0;

            public final void run() {
                HealthMonitor.access$getHealthCallback$p(this.this$0).check();
                HealthMonitor.access$getDelayHandler$p(this.this$0).postDelayed(HealthMonitor.access$getMonitor$p(this.this$0), 10000L);
            }
            {
                this.this$0 = healthMonitor2;
            }
        };
        this.monitor = new Runnable(this){
            final /* synthetic */ HealthMonitor this$0;

            public final void run() {
                if (HealthMonitor.access$needToReconnect(this.this$0)) {
                    HealthMonitor.access$reconnect(this.this$0);
                } else {
                    HealthMonitor.access$getDelayHandler$p(this.this$0).postDelayed(HealthMonitor.access$getHealthCheck$p(this.this$0), 1000L);
                }
            }
            {
                this.this$0 = healthMonitor2;
            }
        };
    }

    public static final /* synthetic */ boolean access$needToReconnect(HealthMonitor $this) {
        return $this.needToReconnect();
    }

    public static final /* synthetic */ HealthCallback access$getHealthCallback$p(HealthMonitor $this) {
        return $this.healthCallback;
    }

    public static final /* synthetic */ Handler access$getDelayHandler$p(HealthMonitor $this) {
        return $this.delayHandler;
    }

    public static final /* synthetic */ Runnable access$getMonitor$p(HealthMonitor $this) {
        return $this.monitor;
    }

    public static final /* synthetic */ void access$reconnect(HealthMonitor $this) {
        $this.reconnect();
    }

    public static final /* synthetic */ Runnable access$getHealthCheck$p(HealthMonitor $this) {
        return $this.healthCheck;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\b\u0010\u0004\u001a\u00020\u0003H&\u00a8\u0006\u0005"}, d2={"Lio/getstream/chat/android/client/socket/HealthMonitor$HealthCallback;", "", "check", "", "reconnect", "stream-chat-android-client_release"})
    public static interface HealthCallback {
        public void check();

        public void reconnect();
    }
}

