/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.client.socket;

import io.getstream.chat.android.client.models.User;
import io.getstream.chat.android.client.network.NetworkStateProvider;
import io.getstream.chat.android.client.parser.ChatParser;
import io.getstream.chat.android.client.socket.ChatSocket;
import io.getstream.chat.android.client.socket.ChatSocketServiceImpl;
import io.getstream.chat.android.client.socket.EventsParser;
import io.getstream.chat.android.client.socket.SocketFactory;
import io.getstream.chat.android.client.socket.SocketListener;
import io.getstream.chat.android.client.token.TokenManager;
import io.getstream.chat.android.client.utils.observable.ChatObservable;
import io.getstream.chat.android.client.utils.observable.ChatObservableImpl;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0011H\u0016J\b\u0010\u0018\u001a\u00020\u0011H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lio/getstream/chat/android/client/socket/ChatSocketImpl;", "Lio/getstream/chat/android/client/socket/ChatSocket;", "apiKey", "", "wssUrl", "tokenManager", "Lio/getstream/chat/android/client/token/TokenManager;", "parser", "Lio/getstream/chat/android/client/parser/ChatParser;", "networkStateProvider", "Lio/getstream/chat/android/client/network/NetworkStateProvider;", "(Ljava/lang/String;Ljava/lang/String;Lio/getstream/chat/android/client/token/TokenManager;Lio/getstream/chat/android/client/parser/ChatParser;Lio/getstream/chat/android/client/network/NetworkStateProvider;)V", "eventsParser", "Lio/getstream/chat/android/client/socket/EventsParser;", "service", "Lio/getstream/chat/android/client/socket/ChatSocketServiceImpl;", "addListener", "", "listener", "Lio/getstream/chat/android/client/socket/SocketListener;", "connect", "user", "Lio/getstream/chat/android/client/models/User;", "connectAnonymously", "disconnect", "events", "Lio/getstream/chat/android/client/utils/observable/ChatObservable;", "removeListener", "stream-chat-android-client_release"})
public final class ChatSocketImpl
implements ChatSocket {
    private final EventsParser eventsParser;
    private final ChatSocketServiceImpl service;
    private final String apiKey;
    private final String wssUrl;

    @Override
    public void connectAnonymously() {
        this.service.connect(this.wssUrl, this.apiKey, null);
    }

    @Override
    public void connect(@NotNull User user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        this.service.connect(this.wssUrl, this.apiKey, user);
    }

    @Override
    @NotNull
    public ChatObservable events() {
        return new ChatObservableImpl(this.service);
    }

    @Override
    public void disconnect() {
        this.service.disconnect();
    }

    @Override
    public void addListener(@NotNull SocketListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.service.addListener(listener);
    }

    @Override
    public void removeListener(@NotNull SocketListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.service.removeListener(listener);
    }

    public ChatSocketImpl(@NotNull String apiKey, @NotNull String wssUrl, @NotNull TokenManager tokenManager, @NotNull ChatParser parser, @NotNull NetworkStateProvider networkStateProvider) {
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        Intrinsics.checkNotNullParameter((Object)wssUrl, (String)"wssUrl");
        Intrinsics.checkNotNullParameter((Object)tokenManager, (String)"tokenManager");
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        Intrinsics.checkNotNullParameter((Object)networkStateProvider, (String)"networkStateProvider");
        this.apiKey = apiKey;
        this.wssUrl = wssUrl;
        this.eventsParser = new EventsParser(parser);
        this.service = ChatSocketServiceImpl.Companion.create(tokenManager, new SocketFactory(this.eventsParser, parser, tokenManager), this.eventsParser, networkStateProvider);
    }
}

