/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.client.utils.observable;

import io.getstream.chat.android.client.errors.ChatError;
import io.getstream.chat.android.client.events.ChatEvent;
import io.getstream.chat.android.client.events.ConnectedEvent;
import io.getstream.chat.android.client.events.ConnectingEvent;
import io.getstream.chat.android.client.events.DisconnectedEvent;
import io.getstream.chat.android.client.events.ErrorEvent;
import io.getstream.chat.android.client.socket.ChatSocket;
import io.getstream.chat.android.client.socket.SocketListener;
import io.getstream.chat.android.client.utils.observable.ChatEventsObservable;
import io.getstream.chat.android.client.utils.observable.Disposable;
import io.getstream.chat.android.client.utils.observable.EventSubscription;
import io.getstream.chat.android.client.utils.observable.SubscriptionImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0018B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0002J\b\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J0\u0010\u0012\u001a\u00020\u000b2\u0014\b\u0002\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00150\u00142\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u000e0\u0014J0\u0010\u0017\u001a\u00020\u000b2\u0014\b\u0002\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00150\u00142\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u000e0\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lio/getstream/chat/android/client/utils/observable/ChatEventsObservable;", "", "socket", "Lio/getstream/chat/android/client/socket/ChatSocket;", "(Lio/getstream/chat/android/client/socket/ChatSocket;)V", "eventsMapper", "Lio/getstream/chat/android/client/utils/observable/ChatEventsObservable$EventsMapper;", "subscriptions", "", "Lio/getstream/chat/android/client/utils/observable/EventSubscription;", "addSubscription", "Lio/getstream/chat/android/client/utils/observable/Disposable;", "subscription", "checkIfEmpty", "", "onNext", "event", "Lio/getstream/chat/android/client/events/ChatEvent;", "subscribe", "filter", "Lkotlin/Function1;", "", "listener", "subscribeSingle", "EventsMapper", "stream-chat-android-client_release"})
public final class ChatEventsObservable {
    private Set<? extends EventSubscription> subscriptions;
    private EventsMapper eventsMapper;
    private final ChatSocket socket;

    /*
     * WARNING - void declaration
     */
    private final void onNext(ChatEvent event) {
        void $this$filterNotTo$iv$iv;
        void $this$filterNot$iv;
        Iterable $this$forEach$iv = this.subscriptions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EventSubscription subscription = (EventSubscription)element$iv;
            boolean bl = false;
            if (subscription.isDisposed()) continue;
            subscription.onNext(event);
        }
        $this$forEach$iv = this.subscriptions;
        ChatEventsObservable chatEventsObservable = this;
        boolean $i$f$filterNot = false;
        Iterator iterator = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        Iterator iterator2 = $this$filterNotTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv$iv;
            Object receiver = element$iv$iv = iterator2.next();
            boolean bl = false;
            if (((Disposable)receiver).isDisposed()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list = (List)destination$iv$iv;
        chatEventsObservable.subscriptions = CollectionsKt.toSet((Iterable)list);
        this.checkIfEmpty();
    }

    private final void checkIfEmpty() {
        if (this.subscriptions.isEmpty()) {
            this.socket.removeListener(this.eventsMapper);
        }
    }

    @NotNull
    public final Disposable subscribe(@NotNull Function1<? super ChatEvent, Boolean> filter2, @NotNull Function1<? super ChatEvent, Unit> listener) {
        Intrinsics.checkNotNullParameter(filter2, (String)"filter");
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        return this.addSubscription(new SubscriptionImpl(filter2, listener));
    }

    public static /* synthetic */ Disposable subscribe$default(ChatEventsObservable chatEventsObservable, Function1 function1, Function1 function12, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = subscribe.1.INSTANCE;
        }
        return chatEventsObservable.subscribe((Function1<? super ChatEvent, Boolean>)function1, (Function1<? super ChatEvent, Unit>)function12);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Disposable subscribeSingle(@NotNull Function1<? super ChatEvent, Boolean> filter2, @NotNull Function1<? super ChatEvent, Unit> listener) {
        void $this$apply;
        Intrinsics.checkNotNullParameter(filter2, (String)"filter");
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        SubscriptionImpl subscriptionImpl = new SubscriptionImpl(filter2, listener);
        boolean bl = false;
        boolean bl2 = false;
        SubscriptionImpl subscriptionImpl2 = subscriptionImpl;
        ChatEventsObservable chatEventsObservable = this;
        boolean bl3 = false;
        $this$apply.setAfterEventDelivered((Function0<Unit>)((Function0)new Function0<Unit>((SubscriptionImpl)$this$apply){

            public final void invoke() {
                ((SubscriptionImpl)this.receiver).dispose();
            }
        }));
        Unit unit = Unit.INSTANCE;
        return chatEventsObservable.addSubscription(subscriptionImpl);
    }

    public static /* synthetic */ Disposable subscribeSingle$default(ChatEventsObservable chatEventsObservable, Function1 function1, Function1 function12, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = subscribeSingle.1.INSTANCE;
        }
        return chatEventsObservable.subscribeSingle((Function1<? super ChatEvent, Boolean>)function1, (Function1<? super ChatEvent, Unit>)function12);
    }

    private final Disposable addSubscription(EventSubscription subscription) {
        if (this.subscriptions.isEmpty()) {
            this.socket.addListener(this.eventsMapper);
        }
        this.subscriptions = SetsKt.plus(this.subscriptions, (Object)subscription);
        return subscription;
    }

    public ChatEventsObservable(@NotNull ChatSocket socket) {
        Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
        this.socket = socket;
        boolean bl = false;
        this.subscriptions = SetsKt.emptySet();
        this.eventsMapper = new EventsMapper(this);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\u0006H\u0016J\b\u0010\n\u001a\u00020\u0006H\u0016J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lio/getstream/chat/android/client/utils/observable/ChatEventsObservable$EventsMapper;", "Lio/getstream/chat/android/client/socket/SocketListener;", "observable", "Lio/getstream/chat/android/client/utils/observable/ChatEventsObservable;", "(Lio/getstream/chat/android/client/utils/observable/ChatEventsObservable;)V", "onConnected", "", "event", "Lio/getstream/chat/android/client/events/ConnectedEvent;", "onConnecting", "onDisconnected", "onError", "error", "Lio/getstream/chat/android/client/errors/ChatError;", "onEvent", "Lio/getstream/chat/android/client/events/ChatEvent;", "stream-chat-android-client_release"})
    private static final class EventsMapper
    extends SocketListener {
        private final ChatEventsObservable observable;

        @Override
        public void onConnecting() {
            this.observable.onNext(new ConnectingEvent("connection.connecting", new Date()));
        }

        @Override
        public void onConnected(@NotNull ConnectedEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.observable.onNext(event);
        }

        @Override
        public void onDisconnected() {
            this.observable.onNext(new DisconnectedEvent("connection.disconnected", new Date()));
        }

        @Override
        public void onEvent(@NotNull ChatEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.observable.onNext(event);
        }

        @Override
        public void onError(@NotNull ChatError error) {
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            this.observable.onNext(new ErrorEvent("connection.error", new Date(), error));
        }

        public EventsMapper(@NotNull ChatEventsObservable observable2) {
            Intrinsics.checkNotNullParameter((Object)observable2, (String)"observable");
            this.observable = observable2;
        }
    }
}

