/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.client.channel;

import androidx.lifecycle.LifecycleOwner;
import io.getstream.chat.android.client.ChatClient;
import io.getstream.chat.android.client.api.models.QueryChannelRequest;
import io.getstream.chat.android.client.api.models.QuerySort;
import io.getstream.chat.android.client.api.models.SendActionRequest;
import io.getstream.chat.android.client.api.models.WatchChannelRequest;
import io.getstream.chat.android.client.call.Call;
import io.getstream.chat.android.client.controllers.ChannelController;
import io.getstream.chat.android.client.events.ChannelCreatedEvent;
import io.getstream.chat.android.client.events.ChannelDeletedEvent;
import io.getstream.chat.android.client.events.ChannelHiddenEvent;
import io.getstream.chat.android.client.events.ChannelMuteEvent;
import io.getstream.chat.android.client.events.ChannelTruncatedEvent;
import io.getstream.chat.android.client.events.ChannelUnmuteEvent;
import io.getstream.chat.android.client.events.ChannelUpdatedByUserEvent;
import io.getstream.chat.android.client.events.ChannelUpdatedEvent;
import io.getstream.chat.android.client.events.ChannelUserBannedEvent;
import io.getstream.chat.android.client.events.ChannelUserUnbannedEvent;
import io.getstream.chat.android.client.events.ChannelVisibleEvent;
import io.getstream.chat.android.client.events.ChannelsMuteEvent;
import io.getstream.chat.android.client.events.ChannelsUnmuteEvent;
import io.getstream.chat.android.client.events.ChatEvent;
import io.getstream.chat.android.client.events.ConnectedEvent;
import io.getstream.chat.android.client.events.ConnectingEvent;
import io.getstream.chat.android.client.events.DisconnectedEvent;
import io.getstream.chat.android.client.events.ErrorEvent;
import io.getstream.chat.android.client.events.GlobalUserBannedEvent;
import io.getstream.chat.android.client.events.GlobalUserUnbannedEvent;
import io.getstream.chat.android.client.events.HealthEvent;
import io.getstream.chat.android.client.events.MarkAllReadEvent;
import io.getstream.chat.android.client.events.MemberAddedEvent;
import io.getstream.chat.android.client.events.MemberRemovedEvent;
import io.getstream.chat.android.client.events.MemberUpdatedEvent;
import io.getstream.chat.android.client.events.MessageDeletedEvent;
import io.getstream.chat.android.client.events.MessageReadEvent;
import io.getstream.chat.android.client.events.MessageUpdatedEvent;
import io.getstream.chat.android.client.events.NewMessageEvent;
import io.getstream.chat.android.client.events.NotificationAddedToChannelEvent;
import io.getstream.chat.android.client.events.NotificationChannelDeletedEvent;
import io.getstream.chat.android.client.events.NotificationChannelMutesUpdatedEvent;
import io.getstream.chat.android.client.events.NotificationChannelTruncatedEvent;
import io.getstream.chat.android.client.events.NotificationInviteAcceptedEvent;
import io.getstream.chat.android.client.events.NotificationInvitedEvent;
import io.getstream.chat.android.client.events.NotificationMarkReadEvent;
import io.getstream.chat.android.client.events.NotificationMessageNewEvent;
import io.getstream.chat.android.client.events.NotificationMutesUpdatedEvent;
import io.getstream.chat.android.client.events.NotificationRemovedFromChannelEvent;
import io.getstream.chat.android.client.events.ReactionDeletedEvent;
import io.getstream.chat.android.client.events.ReactionNewEvent;
import io.getstream.chat.android.client.events.ReactionUpdateEvent;
import io.getstream.chat.android.client.events.TypingStartEvent;
import io.getstream.chat.android.client.events.TypingStopEvent;
import io.getstream.chat.android.client.events.UnknownEvent;
import io.getstream.chat.android.client.events.UserDeletedEvent;
import io.getstream.chat.android.client.events.UserMutedEvent;
import io.getstream.chat.android.client.events.UserPresenceChangedEvent;
import io.getstream.chat.android.client.events.UserStartWatchingEvent;
import io.getstream.chat.android.client.events.UserStopWatchingEvent;
import io.getstream.chat.android.client.events.UserUnmutedEvent;
import io.getstream.chat.android.client.events.UserUpdatedEvent;
import io.getstream.chat.android.client.events.UsersMutedEvent;
import io.getstream.chat.android.client.events.UsersUnmutedEvent;
import io.getstream.chat.android.client.models.AttachmentWithDate;
import io.getstream.chat.android.client.models.Channel;
import io.getstream.chat.android.client.models.ChannelMute;
import io.getstream.chat.android.client.models.Member;
import io.getstream.chat.android.client.models.Message;
import io.getstream.chat.android.client.models.Mute;
import io.getstream.chat.android.client.models.Reaction;
import io.getstream.chat.android.client.utils.FilterObject;
import io.getstream.chat.android.client.utils.ProgressCallback;
import io.getstream.chat.android.client.utils.observable.ChatObservable;
import io.getstream.chat.android.client.utils.observable.Disposable;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u00e0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0016J'\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0013\"\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u0014J/\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u000e2\u0006\u0010\u0017\u001a\u00020\u00032\b\u0010\u0018\u001a\u0004\u0018\u00010\u00032\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016\u00a2\u0006\u0002\u0010\u001bJ0\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00030\u001e2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020!0 H\u0016J\"\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020!0 H\u0016J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u000e2\u0006\u0010%\u001a\u00020\u0003H\u0016J\u001e\u0010&\u001a\b\u0012\u0004\u0012\u00020$0\u000e2\u0006\u0010%\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\u0003H\u0016J\u000e\u0010(\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010*\u001a\u00020\u001aH\u0016J\b\u0010+\u001a\u00020,H\u0016JA\u0010-\u001a\u000e\u0012\u0004\u0012\u0002H/\u0012\u0004\u0012\u00020\u00160.\"\b\b\u0000\u0010/*\u0002002!\u00101\u001a\u001d\u0012\u0013\u0012\u0011H/\u00a2\u0006\f\b2\u0012\b\b3\u0012\u0004\b\b(4\u0012\u0004\u0012\u00020\u00160.H\u0002J\"\u00105\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002060\u001e0\u000e2\u0006\u00107\u001a\u00020\u001a2\u0006\u00108\u001a\u00020\u001aJ\"\u00109\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002060\u001e0\u000e2\u0006\u00107\u001a\u00020\u001a2\u0006\u00108\u001a\u00020\u001aJ\u0016\u0010:\u001a\b\u0012\u0004\u0012\u00020$0\u000e2\u0006\u0010%\u001a\u00020\u0003H\u0016J,\u0010;\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020<0\u001e0\u000e2\u0006\u0010%\u001a\u00020\u00032\u0006\u00107\u001a\u00020\u001a2\u0006\u00108\u001a\u00020\u001aH\u0016J,\u0010;\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020$0\u001e0\u000e2\u0006\u0010%\u001a\u00020\u00032\u0006\u0010=\u001a\u00020\u00032\u0006\u00108\u001a\u00020\u001aH\u0016J\u0016\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00160\u000e2\u0006\u0010?\u001a\u00020@H\u0016J\u0010\u0010A\u001a\u00020@2\u0006\u00104\u001a\u000200H\u0002J\u000e\u0010B\u001a\b\u0012\u0004\u0012\u0002000\u000eH\u0016J\u0016\u0010C\u001a\b\u0012\u0004\u0012\u00020\u00160\u000e2\u0006\u0010%\u001a\u00020\u0003H\u0016J\u000e\u0010D\u001a\b\u0012\u0004\u0012\u00020\u00160\u000eH\u0016J\u000e\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00160\u000eH\u0016J\u000e\u0010F\u001a\b\u0012\u0004\u0012\u00020G0\u000eH\u0016J\u0016\u0010H\u001a\b\u0012\u0004\u0012\u00020G0\u000e2\u0006\u0010I\u001a\u00020\u0003H\u0016J\u0016\u0010J\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010K\u001a\u00020LH\u0016JH\u0010M\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020N0\u001e0\u000e2\u0006\u00107\u001a\u00020\u001a2\u0006\u00108\u001a\u00020\u001a2\u0006\u0010O\u001a\u00020P2\f\u0010Q\u001a\b\u0012\u0004\u0012\u00020N0R2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020N0\u001eH\u0016J\u000e\u0010S\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J'\u0010T\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0013\"\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u0014J\u0016\u0010U\u001a\b\u0012\u0004\u0012\u00020\u00160\u000e2\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\u0016\u0010V\u001a\b\u0012\u0004\u0012\u00020$0\u000e2\u0006\u0010K\u001a\u00020WH\u0016J\u0016\u0010X\u001a\b\u0012\u0004\u0012\u00020\u00030\u000e2\u0006\u0010Y\u001a\u00020ZH\u0016J\u001e\u0010X\u001a\b\u0012\u0004\u0012\u00020\u00030\u000e2\u0006\u0010Y\u001a\u00020Z2\u0006\u0010[\u001a\u00020\\H\u0016J\u0016\u0010]\u001a\b\u0012\u0004\u0012\u00020\u00030\u000e2\u0006\u0010Y\u001a\u00020ZH\u0016J\u001e\u0010]\u001a\b\u0012\u0004\u0012\u00020\u00030\u000e2\u0006\u0010Y\u001a\u00020Z2\u0006\u0010[\u001a\u00020\\H\u0016J\u0016\u0010^\u001a\b\u0012\u0004\u0012\u00020$0\u000e2\u0006\u0010\u0010\u001a\u00020$H\u0016J\u0016\u0010_\u001a\b\u0012\u0004\u0012\u00020<0\u000e2\u0006\u0010`\u001a\u00020<H\u0016J/\u0010a\u001a\b\u0012\u0004\u0012\u00020\u00160\u000e2\u0006\u0010\u0017\u001a\u00020\u00032\b\u0010\u0018\u001a\u0004\u0018\u00010\u00032\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016\u00a2\u0006\u0002\u0010\u001bJ\u000e\u0010b\u001a\b\u0012\u0004\u0012\u00020\u00160\u000eH\u0016J\u000e\u0010c\u001a\b\u0012\u0004\u0012\u0002000\u000eH\u0016J\u000e\u0010d\u001a\b\u0012\u0004\u0012\u00020\u00160\u000eH\u0016J+\u0010e\u001a\u00020f2!\u00101\u001a\u001d\u0012\u0013\u0012\u001100\u00a2\u0006\f\b2\u0012\b\b3\u0012\u0004\b\b(4\u0012\u0004\u0012\u00020\u00160.H\u0016J\\\u0010g\u001a\u00020f2\u0006\u0010h\u001a\u00020i2\"\u0010j\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u0002000k0\u0013\"\n\u0012\u0006\b\u0001\u0012\u0002000k2!\u00101\u001a\u001d\u0012\u0013\u0012\u001100\u00a2\u0006\f\b2\u0012\b\b3\u0012\u0004\b\b(4\u0012\u0004\u0012\u00020\u00160.H\u0016\u00a2\u0006\u0002\u0010lJL\u0010g\u001a\u00020f2\u0006\u0010h\u001a\u00020i2\u0012\u0010j\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0013\"\u00020\u00032!\u00101\u001a\u001d\u0012\u0013\u0012\u001100\u00a2\u0006\f\b2\u0012\b\b3\u0012\u0004\b\b(4\u0012\u0004\u0012\u00020\u00160.H\u0016\u00a2\u0006\u0002\u0010mJT\u0010g\u001a\u00020f2\"\u0010j\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u0002000k0\u0013\"\n\u0012\u0006\b\u0001\u0012\u0002000k2!\u00101\u001a\u001d\u0012\u0013\u0012\u001100\u00a2\u0006\f\b2\u0012\b\b3\u0012\u0004\b\b(4\u0012\u0004\u0012\u00020\u00160.H\u0016\u00a2\u0006\u0002\u0010nJD\u0010g\u001a\u00020f2\u0012\u0010j\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0013\"\u00020\u00032!\u00101\u001a\u001d\u0012\u0013\u0012\u001100\u00a2\u0006\f\b2\u0012\b\b3\u0012\u0004\b\b(4\u0012\u0004\u0012\u00020\u00160.H\u0016\u00a2\u0006\u0002\u0010oJC\u0010p\u001a\u00020f\"\b\b\u0000\u0010/*\u0002002\f\u0010q\u001a\b\u0012\u0004\u0012\u0002H/0k2!\u00101\u001a\u001d\u0012\u0013\u0012\u0011H/\u00a2\u0006\f\b2\u0012\b\b3\u0012\u0004\b\b(4\u0012\u0004\u0012\u00020\u00160.H\u0016J3\u0010p\u001a\u00020f2\u0006\u0010q\u001a\u00020\u00032!\u00101\u001a\u001d\u0012\u0013\u0012\u001100\u00a2\u0006\f\b2\u0012\b\b3\u0012\u0004\b\b(4\u0012\u0004\u0012\u00020\u00160.H\u0016J/\u0010r\u001a\b\u0012\u0004\u0012\u00020\u00160\u000e2\u0006\u0010\u0017\u001a\u00020\u00032\b\u0010\u0018\u001a\u0004\u0018\u00010\u00032\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016\u00a2\u0006\u0002\u0010\u001bJ\u000e\u0010s\u001a\b\u0012\u0004\u0012\u00020\u00160\u000eH\u0016J\u000e\u0010t\u001a\b\u0012\u0004\u0012\u00020G0\u000eH\u0016J\u0016\u0010u\u001a\b\u0012\u0004\u0012\u00020G0\u000e2\u0006\u0010I\u001a\u00020\u0003H\u0016J,\u0010v\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010$2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020!0 H\u0016J\u0016\u0010w\u001a\b\u0012\u0004\u0012\u00020$0\u000e2\u0006\u0010\u0010\u001a\u00020$H\u0016J\u000e\u0010x\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\u0016\u0010x\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010K\u001a\u00020yH\u0016J\"\u0010x\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0012\u0010z\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020!0 H\u0016R\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0014\u0010\u000b\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\tR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006{"}, d2={"Lio/getstream/chat/android/client/channel/ChannelClient;", "Lio/getstream/chat/android/client/controllers/ChannelController;", "channelType", "", "channelId", "client", "Lio/getstream/chat/android/client/ChatClient;", "(Ljava/lang/String;Ljava/lang/String;Lio/getstream/chat/android/client/ChatClient;)V", "getChannelId", "()Ljava/lang/String;", "getChannelType", "cid", "getCid", "acceptInvite", "Lio/getstream/chat/android/client/call/Call;", "Lio/getstream/chat/android/client/models/Channel;", "message", "addMembers", "userIds", "", "([Ljava/lang/String;)Lio/getstream/chat/android/client/call/Call;", "banUser", "", "targetId", "reason", "timeout", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;)Lio/getstream/chat/android/client/call/Call;", "create", "members", "", "extraData", "", "", "delete", "deleteMessage", "Lio/getstream/chat/android/client/models/Message;", "messageId", "deleteReaction", "reactionType", "disableSlowMode", "enableSlowMode", "cooldownTimeInSeconds", "events", "Lio/getstream/chat/android/client/utils/observable/ChatObservable;", "filterRelevantEvents", "Lkotlin/Function1;", "T", "Lio/getstream/chat/android/client/events/ChatEvent;", "listener", "Lkotlin/ParameterName;", "name", "event", "getFileAttachments", "Lio/getstream/chat/android/client/models/AttachmentWithDate;", "offset", "limit", "getImageAttachments", "getMessage", "getReactions", "Lio/getstream/chat/android/client/models/Reaction;", "firstReactionId", "hide", "clearHistory", "", "isRelevantForChannel", "keystroke", "markMessageRead", "markRead", "mute", "muteCurrentUser", "Lio/getstream/chat/android/client/models/Mute;", "muteUser", "userId", "query", "request", "Lio/getstream/chat/android/client/api/models/QueryChannelRequest;", "queryMembers", "Lio/getstream/chat/android/client/models/Member;", "filter", "Lio/getstream/chat/android/client/utils/FilterObject;", "sort", "Lio/getstream/chat/android/client/api/models/QuerySort;", "rejectInvite", "removeMembers", "removeShadowBan", "sendAction", "Lio/getstream/chat/android/client/api/models/SendActionRequest;", "sendFile", "file", "Ljava/io/File;", "callback", "Lio/getstream/chat/android/client/utils/ProgressCallback;", "sendImage", "sendMessage", "sendReaction", "reaction", "shadowBanUser", "show", "stopTyping", "stopWatching", "subscribe", "Lio/getstream/chat/android/client/utils/observable/Disposable;", "subscribeFor", "lifecycleOwner", "Landroidx/lifecycle/LifecycleOwner;", "eventTypes", "Ljava/lang/Class;", "(Landroidx/lifecycle/LifecycleOwner;[Ljava/lang/Class;Lkotlin/jvm/functions/Function1;)Lio/getstream/chat/android/client/utils/observable/Disposable;", "(Landroidx/lifecycle/LifecycleOwner;[Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Lio/getstream/chat/android/client/utils/observable/Disposable;", "([Ljava/lang/Class;Lkotlin/jvm/functions/Function1;)Lio/getstream/chat/android/client/utils/observable/Disposable;", "([Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Lio/getstream/chat/android/client/utils/observable/Disposable;", "subscribeForSingle", "eventType", "unBanUser", "unmute", "unmuteCurrentUser", "unmuteUser", "update", "updateMessage", "watch", "Lio/getstream/chat/android/client/api/models/WatchChannelRequest;", "data", "stream-chat-android-client_release"})
public final class ChannelClient
implements ChannelController {
    @NotNull
    private final String cid;
    @NotNull
    private final String channelType;
    @NotNull
    private final String channelId;
    private final ChatClient client;

    @Override
    @NotNull
    public String getCid() {
        return this.cid;
    }

    @Override
    @NotNull
    public Call<Channel> create(@NotNull List<String> members, @NotNull Map<String, ? extends Object> extraData) {
        Intrinsics.checkNotNullParameter(members, (String)"members");
        Intrinsics.checkNotNullParameter(extraData, (String)"extraData");
        return this.client.createChannel(this.getChannelType(), this.getChannelId(), members, extraData);
    }

    @Override
    @NotNull
    public Call<Channel> create(@NotNull Map<String, ? extends Object> extraData) {
        Intrinsics.checkNotNullParameter(extraData, (String)"extraData");
        return this.client.createChannel(this.getChannelType(), this.getChannelId(), CollectionsKt.emptyList());
    }

    @Override
    @NotNull
    public ChatObservable events() {
        return this.client.events().filter((Function1<? super ChatEvent, Boolean>)((Function1)new Function1<ChatEvent, Boolean>(this){

            public final boolean invoke(@NotNull ChatEvent p1) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return ChannelClient.access$isRelevantForChannel((ChannelClient)this.receiver, p1);
            }
        }));
    }

    @Override
    @NotNull
    public Disposable subscribe(@NotNull Function1<? super ChatEvent, Unit> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        return this.client.subscribe(this.filterRelevantEvents(listener));
    }

    @Override
    @NotNull
    public Disposable subscribeFor(@NotNull String[] eventTypes, @NotNull Function1<? super ChatEvent, Unit> listener) {
        Intrinsics.checkNotNullParameter((Object)eventTypes, (String)"eventTypes");
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        return this.client.subscribeFor(Arrays.copyOf(eventTypes, eventTypes.length), this.filterRelevantEvents(listener));
    }

    @Override
    @NotNull
    public Disposable subscribeFor(@NotNull LifecycleOwner lifecycleOwner, @NotNull String[] eventTypes, @NotNull Function1<? super ChatEvent, Unit> listener) {
        Intrinsics.checkNotNullParameter((Object)lifecycleOwner, (String)"lifecycleOwner");
        Intrinsics.checkNotNullParameter((Object)eventTypes, (String)"eventTypes");
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        return this.client.subscribeFor(lifecycleOwner, Arrays.copyOf(eventTypes, eventTypes.length), this.filterRelevantEvents(listener));
    }

    @Override
    @NotNull
    public Disposable subscribeFor(@NotNull Class<? extends ChatEvent>[] eventTypes, @NotNull Function1<? super ChatEvent, Unit> listener) {
        Intrinsics.checkNotNullParameter(eventTypes, (String)"eventTypes");
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        return this.client.subscribeFor(Arrays.copyOf(eventTypes, eventTypes.length), this.filterRelevantEvents(listener));
    }

    @Override
    @NotNull
    public Disposable subscribeFor(@NotNull LifecycleOwner lifecycleOwner, @NotNull Class<? extends ChatEvent>[] eventTypes, @NotNull Function1<? super ChatEvent, Unit> listener) {
        Intrinsics.checkNotNullParameter((Object)lifecycleOwner, (String)"lifecycleOwner");
        Intrinsics.checkNotNullParameter(eventTypes, (String)"eventTypes");
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        return this.client.subscribeFor(lifecycleOwner, Arrays.copyOf(eventTypes, eventTypes.length), this.filterRelevantEvents(listener));
    }

    @Override
    @NotNull
    public Disposable subscribeForSingle(@NotNull String eventType, @NotNull Function1<? super ChatEvent, Unit> listener) {
        Intrinsics.checkNotNullParameter((Object)eventType, (String)"eventType");
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        return this.client.subscribeForSingle(eventType, this.filterRelevantEvents(listener));
    }

    @Override
    @NotNull
    public <T extends ChatEvent> Disposable subscribeForSingle(@NotNull Class<T> eventType, @NotNull Function1<? super T, Unit> listener) {
        Intrinsics.checkNotNullParameter(eventType, (String)"eventType");
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        return this.client.subscribeForSingle(eventType, this.filterRelevantEvents(listener));
    }

    private final <T extends ChatEvent> Function1<T, Unit> filterRelevantEvents(Function1<? super T, Unit> listener) {
        return new Function1<T, Unit>(this, listener){
            final /* synthetic */ ChannelClient this$0;
            final /* synthetic */ Function1 $listener;

            public final void invoke(@NotNull T event) {
                Intrinsics.checkNotNullParameter(event, (String)"event");
                if (ChannelClient.access$isRelevantForChannel(this.this$0, event)) {
                    this.$listener.invoke(event);
                }
            }
            {
                this.this$0 = channelClient;
                this.$listener = function1;
                super(1);
            }
        };
    }

    private final boolean isRelevantForChannel(ChatEvent event) {
        boolean bl;
        block80: {
            ChatEvent chatEvent = event;
            if (chatEvent instanceof ChannelCreatedEvent) {
                bl = Intrinsics.areEqual((Object)((ChannelCreatedEvent)event).getCid(), (Object)this.getCid());
            } else if (chatEvent instanceof ChannelDeletedEvent) {
                bl = Intrinsics.areEqual((Object)((ChannelDeletedEvent)event).getCid(), (Object)this.getCid());
            } else if (chatEvent instanceof ChannelHiddenEvent) {
                bl = Intrinsics.areEqual((Object)((ChannelHiddenEvent)event).getCid(), (Object)this.getCid());
            } else if (chatEvent instanceof ChannelMuteEvent) {
                bl = Intrinsics.areEqual((Object)((ChannelMuteEvent)event).getChannelMute().getChannel().getCid(), (Object)this.getCid());
            } else if (chatEvent instanceof ChannelsMuteEvent) {
                Iterable $this$any$iv = ((ChannelsMuteEvent)event).getChannelsMute();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ChannelMute it = (ChannelMute)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getChannel().getCid(), (Object)this.getCid())) continue;
                        bl = true;
                        break block80;
                    }
                    bl = false;
                }
            } else if (chatEvent instanceof ChannelTruncatedEvent) {
                bl = Intrinsics.areEqual((Object)((ChannelTruncatedEvent)event).getCid(), (Object)this.getCid());
            } else if (chatEvent instanceof ChannelUnmuteEvent) {
                bl = Intrinsics.areEqual((Object)((ChannelUnmuteEvent)event).getChannelMute().getChannel().getCid(), (Object)this.getCid());
            } else if (chatEvent instanceof ChannelsUnmuteEvent) {
                Iterable $this$any$iv = ((ChannelsUnmuteEvent)event).getChannelsMute();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ChannelMute it = (ChannelMute)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it.getChannel().getCid(), (Object)this.getCid())) continue;
                        bl = true;
                        break block80;
                    }
                    bl = false;
                }
            } else if (chatEvent instanceof ChannelUpdatedEvent) {
                bl = Intrinsics.areEqual((Object)((ChannelUpdatedEvent)event).getCid(), (Object)this.getCid());
            } else if (chatEvent instanceof ChannelUpdatedByUserEvent) {
                bl = Intrinsics.areEqual((Object)((ChannelUpdatedByUserEvent)event).getCid(), (Object)this.getCid());
            } else if (chatEvent instanceof ChannelVisibleEvent) {
                bl = Intrinsics.areEqual((Object)((ChannelVisibleEvent)event).getCid(), (Object)this.getCid());
            } else if (chatEvent instanceof MemberAddedEvent) {
                bl = Intrinsics.areEqual((Object)((MemberAddedEvent)event).getCid(), (Object)this.getCid());
            } else if (chatEvent instanceof MemberRemovedEvent) {
                bl = Intrinsics.areEqual((Object)((MemberRemovedEvent)event).getCid(), (Object)this.getCid());
            } else if (chatEvent instanceof MemberUpdatedEvent) {
                bl = Intrinsics.areEqual((Object)((MemberUpdatedEvent)event).getCid(), (Object)this.getCid());
            } else if (chatEvent instanceof MessageDeletedEvent) {
                bl = Intrinsics.areEqual((Object)((MessageDeletedEvent)event).getCid(), (Object)this.getCid());
            } else if (chatEvent instanceof MessageReadEvent) {
                bl = Intrinsics.areEqual((Object)((MessageReadEvent)event).getCid(), (Object)this.getCid());
            } else if (chatEvent instanceof MessageUpdatedEvent) {
                bl = Intrinsics.areEqual((Object)((MessageUpdatedEvent)event).getCid(), (Object)this.getCid());
            } else if (chatEvent instanceof NewMessageEvent) {
                bl = Intrinsics.areEqual((Object)((NewMessageEvent)event).getCid(), (Object)this.getCid());
            } else if (chatEvent instanceof NotificationAddedToChannelEvent) {
                bl = Intrinsics.areEqual((Object)((NotificationAddedToChannelEvent)event).getCid(), (Object)this.getCid());
            } else if (chatEvent instanceof NotificationChannelDeletedEvent) {
                bl = Intrinsics.areEqual((Object)((NotificationChannelDeletedEvent)event).getCid(), (Object)this.getCid());
            } else if (chatEvent instanceof NotificationChannelTruncatedEvent) {
                bl = Intrinsics.areEqual((Object)((NotificationChannelTruncatedEvent)event).getCid(), (Object)this.getCid());
            } else if (chatEvent instanceof NotificationInviteAcceptedEvent) {
                bl = Intrinsics.areEqual((Object)((NotificationInviteAcceptedEvent)event).getCid(), (Object)this.getCid());
            } else if (chatEvent instanceof NotificationInvitedEvent) {
                bl = Intrinsics.areEqual((Object)((NotificationInvitedEvent)event).getCid(), (Object)this.getCid());
            } else if (chatEvent instanceof NotificationMarkReadEvent) {
                bl = Intrinsics.areEqual((Object)((NotificationMarkReadEvent)event).getCid(), (Object)this.getCid());
            } else if (chatEvent instanceof NotificationMessageNewEvent) {
                bl = Intrinsics.areEqual((Object)((NotificationMessageNewEvent)event).getCid(), (Object)this.getCid());
            } else if (chatEvent instanceof NotificationRemovedFromChannelEvent) {
                bl = Intrinsics.areEqual((Object)((NotificationRemovedFromChannelEvent)event).getCid(), (Object)this.getCid());
            } else if (chatEvent instanceof ReactionDeletedEvent) {
                bl = Intrinsics.areEqual((Object)((ReactionDeletedEvent)event).getCid(), (Object)this.getCid());
            } else if (chatEvent instanceof ReactionNewEvent) {
                bl = Intrinsics.areEqual((Object)((ReactionNewEvent)event).getCid(), (Object)this.getCid());
            } else if (chatEvent instanceof ReactionUpdateEvent) {
                bl = Intrinsics.areEqual((Object)((ReactionUpdateEvent)event).getCid(), (Object)this.getCid());
            } else if (chatEvent instanceof TypingStartEvent) {
                bl = Intrinsics.areEqual((Object)((TypingStartEvent)event).getCid(), (Object)this.getCid());
            } else if (chatEvent instanceof TypingStopEvent) {
                bl = Intrinsics.areEqual((Object)((TypingStopEvent)event).getCid(), (Object)this.getCid());
            } else if (chatEvent instanceof ChannelUserBannedEvent) {
                bl = Intrinsics.areEqual((Object)((ChannelUserBannedEvent)event).getCid(), (Object)this.getCid());
            } else if (chatEvent instanceof UserStartWatchingEvent) {
                bl = Intrinsics.areEqual((Object)((UserStartWatchingEvent)event).getCid(), (Object)this.getCid());
            } else if (chatEvent instanceof UserStopWatchingEvent) {
                bl = Intrinsics.areEqual((Object)((UserStopWatchingEvent)event).getCid(), (Object)this.getCid());
            } else if (chatEvent instanceof ChannelUserUnbannedEvent) {
                bl = Intrinsics.areEqual((Object)((ChannelUserUnbannedEvent)event).getCid(), (Object)this.getCid());
            } else if (chatEvent instanceof UnknownEvent) {
                Map<?, ?> map = ((UnknownEvent)event).getRawData();
                String string2 = "cid";
                boolean bl4 = false;
                bl = Intrinsics.areEqual(map.get(string2), (Object)this.getCid());
            } else if (chatEvent instanceof HealthEvent || chatEvent instanceof NotificationChannelMutesUpdatedEvent || chatEvent instanceof NotificationMutesUpdatedEvent || chatEvent instanceof GlobalUserBannedEvent || chatEvent instanceof UserDeletedEvent || chatEvent instanceof UserMutedEvent || chatEvent instanceof UsersMutedEvent || chatEvent instanceof UserPresenceChangedEvent || chatEvent instanceof GlobalUserUnbannedEvent || chatEvent instanceof UserUnmutedEvent || chatEvent instanceof UsersUnmutedEvent || chatEvent instanceof UserUpdatedEvent || chatEvent instanceof ConnectedEvent || chatEvent instanceof ConnectingEvent || chatEvent instanceof DisconnectedEvent || chatEvent instanceof ErrorEvent || chatEvent instanceof MarkAllReadEvent) {
                bl = false;
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    @Override
    @NotNull
    public Call<Channel> query(@NotNull QueryChannelRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return this.client.queryChannel(this.getChannelType(), this.getChannelId(), request);
    }

    @Override
    @NotNull
    public Call<Channel> watch(@NotNull WatchChannelRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return this.client.queryChannel(this.getChannelType(), this.getChannelId(), request);
    }

    @Override
    @NotNull
    public Call<Channel> watch(@NotNull Map<String, ? extends Object> data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        WatchChannelRequest request = new WatchChannelRequest();
        request.getData().putAll(data);
        return this.watch(request);
    }

    @Override
    @NotNull
    public Call<Channel> watch() {
        return this.client.queryChannel(this.getChannelType(), this.getChannelId(), new WatchChannelRequest());
    }

    @Override
    @NotNull
    public Call<Unit> stopWatching() {
        return this.client.stopWatching(this.getChannelType(), this.getChannelId());
    }

    @Override
    @NotNull
    public Call<Message> getMessage(@NotNull String messageId) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        return this.client.getMessage(messageId);
    }

    @Override
    @NotNull
    public Call<Message> updateMessage(@NotNull Message message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return this.client.updateMessage(message);
    }

    @Override
    @NotNull
    public Call<Message> deleteMessage(@NotNull String messageId) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        return this.client.deleteMessage(messageId);
    }

    @Override
    @NotNull
    public Call<Message> sendMessage(@NotNull Message message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return this.client.sendMessage(this.getChannelType(), this.getChannelId(), message);
    }

    @Override
    @NotNull
    public Call<Unit> banUser(@NotNull String targetId, @Nullable String reason, @Nullable Integer timeout) {
        Intrinsics.checkNotNullParameter((Object)targetId, (String)"targetId");
        return this.client.banUser(targetId, this.getChannelType(), this.getChannelId(), reason, timeout);
    }

    @Override
    @NotNull
    public Call<Unit> unBanUser(@NotNull String targetId, @Nullable String reason, @Nullable Integer timeout) {
        Intrinsics.checkNotNullParameter((Object)targetId, (String)"targetId");
        return this.client.unBanUser(targetId, this.getChannelType(), this.getChannelId());
    }

    @Override
    @NotNull
    public Call<Unit> shadowBanUser(@NotNull String targetId, @Nullable String reason, @Nullable Integer timeout) {
        Intrinsics.checkNotNullParameter((Object)targetId, (String)"targetId");
        return this.client.shadowBanUser(targetId, this.getChannelType(), this.getChannelId(), reason, timeout);
    }

    @Override
    @NotNull
    public Call<Unit> removeShadowBan(@NotNull String targetId) {
        Intrinsics.checkNotNullParameter((Object)targetId, (String)"targetId");
        return this.client.removeShadowBan(targetId, this.getChannelType(), this.getChannelId());
    }

    @Override
    @NotNull
    public Call<Unit> markMessageRead(@NotNull String messageId) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        return this.client.markMessageRead(this.getChannelType(), this.getChannelId(), messageId);
    }

    @Override
    @NotNull
    public Call<Unit> markRead() {
        return this.client.markRead(this.getChannelType(), this.getChannelId());
    }

    @Override
    @NotNull
    public Call<Channel> delete() {
        return this.client.deleteChannel(this.getChannelType(), this.getChannelId());
    }

    @Override
    @NotNull
    public Call<Unit> show() {
        return this.client.showChannel(this.getChannelType(), this.getChannelId());
    }

    @Override
    @NotNull
    public Call<Unit> hide(boolean clearHistory) {
        return this.client.hideChannel(this.getChannelType(), this.getChannelId(), clearHistory);
    }

    @Override
    @NotNull
    public Call<String> sendFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.client.sendFile(this.getChannelType(), this.getChannelId(), file);
    }

    @Override
    @NotNull
    public Call<String> sendImage(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.client.sendImage(this.getChannelType(), this.getChannelId(), file);
    }

    @Override
    @NotNull
    public Call<String> sendFile(@NotNull File file, @NotNull ProgressCallback callback2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
        return this.client.sendFile(this.getChannelType(), this.getChannelId(), file);
    }

    @Override
    @NotNull
    public Call<String> sendImage(@NotNull File file, @NotNull ProgressCallback callback2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
        return this.client.sendImage(this.getChannelType(), this.getChannelId(), file);
    }

    @Override
    @NotNull
    public Call<Reaction> sendReaction(@NotNull Reaction reaction) {
        Intrinsics.checkNotNullParameter((Object)reaction, (String)"reaction");
        return this.client.sendReaction(reaction);
    }

    @Override
    @NotNull
    public Call<Message> sendAction(@NotNull SendActionRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return this.client.sendAction(request);
    }

    @Override
    @NotNull
    public Call<Message> deleteReaction(@NotNull String messageId, @NotNull String reactionType) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Intrinsics.checkNotNullParameter((Object)reactionType, (String)"reactionType");
        return this.client.deleteReaction(messageId, reactionType);
    }

    @Override
    @NotNull
    public Call<List<Reaction>> getReactions(@NotNull String messageId, int offset, int limit) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        return this.client.getReactions(messageId, offset, limit);
    }

    @Override
    @NotNull
    public Call<List<Message>> getReactions(@NotNull String messageId, @NotNull String firstReactionId, int limit) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Intrinsics.checkNotNullParameter((Object)firstReactionId, (String)"firstReactionId");
        return this.client.getRepliesMore(messageId, firstReactionId, limit);
    }

    @Override
    @NotNull
    public Call<Channel> update(@Nullable Message message, @NotNull Map<String, ? extends Object> extraData) {
        Intrinsics.checkNotNullParameter(extraData, (String)"extraData");
        return this.client.updateChannel(this.getChannelType(), this.getChannelId(), message, extraData);
    }

    @Override
    @NotNull
    public Call<Channel> enableSlowMode(int cooldownTimeInSeconds) {
        return this.client.enableSlowMode(this.getChannelType(), this.getChannelId(), cooldownTimeInSeconds);
    }

    @Override
    @NotNull
    public Call<Channel> disableSlowMode() {
        return this.client.disableSlowMode(this.getChannelType(), this.getChannelId());
    }

    @Override
    @NotNull
    public Call<Channel> addMembers(String ... userIds) {
        Intrinsics.checkNotNullParameter((Object)userIds, (String)"userIds");
        return this.client.addMembers(this.getChannelType(), this.getChannelId(), ArraysKt.toList((Object[])userIds));
    }

    @Override
    @NotNull
    public Call<Channel> removeMembers(String ... userIds) {
        Intrinsics.checkNotNullParameter((Object)userIds, (String)"userIds");
        return this.client.removeMembers(this.getChannelType(), this.getChannelId(), ArraysKt.toList((Object[])userIds));
    }

    @Override
    @NotNull
    public Call<Channel> acceptInvite(@Nullable String message) {
        return this.client.acceptInvite(this.getChannelType(), this.getChannelId(), message);
    }

    @Override
    @NotNull
    public Call<Channel> rejectInvite() {
        return this.client.rejectInvite(this.getChannelType(), this.getChannelId());
    }

    @Override
    @NotNull
    public Call<Mute> muteCurrentUser() {
        return this.client.muteCurrentUser();
    }

    @Override
    @NotNull
    public Call<Unit> mute() {
        return this.client.muteChannel(this.getChannelType(), this.getChannelId());
    }

    @Override
    @NotNull
    public Call<Unit> unmute() {
        return this.client.unMuteChannel(this.getChannelType(), this.getChannelId());
    }

    @Override
    @NotNull
    public Call<Mute> muteUser(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        return this.client.muteUser(userId);
    }

    @Override
    @NotNull
    public Call<Mute> unmuteUser(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        return this.client.unmuteUser(userId);
    }

    @Override
    @NotNull
    public Call<Mute> unmuteCurrentUser() {
        return this.client.unmuteCurrentUser();
    }

    @Override
    @NotNull
    public Call<ChatEvent> keystroke() {
        return ChatClient.sendEvent$default(this.client, "typing.start", this.getChannelType(), this.getChannelId(), null, 8, null);
    }

    @Override
    @NotNull
    public Call<ChatEvent> stopTyping() {
        return ChatClient.sendEvent$default(this.client, "typing.stop", this.getChannelType(), this.getChannelId(), null, 8, null);
    }

    @Override
    @NotNull
    public Call<List<Member>> queryMembers(int offset, int limit, @NotNull FilterObject filter2, @NotNull QuerySort<Member> sort, @NotNull List<Member> members) {
        Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter");
        Intrinsics.checkNotNullParameter(sort, (String)"sort");
        Intrinsics.checkNotNullParameter(members, (String)"members");
        return this.client.queryMembers(this.getChannelType(), this.getChannelId(), offset, limit, filter2, sort, members);
    }

    @NotNull
    public final Call<List<AttachmentWithDate>> getFileAttachments(int offset, int limit) {
        return this.client.getFileAttachments(this.getChannelType(), this.getChannelId(), offset, limit);
    }

    @NotNull
    public final Call<List<AttachmentWithDate>> getImageAttachments(int offset, int limit) {
        return this.client.getImageAttachments(this.getChannelType(), this.getChannelId(), offset, limit);
    }

    @Override
    @NotNull
    public String getChannelType() {
        return this.channelType;
    }

    @Override
    @NotNull
    public String getChannelId() {
        return this.channelId;
    }

    public ChannelClient(@NotNull String channelType, @NotNull String channelId, @NotNull ChatClient client) {
        Intrinsics.checkNotNullParameter((Object)channelType, (String)"channelType");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.channelType = channelType;
        this.channelId = channelId;
        this.client = client;
        this.cid = this.getChannelType() + ':' + this.getChannelId();
    }

    public static final /* synthetic */ boolean access$isRelevantForChannel(ChannelClient $this, ChatEvent event) {
        return $this.isRelevantForChannel(event);
    }
}

