/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.client.notifications;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.content.Context;
import android.os.Build;
import androidx.core.app.NotificationCompat;
import com.google.firebase.messaging.FirebaseMessagingService;
import com.google.firebase.messaging.RemoteMessage;
import io.getstream.chat.android.client.ChatClient;
import io.getstream.chat.android.client.logger.ChatLogger;
import io.getstream.chat.android.client.logger.TaggedLogger;
import io.getstream.chat.android.client.notifications.handler.NotificationConfig;
import io.getstream.chat.android.core.internal.coroutines.DispatcherProvider;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.GlobalScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/getstream/chat/android/client/notifications/ChatFirebaseMessagingService;", "Lcom/google/firebase/messaging/FirebaseMessagingService;", "()V", "defaultNotificationConfig", "Lio/getstream/chat/android/client/notifications/handler/NotificationConfig;", "logger", "Lio/getstream/chat/android/client/logger/TaggedLogger;", "createSyncNotificationChannel", "", "onMessageReceived", "remoteMessage", "Lcom/google/firebase/messaging/RemoteMessage;", "onNewToken", "token", "", "showForegroundNotification", "smallIcon", "", "Companion", "stream-chat-android-client_release"})
public final class ChatFirebaseMessagingService
extends FirebaseMessagingService {
    private final TaggedLogger logger = ChatLogger.Companion.get("ChatFirebaseMessagingService");
    private final NotificationConfig defaultNotificationConfig = new NotificationConfig(0, 0, 0, null, null, null, null, null, 0, 0, false, 2047, null);
    @NotNull
    public static final String CHANNEL_ID = "notification_channel_id";
    @NotNull
    public static final String CHANNEL_NAME = "Chat messages sync";
    public static final int NOTIFICATION_ID = 1;
    @NotNull
    private static final Companion Companion = new Companion(null);

    public void onMessageReceived(@NotNull RemoteMessage remoteMessage) {
        Intrinsics.checkNotNullParameter((Object)remoteMessage, (String)"remoteMessage");
        this.logger.logD("onMessageReceived(): " + remoteMessage);
        if (!ChatClient.Companion.isValidRemoteMessage(remoteMessage, this.defaultNotificationConfig)) {
            return;
        }
        this.createSyncNotificationChannel();
        this.showForegroundNotification(this.defaultNotificationConfig.getSmallIcon());
        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), (CoroutineContext)((CoroutineContext)DispatcherProvider.INSTANCE.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, remoteMessage, null){
            int label;
            final /* synthetic */ ChatFirebaseMessagingService this$0;
            final /* synthetic */ RemoteMessage $remoteMessage;

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        if (ChatClient.Companion.isInitialized()) {
                            ChatClient.Companion.instance().onMessageReceived(this.$remoteMessage);
                        }
                        this.this$0.stopForeground(true);
                        this.this$0.stopSelf();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.this$0 = chatFirebaseMessagingService;
                this.$remoteMessage = remoteMessage;
                super(2, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkNotNullParameter(completion, (String)"completion");
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public void onNewToken(@NotNull String token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        if (ChatClient.Companion.isInitialized()) {
            ChatClient.Companion.instance().onNewTokenReceived(token);
        }
    }

    private final void showForegroundNotification(int smallIcon) {
        Notification notification = new NotificationCompat.Builder((Context)this, CHANNEL_ID).setAutoCancel(true).setSmallIcon(smallIcon).build();
        boolean bl = false;
        boolean bl2 = false;
        Notification $this$apply = notification;
        boolean bl3 = false;
        this.startForeground(1, $this$apply);
    }

    private final void createSyncNotificationChannel() {
        if (Build.VERSION.SDK_INT >= 26) {
            NotificationChannel notificationChannel = new NotificationChannel(CHANNEL_ID, (CharSequence)CHANNEL_NAME, 4);
            boolean bl = false;
            boolean bl2 = false;
            NotificationChannel $this$run = notificationChannel;
            boolean bl3 = false;
            ((NotificationManager)this.getSystemService(NotificationManager.class)).createNotificationChannel($this$run);
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lio/getstream/chat/android/client/notifications/ChatFirebaseMessagingService$Companion;", "", "()V", "CHANNEL_ID", "", "CHANNEL_NAME", "NOTIFICATION_ID", "", "stream-chat-android-client_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

