/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.client.notifications;

import com.google.firebase.messaging.RemoteMessage;
import io.getstream.chat.android.client.extensions.RemoteMessageExtensionsKt;
import io.getstream.chat.android.client.notifications.FirebaseMessageParser;
import io.getstream.chat.android.client.notifications.handler.NotificationConfig;
import io.getstream.chat.android.core.internal.InternalStreamChatApi;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@InternalStreamChatApi
@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/getstream/chat/android/client/notifications/FirebaseMessageParserImpl;", "Lio/getstream/chat/android/client/notifications/FirebaseMessageParser;", "config", "Lio/getstream/chat/android/client/notifications/handler/NotificationConfig;", "(Lio/getstream/chat/android/client/notifications/handler/NotificationConfig;)V", "channelIdKey", "", "channelTypeKey", "messageIdKey", "isValidRemoteMessage", "", "message", "Lcom/google/firebase/messaging/RemoteMessage;", "parse", "Lio/getstream/chat/android/client/notifications/FirebaseMessageParser$Data;", "stream-chat-android-client_release"})
public final class FirebaseMessageParserImpl
implements FirebaseMessageParser {
    private final String messageIdKey;
    private final String channelTypeKey;
    private final String channelIdKey;
    private final NotificationConfig config;

    @Override
    public boolean isValidRemoteMessage(@NotNull RemoteMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return RemoteMessageExtensionsKt.isValid(message, this.config);
    }

    @Override
    @NotNull
    public FirebaseMessageParser.Data parse(@NotNull RemoteMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Object v = message.getData().get(this.messageIdKey);
        Intrinsics.checkNotNull(v);
        String messageId = (String)v;
        Object v2 = message.getData().get(this.channelIdKey);
        Intrinsics.checkNotNull(v2);
        String channelId = (String)v2;
        Object v3 = message.getData().get(this.channelTypeKey);
        Intrinsics.checkNotNull(v3);
        String channelType = (String)v3;
        return new FirebaseMessageParser.Data(messageId, channelType, channelId);
    }

    public FirebaseMessageParserImpl(@NotNull NotificationConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        this.messageIdKey = this.config.getFirebaseMessageIdKey();
        this.channelTypeKey = this.config.getFirebaseChannelIdKey();
        this.channelIdKey = this.config.getFirebaseChannelTypeKey();
    }
}

