/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.client.notifications;

import android.app.Notification;
import android.app.NotificationManager;
import android.content.Context;
import android.os.Build;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.ProcessLifecycleOwner;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.InstanceIdResult;
import com.google.firebase.messaging.RemoteMessage;
import io.getstream.chat.android.client.api.ChatApi;
import io.getstream.chat.android.client.api.models.QueryChannelRequest;
import io.getstream.chat.android.client.call.Call;
import io.getstream.chat.android.client.call.CallKt;
import io.getstream.chat.android.client.events.ChatEvent;
import io.getstream.chat.android.client.events.NewMessageEvent;
import io.getstream.chat.android.client.logger.ChatLogger;
import io.getstream.chat.android.client.logger.TaggedLogger;
import io.getstream.chat.android.client.models.Channel;
import io.getstream.chat.android.client.models.Message;
import io.getstream.chat.android.client.notifications.DeviceRegisteredListener;
import io.getstream.chat.android.client.notifications.FirebaseMessageParser;
import io.getstream.chat.android.client.notifications.NotificationLoadDataListener;
import io.getstream.chat.android.client.notifications.handler.ChatNotificationHandler;
import io.getstream.chat.android.client.utils.Result;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 62\u00020\u0001:\u00016B\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u0017H\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0002J\u000e\u0010 \u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\u001cJ \u0010!\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\u00152\u0006\u0010#\u001a\u00020\u00152\u0006\u0010$\u001a\u00020\u0015H\u0002J\u000e\u0010%\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020&J\u000e\u0010'\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001cJ\u0018\u0010(\u001a\u00020\u00172\u0006\u0010)\u001a\u00020*2\u0006\u0010\u001b\u001a\u00020+H\u0002J\u0006\u0010,\u001a\u00020\u0017J\u000e\u0010-\u001a\u00020\u00172\u0006\u0010.\u001a\u00020\u0015J\b\u0010/\u001a\u00020\u0017H\u0002J\u0018\u00100\u001a\u00020\u00172\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u000204H\u0002J\u0010\u00105\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020\u0015H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\r\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lio/getstream/chat/android/client/notifications/ChatNotifications;", "", "handler", "Lio/getstream/chat/android/client/notifications/handler/ChatNotificationHandler;", "client", "Lio/getstream/chat/android/client/api/ChatApi;", "context", "Landroid/content/Context;", "(Lio/getstream/chat/android/client/notifications/handler/ChatNotificationHandler;Lio/getstream/chat/android/client/api/ChatApi;Landroid/content/Context;)V", "getHandler", "()Lio/getstream/chat/android/client/notifications/handler/ChatNotificationHandler;", "logger", "Lio/getstream/chat/android/client/logger/TaggedLogger;", "notificationManager", "Landroid/app/NotificationManager;", "getNotificationManager", "()Landroid/app/NotificationManager;", "notificationManager$delegate", "Lkotlin/Lazy;", "showedNotifications", "", "", "handleEvent", "", "event", "Lio/getstream/chat/android/client/events/NewMessageEvent;", "handleRemoteMessage", "message", "Lcom/google/firebase/messaging/RemoteMessage;", "init", "isForeground", "", "isValidRemoteMessage", "loadRequiredData", "channelType", "channelId", "messageId", "onChatEvent", "Lio/getstream/chat/android/client/events/ChatEvent;", "onFirebaseMessage", "onRequiredDataLoaded", "channel", "Lio/getstream/chat/android/client/models/Channel;", "Lio/getstream/chat/android/client/models/Message;", "onSetUser", "setFirebaseToken", "firebaseToken", "showErrorCaseNotification", "showNotification", "notificationId", "", "notification", "Landroid/app/Notification;", "wasNotificationDisplayed", "Companion", "stream-chat-android-client_release"})
public final class ChatNotifications {
    private final Set<String> showedNotifications;
    private final TaggedLogger logger;
    private final Lazy notificationManager$delegate;
    @NotNull
    private final ChatNotificationHandler handler;
    private final ChatApi client;
    private final Context context;
    @NotNull
    public static final Companion Companion = new Companion(null);

    private final NotificationManager getNotificationManager() {
        Lazy lazy = this.notificationManager$delegate;
        ChatNotifications chatNotifications = this;
        Object var3_3 = null;
        boolean bl = false;
        return (NotificationManager)lazy.getValue();
    }

    private final void init() {
        if (Build.VERSION.SDK_INT >= 26) {
            this.getNotificationManager().createNotificationChannel(this.handler.createNotificationChannel());
        }
    }

    public final void onSetUser() {
        block0: {
            FirebaseInstanceId firebaseInstanceId = this.handler.getFirebaseInstanceId();
            if (firebaseInstanceId == null || (firebaseInstanceId = firebaseInstanceId.getInstanceId()) == null) break block0;
            firebaseInstanceId.addOnCompleteListener((OnCompleteListener)new OnCompleteListener<InstanceIdResult>(this){
                final /* synthetic */ ChatNotifications this$0;

                public final void onComplete(@NotNull Task<InstanceIdResult> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    if (it.isSuccessful()) {
                        ChatNotifications.access$getLogger$p(this.this$0).logI("FirebaseInstanceId returned token successfully");
                        Object object = it.getResult();
                        Intrinsics.checkNotNull((Object)object);
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it.result!!");
                        String string = ((InstanceIdResult)object).getToken();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.result!!.token");
                        this.this$0.setFirebaseToken(string);
                    } else {
                        ChatNotifications.access$getLogger$p(this.this$0).logI("Error: FirebaseInstanceId doesn't returned token");
                    }
                }
                {
                    this.this$0 = chatNotifications;
                }
            });
        }
    }

    public final void setFirebaseToken(@NotNull String firebaseToken) {
        Intrinsics.checkNotNullParameter((Object)firebaseToken, (String)"firebaseToken");
        this.logger.logI("setFirebaseToken: " + firebaseToken);
        this.client.addDevice(firebaseToken).enqueue((Call.Callback)new Call.Callback<Unit>(this){
            final /* synthetic */ ChatNotifications this$0;

            public final void onResult(@NotNull Result<Unit> result) {
                Intrinsics.checkNotNullParameter(result, (String)"result");
                if (result.isSuccess()) {
                    DeviceRegisteredListener deviceRegisteredListener = this.this$0.getHandler().getDeviceRegisteredListener();
                    if (deviceRegisteredListener != null) {
                        deviceRegisteredListener.onDeviceRegisteredSuccess();
                    }
                    ChatNotifications.access$getLogger$p(this.this$0).logI("DeviceRegisteredSuccess");
                } else {
                    DeviceRegisteredListener deviceRegisteredListener = this.this$0.getHandler().getDeviceRegisteredListener();
                    if (deviceRegisteredListener != null) {
                        deviceRegisteredListener.onDeviceRegisteredError(result.error());
                    }
                    ChatNotifications.access$getLogger$p(this.this$0).logE("Error register device " + result.error().getMessage());
                }
            }
            {
                this.this$0 = chatNotifications;
            }
        });
    }

    public final void onFirebaseMessage(@NotNull RemoteMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.logger.logI("onReceiveFirebaseMessage: payload: {" + message + ".data}");
        if (!this.handler.onFirebaseMessage(message)) {
            if (this.isForeground()) {
                return;
            }
            this.handleRemoteMessage(message);
        }
    }

    public final void onChatEvent(@NotNull ChatEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event instanceof NewMessageEvent) {
            this.logger.logI("onChatEvent: {" + event + ".type}");
            if (!this.handler.onChatEvent(event)) {
                if (this.isForeground()) {
                    return;
                }
                this.logger.logI("onReceiveWebSocketEvent: " + event);
                this.handleEvent((NewMessageEvent)event);
            }
        }
    }

    private final void handleRemoteMessage(RemoteMessage message) {
        if (this.isValidRemoteMessage(message)) {
            FirebaseMessageParser firebaseParser = this.handler.getFirebaseMessageParser();
            FirebaseMessageParser.Data data = firebaseParser.parse(message);
            if (!this.wasNotificationDisplayed(data.getMessageId())) {
                this.showedNotifications.add(data.getMessageId());
                this.loadRequiredData(data.getChannelType(), data.getChannelId(), data.getMessageId());
            }
        } else {
            this.logger.logE("Push payload is not configured correctly: {" + message.getData() + '}');
        }
    }

    public final boolean isValidRemoteMessage(@NotNull RemoteMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return this.handler.isValidRemoteMessage$stream_chat_android_client_release(message);
    }

    private final void handleEvent(NewMessageEvent event) {
        String messageId = event.getMessage().getId();
        if (!this.wasNotificationDisplayed(messageId)) {
            this.showedNotifications.add(messageId);
            this.loadRequiredData(event.getChannelType(), event.getChannelId(), messageId);
        }
    }

    private final boolean wasNotificationDisplayed(String messageId) {
        return this.showedNotifications.contains(messageId);
    }

    private final void loadRequiredData(String channelType, String channelId, String messageId) {
        Call<Message> getMessage2 = this.client.getMessage(messageId);
        Call<Channel> getChannel = this.client.queryChannel(channelType, channelId, new QueryChannelRequest());
        CallKt.zipWith(getChannel, getMessage2).enqueue((Call.Callback)new Call.Callback<Pair<? extends Channel, ? extends Message>>(this, messageId){
            final /* synthetic */ ChatNotifications this$0;
            final /* synthetic */ String $messageId;

            /*
             * WARNING - void declaration
             */
            public final void onResult(@NotNull Result<Pair<Channel, Message>> result) {
                Intrinsics.checkNotNullParameter(result, (String)"result");
                if (result.isSuccess()) {
                    void channel;
                    Pair pair = (Pair)result.data();
                    Channel channel2 = (Channel)pair.component1();
                    Message message = (Message)pair.component2();
                    NotificationLoadDataListener notificationLoadDataListener = this.this$0.getHandler().getDataLoadListener();
                    if (notificationLoadDataListener != null) {
                        notificationLoadDataListener.onLoadSuccess((Channel)channel, message);
                    }
                    ChatNotifications.access$onRequiredDataLoaded(this.this$0, (Channel)channel, message);
                } else {
                    ChatNotifications.access$getLogger$p(this.this$0).logE("Error loading required data: " + result.error().getMessage(), result.error());
                    NotificationLoadDataListener notificationLoadDataListener = this.this$0.getHandler().getDataLoadListener();
                    if (notificationLoadDataListener != null) {
                        notificationLoadDataListener.onLoadFail(this.$messageId, result.error());
                    }
                    ChatNotifications.access$showErrorCaseNotification(this.this$0);
                }
            }
            {
                this.this$0 = chatNotifications;
                this.$messageId = string;
            }
        });
    }

    private final void onRequiredDataLoaded(Channel channel, Message message) {
        String messageId = message.getId();
        String channelId = channel.getId();
        int notificationId = (int)System.currentTimeMillis();
        Object object = channel.getExtraData().get("name");
        if (object == null) {
            object = "";
        }
        Object channelName = object;
        Notification notification = this.handler.buildNotification(notificationId, channelName.toString(), message.getText(), messageId, channel.getType(), channelId);
        this.showedNotifications.add(messageId);
        this.showNotification(notificationId, notification);
    }

    private final void showErrorCaseNotification() {
        this.showNotification((int)System.currentTimeMillis(), this.handler.buildErrorCaseNotification());
    }

    private final void showNotification(int notificationId, Notification notification) {
        block2: {
            if (this.isForeground()) break block2;
            Object object = this.context.getSystemService("notification");
            if (!(object instanceof NotificationManager)) {
                object = null;
            }
            NotificationManager notificationManager2 = (NotificationManager)object;
            if (notificationManager2 != null) {
                notificationManager2.notify(notificationId, notification);
            }
        }
    }

    private final boolean isForeground() {
        LifecycleOwner lifecycleOwner = ProcessLifecycleOwner.get();
        Intrinsics.checkNotNullExpressionValue((Object)lifecycleOwner, (String)"ProcessLifecycleOwner.get()");
        Lifecycle lifecycle = lifecycleOwner.getLifecycle();
        Intrinsics.checkNotNullExpressionValue((Object)lifecycle, (String)"ProcessLifecycleOwner.get().lifecycle");
        return lifecycle.getCurrentState().isAtLeast(Lifecycle.State.STARTED);
    }

    @NotNull
    public final ChatNotificationHandler getHandler() {
        return this.handler;
    }

    private ChatNotifications(ChatNotificationHandler handler2, ChatApi client, Context context) {
        this.handler = handler2;
        this.client = client;
        this.context = context;
        boolean bl = false;
        this.showedNotifications = new LinkedHashSet();
        this.logger = ChatLogger.Companion.get("ChatNotifications");
        this.notificationManager$delegate = LazyKt.lazy((Function0)((Function0)new Function0<NotificationManager>(this){
            final /* synthetic */ ChatNotifications this$0;

            @NotNull
            public final NotificationManager invoke() {
                Object object = ChatNotifications.access$getContext$p(this.this$0).getSystemService("notification");
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type android.app.NotificationManager");
                }
                return (NotificationManager)object;
            }
            {
                this.this$0 = chatNotifications;
                super(0);
            }
        }));
    }

    public static final /* synthetic */ TaggedLogger access$getLogger$p(ChatNotifications $this) {
        return $this.logger;
    }

    public static final /* synthetic */ void access$onRequiredDataLoaded(ChatNotifications $this, Channel channel, Message message) {
        $this.onRequiredDataLoaded(channel, message);
    }

    public static final /* synthetic */ void access$showErrorCaseNotification(ChatNotifications $this) {
        $this.showErrorCaseNotification();
    }

    public static final /* synthetic */ Context access$getContext$p(ChatNotifications $this) {
        return $this.context;
    }

    public /* synthetic */ ChatNotifications(ChatNotificationHandler handler2, ChatApi client, Context context, DefaultConstructorMarker $constructor_marker) {
        this(handler2, client, context);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lio/getstream/chat/android/client/notifications/ChatNotifications$Companion;", "", "()V", "create", "Lio/getstream/chat/android/client/notifications/ChatNotifications;", "handler", "Lio/getstream/chat/android/client/notifications/handler/ChatNotificationHandler;", "client", "Lio/getstream/chat/android/client/api/ChatApi;", "context", "Landroid/content/Context;", "stream-chat-android-client_release"})
    public static final class Companion {
        @NotNull
        public final ChatNotifications create(@NotNull ChatNotificationHandler handler2, @NotNull ChatApi client, @NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)handler2, (String)"handler");
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            ChatNotifications chatNotifications = new ChatNotifications(handler2, client, context, null);
            boolean bl = false;
            boolean bl2 = false;
            ChatNotifications p1 = chatNotifications;
            boolean bl3 = false;
            p1.init();
            return chatNotifications;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

