/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.client.socket;

import io.getstream.chat.android.client.errors.ChatError;
import io.getstream.chat.android.client.errors.ChatErrorCode;
import io.getstream.chat.android.client.errors.ChatNetworkError;
import io.getstream.chat.android.client.events.ChatEvent;
import io.getstream.chat.android.client.events.ConnectedEvent;
import io.getstream.chat.android.client.logger.ChatLogger;
import io.getstream.chat.android.client.logger.TaggedLogger;
import io.getstream.chat.android.client.parser.ChatParser;
import io.getstream.chat.android.client.socket.ChatSocketService;
import io.getstream.chat.android.client.socket.ErrorResponse;
import io.getstream.chat.android.client.socket.SocketErrorMessage;
import io.getstream.chat.android.client.utils.Result;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J \u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0011H\u0016J \u0010\u0018\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0011H\u0016J\u0010\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\"\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\u0018\u0010 \u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010!\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u000e\u0010\"\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lio/getstream/chat/android/client/socket/EventsParser;", "Lokhttp3/WebSocketListener;", "parser", "Lio/getstream/chat/android/client/parser/ChatParser;", "(Lio/getstream/chat/android/client/parser/ChatParser;)V", "connectionEventReceived", "", "logger", "Lio/getstream/chat/android/client/logger/TaggedLogger;", "service", "Lio/getstream/chat/android/client/socket/ChatSocketService;", "handleErrorEvent", "", "error", "Lio/getstream/chat/android/client/socket/ErrorResponse;", "handleEvent", "text", "", "onClosed", "webSocket", "Lokhttp3/WebSocket;", "code", "", "reason", "onClosing", "onFailure", "chatError", "Lio/getstream/chat/android/client/errors/ChatError;", "t", "", "response", "Lokhttp3/Response;", "onMessage", "onOpen", "setSocketService", "stream-chat-android-client_release"})
public final class EventsParser
extends WebSocketListener {
    private boolean connectionEventReceived;
    private final TaggedLogger logger;
    private ChatSocketService service;
    private final ChatParser parser;

    public final void setSocketService(@NotNull ChatSocketService service) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        this.service = service;
    }

    public void onOpen(@NotNull WebSocket webSocket, @NotNull Response response) {
        Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        this.logger.logI("onOpen");
        this.connectionEventReceived = false;
    }

    public void onMessage(@NotNull WebSocket webSocket, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        try {
            this.logger.logI(text);
            Result<SocketErrorMessage> errorMessage = this.parser.fromJsonOrError(text, SocketErrorMessage.class);
            SocketErrorMessage errorData = (SocketErrorMessage)errorMessage.data();
            if (errorMessage.isSuccess() && errorData.getError() != null) {
                this.handleErrorEvent(errorData.getError());
            } else {
                this.handleEvent(text);
            }
        }
        catch (Throwable t) {
            this.logger.logE("onMessage", t);
            ChatSocketService chatSocketService = this.service;
            if (chatSocketService == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"service");
            }
            chatSocketService.onSocketError(ChatNetworkError.Companion.create$default(ChatNetworkError.Companion, ChatErrorCode.UNABLE_TO_PARSE_SOCKET_EVENT, null, 0, 6, null));
        }
    }

    public void onClosing(@NotNull WebSocket webSocket, int code, @NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
    }

    public void onClosed(@NotNull WebSocket webSocket, int code, @NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        this.onFailure(ChatNetworkError.Companion.create$default(ChatNetworkError.Companion, ChatErrorCode.SOCKET_CLOSED, null, 0, 6, null));
    }

    public void onFailure(@NotNull WebSocket webSocket, @NotNull Throwable t, @Nullable Response response) {
        Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        this.logger.logE("onFailure: " + t, t);
        ChatSocketService chatSocketService = this.service;
        if (chatSocketService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"service");
        }
        chatSocketService.onSocketError(ChatNetworkError.Companion.create$default(ChatNetworkError.Companion, ChatErrorCode.SOCKET_FAILURE, t, 0, 4, null));
    }

    private final void onFailure(ChatError chatError) {
        this.logger.logE("onFailure " + chatError, chatError);
        ChatSocketService chatSocketService = this.service;
        if (chatSocketService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"service");
        }
        chatSocketService.onSocketError(ChatNetworkError.Companion.create$default(ChatNetworkError.Companion, ChatErrorCode.SOCKET_FAILURE, chatError.getCause(), 0, 4, null));
    }

    private final void handleEvent(String text) {
        Result<ChatEvent> eventResult = this.parser.fromJsonOrError(text, ChatEvent.class);
        if (eventResult.isSuccess()) {
            ChatEvent event = (ChatEvent)eventResult.data();
            if (!this.connectionEventReceived) {
                if (event instanceof ConnectedEvent) {
                    this.connectionEventReceived = true;
                    ChatSocketService chatSocketService = this.service;
                    if (chatSocketService == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"service");
                    }
                    chatSocketService.onConnectionResolved((ConnectedEvent)event);
                } else {
                    ChatSocketService chatSocketService = this.service;
                    if (chatSocketService == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"service");
                    }
                    chatSocketService.onSocketError(ChatNetworkError.Companion.create$default(ChatNetworkError.Companion, ChatErrorCode.CANT_PARSE_CONNECTION_EVENT, null, 0, 6, null));
                }
            } else {
                ChatSocketService chatSocketService = this.service;
                if (chatSocketService == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"service");
                }
                chatSocketService.onEvent(event);
            }
        } else {
            ChatSocketService chatSocketService = this.service;
            if (chatSocketService == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"service");
            }
            chatSocketService.onSocketError(ChatNetworkError.Companion.create$default(ChatNetworkError.Companion, ChatErrorCode.CANT_PARSE_EVENT, eventResult.error().getCause(), 0, 4, null));
        }
    }

    private final void handleErrorEvent(ErrorResponse error) {
        ChatSocketService chatSocketService = this.service;
        if (chatSocketService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"service");
        }
        chatSocketService.onSocketError(ChatNetworkError.Companion.create$default(ChatNetworkError.Companion, error.getCode(), error.getMessage(), error.getStatusCode(), null, 8, null));
    }

    public EventsParser(@NotNull ChatParser parser) {
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        this.parser = parser;
        this.logger = ChatLogger.Companion.get("Events");
    }
}

