/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.client.api;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import io.getstream.chat.android.client.api.HttpLoggingInterceptorKt;
import io.getstream.chat.android.client.logger.ChatLogLevel;
import io.getstream.chat.android.client.logger.ChatLogger;
import io.getstream.chat.android.client.logger.TaggedLogger;
import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import okhttp3.Connection;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.http.HttpHeaders;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.GzipSource;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.json.JSONException;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u000e\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\bR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lio/getstream/chat/android/client/api/HttpLoggingInterceptor;", "Lokhttp3/Interceptor;", "()V", "gson", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "headersToRedact", "", "", "logger", "Lio/getstream/chat/android/client/logger/TaggedLogger;", "bodyHasUnknownEncoding", "", "headers", "Lokhttp3/Headers;", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "logHeader", "", "i", "", "redactHeader", "name", "stream-chat-android-client_release"})
public final class HttpLoggingInterceptor
implements Interceptor {
    private volatile Set<String> headersToRedact = SetsKt.emptySet();
    private final TaggedLogger logger = ChatLogger.Companion.get("Http");
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public final void redactHeader(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        TreeSet newHeadersToRedact = new TreeSet(StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE));
        Collection collection = newHeadersToRedact;
        Iterable iterable = this.headersToRedact;
        boolean bl = false;
        CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
        collection = newHeadersToRedact;
        boolean bl2 = false;
        collection.add(name);
        this.headersToRedact = newHeadersToRedact;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        int n;
        String string2;
        int n2;
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        ChatLogLevel level = this.logger.getLevel();
        Request request = chain.request();
        if (level == ChatLogLevel.NOTHING) {
            return chain.proceed(request);
        }
        RequestBody requestBody = request.body();
        Connection connection = chain.connection();
        String requestStartMessage = "--> " + request.method() + ' ' + request.url() + (connection != null ? " " + connection.protocol() : "");
        this.logger.logI(requestStartMessage);
        Headers headers = request.headers();
        if (requestBody != null) {
            MediaType mediaType = requestBody.contentType();
            if (mediaType != null) {
                MediaType mediaType2 = mediaType;
                n2 = 0;
                boolean bl = false;
                MediaType it = mediaType2;
                boolean bl2 = false;
                if (headers.get("Content-Type") == null) {
                    this.logger.logI("Content-Type: " + it);
                }
            }
            if (requestBody.contentLength() != -1L && headers.get("Content-Length") == null) {
                this.logger.logI("Content-Length: " + requestBody.contentLength());
            }
        }
        int n3 = 0;
        n2 = headers.size();
        while (n3 < n2) {
            void i;
            this.logHeader(headers, (int)i);
            ++i;
        }
        if (requestBody == null) {
            this.logger.logI("--> END " + request.method());
        } else if (this.bodyHasUnknownEncoding(request.headers())) {
            this.logger.logI("--> END " + request.method() + " (encoded body omitted)");
        } else if (requestBody.isDuplex()) {
            this.logger.logI("--> END " + request.method() + " (duplex request body omitted)");
        } else if (requestBody.isOneShot()) {
            this.logger.logI("--> END " + request.method() + " (one-shot body omitted)");
        } else {
            Buffer buffer = new Buffer();
            requestBody.writeTo((BufferedSink)buffer);
            MediaType contentType = requestBody.contentType();
            Object object = contentType;
            if (object == null || (object = object.charset(StandardCharsets.UTF_8)) == null) {
                Charset charset = StandardCharsets.UTF_8;
                object = charset;
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"StandardCharsets.UTF_8");
            }
            Object charset = object;
            this.logger.logI("");
            if (HttpLoggingInterceptorKt.access$isProbablyUtf8(buffer)) {
                this.logger.logI(buffer.readString((Charset)charset));
                this.logger.logI("--> END " + request.method() + " (" + requestBody.contentLength() + "-byte body)");
            } else {
                this.logger.logI("--> END " + request.method() + " (binary " + requestBody.contentLength() + "-byte body omitted)");
            }
        }
        long startNs = System.nanoTime();
        Response response = null;
        try {
            response = chain.proceed(request);
        }
        catch (Exception e) {
            this.logger.logI("<-- HTTP FAILED: " + e);
            throw (Throwable)e;
        }
        long tookMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNs);
        ResponseBody responseBody = response.body();
        Intrinsics.checkNotNull((Object)responseBody);
        ResponseBody responseBody2 = responseBody;
        long contentLength = responseBody2.contentLength();
        String bodySize = contentLength != -1L ? contentLength + "-byte" : "unknown-length";
        StringBuilder stringBuilder = new StringBuilder().append("<-- ").append(response.code());
        CharSequence charSequence = response.message();
        int n4 = 0;
        if (charSequence.length() == 0) {
            string2 = "";
        } else {
            char c = ' ';
            String string3 = response.message();
            n = 0;
            string2 = String.valueOf(c) + string3;
        }
        this.logger.logI(stringBuilder.append(string2).append(' ').append(response.request().url()).append(" (").append(tookMs).append("ms").append("").append(')').toString());
        Headers headers2 = response.headers();
        n4 = 0;
        n = headers2.size();
        while (n4 < n) {
            void i;
            this.logHeader(headers2, (int)i);
            ++i;
        }
        if (!HttpHeaders.promisesBody((Response)response)) {
            this.logger.logI("<-- END HTTP");
        } else if (this.bodyHasUnknownEncoding(response.headers())) {
            this.logger.logI("<-- END HTTP (encoded body omitted)");
        } else {
            MediaType contentType;
            Object object;
            BufferedSource source = responseBody2.source();
            source.request(Long.MAX_VALUE);
            Buffer buffer = source.getBuffer();
            Long gzippedLength = null;
            if (StringsKt.equals((String)"gzip", (String)headers2.get("Content-Encoding"), (boolean)true)) {
                gzippedLength = buffer.size();
                Closeable closeable = (Closeable)new GzipSource((Source)buffer.clone());
                boolean bl = false;
                boolean bl3 = false;
                Throwable throwable = null;
                try {
                    GzipSource gzippedResponseBody22 = (GzipSource)closeable;
                    boolean bl4 = false;
                    buffer = new Buffer();
                    long gzippedResponseBody22 = buffer.writeAll((Source)gzippedResponseBody22);
                }
                catch (Throwable gzippedResponseBody22) {
                    throwable = gzippedResponseBody22;
                    throw gzippedResponseBody22;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            if ((object = (contentType = responseBody2.contentType())) == null || (object = object.charset(StandardCharsets.UTF_8)) == null) {
                Charset charset = StandardCharsets.UTF_8;
                object = charset;
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"StandardCharsets.UTF_8");
            }
            Object charset = object;
            if (!HttpLoggingInterceptorKt.access$isProbablyUtf8(buffer)) {
                this.logger.logI("");
                this.logger.logI("<-- END HTTP (binary " + buffer.size() + "-byte body omitted)");
                return response;
            }
            if (contentLength != 0L) {
                this.logger.logI("");
                String logString = buffer.clone().readString((Charset)charset);
                try {
                    JsonElement json = JsonParser.parseString((String)logString);
                    String string4 = this.gson.toJson(json);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"gson.toJson(json)");
                    this.logger.logI(string4);
                }
                catch (JSONException e) {
                    this.logger.logI(logString);
                }
            }
            if (gzippedLength != null) {
                this.logger.logI("<-- END HTTP (" + buffer.size() + "-byte, " + gzippedLength + "-gzipped-byte body)");
            } else {
                this.logger.logI("<-- END HTTP (" + buffer.size() + "-byte body)");
            }
        }
        return response;
    }

    private final void logHeader(Headers headers, int i) {
        String value = this.headersToRedact.contains(headers.name(i)) ? "\u2588\u2588" : headers.value(i);
        this.logger.logI(headers.name(i) + ": " + value);
    }

    private final boolean bodyHasUnknownEncoding(Headers headers) {
        String string2 = headers.get("Content-Encoding");
        if (string2 == null) {
            return false;
        }
        String contentEncoding = string2;
        return !StringsKt.equals((String)contentEncoding, (String)"identity", (boolean)true) && !StringsKt.equals((String)contentEncoding, (String)"gzip", (boolean)true);
    }
}

