/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.client.socket;

import android.os.Handler;
import android.os.Looper;
import androidx.annotation.VisibleForTesting;
import io.getstream.chat.android.client.errors.ChatError;
import io.getstream.chat.android.client.errors.ChatErrorCode;
import io.getstream.chat.android.client.errors.ChatNetworkError;
import io.getstream.chat.android.client.events.ChatEvent;
import io.getstream.chat.android.client.events.ConnectedEvent;
import io.getstream.chat.android.client.logger.ChatLogger;
import io.getstream.chat.android.client.logger.TaggedLogger;
import io.getstream.chat.android.client.models.User;
import io.getstream.chat.android.client.network.NetworkStateProvider;
import io.getstream.chat.android.client.socket.ChatSocketService;
import io.getstream.chat.android.client.socket.ChatSocketServiceImpl;
import io.getstream.chat.android.client.socket.EventsParser;
import io.getstream.chat.android.client.socket.HealthMonitor;
import io.getstream.chat.android.client.socket.Socket;
import io.getstream.chat.android.client.socket.SocketFactory;
import io.getstream.chat.android.client.socket.SocketListener;
import io.getstream.chat.android.client.token.TokenManager;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.Delegates;
import kotlin.properties.ObservableProperty;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0091\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004*\u0001\u0015\b\u0000\u0018\u0000 C2\u00020\u0001:\u0003CDEB\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0011H\u0016J\u0018\u0010'\u001a\u00020%2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)H\u0016J\u001c\u0010+\u001a\u00020%2\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020%0-H\u0002J\u0010\u0010.\u001a\u00020%2\u0006\u0010\t\u001a\u00020\nH\u0002J\b\u0010/\u001a\u00020%H\u0016J\u0010\u00100\u001a\u00020%2\u0006\u00101\u001a\u000202H\u0002J\u0010\u00103\u001a\u00020%2\u0006\u00104\u001a\u000205H\u0016J\u0010\u00106\u001a\u00020%2\u0006\u00104\u001a\u000207H\u0016J\u0010\u00108\u001a\u00020%2\u0006\u00101\u001a\u000209H\u0016J\u0010\u0010:\u001a\u00020%2\u0006\u0010\t\u001a\u00020\nH\u0002J\b\u0010;\u001a\u00020%H\u0002J\u0010\u0010<\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0011H\u0016J\u0015\u0010=\u001a\u00020%2\u0006\u00104\u001a\u000207H\u0000\u00a2\u0006\u0002\b>J\u0010\u0010?\u001a\u00020%2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010@\u001a\u00020%2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)2\u0006\u0010A\u001a\u00020BH\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R1\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020\u001a8@@BX\u0081\u008e\u0002\u00a2\u0006\u0018\n\u0004\b\"\u0010#\u0012\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lio/getstream/chat/android/client/socket/ChatSocketServiceImpl;", "Lio/getstream/chat/android/client/socket/ChatSocketService;", "tokenManager", "Lio/getstream/chat/android/client/token/TokenManager;", "socketFactory", "Lio/getstream/chat/android/client/socket/SocketFactory;", "networkStateProvider", "Lio/getstream/chat/android/client/network/NetworkStateProvider;", "(Lio/getstream/chat/android/client/token/TokenManager;Lio/getstream/chat/android/client/socket/SocketFactory;Lio/getstream/chat/android/client/network/NetworkStateProvider;)V", "connectionConf", "Lio/getstream/chat/android/client/socket/ChatSocketServiceImpl$ConnectionConf;", "eventUiHandler", "Landroid/os/Handler;", "healthMonitor", "Lio/getstream/chat/android/client/socket/HealthMonitor;", "listeners", "", "Lio/getstream/chat/android/client/socket/SocketListener;", "logger", "Lio/getstream/chat/android/client/logger/TaggedLogger;", "networkStateListener", "io/getstream/chat/android/client/socket/ChatSocketServiceImpl$networkStateListener$1", "Lio/getstream/chat/android/client/socket/ChatSocketServiceImpl$networkStateListener$1;", "socket", "Lio/getstream/chat/android/client/socket/Socket;", "<set-?>", "Lio/getstream/chat/android/client/socket/ChatSocketServiceImpl$State;", "state", "getState$stream_chat_android_client_release$annotations", "()V", "getState$stream_chat_android_client_release", "()Lio/getstream/chat/android/client/socket/ChatSocketServiceImpl$State;", "setState", "(Lio/getstream/chat/android/client/socket/ChatSocketServiceImpl$State;)V", "state$delegate", "Lkotlin/properties/ReadWriteProperty;", "addListener", "", "listener", "anonymousConnect", "endpoint", "", "apiKey", "callListeners", "call", "Lkotlin/Function1;", "connect", "disconnect", "onChatNetworkError", "error", "Lio/getstream/chat/android/client/errors/ChatNetworkError;", "onConnectionResolved", "event", "Lio/getstream/chat/android/client/events/ConnectedEvent;", "onEvent", "Lio/getstream/chat/android/client/events/ChatEvent;", "onSocketError", "Lio/getstream/chat/android/client/errors/ChatError;", "reconnect", "releaseSocket", "removeListener", "sendEvent", "sendEvent$stream_chat_android_client_release", "setupSocket", "userConnect", "user", "Lio/getstream/chat/android/client/models/User;", "Companion", "ConnectionConf", "State", "stream-chat-android-client_release"})
public final class ChatSocketServiceImpl
implements ChatSocketService {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final TaggedLogger logger;
    private ConnectionConf connectionConf;
    private Socket socket;
    private final List<SocketListener> listeners;
    private final Handler eventUiHandler;
    private final HealthMonitor healthMonitor;
    private final networkStateListener.1 networkStateListener;
    @NotNull
    private final ReadWriteProperty state$delegate;
    private final TokenManager tokenManager;
    private final SocketFactory socketFactory;
    private final NetworkStateProvider networkStateProvider;
    @NotNull
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl(ChatSocketServiceImpl.class, "state", "getState$stream_chat_android_client_release()Lio/getstream/chat/android/client/socket/ChatSocketServiceImpl$State;", 0))};
        Companion = new Companion(null);
    }

    @VisibleForTesting
    public static /* synthetic */ void getState$stream_chat_android_client_release$annotations() {
    }

    @NotNull
    public final State getState$stream_chat_android_client_release() {
        return (State)this.state$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    private final void setState(State state2) {
        this.state$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)state2);
    }

    @Override
    public void onSocketError(@NotNull ChatError error) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            if (!(Intrinsics.areEqual((Object)this.getState$stream_chat_android_client_release(), (Object)State.DisconnectedPermanently.INSTANCE) ^ true)) break block2;
            this.logger.logE(error);
            this.callListeners((Function1<? super SocketListener, Unit>)((Function1)new Function1<SocketListener, Unit>(error){
                final /* synthetic */ ChatError $error;

                public final void invoke(@NotNull SocketListener it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    it.onError(this.$error);
                }
                {
                    this.$error = chatError;
                    super(1);
                }
            }));
            ChatError chatError = error;
            if (!(chatError instanceof ChatNetworkError)) {
                chatError = null;
            }
            ChatNetworkError chatNetworkError = (ChatNetworkError)chatError;
            if (chatNetworkError != null) {
                ChatNetworkError chatNetworkError2 = chatNetworkError;
                ChatSocketServiceImpl chatSocketServiceImpl = this;
                boolean bl = false;
                boolean bl2 = false;
                ChatNetworkError p1 = chatNetworkError2;
                boolean bl3 = false;
                chatSocketServiceImpl.onChatNetworkError(p1);
            }
        }
    }

    private final void onChatNetworkError(ChatNetworkError error) {
        int n = error.getStreamCode();
        if (n != ChatErrorCode.PARSER_ERROR.getCode() && n != ChatErrorCode.CANT_PARSE_CONNECTION_EVENT.getCode() && n != ChatErrorCode.CANT_PARSE_EVENT.getCode() && n != ChatErrorCode.UNABLE_TO_PARSE_SOCKET_EVENT.getCode() && n != ChatErrorCode.NO_ERROR_BODY.getCode()) {
            if (n == ChatErrorCode.TOKEN_EXPIRED.getCode()) {
                this.tokenManager.expireToken();
                this.tokenManager.loadSync();
                this.setState(State.Disconnected.INSTANCE);
            } else if (n == ChatErrorCode.UNDEFINED_TOKEN.getCode() || n == ChatErrorCode.INVALID_TOKEN.getCode() || n == ChatErrorCode.API_KEY_NOT_FOUND.getCode()) {
                this.setState(State.DisconnectedPermanently.INSTANCE);
            } else if (n == ChatErrorCode.NETWORK_FAILED.getCode() || n == ChatErrorCode.SOCKET_CLOSED.getCode() || n == ChatErrorCode.SOCKET_FAILURE.getCode()) {
                this.setState(State.Disconnected.INSTANCE);
            } else {
                this.setState(State.Disconnected.INSTANCE);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(@NotNull SocketListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        List<SocketListener> list = this.listeners;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (list) {
            boolean bl3 = false;
            bl2 = this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(@NotNull SocketListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        List<SocketListener> list = this.listeners;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (list) {
            boolean bl3 = false;
            bl2 = this.listeners.add(listener);
        }
    }

    @Override
    public void anonymousConnect(@NotNull String endpoint, @NotNull String apiKey) {
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        this.connect(new ConnectionConf.AnonymousConnectionConf(endpoint, apiKey));
    }

    @Override
    public void userConnect(@NotNull String endpoint, @NotNull String apiKey, @NotNull User user) {
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        this.connect(new ConnectionConf.UserConnectionConf(endpoint, apiKey, user));
    }

    private final void connect(ConnectionConf connectionConf) {
        this.logger.logI("connect");
        this.connectionConf = connectionConf;
        if (this.networkStateProvider.isConnected()) {
            this.setState(State.Disconnected.INSTANCE);
            this.setupSocket(connectionConf);
        } else {
            this.setState(State.NetworkDisconnected.INSTANCE);
        }
        this.networkStateProvider.subscribe(this.networkStateListener);
    }

    @Override
    public void disconnect() {
        this.setState(State.DisconnectedPermanently.INSTANCE);
    }

    @Override
    public void onConnectionResolved(@NotNull ConnectedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.setState(new State.Connected(event));
    }

    @Override
    public void onEvent(@NotNull ChatEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.healthMonitor.ack();
        this.callListeners((Function1<? super SocketListener, Unit>)((Function1)new Function1<SocketListener, Unit>(event){
            final /* synthetic */ ChatEvent $event;

            public final void invoke(@NotNull SocketListener listener) {
                Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
                listener.onEvent(this.$event);
            }
            {
                this.$event = chatEvent;
                super(1);
            }
        }));
    }

    public final void sendEvent$stream_chat_android_client_release(@NotNull ChatEvent event) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Socket socket = this.socket;
            if (socket == null) break block0;
            socket.send(event);
        }
    }

    private final void reconnect(ConnectionConf connectionConf) {
        this.releaseSocket();
        this.setupSocket(connectionConf);
    }

    private final void setupSocket(ConnectionConf connectionConf) {
        Unit unit;
        this.logger.logI("setupSocket");
        ConnectionConf connectionConf2 = connectionConf;
        if (connectionConf2 instanceof ConnectionConf.None) {
            this.setState(State.DisconnectedPermanently.INSTANCE);
            unit = Unit.INSTANCE;
        } else if (connectionConf2 instanceof ConnectionConf.AnonymousConnectionConf) {
            this.setState(State.Connecting.INSTANCE);
            this.socket = this.socketFactory.createAnonymousSocket(((ConnectionConf.AnonymousConnectionConf)connectionConf).getEndpoint(), ((ConnectionConf.AnonymousConnectionConf)connectionConf).getApiKey());
            unit = Unit.INSTANCE;
        } else if (connectionConf2 instanceof ConnectionConf.UserConnectionConf) {
            this.setState(State.Connecting.INSTANCE);
            this.socket = this.socketFactory.createNormalSocket(((ConnectionConf.UserConnectionConf)connectionConf).getEndpoint(), ((ConnectionConf.UserConnectionConf)connectionConf).getApiKey(), ((ConnectionConf.UserConnectionConf)connectionConf).getUser());
            unit = Unit.INSTANCE;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Unit $this$exhaustive$iv = unit;
        boolean $i$f$getExhaustive = false;
    }

    private final void releaseSocket() {
        Socket socket = this.socket;
        if (socket != null) {
            socket.close(1000, "Connection close by client");
        }
        this.socket = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void callListeners(Function1<? super SocketListener, Unit> call) {
        List<SocketListener> list = this.listeners;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (list) {
            boolean bl3 = false;
            Iterable $this$forEach$iv = this.listeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SocketListener listener = (SocketListener)element$iv;
                boolean bl4 = false;
                this.eventUiHandler.post(new Runnable(listener, this, call){
                    final /* synthetic */ SocketListener $listener;
                    final /* synthetic */ ChatSocketServiceImpl this$0;
                    final /* synthetic */ Function1 $call$inlined;
                    {
                        this.$listener = socketListener;
                        this.this$0 = chatSocketServiceImpl;
                        this.$call$inlined = function1;
                    }

                    public final void run() {
                        this.$call$inlined.invoke((Object)this.$listener);
                    }
                });
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private ChatSocketServiceImpl(TokenManager tokenManager, SocketFactory socketFactory, NetworkStateProvider networkStateProvider) {
        this.tokenManager = tokenManager;
        this.socketFactory = socketFactory;
        this.networkStateProvider = networkStateProvider;
        this.logger = ChatLogger.Companion.get("SocketService");
        this.connectionConf = ConnectionConf.None.INSTANCE;
        boolean bl = false;
        this.listeners = new ArrayList();
        this.eventUiHandler = new Handler(Looper.getMainLooper());
        this.healthMonitor = new HealthMonitor(new HealthMonitor.HealthCallback(this){
            final /* synthetic */ ChatSocketServiceImpl this$0;

            public void reconnect() {
                ChatSocketServiceImpl.access$reconnect(this.this$0, ChatSocketServiceImpl.access$getConnectionConf$p(this.this$0));
            }

            public void check() {
                block1: {
                    State state2 = this.this$0.getState$stream_chat_android_client_release();
                    if (!(state2 instanceof State.Connected)) {
                        state2 = null;
                    }
                    State.Connected connected = (State.Connected)state2;
                    if (connected == null) break block1;
                    State.Connected connected2 = connected;
                    boolean bl = false;
                    boolean bl2 = false;
                    State.Connected it = connected2;
                    boolean bl3 = false;
                    this.this$0.sendEvent$stream_chat_android_client_release(it.getEvent());
                }
            }
            {
                this.this$0 = this$0;
            }
        });
        this.networkStateListener = new NetworkStateProvider.NetworkStateListener(this){
            final /* synthetic */ ChatSocketServiceImpl this$0;

            public void onConnected() {
                if (Intrinsics.areEqual((Object)this.this$0.getState$stream_chat_android_client_release(), (Object)State.Disconnected.INSTANCE) || Intrinsics.areEqual((Object)this.this$0.getState$stream_chat_android_client_release(), (Object)State.NetworkDisconnected.INSTANCE)) {
                    ChatSocketServiceImpl.access$getLogger$p(this.this$0).logI("network connected, reconnecting socket");
                    ChatSocketServiceImpl.access$reconnect(this.this$0, ChatSocketServiceImpl.access$getConnectionConf$p(this.this$0));
                }
            }

            public void onDisconnected() {
                ChatSocketServiceImpl.access$setState$p(this.this$0, State.NetworkDisconnected.INSTANCE);
            }
            {
                this.this$0 = this$0;
            }
        };
        Delegates delegates = Delegates.INSTANCE;
        State.Disconnected disconnected = State.Disconnected.INSTANCE;
        if (disconnected == null) {
            throw new NullPointerException("null cannot be cast to non-null type io.getstream.chat.android.client.socket.ChatSocketServiceImpl.State");
        }
        State initialValue$iv = disconnected;
        boolean $i$f$observable = false;
        this.state$delegate = (ReadWriteProperty)new ObservableProperty<State>((Object)initialValue$iv, (Object)initialValue$iv, this){
            final /* synthetic */ Object $initialValue;
            final /* synthetic */ ChatSocketServiceImpl this$0;
            {
                this.$initialValue = $captured_local_variable$1;
                this.this$0 = chatSocketServiceImpl;
                super($super_call_param$2);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            protected void afterChange(@NotNull KProperty property, Object oldValue, Object newValue) {
                block0: {
                    void var8_8;
                    block4: {
                        block3: {
                            block2: {
                                void newState;
                                block1: {
                                    void oldState;
                                    Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                                    State state2 = (State)newValue;
                                    State state3 = (State)oldValue;
                                    KProperty $noName_0 = property;
                                    boolean bl = false;
                                    if (!(Intrinsics.areEqual((Object)oldState, (Object)newState) ^ true)) break block0;
                                    ChatSocketServiceImpl.access$getLogger$p(this.this$0).logI("updateState: " + newState.getClass().getSimpleName());
                                    var8_8 = newState;
                                    if (!(var8_8 instanceof State.Connecting)) break block1;
                                    ChatSocketServiceImpl.access$getHealthMonitor$p(this.this$0).stop();
                                    ChatSocketServiceImpl.access$callListeners(this.this$0, state.2.1.INSTANCE);
                                    break block0;
                                }
                                if (!(var8_8 instanceof State.Connected)) break block2;
                                ChatSocketServiceImpl.access$getHealthMonitor$p(this.this$0).start();
                                ChatSocketServiceImpl.access$callListeners(this.this$0, (Function1)new Function1<SocketListener, Unit>((State)newState){
                                    final /* synthetic */ State $newState;
                                    {
                                        this.$newState = state2;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull SocketListener it) {
                                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                        it.onConnected(((State.Connected)this.$newState).getEvent());
                                    }
                                });
                                break block0;
                            }
                            if (!(var8_8 instanceof State.NetworkDisconnected)) break block3;
                            ChatSocketServiceImpl.access$releaseSocket(this.this$0);
                            ChatSocketServiceImpl.access$getHealthMonitor$p(this.this$0).stop();
                            ChatSocketServiceImpl.access$callListeners(this.this$0, state.2.3.INSTANCE);
                            break block0;
                        }
                        if (!(var8_8 instanceof State.Disconnected)) break block4;
                        ChatSocketServiceImpl.access$releaseSocket(this.this$0);
                        ChatSocketServiceImpl.access$getHealthMonitor$p(this.this$0).onDisconnected();
                        ChatSocketServiceImpl.access$callListeners(this.this$0, state.2.4.INSTANCE);
                        break block0;
                    }
                    if (!(var8_8 instanceof State.DisconnectedPermanently)) break block0;
                    ChatSocketServiceImpl.access$releaseSocket(this.this$0);
                    ChatSocketServiceImpl.access$setConnectionConf$p(this.this$0, ConnectionConf.None.INSTANCE);
                    ChatSocketServiceImpl.access$getNetworkStateProvider$p(this.this$0).unsubscribe(ChatSocketServiceImpl.access$getNetworkStateListener$p(this.this$0));
                    ChatSocketServiceImpl.access$getHealthMonitor$p(this.this$0).stop();
                    ChatSocketServiceImpl.access$callListeners(this.this$0, state.2.5.INSTANCE);
                }
            }
        };
    }

    public static final /* synthetic */ void access$reconnect(ChatSocketServiceImpl $this, ConnectionConf connectionConf) {
        $this.reconnect(connectionConf);
    }

    public static final /* synthetic */ ConnectionConf access$getConnectionConf$p(ChatSocketServiceImpl $this) {
        return $this.connectionConf;
    }

    public static final /* synthetic */ void access$setConnectionConf$p(ChatSocketServiceImpl $this, ConnectionConf connectionConf) {
        $this.connectionConf = connectionConf;
    }

    public static final /* synthetic */ State access$getState$p(ChatSocketServiceImpl $this) {
        return $this.getState$stream_chat_android_client_release();
    }

    public static final /* synthetic */ void access$setState$p(ChatSocketServiceImpl $this, State state2) {
        $this.setState(state2);
    }

    public static final /* synthetic */ TaggedLogger access$getLogger$p(ChatSocketServiceImpl $this) {
        return $this.logger;
    }

    public static final /* synthetic */ HealthMonitor access$getHealthMonitor$p(ChatSocketServiceImpl $this) {
        return $this.healthMonitor;
    }

    public static final /* synthetic */ void access$callListeners(ChatSocketServiceImpl $this, Function1 call) {
        $this.callListeners((Function1<? super SocketListener, Unit>)call);
    }

    public static final /* synthetic */ void access$releaseSocket(ChatSocketServiceImpl $this) {
        $this.releaseSocket();
    }

    public static final /* synthetic */ NetworkStateProvider access$getNetworkStateProvider$p(ChatSocketServiceImpl $this) {
        return $this.networkStateProvider;
    }

    public static final /* synthetic */ networkStateListener.1 access$getNetworkStateListener$p(ChatSocketServiceImpl $this) {
        return $this.networkStateListener;
    }

    public /* synthetic */ ChatSocketServiceImpl(TokenManager tokenManager, SocketFactory socketFactory, NetworkStateProvider networkStateProvider, DefaultConstructorMarker $constructor_marker) {
        this(tokenManager, socketFactory, networkStateProvider);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001:\u0003\u0003\u0004\u0005B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0003\u0006\u0007\b\u00a8\u0006\t"}, d2={"Lio/getstream/chat/android/client/socket/ChatSocketServiceImpl$ConnectionConf;", "", "()V", "AnonymousConnectionConf", "None", "UserConnectionConf", "Lio/getstream/chat/android/client/socket/ChatSocketServiceImpl$ConnectionConf$None;", "Lio/getstream/chat/android/client/socket/ChatSocketServiceImpl$ConnectionConf$AnonymousConnectionConf;", "Lio/getstream/chat/android/client/socket/ChatSocketServiceImpl$ConnectionConf$UserConnectionConf;", "stream-chat-android-client_release"})
    public static abstract class ConnectionConf {
        private ConnectionConf() {
        }

        public /* synthetic */ ConnectionConf(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lio/getstream/chat/android/client/socket/ChatSocketServiceImpl$ConnectionConf$None;", "Lio/getstream/chat/android/client/socket/ChatSocketServiceImpl$ConnectionConf;", "()V", "stream-chat-android-client_release"})
        public static final class None
        extends ConnectionConf {
            @NotNull
            public static final None INSTANCE;

            private None() {
                super(null);
            }

            static {
                None none;
                INSTANCE = none = new None();
            }
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lio/getstream/chat/android/client/socket/ChatSocketServiceImpl$ConnectionConf$AnonymousConnectionConf;", "Lio/getstream/chat/android/client/socket/ChatSocketServiceImpl$ConnectionConf;", "endpoint", "", "apiKey", "(Ljava/lang/String;Ljava/lang/String;)V", "getApiKey", "()Ljava/lang/String;", "getEndpoint", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "stream-chat-android-client_release"})
        public static final class AnonymousConnectionConf
        extends ConnectionConf {
            @NotNull
            private final String endpoint;
            @NotNull
            private final String apiKey;

            @NotNull
            public final String getEndpoint() {
                return this.endpoint;
            }

            @NotNull
            public final String getApiKey() {
                return this.apiKey;
            }

            public AnonymousConnectionConf(@NotNull String endpoint, @NotNull String apiKey) {
                Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
                Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
                super(null);
                this.endpoint = endpoint;
                this.apiKey = apiKey;
            }

            @NotNull
            public final String component1() {
                return this.endpoint;
            }

            @NotNull
            public final String component2() {
                return this.apiKey;
            }

            @NotNull
            public final AnonymousConnectionConf copy(@NotNull String endpoint, @NotNull String apiKey) {
                Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
                Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
                return new AnonymousConnectionConf(endpoint, apiKey);
            }

            public static /* synthetic */ AnonymousConnectionConf copy$default(AnonymousConnectionConf anonymousConnectionConf, String string2, String string3, int n, Object object) {
                if ((n & 1) != 0) {
                    string2 = anonymousConnectionConf.endpoint;
                }
                if ((n & 2) != 0) {
                    string3 = anonymousConnectionConf.apiKey;
                }
                return anonymousConnectionConf.copy(string2, string3);
            }

            @NotNull
            public String toString() {
                return "AnonymousConnectionConf(endpoint=" + this.endpoint + ", apiKey=" + this.apiKey + ")";
            }

            public int hashCode() {
                String string2 = this.endpoint;
                String string3 = this.apiKey;
                return (string2 != null ? string2.hashCode() : 0) * 31 + (string3 != null ? string3.hashCode() : 0);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof AnonymousConnectionConf)) break block3;
                        AnonymousConnectionConf anonymousConnectionConf = (AnonymousConnectionConf)object;
                        if (!Intrinsics.areEqual((Object)this.endpoint, (Object)anonymousConnectionConf.endpoint) || !Intrinsics.areEqual((Object)this.apiKey, (Object)anonymousConnectionConf.apiKey)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Lio/getstream/chat/android/client/socket/ChatSocketServiceImpl$ConnectionConf$UserConnectionConf;", "Lio/getstream/chat/android/client/socket/ChatSocketServiceImpl$ConnectionConf;", "endpoint", "", "apiKey", "user", "Lio/getstream/chat/android/client/models/User;", "(Ljava/lang/String;Ljava/lang/String;Lio/getstream/chat/android/client/models/User;)V", "getApiKey", "()Ljava/lang/String;", "getEndpoint", "getUser", "()Lio/getstream/chat/android/client/models/User;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "stream-chat-android-client_release"})
        public static final class UserConnectionConf
        extends ConnectionConf {
            @NotNull
            private final String endpoint;
            @NotNull
            private final String apiKey;
            @NotNull
            private final User user;

            @NotNull
            public final String getEndpoint() {
                return this.endpoint;
            }

            @NotNull
            public final String getApiKey() {
                return this.apiKey;
            }

            @NotNull
            public final User getUser() {
                return this.user;
            }

            public UserConnectionConf(@NotNull String endpoint, @NotNull String apiKey, @NotNull User user) {
                Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
                Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
                Intrinsics.checkNotNullParameter((Object)user, (String)"user");
                super(null);
                this.endpoint = endpoint;
                this.apiKey = apiKey;
                this.user = user;
            }

            @NotNull
            public final String component1() {
                return this.endpoint;
            }

            @NotNull
            public final String component2() {
                return this.apiKey;
            }

            @NotNull
            public final User component3() {
                return this.user;
            }

            @NotNull
            public final UserConnectionConf copy(@NotNull String endpoint, @NotNull String apiKey, @NotNull User user) {
                Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
                Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
                Intrinsics.checkNotNullParameter((Object)user, (String)"user");
                return new UserConnectionConf(endpoint, apiKey, user);
            }

            public static /* synthetic */ UserConnectionConf copy$default(UserConnectionConf userConnectionConf, String string2, String string3, User user, int n, Object object) {
                if ((n & 1) != 0) {
                    string2 = userConnectionConf.endpoint;
                }
                if ((n & 2) != 0) {
                    string3 = userConnectionConf.apiKey;
                }
                if ((n & 4) != 0) {
                    user = userConnectionConf.user;
                }
                return userConnectionConf.copy(string2, string3, user);
            }

            @NotNull
            public String toString() {
                return "UserConnectionConf(endpoint=" + this.endpoint + ", apiKey=" + this.apiKey + ", user=" + this.user + ")";
            }

            public int hashCode() {
                String string2 = this.endpoint;
                String string3 = this.apiKey;
                User user = this.user;
                return ((string2 != null ? string2.hashCode() : 0) * 31 + (string3 != null ? string3.hashCode() : 0)) * 31 + (user != null ? ((Object)user).hashCode() : 0);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof UserConnectionConf)) break block3;
                        UserConnectionConf userConnectionConf = (UserConnectionConf)object;
                        if (!Intrinsics.areEqual((Object)this.endpoint, (Object)userConnectionConf.endpoint) || !Intrinsics.areEqual((Object)this.apiKey, (Object)userConnectionConf.apiKey) || !Intrinsics.areEqual((Object)this.user, (Object)userConnectionConf.user)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b1\u0018\u00002\u00020\u0001:\u0005\u0003\u0004\u0005\u0006\u0007B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0005\b\t\n\u000b\f\u00a8\u0006\r"}, d2={"Lio/getstream/chat/android/client/socket/ChatSocketServiceImpl$State;", "", "()V", "Connected", "Connecting", "Disconnected", "DisconnectedPermanently", "NetworkDisconnected", "Lio/getstream/chat/android/client/socket/ChatSocketServiceImpl$State$Connecting;", "Lio/getstream/chat/android/client/socket/ChatSocketServiceImpl$State$Connected;", "Lio/getstream/chat/android/client/socket/ChatSocketServiceImpl$State$NetworkDisconnected;", "Lio/getstream/chat/android/client/socket/ChatSocketServiceImpl$State$Disconnected;", "Lio/getstream/chat/android/client/socket/ChatSocketServiceImpl$State$DisconnectedPermanently;", "stream-chat-android-client_release"})
    @VisibleForTesting
    public static abstract class State {
        private State() {
        }

        public /* synthetic */ State(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lio/getstream/chat/android/client/socket/ChatSocketServiceImpl$State$Connecting;", "Lio/getstream/chat/android/client/socket/ChatSocketServiceImpl$State;", "()V", "stream-chat-android-client_release"})
        public static final class Connecting
        extends State {
            @NotNull
            public static final Connecting INSTANCE;

            private Connecting() {
                super(null);
            }

            static {
                Connecting connecting;
                INSTANCE = connecting = new Connecting();
            }
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lio/getstream/chat/android/client/socket/ChatSocketServiceImpl$State$Connected;", "Lio/getstream/chat/android/client/socket/ChatSocketServiceImpl$State;", "event", "Lio/getstream/chat/android/client/events/ConnectedEvent;", "(Lio/getstream/chat/android/client/events/ConnectedEvent;)V", "getEvent", "()Lio/getstream/chat/android/client/events/ConnectedEvent;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "stream-chat-android-client_release"})
        public static final class Connected
        extends State {
            @NotNull
            private final ConnectedEvent event;

            @NotNull
            public final ConnectedEvent getEvent() {
                return this.event;
            }

            public Connected(@NotNull ConnectedEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                super(null);
                this.event = event;
            }

            @NotNull
            public final ConnectedEvent component1() {
                return this.event;
            }

            @NotNull
            public final Connected copy(@NotNull ConnectedEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                return new Connected(event);
            }

            public static /* synthetic */ Connected copy$default(Connected connected, ConnectedEvent connectedEvent, int n, Object object) {
                if ((n & 1) != 0) {
                    connectedEvent = connected.event;
                }
                return connected.copy(connectedEvent);
            }

            @NotNull
            public String toString() {
                return "Connected(event=" + this.event + ")";
            }

            public int hashCode() {
                ConnectedEvent connectedEvent = this.event;
                return connectedEvent != null ? ((Object)connectedEvent).hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Connected)) break block3;
                        Connected connected = (Connected)object;
                        if (!Intrinsics.areEqual((Object)this.event, (Object)connected.event)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lio/getstream/chat/android/client/socket/ChatSocketServiceImpl$State$NetworkDisconnected;", "Lio/getstream/chat/android/client/socket/ChatSocketServiceImpl$State;", "()V", "stream-chat-android-client_release"})
        public static final class NetworkDisconnected
        extends State {
            @NotNull
            public static final NetworkDisconnected INSTANCE;

            private NetworkDisconnected() {
                super(null);
            }

            static {
                NetworkDisconnected networkDisconnected;
                INSTANCE = networkDisconnected = new NetworkDisconnected();
            }
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lio/getstream/chat/android/client/socket/ChatSocketServiceImpl$State$Disconnected;", "Lio/getstream/chat/android/client/socket/ChatSocketServiceImpl$State;", "()V", "stream-chat-android-client_release"})
        public static final class Disconnected
        extends State {
            @NotNull
            public static final Disconnected INSTANCE;

            private Disconnected() {
                super(null);
            }

            static {
                Disconnected disconnected;
                INSTANCE = disconnected = new Disconnected();
            }
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lio/getstream/chat/android/client/socket/ChatSocketServiceImpl$State$DisconnectedPermanently;", "Lio/getstream/chat/android/client/socket/ChatSocketServiceImpl$State;", "()V", "stream-chat-android-client_release"})
        public static final class DisconnectedPermanently
        extends State {
            @NotNull
            public static final DisconnectedPermanently INSTANCE;

            private DisconnectedPermanently() {
                super(null);
            }

            static {
                DisconnectedPermanently disconnectedPermanently;
                INSTANCE = disconnectedPermanently = new DisconnectedPermanently();
            }
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"Lio/getstream/chat/android/client/socket/ChatSocketServiceImpl$Companion;", "", "()V", "create", "Lio/getstream/chat/android/client/socket/ChatSocketServiceImpl;", "tokenManager", "Lio/getstream/chat/android/client/token/TokenManager;", "socketFactory", "Lio/getstream/chat/android/client/socket/SocketFactory;", "eventsParser", "Lio/getstream/chat/android/client/socket/EventsParser;", "networkStateProvider", "Lio/getstream/chat/android/client/network/NetworkStateProvider;", "stream-chat-android-client_release"})
    public static final class Companion {
        @NotNull
        public final ChatSocketServiceImpl create(@NotNull TokenManager tokenManager, @NotNull SocketFactory socketFactory, @NotNull EventsParser eventsParser, @NotNull NetworkStateProvider networkStateProvider) {
            Intrinsics.checkNotNullParameter((Object)tokenManager, (String)"tokenManager");
            Intrinsics.checkNotNullParameter((Object)socketFactory, (String)"socketFactory");
            Intrinsics.checkNotNullParameter((Object)((Object)eventsParser), (String)"eventsParser");
            Intrinsics.checkNotNullParameter((Object)networkStateProvider, (String)"networkStateProvider");
            ChatSocketServiceImpl chatSocketServiceImpl = new ChatSocketServiceImpl(tokenManager, socketFactory, networkStateProvider, null);
            boolean bl = false;
            boolean bl2 = false;
            ChatSocketServiceImpl it = chatSocketServiceImpl;
            boolean bl3 = false;
            eventsParser.setSocketService(it);
            return chatSocketServiceImpl;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

