/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.client.socket;

import io.getstream.chat.android.client.ChatClient;
import io.getstream.chat.android.client.logger.ChatLogger;
import io.getstream.chat.android.client.logger.TaggedLogger;
import io.getstream.chat.android.client.models.User;
import io.getstream.chat.android.client.parser.ChatParser;
import io.getstream.chat.android.client.socket.EventsParser;
import io.getstream.chat.android.client.socket.Socket;
import io.getstream.chat.android.client.token.TokenManager;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ(\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J(\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0016\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eJ\u001e\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lio/getstream/chat/android/client/socket/SocketFactory;", "", "eventsParser", "Lio/getstream/chat/android/client/socket/EventsParser;", "parser", "Lio/getstream/chat/android/client/parser/ChatParser;", "tokenManager", "Lio/getstream/chat/android/client/token/TokenManager;", "(Lio/getstream/chat/android/client/socket/EventsParser;Lio/getstream/chat/android/client/parser/ChatParser;Lio/getstream/chat/android/client/token/TokenManager;)V", "httpClient", "Lokhttp3/OkHttpClient;", "logger", "Lio/getstream/chat/android/client/logger/TaggedLogger;", "buildUrl", "", "endpoint", "apiKey", "user", "Lio/getstream/chat/android/client/models/User;", "isAnonymous", "", "buildUserDetailJson", "create", "Lio/getstream/chat/android/client/socket/Socket;", "createAnonymousSocket", "createNormalSocket", "Companion", "stream-chat-android-client_release"})
public final class SocketFactory {
    private final TaggedLogger logger;
    private final OkHttpClient httpClient;
    private final EventsParser eventsParser;
    private final ChatParser parser;
    private final TokenManager tokenManager;
    private static final String ANONYMOUS_USER_ID = "anon";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Socket createAnonymousSocket(@NotNull String endpoint, @NotNull String apiKey) {
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        return this.create(endpoint, apiKey, new User(ANONYMOUS_USER_ID, null, false, false, null, false, null, null, null, 0, 0, 0, null, null, null, null, 65534, null), true);
    }

    @NotNull
    public final Socket createNormalSocket(@NotNull String endpoint, @NotNull String apiKey, @NotNull User user) {
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        return this.create(endpoint, apiKey, user, false);
    }

    private final Socket create(String endpoint, String apiKey, User user, boolean isAnonymous) {
        String url = this.buildUrl(endpoint, apiKey, user, isAnonymous);
        Request request = new Request.Builder().url(url).build();
        WebSocket newWebSocket = this.httpClient.newWebSocket(request, (WebSocketListener)this.eventsParser);
        this.logger.logI("new web socket: " + url);
        return new Socket(newWebSocket, this.parser);
    }

    private final String buildUrl(String endpoint, String apiKey, User user, boolean isAnonymous) {
        String string2;
        String json = this.buildUserDetailJson(user);
        try {
            String string3;
            String string4 = URLEncoder.encode(json, StandardCharsets.UTF_8.name());
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"URLEncoder.encode(json, \u2026ardCharsets.UTF_8.name())");
            json = string4;
            String baseWsUrl = endpoint + "connect?json=" + json + "&api_key=" + apiKey;
            if (isAnonymous) {
                string3 = baseWsUrl + "&stream-auth-type=anonymous";
            } else {
                String token = this.tokenManager.getToken();
                string3 = baseWsUrl + "&authorization=" + token + "&stream-auth-type=jwt";
            }
            string2 = string3;
        }
        catch (Throwable throwable) {
            throw (Throwable)new UnsupportedEncodingException("Unable to encode user details json: " + json);
        }
        return string2;
    }

    private final String buildUserDetailJson(User user) {
        Map data = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"user_details", (Object)user), TuplesKt.to((Object)"user_id", (Object)user.getId()), TuplesKt.to((Object)"server_determines_connection_id", (Object)true), TuplesKt.to((Object)"X-STREAM-CLIENT", (Object)ChatClient.Companion.instance().getVersion())});
        return this.parser.toJson(data);
    }

    public SocketFactory(@NotNull EventsParser eventsParser, @NotNull ChatParser parser, @NotNull TokenManager tokenManager) {
        Intrinsics.checkNotNullParameter((Object)((Object)eventsParser), (String)"eventsParser");
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        Intrinsics.checkNotNullParameter((Object)tokenManager, (String)"tokenManager");
        this.eventsParser = eventsParser;
        this.parser = parser;
        this.tokenManager = tokenManager;
        String string2 = SocketFactory.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"SocketFactory::class.java.simpleName");
        this.logger = ChatLogger.Companion.get(string2);
        this.httpClient = new OkHttpClient();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/getstream/chat/android/client/socket/SocketFactory$Companion;", "", "()V", "ANONYMOUS_USER_ID", "", "stream-chat-android-client_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

