/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.client.token;

import io.getstream.chat.android.client.errors.ChatError;
import io.getstream.chat.android.client.token.TokenManager;
import io.getstream.chat.android.client.token.TokenProvider;
import io.getstream.chat.android.client.utils.Result;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0003\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0011\u001a\u00020\bH\u0016J\b\u0010\u0012\u001a\u00020\u0007H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0016J\b\u0010\u0016\u001a\u00020\bH\u0016J\"\u0010\u0016\u001a\u00020\b2\u0018\u0010\u0017\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0004\u0012\u00020\b0\u0005H\u0016J\b\u0010\u0018\u001a\u00020\bH\u0016J\u0012\u0010\u0019\u001a\u00020\b2\b\u0010\r\u001a\u0004\u0018\u00010\u0007H\u0002J\u0010\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0016R(\u0010\u0003\u001a\u001c\u0012\u0018\u0012\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0004\u0012\u00020\b\u0018\u00010\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0002\b\u0003\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lio/getstream/chat/android/client/token/TokenManagerImpl;", "Lio/getstream/chat/android/client/token/TokenManager;", "()V", "listeners", "", "Lkotlin/Function1;", "Lio/getstream/chat/android/client/utils/Result;", "", "", "loadingFuture", "Ljava/util/concurrent/Future;", "provider", "Lio/getstream/chat/android/client/token/TokenProvider;", "token", "tokenProviderExecutor", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "expireToken", "getToken", "hasToken", "", "hasTokenProvider", "loadAsync", "listener", "loadSync", "onTokenLoaded", "onTokenLoadingError", "cause", "", "setTokenProvider", "stream-chat-android-client_release"})
public final class TokenManagerImpl
implements TokenManager {
    private volatile String token = "";
    private volatile Future<?> loadingFuture;
    private final List<Function1<Result<String>, Unit>> listeners;
    private TokenProvider provider;
    private final ExecutorService tokenProviderExecutor;

    @Override
    public void loadAsync(@NotNull Function1<? super Result<String>, Unit> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        if (this.hasToken()) {
            listener.invoke((Object)new Result((Object)this.token));
        } else {
            this.listeners.add(listener);
            this.loadAsync();
        }
    }

    @Override
    public void loadAsync() {
        if (this.loadingFuture == null) {
            this.loadingFuture = this.tokenProviderExecutor.submit(new Runnable(this){
                final /* synthetic */ TokenManagerImpl this$0;

                public final void run() {
                    this.this$0.loadSync();
                    TokenManagerImpl.access$setLoadingFuture$p(this.this$0, null);
                }
                {
                    this.this$0 = tokenManagerImpl;
                }
            });
        }
    }

    @Override
    public void loadSync() {
        try {
            TokenProvider tokenProvider = this.provider;
            if (tokenProvider == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"provider");
            }
            this.onTokenLoaded(tokenProvider.loadToken());
        }
        catch (Throwable t) {
            this.onTokenLoadingError(t);
        }
    }

    @Override
    @NotNull
    public String getToken() {
        return this.token;
    }

    @Override
    public void expireToken() {
        this.token = "";
    }

    @Override
    public void setTokenProvider(@NotNull TokenProvider provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        this.token = "";
        this.provider = provider;
    }

    @Override
    public boolean hasToken() {
        CharSequence charSequence = this.token;
        boolean bl = false;
        return charSequence.length() > 0;
    }

    @Override
    public boolean hasTokenProvider() {
        return this.provider != null;
    }

    private final synchronized void onTokenLoaded(String token) {
        String string2 = token;
        if (string2 == null) {
            string2 = "";
        }
        this.token = string2;
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function1 it = (Function1)element$iv;
            boolean bl = false;
            Function1 function1 = it;
            if (function1 == null) continue;
            Unit cfr_ignored_0 = (Unit)function1.invoke((Object)new Result((Object)this.token));
        }
        this.listeners.clear();
    }

    private final void onTokenLoadingError(Throwable cause) {
        this.token = "";
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function1 it = (Function1)element$iv;
            boolean bl = false;
            Function1 function1 = it;
            if (function1 == null) continue;
            Unit cfr_ignored_0 = (Unit)function1.invoke((Object)new Result(new ChatError("Unable to load token", cause)));
        }
        this.listeners.clear();
    }

    public TokenManagerImpl() {
        boolean bl = false;
        this.listeners = new ArrayList();
        this.tokenProviderExecutor = Executors.newSingleThreadExecutor();
    }

    public static final /* synthetic */ Future access$getLoadingFuture$p(TokenManagerImpl $this) {
        return $this.loadingFuture;
    }

    public static final /* synthetic */ void access$setLoadingFuture$p(TokenManagerImpl $this, Future future) {
        $this.loadingFuture = future;
    }

    public static final /* synthetic */ TokenProvider access$getProvider$p(TokenManagerImpl $this) {
        TokenProvider tokenProvider = $this.provider;
        if (tokenProvider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"provider");
        }
        return tokenProvider;
    }

    public static final /* synthetic */ void access$setProvider$p(TokenManagerImpl $this, TokenProvider tokenProvider) {
        $this.provider = tokenProvider;
    }
}

