/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.client.uploader;

import io.getstream.chat.android.client.api.RetrofitCdnApi;
import io.getstream.chat.android.client.api.models.ProgressRequestBody;
import io.getstream.chat.android.client.api.models.UploadFileResponse;
import io.getstream.chat.android.client.extensions.FileExtensionsKt;
import io.getstream.chat.android.client.uploader.FileUploader;
import io.getstream.chat.android.client.utils.ProgressCallback;
import io.getstream.chat.android.client.utils.Result;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J0\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003H\u0016J0\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003H\u0016J2\u0010\u000f\u001a\u0004\u0018\u00010\u00032\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J:\u0010\u000f\u001a\u0004\u0018\u00010\u00032\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J2\u0010\u0014\u001a\u0004\u0018\u00010\u00032\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J:\u0010\u0014\u001a\u0004\u0018\u00010\u00032\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lio/getstream/chat/android/client/uploader/StreamFileUploader;", "Lio/getstream/chat/android/client/uploader/FileUploader;", "apiKey", "", "retrofitCdnApi", "Lio/getstream/chat/android/client/api/RetrofitCdnApi;", "(Ljava/lang/String;Lio/getstream/chat/android/client/api/RetrofitCdnApi;)V", "deleteFile", "", "channelType", "channelId", "userId", "connectionId", "url", "deleteImage", "sendFile", "file", "Ljava/io/File;", "callback", "Lio/getstream/chat/android/client/utils/ProgressCallback;", "sendImage", "stream-chat-android-client_release"})
public final class StreamFileUploader
implements FileUploader {
    private final String apiKey;
    private final RetrofitCdnApi retrofitCdnApi;

    @Override
    @Nullable
    public String sendFile(@NotNull String channelType, @NotNull String channelId, @NotNull String userId, @NotNull String connectionId, @NotNull File file, @NotNull ProgressCallback callback2) {
        Intrinsics.checkNotNullParameter((Object)channelType, (String)"channelType");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)connectionId, (String)"connectionId");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
        ProgressRequestBody body = new ProgressRequestBody(file, callback2);
        MultipartBody.Part part = MultipartBody.Part.Companion.createFormData("file", file.getName(), (RequestBody)body);
        Result<UploadFileResponse> result = this.retrofitCdnApi.sendFile(channelType, channelId, part, this.apiKey, userId, connectionId).execute();
        return result.isSuccess() ? ((UploadFileResponse)result.data()).getFile() : null;
    }

    @Override
    @Nullable
    public String sendFile(@NotNull String channelType, @NotNull String channelId, @NotNull String userId, @NotNull String connectionId, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)channelType, (String)"channelType");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)connectionId, (String)"connectionId");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        MultipartBody.Part part = MultipartBody.Part.Companion.createFormData("file", file.getName(), RequestBody.Companion.create(file, FileExtensionsKt.getMediaType(file)));
        Result<UploadFileResponse> result = this.retrofitCdnApi.sendFile(channelType, channelId, part, this.apiKey, userId, connectionId).execute();
        return result.isSuccess() ? ((UploadFileResponse)result.data()).getFile() : null;
    }

    @Override
    @Nullable
    public String sendImage(@NotNull String channelType, @NotNull String channelId, @NotNull String userId, @NotNull String connectionId, @NotNull File file, @NotNull ProgressCallback callback2) {
        Intrinsics.checkNotNullParameter((Object)channelType, (String)"channelType");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)connectionId, (String)"connectionId");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
        ProgressRequestBody body = new ProgressRequestBody(file, callback2);
        MultipartBody.Part part = MultipartBody.Part.Companion.createFormData("file", file.getName(), (RequestBody)body);
        Result<UploadFileResponse> result = this.retrofitCdnApi.sendImage(channelType, channelId, part, this.apiKey, userId, connectionId).execute();
        return result.isSuccess() ? ((UploadFileResponse)result.data()).getFile() : null;
    }

    @Override
    @Nullable
    public String sendImage(@NotNull String channelType, @NotNull String channelId, @NotNull String userId, @NotNull String connectionId, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)channelType, (String)"channelType");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)connectionId, (String)"connectionId");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        MultipartBody.Part part = MultipartBody.Part.Companion.createFormData("file", file.getName(), RequestBody.Companion.create(file, FileExtensionsKt.getMediaType(file)));
        Result<UploadFileResponse> result = this.retrofitCdnApi.sendImage(channelType, channelId, part, this.apiKey, userId, connectionId).execute();
        return result.isSuccess() ? ((UploadFileResponse)result.data()).getFile() : null;
    }

    @Override
    public void deleteFile(@NotNull String channelType, @NotNull String channelId, @NotNull String userId, @NotNull String connectionId, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)channelType, (String)"channelType");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)connectionId, (String)"connectionId");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.retrofitCdnApi.deleteFile(channelType, channelId, this.apiKey, connectionId, url).execute();
    }

    @Override
    public void deleteImage(@NotNull String channelType, @NotNull String channelId, @NotNull String userId, @NotNull String connectionId, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)channelType, (String)"channelType");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)connectionId, (String)"connectionId");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.retrofitCdnApi.deleteImage(channelType, channelId, this.apiKey, connectionId, url).execute();
    }

    public StreamFileUploader(@NotNull String apiKey, @NotNull RetrofitCdnApi retrofitCdnApi) {
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        Intrinsics.checkNotNullParameter((Object)retrofitCdnApi, (String)"retrofitCdnApi");
        this.apiKey = apiKey;
        this.retrofitCdnApi = retrofitCdnApi;
    }
}

