/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.client.parser2;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import io.getstream.chat.android.client.api2.MoshiUrlQueryPayloadFactory;
import io.getstream.chat.android.client.api2.mapping.EventMappingKt;
import io.getstream.chat.android.client.api2.mapping.SocketErrorMappingKt;
import io.getstream.chat.android.client.api2.model.dto.ChatEventDto;
import io.getstream.chat.android.client.api2.model.dto.UpstreamConnectedEventDto;
import io.getstream.chat.android.client.api2.model.response.SocketErrorResponse;
import io.getstream.chat.android.client.errors.ChatNetworkError;
import io.getstream.chat.android.client.events.ChannelCreatedEvent;
import io.getstream.chat.android.client.events.ChannelUpdatedByUserEvent;
import io.getstream.chat.android.client.events.ChannelUpdatedEvent;
import io.getstream.chat.android.client.events.ChatEvent;
import io.getstream.chat.android.client.events.ConnectedEvent;
import io.getstream.chat.android.client.events.MessageDeletedEvent;
import io.getstream.chat.android.client.events.MessageUpdatedEvent;
import io.getstream.chat.android.client.events.NewMessageEvent;
import io.getstream.chat.android.client.events.NotificationMessageNewEvent;
import io.getstream.chat.android.client.events.ReactionDeletedEvent;
import io.getstream.chat.android.client.events.ReactionNewEvent;
import io.getstream.chat.android.client.events.ReactionUpdateEvent;
import io.getstream.chat.android.client.extensions.MessageExtensionsKt;
import io.getstream.chat.android.client.models.Message;
import io.getstream.chat.android.client.parser.ChatParser;
import io.getstream.chat.android.client.parser2.adapters.AttachmentDtoAdapter;
import io.getstream.chat.android.client.parser2.adapters.DateAdapter;
import io.getstream.chat.android.client.parser2.adapters.DownstreamChannelDtoAdapter;
import io.getstream.chat.android.client.parser2.adapters.DownstreamMessageDtoAdapter;
import io.getstream.chat.android.client.parser2.adapters.DownstreamReactionDtoAdapter;
import io.getstream.chat.android.client.parser2.adapters.DownstreamUserDtoAdapter;
import io.getstream.chat.android.client.parser2.adapters.EventAdapterFactory;
import io.getstream.chat.android.client.parser2.adapters.UpstreamChannelDtoAdapter;
import io.getstream.chat.android.client.parser2.adapters.UpstreamMessageDtoAdapter;
import io.getstream.chat.android.client.parser2.adapters.UpstreamReactionDtoAdapter;
import io.getstream.chat.android.client.parser2.adapters.UpstreamUserDtoAdapter;
import io.getstream.chat.android.client.socket.SocketErrorMessage;
import io.getstream.chat.android.client.utils.Result;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.moshi.MoshiConverterFactory;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016J-\u0010\u0016\u001a\u0002H\u0017\"\b\b\u0000\u0010\u0017*\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u00170\u001cH\u0016\u00a2\u0006\u0002\u0010\u001dJ\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\"\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020\u0018H\u0002J\u0010\u0010'\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020\u0018H\u0016J#\u0010(\u001a\u00020)\"\u0006\b\u0000\u0010\u0017\u0018\u0001*\u00020)2\f\u0010*\u001a\b\u0012\u0004\u0012\u0002H\u00170\u0004H\u0082\bJ\f\u0010+\u001a\u00020\u001f*\u00020\u001fH\u0002R2\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000RR\u0010\u0007\u001aF\u0012\u001c\u0012\u001a\u0012\u0002\b\u0003\u0012\u0002\b\u0003 \u0006*\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\b0\b \u0006*\"\u0012\u001c\u0012\u001a\u0012\u0002\b\u0003\u0012\u0002\b\u0003 \u0006*\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\b0\b\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR2\u0010\u000f\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00100\u0010 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00100\u0010\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0011\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00120\u0012 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00120\u0012\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lio/getstream/chat/android/client/parser2/MoshiChatParser;", "Lio/getstream/chat/android/client/parser/ChatParser;", "()V", "chatEventDtoAdapter", "Lcom/squareup/moshi/JsonAdapter;", "Lio/getstream/chat/android/client/api2/model/dto/ChatEventDto;", "kotlin.jvm.PlatformType", "mapAdapter", "", "moshi", "Lcom/squareup/moshi/Moshi;", "getMoshi", "()Lcom/squareup/moshi/Moshi;", "moshi$delegate", "Lkotlin/Lazy;", "socketErrorResponseAdapter", "Lio/getstream/chat/android/client/api2/model/response/SocketErrorResponse;", "upstreamConnectedEventAdapter", "Lio/getstream/chat/android/client/api2/model/dto/UpstreamConnectedEventDto;", "configRetrofit", "Lretrofit2/Retrofit$Builder;", "builder", "fromJson", "T", "", "raw", "", "clazz", "Ljava/lang/Class;", "(Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;", "parseAndProcessEvent", "Lio/getstream/chat/android/client/events/ChatEvent;", "parseSocketError", "Lio/getstream/chat/android/client/socket/SocketErrorMessage;", "serializeConnectedEvent", "connectedEvent", "Lio/getstream/chat/android/client/events/ConnectedEvent;", "serializeMap", "any", "toJson", "addAdapter", "Lcom/squareup/moshi/Moshi$Builder;", "adapter", "enrichIfNeeded", "stream-chat-android-client_release"})
public final class MoshiChatParser
implements ChatParser {
    private final Lazy moshi$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Moshi>(this){
        final /* synthetic */ MoshiChatParser this$0;

        /*
         * WARNING - void declaration
         */
        public final Moshi invoke() {
            void $this$addAdapter$iv;
            Moshi.Builder builder = new Moshi.Builder();
            MoshiChatParser moshiChatParser = this.this$0;
            JsonAdapter adapter$iv = new DateAdapter();
            boolean $i$f$addAdapter = false;
            void var5_5 = $this$addAdapter$iv;
            boolean bl = false;
            boolean bl2 = false;
            void $this$apply$iv = var5_5;
            boolean bl3 = false;
            $this$apply$iv.add((Type)((Object)Date.class), adapter$iv);
            return var5_5.add((JsonAdapter.Factory)new EventAdapterFactory()).add((Object)DownstreamMessageDtoAdapter.INSTANCE).add((Object)UpstreamMessageDtoAdapter.INSTANCE).add((Object)DownstreamChannelDtoAdapter.INSTANCE).add((Object)UpstreamChannelDtoAdapter.INSTANCE).add((Object)AttachmentDtoAdapter.INSTANCE).add((Object)DownstreamReactionDtoAdapter.INSTANCE).add((Object)UpstreamReactionDtoAdapter.INSTANCE).add((Object)DownstreamUserDtoAdapter.INSTANCE).add((Object)UpstreamUserDtoAdapter.INSTANCE).build();
        }
        {
            this.this$0 = moshiChatParser;
            super(0);
        }
    }));
    private final JsonAdapter<Map<?, ?>> mapAdapter = this.getMoshi().adapter(Map.class);
    private final JsonAdapter<UpstreamConnectedEventDto> upstreamConnectedEventAdapter = this.getMoshi().adapter(UpstreamConnectedEventDto.class);
    private final JsonAdapter<SocketErrorResponse> socketErrorResponseAdapter = this.getMoshi().adapter(SocketErrorResponse.class);
    private final JsonAdapter<ChatEventDto> chatEventDtoAdapter = this.getMoshi().adapter(ChatEventDto.class);

    private final Moshi getMoshi() {
        Lazy lazy = this.moshi$delegate;
        MoshiChatParser moshiChatParser = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Moshi)lazy.getValue();
    }

    private final /* synthetic */ <T> Moshi.Builder addAdapter(Moshi.Builder $this$addAdapter, JsonAdapter<T> adapter) {
        int $i$f$addAdapter = 0;
        Moshi.Builder builder = $this$addAdapter;
        boolean bl = false;
        boolean bl2 = false;
        Moshi.Builder $this$apply = builder;
        boolean bl3 = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        $this$apply.add((Type)((Object)Object.class), adapter);
        return builder;
    }

    @Override
    @NotNull
    public Retrofit.Builder configRetrofit(@NotNull Retrofit.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Retrofit.Builder builder2 = builder.addConverterFactory((Converter.Factory)new MoshiUrlQueryPayloadFactory(this.getMoshi())).addConverterFactory((Converter.Factory)MoshiConverterFactory.create((Moshi)this.getMoshi()));
        Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"builder\n            .add\u2026terFactory.create(moshi))");
        return builder2;
    }

    @Override
    @NotNull
    public String toJson(@NotNull Object any) {
        Intrinsics.checkNotNullParameter((Object)any, (String)"any");
        if (Map.class.isAssignableFrom(any.getClass())) {
            return this.serializeMap(any);
        }
        if (any instanceof ConnectedEvent) {
            return this.serializeConnectedEvent((ConnectedEvent)any);
        }
        JsonAdapter adapter = this.getMoshi().adapter(any.getClass());
        String string = adapter.toJson(any);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"adapter.toJson(any)");
        return string;
    }

    private final String serializeMap(Object any) {
        Object object = any;
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<*, *>");
        }
        String string = this.mapAdapter.toJson((Object)((Map)object));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"mapAdapter.toJson(any as Map<*, *>)");
        return string;
    }

    private final String serializeConnectedEvent(ConnectedEvent connectedEvent) {
        UpstreamConnectedEventDto eventDto = EventMappingKt.toDto(connectedEvent);
        String string = this.upstreamConnectedEventAdapter.toJson((Object)eventDto);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"upstreamConnectedEventAdapter.toJson(eventDto)");
        return string;
    }

    @Override
    @NotNull
    public <T> T fromJson(@NotNull String raw, @NotNull Class<T> clazz) {
        Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        if (Intrinsics.areEqual(clazz, ChatEvent.class)) {
            ChatEvent chatEvent = this.parseAndProcessEvent(raw);
            if (chatEvent == null) {
                throw new NullPointerException("null cannot be cast to non-null type T");
            }
            return (T)chatEvent;
        }
        if (Intrinsics.areEqual(clazz, SocketErrorMessage.class)) {
            SocketErrorMessage socketErrorMessage = this.parseSocketError(raw);
            if (socketErrorMessage == null) {
                throw new NullPointerException("null cannot be cast to non-null type T");
            }
            return (T)socketErrorMessage;
        }
        JsonAdapter adapter = this.getMoshi().adapter(clazz);
        Object object = adapter.fromJson(raw);
        Intrinsics.checkNotNull((Object)object);
        return (T)object;
    }

    private final SocketErrorMessage parseSocketError(String raw) {
        Object object = this.socketErrorResponseAdapter.fromJson(raw);
        Intrinsics.checkNotNull((Object)object);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"socketErrorResponseAdapter.fromJson(raw)!!");
        return SocketErrorMappingKt.toDomain((SocketErrorResponse)object);
    }

    private final ChatEvent parseAndProcessEvent(String raw) {
        Object object = this.chatEventDtoAdapter.fromJson(raw);
        Intrinsics.checkNotNull((Object)object);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"chatEventDtoAdapter.fromJson(raw)!!");
        ChatEvent event = EventMappingKt.toDomain((ChatEventDto)object);
        return this.enrichIfNeeded(event);
    }

    private final ChatEvent enrichIfNeeded(ChatEvent $this$enrichIfNeeded) {
        ChatEvent chatEvent = $this$enrichIfNeeded;
        boolean bl = false;
        boolean bl2 = false;
        ChatEvent $this$apply = chatEvent;
        boolean bl3 = false;
        ChatEvent chatEvent2 = $this$apply;
        if (chatEvent2 instanceof NewMessageEvent) {
            MessageExtensionsKt.enrichWithCid(((NewMessageEvent)$this$apply).getMessage(), ((NewMessageEvent)$this$apply).getCid());
        } else if (chatEvent2 instanceof MessageDeletedEvent) {
            MessageExtensionsKt.enrichWithCid(((MessageDeletedEvent)$this$apply).getMessage(), ((MessageDeletedEvent)$this$apply).getCid());
        } else if (chatEvent2 instanceof MessageUpdatedEvent) {
            MessageExtensionsKt.enrichWithCid(((MessageUpdatedEvent)$this$apply).getMessage(), ((MessageUpdatedEvent)$this$apply).getCid());
        } else if (chatEvent2 instanceof ReactionNewEvent) {
            MessageExtensionsKt.enrichWithCid(((ReactionNewEvent)$this$apply).getMessage(), ((ReactionNewEvent)$this$apply).getCid());
        } else if (chatEvent2 instanceof ReactionUpdateEvent) {
            MessageExtensionsKt.enrichWithCid(((ReactionUpdateEvent)$this$apply).getMessage(), ((ReactionUpdateEvent)$this$apply).getCid());
        } else if (chatEvent2 instanceof ReactionDeletedEvent) {
            MessageExtensionsKt.enrichWithCid(((ReactionDeletedEvent)$this$apply).getMessage(), ((ReactionDeletedEvent)$this$apply).getCid());
        } else if (chatEvent2 instanceof ChannelCreatedEvent) {
            Message message = ((ChannelCreatedEvent)$this$apply).getMessage();
            if (message != null) {
                MessageExtensionsKt.enrichWithCid(message, ((ChannelCreatedEvent)$this$apply).getCid());
            }
        } else if (chatEvent2 instanceof ChannelUpdatedEvent) {
            Message message = ((ChannelUpdatedEvent)$this$apply).getMessage();
            if (message != null) {
                MessageExtensionsKt.enrichWithCid(message, ((ChannelUpdatedEvent)$this$apply).getCid());
            }
        } else if (chatEvent2 instanceof ChannelUpdatedByUserEvent) {
            Message message = ((ChannelUpdatedByUserEvent)$this$apply).getMessage();
            if (message != null) {
                MessageExtensionsKt.enrichWithCid(message, ((ChannelUpdatedByUserEvent)$this$apply).getCid());
            }
        } else if (chatEvent2 instanceof NotificationMessageNewEvent) {
            MessageExtensionsKt.enrichWithCid(((NotificationMessageNewEvent)$this$apply).getMessage(), ((NotificationMessageNewEvent)$this$apply).getCid());
        }
        return chatEvent;
    }

    @Override
    @NotNull
    public <T> Result<T> fromJsonOrError(@NotNull String raw, @NotNull Class<T> clazz) {
        Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        return ChatParser.DefaultImpls.fromJsonOrError(this, raw, clazz);
    }

    @Override
    @NotNull
    public ChatNetworkError toError(@NotNull Response okHttpResponse) {
        Intrinsics.checkNotNullParameter((Object)okHttpResponse, (String)"okHttpResponse");
        return ChatParser.DefaultImpls.toError((ChatParser)this, okHttpResponse);
    }

    public static final /* synthetic */ Moshi.Builder access$addAdapter(MoshiChatParser $this, Moshi.Builder $this$access_u24addAdapter, JsonAdapter adapter) {
        return $this.addAdapter($this$access_u24addAdapter, adapter);
    }
}

