/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.client.socket;

import io.getstream.chat.android.client.errors.ChatError;
import io.getstream.chat.android.client.errors.ChatErrorCode;
import io.getstream.chat.android.client.errors.ChatNetworkError;
import io.getstream.chat.android.client.events.ChatEvent;
import io.getstream.chat.android.client.events.ConnectedEvent;
import io.getstream.chat.android.client.logger.ChatLogger;
import io.getstream.chat.android.client.logger.TaggedLogger;
import io.getstream.chat.android.client.parser.ChatParser;
import io.getstream.chat.android.client.socket.ChatSocketService;
import io.getstream.chat.android.client.socket.ErrorResponse;
import io.getstream.chat.android.client.socket.SocketErrorMessage;
import io.getstream.chat.android.client.utils.Result;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\r\u0010\f\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u000eJ\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J \u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0014H\u0016J \u0010\u001b\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0014H\u0016J\u0010\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\r2\u0006\u0010\"\u001a\u00020#H\u0002J\"\u0010!\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010'H\u0016J\u0018\u0010(\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010)\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010&\u001a\u00020'H\u0016J\u0010\u0010*\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020#H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lio/getstream/chat/android/client/socket/EventsParser;", "Lokhttp3/WebSocketListener;", "parser", "Lio/getstream/chat/android/client/parser/ChatParser;", "service", "Lio/getstream/chat/android/client/socket/ChatSocketService;", "(Lio/getstream/chat/android/client/parser/ChatParser;Lio/getstream/chat/android/client/socket/ChatSocketService;)V", "closedByClient", "", "connectionEventReceived", "logger", "Lio/getstream/chat/android/client/logger/TaggedLogger;", "closeByClient", "", "closeByClient$stream_chat_android_client_release", "handleErrorEvent", "error", "Lio/getstream/chat/android/client/socket/ErrorResponse;", "handleEvent", "text", "", "onClosed", "webSocket", "Lokhttp3/WebSocket;", "code", "", "reason", "onClosing", "onConnectionResolved", "event", "Lio/getstream/chat/android/client/events/ConnectedEvent;", "onEvent", "Lio/getstream/chat/android/client/events/ChatEvent;", "onFailure", "chatError", "Lio/getstream/chat/android/client/errors/ChatError;", "t", "", "response", "Lokhttp3/Response;", "onMessage", "onOpen", "onSocketError", "stream-chat-android-client_release"})
public final class EventsParser
extends WebSocketListener {
    private boolean connectionEventReceived;
    private final TaggedLogger logger;
    private boolean closedByClient;
    private final ChatParser parser;
    private final ChatSocketService service;

    public void onOpen(@NotNull WebSocket webSocket, @NotNull Response response) {
        Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        this.logger.logI("onOpen");
        this.connectionEventReceived = false;
        this.closedByClient = false;
    }

    public void onMessage(@NotNull WebSocket webSocket, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        try {
            this.logger.logI(text);
            Result<SocketErrorMessage> errorMessage = this.parser.fromJsonOrError(text, SocketErrorMessage.class);
            SocketErrorMessage errorData = (SocketErrorMessage)errorMessage.data();
            if (errorMessage.isSuccess() && errorData.getError() != null) {
                this.handleErrorEvent(errorData.getError());
            } else {
                this.handleEvent(text);
            }
        }
        catch (Throwable t) {
            this.logger.logE("onMessage", t);
            this.onSocketError(ChatNetworkError.Companion.create$default(ChatNetworkError.Companion, ChatErrorCode.UNABLE_TO_PARSE_SOCKET_EVENT, null, 0, 6, null));
        }
    }

    public void onClosing(@NotNull WebSocket webSocket, int code, @NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
    }

    public void onClosed(@NotNull WebSocket webSocket, int code, @NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        this.onFailure(ChatNetworkError.Companion.create$default(ChatNetworkError.Companion, ChatErrorCode.SOCKET_CLOSED, null, 0, 6, null));
    }

    public void onFailure(@NotNull WebSocket webSocket, @NotNull Throwable t, @Nullable Response response) {
        Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        this.logger.logE("onFailure: " + t, t);
        this.onSocketError(ChatNetworkError.Companion.create$default(ChatNetworkError.Companion, ChatErrorCode.SOCKET_FAILURE, t, 0, 4, null));
    }

    private final void onFailure(ChatError chatError) {
        this.logger.logE("onFailure " + chatError, chatError);
        this.onSocketError(ChatNetworkError.Companion.create$default(ChatNetworkError.Companion, ChatErrorCode.SOCKET_FAILURE, chatError.getCause(), 0, 4, null));
    }

    public final void closeByClient$stream_chat_android_client_release() {
        this.closedByClient = true;
    }

    private final void handleEvent(String text) {
        Result<ChatEvent> eventResult = this.parser.fromJsonOrError(text, ChatEvent.class);
        if (eventResult.isSuccess()) {
            ChatEvent event = (ChatEvent)eventResult.data();
            if (!this.connectionEventReceived) {
                if (event instanceof ConnectedEvent) {
                    this.connectionEventReceived = true;
                    this.onConnectionResolved((ConnectedEvent)event);
                } else {
                    this.onSocketError(ChatNetworkError.Companion.create$default(ChatNetworkError.Companion, ChatErrorCode.CANT_PARSE_CONNECTION_EVENT, null, 0, 6, null));
                }
            } else {
                this.onEvent(event);
            }
        } else {
            this.onSocketError(ChatNetworkError.Companion.create$default(ChatNetworkError.Companion, ChatErrorCode.CANT_PARSE_EVENT, eventResult.error().getCause(), 0, 4, null));
        }
    }

    private final void handleErrorEvent(ErrorResponse error) {
        this.onSocketError(ChatNetworkError.Companion.create$default(ChatNetworkError.Companion, error.getCode(), error.getMessage(), error.getStatusCode(), null, 8, null));
    }

    private final void onSocketError(ChatError error) {
        if (!this.closedByClient) {
            this.service.onSocketError(error);
        }
    }

    private final void onConnectionResolved(ConnectedEvent event) {
        if (!this.closedByClient) {
            this.service.onConnectionResolved(event);
        }
    }

    private final void onEvent(ChatEvent event) {
        if (!this.closedByClient) {
            this.service.onEvent(event);
        }
    }

    public EventsParser(@NotNull ChatParser parser, @NotNull ChatSocketService service) {
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        this.parser = parser;
        this.service = service;
        this.logger = ChatLogger.Companion.get("Events");
        this.closedByClient = true;
    }
}

