/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.client.api2;

import androidx.annotation.CheckResult;
import io.getstream.chat.android.client.api.ChatApi;
import io.getstream.chat.android.client.api.ErrorCall;
import io.getstream.chat.android.client.api.models.FilterObject;
import io.getstream.chat.android.client.api.models.PinnedMessagesPagination;
import io.getstream.chat.android.client.api.models.QuerySort;
import io.getstream.chat.android.client.api2.ChannelApi;
import io.getstream.chat.android.client.api2.ConfigApi;
import io.getstream.chat.android.client.api2.DeviceApi;
import io.getstream.chat.android.client.api2.GeneralApi;
import io.getstream.chat.android.client.api2.GuestApi;
import io.getstream.chat.android.client.api2.MessageApi;
import io.getstream.chat.android.client.api2.ModerationApi;
import io.getstream.chat.android.client.api2.MoshiChatApi;
import io.getstream.chat.android.client.api2.UserApi;
import io.getstream.chat.android.client.api2.mapping.ChannelMappingKt;
import io.getstream.chat.android.client.api2.mapping.ChannelUserReadMappingKt;
import io.getstream.chat.android.client.api2.mapping.MemberMappingKt;
import io.getstream.chat.android.client.api2.mapping.MessageMappingKt;
import io.getstream.chat.android.client.api2.mapping.ReactionMappingKt;
import io.getstream.chat.android.client.api2.mapping.UserMappingKt;
import io.getstream.chat.android.client.api2.model.dto.DownstreamChannelUserRead;
import io.getstream.chat.android.client.api2.model.dto.DownstreamMemberDto;
import io.getstream.chat.android.client.api2.model.dto.DownstreamMessageDto;
import io.getstream.chat.android.client.api2.model.dto.DownstreamUserDto;
import io.getstream.chat.android.client.api2.model.dto.PartialUpdateUserDto;
import io.getstream.chat.android.client.api2.model.dto.UpstreamMemberDto;
import io.getstream.chat.android.client.api2.model.dto.UpstreamMessageDto;
import io.getstream.chat.android.client.api2.model.dto.UpstreamUserDto;
import io.getstream.chat.android.client.api2.model.requests.AcceptInviteRequest;
import io.getstream.chat.android.client.api2.model.requests.AddDeviceRequest;
import io.getstream.chat.android.client.api2.model.requests.AddMembersRequest;
import io.getstream.chat.android.client.api2.model.requests.BanUserRequest;
import io.getstream.chat.android.client.api2.model.requests.GuestUserRequest;
import io.getstream.chat.android.client.api2.model.requests.HideChannelRequest;
import io.getstream.chat.android.client.api2.model.requests.MarkReadRequest;
import io.getstream.chat.android.client.api2.model.requests.MessageRequest;
import io.getstream.chat.android.client.api2.model.requests.MuteChannelRequest;
import io.getstream.chat.android.client.api2.model.requests.MuteUserRequest;
import io.getstream.chat.android.client.api2.model.requests.PartialUpdateMessageRequest;
import io.getstream.chat.android.client.api2.model.requests.PartialUpdateUsersRequest;
import io.getstream.chat.android.client.api2.model.requests.PinnedMessagesRequest;
import io.getstream.chat.android.client.api2.model.requests.QueryBannedUsersRequest;
import io.getstream.chat.android.client.api2.model.requests.QueryChannelRequest;
import io.getstream.chat.android.client.api2.model.requests.QueryChannelsRequest;
import io.getstream.chat.android.client.api2.model.requests.QueryMembersRequest;
import io.getstream.chat.android.client.api2.model.requests.QueryUsersRequest;
import io.getstream.chat.android.client.api2.model.requests.ReactionRequest;
import io.getstream.chat.android.client.api2.model.requests.RejectInviteRequest;
import io.getstream.chat.android.client.api2.model.requests.RemoveMembersRequest;
import io.getstream.chat.android.client.api2.model.requests.SearchMessagesRequest;
import io.getstream.chat.android.client.api2.model.requests.SendActionRequest;
import io.getstream.chat.android.client.api2.model.requests.SendEventRequest;
import io.getstream.chat.android.client.api2.model.requests.SyncHistoryRequest;
import io.getstream.chat.android.client.api2.model.requests.TruncateChannelRequest;
import io.getstream.chat.android.client.api2.model.requests.UpdateChannelPartialRequest;
import io.getstream.chat.android.client.api2.model.requests.UpdateChannelRequest;
import io.getstream.chat.android.client.api2.model.requests.UpdateCooldownRequest;
import io.getstream.chat.android.client.api2.model.requests.UpdateUsersRequest;
import io.getstream.chat.android.client.api2.model.response.ChannelResponse;
import io.getstream.chat.android.client.api2.model.response.QueryChannelsResponse;
import io.getstream.chat.android.client.api2.model.response.TranslateMessageRequest;
import io.getstream.chat.android.client.api2.model.response.UpdateUsersResponse;
import io.getstream.chat.android.client.call.Call;
import io.getstream.chat.android.client.call.CallKt;
import io.getstream.chat.android.client.call.CoroutineCall;
import io.getstream.chat.android.client.errors.ChatError;
import io.getstream.chat.android.client.events.ChatEvent;
import io.getstream.chat.android.client.extensions.MessageExtensionsKt;
import io.getstream.chat.android.client.logger.ChatLogger;
import io.getstream.chat.android.client.logger.TaggedLogger;
import io.getstream.chat.android.client.models.AppSettings;
import io.getstream.chat.android.client.models.BannedUser;
import io.getstream.chat.android.client.models.BannedUsersSort;
import io.getstream.chat.android.client.models.Channel;
import io.getstream.chat.android.client.models.Device;
import io.getstream.chat.android.client.models.Flag;
import io.getstream.chat.android.client.models.GuestUser;
import io.getstream.chat.android.client.models.Member;
import io.getstream.chat.android.client.models.Message;
import io.getstream.chat.android.client.models.Mute;
import io.getstream.chat.android.client.models.Reaction;
import io.getstream.chat.android.client.models.SearchMessagesResult;
import io.getstream.chat.android.client.models.User;
import io.getstream.chat.android.client.parser.FilterObjectToMapKt;
import io.getstream.chat.android.client.uploader.FileUploader;
import io.getstream.chat.android.client.utils.ProgressCallback;
import io.getstream.chat.android.client.utils.Result;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00d0\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001b\b\u0000\u0018\u00002\u00020\u0001BU\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0016J(\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010$\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\u00182\b\u0010&\u001a\u0004\u0018\u00010\u0018H\u0016J\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\"2\u0006\u0010)\u001a\u00020*H\u0016J,\u0010+\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010$\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\u00182\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00180-H\u0016J\u000e\u0010.\u001a\b\u0012\u0004\u0012\u00020/0\"H\u0016JG\u00100\u001a\b\u0012\u0004\u0012\u00020(0\"2\u0006\u00101\u001a\u00020\u00182\b\u00102\u001a\u0004\u0018\u0001032\b\u00104\u001a\u0004\u0018\u00010\u00182\u0006\u0010$\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\u00182\u0006\u00105\u001a\u000206H\u0016\u00a2\u0006\u0002\u00107J\u001e\u00108\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010$\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\u0018H\u0016J\u0016\u00109\u001a\b\u0012\u0004\u0012\u00020(0\"2\u0006\u0010)\u001a\u00020*H\u0016J&\u0010:\u001a\b\u0012\u0004\u0012\u00020(0\"2\u0006\u0010$\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\u00182\u0006\u0010;\u001a\u00020\u0018H\u0016J&\u0010<\u001a\b\u0012\u0004\u0012\u00020(0\"2\u0006\u0010$\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\u00182\u0006\u0010;\u001a\u00020\u0018H\u0016J\u001e\u0010=\u001a\b\u0012\u0004\u0012\u00020>0\"2\u0006\u0010?\u001a\u00020\u00182\u0006\u0010@\u001a\u000206H\u0016J\u001e\u0010A\u001a\b\u0012\u0004\u0012\u00020>0\"2\u0006\u0010?\u001a\u00020\u00182\u0006\u0010B\u001a\u00020\u0018H\u0016J\u001e\u0010C\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010$\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\u0018H\u0016J&\u0010D\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010$\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\u00182\u0006\u0010E\u001a\u000203H\u0016J\"\u0010F\u001a\b\u0012\u0004\u0012\u00020G0\"2\u0012\u0010H\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00180IH\u0002J\u0016\u0010J\u001a\b\u0012\u0004\u0012\u00020G0\"2\u0006\u0010?\u001a\u00020\u0018H\u0016J\u0016\u0010K\u001a\b\u0012\u0004\u0012\u00020G0\"2\u0006\u0010\u001f\u001a\u00020\u0018H\u0016J\u0010\u0010L\u001a\u00020#2\u0006\u0010M\u001a\u00020NH\u0002J\u0014\u0010O\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020*0-0\"H\u0016J\u001e\u0010P\u001a\b\u0012\u0004\u0012\u00020Q0\"2\u0006\u0010\u001f\u001a\u00020\u00182\u0006\u0010R\u001a\u00020\u0018H\u0016J\u0016\u0010S\u001a\b\u0012\u0004\u0012\u00020>0\"2\u0006\u0010?\u001a\u00020\u0018H\u0016JB\u0010T\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020>0-0\"2\u0006\u0010$\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\u00182\u0006\u0010U\u001a\u0002032\f\u0010V\u001a\b\u0012\u0004\u0012\u00020>0W2\u0006\u0010X\u001a\u00020YH\u0016J,\u0010Z\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020[0-0\"2\u0006\u0010?\u001a\u00020\u00182\u0006\u0010\\\u001a\u0002032\u0006\u0010U\u001a\u000203H\u0016J$\u0010]\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020>0-0\"2\u0006\u0010?\u001a\u00020\u00182\u0006\u0010U\u001a\u000203H\u0016J,\u0010^\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020>0-0\"2\u0006\u0010?\u001a\u00020\u00182\u0006\u0010_\u001a\u00020\u00182\u0006\u0010U\u001a\u000203H\u0016J*\u0010`\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020a0-0\"2\f\u0010b\u001a\b\u0012\u0004\u0012\u00020\u00180-2\u0006\u0010c\u001a\u00020dH\u0016J&\u0010e\u001a\b\u0012\u0004\u0012\u00020(0\"2\u0006\u0010$\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\u00182\u0006\u0010f\u001a\u000206H\u0016J\u000e\u0010g\u001a\b\u0012\u0004\u0012\u00020(0\"H\u0016J&\u0010h\u001a\b\u0012\u0004\u0012\u00020(0\"2\u0006\u0010$\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\u00182\u0006\u0010?\u001a\u00020\u0018H\u0016J-\u0010i\u001a\b\u0012\u0004\u0012\u00020(0\"2\u0006\u0010$\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\u00182\b\u0010j\u001a\u0004\u0018\u000103H\u0016\u00a2\u0006\u0002\u0010kJ\u000e\u0010l\u001a\b\u0012\u0004\u0012\u00020m0\"H\u0016J%\u0010n\u001a\b\u0012\u0004\u0012\u00020m0\"2\u0006\u0010\u001f\u001a\u00020\u00182\b\u00102\u001a\u0004\u0018\u000103H\u0016\u00a2\u0006\u0002\u0010oJ\u0018\u0010p\u001a\b\u0012\u0004\u0012\u0002Hr0q\"\b\b\u0000\u0010r*\u00020sH\u0002J8\u0010t\u001a\b\u0012\u0004\u0012\u00020>0\"2\u0006\u0010?\u001a\u00020\u00182\u0012\u0010u\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020s0v2\f\u0010w\u001a\b\u0012\u0004\u0012\u00020\u00180-H\u0016J8\u0010x\u001a\b\u0012\u0004\u0012\u00020y0\"2\u0006\u0010z\u001a\u00020\u00182\u0012\u0010u\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020s0v2\f\u0010w\u001a\b\u0012\u0004\u0012\u00020\u00180-H\u0016Jp\u0010{\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020|0-0\"2\u0006\u0010}\u001a\u00020~2\f\u0010V\u001a\b\u0012\u0004\u0012\u00020\u007f0W2\b\u0010\\\u001a\u0004\u0018\u0001032\b\u0010U\u001a\u0004\u0018\u0001032\t\u0010\u0080\u0001\u001a\u0004\u0018\u00010d2\t\u0010\u0081\u0001\u001a\u0004\u0018\u00010d2\t\u0010\u0082\u0001\u001a\u0004\u0018\u00010d2\t\u0010\u0083\u0001\u001a\u0004\u0018\u00010dH\u0016\u00a2\u0006\u0003\u0010\u0084\u0001J)\u0010\u0085\u0001\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010$\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\u00182\b\u0010\u0086\u0001\u001a\u00030\u0087\u0001H\u0016J\u001f\u0010\u0088\u0001\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020#0-0\"2\b\u0010\u0086\u0001\u001a\u00030\u0089\u0001H\u0016J\\\u0010\u008a\u0001\u001a\u000f\u0012\u000b\u0012\t\u0012\u0005\u0012\u00030\u008b\u00010-0\"2\u0006\u0010$\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\u00182\u0006\u0010\\\u001a\u0002032\u0006\u0010U\u001a\u0002032\u0006\u0010}\u001a\u00020~2\r\u0010V\u001a\t\u0012\u0005\u0012\u00030\u008b\u00010W2\r\u0010,\u001a\t\u0012\u0005\u0012\u00030\u008b\u00010-H\u0016J\u001f\u0010\u008c\u0001\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020y0-0\"2\b\u0010\u008c\u0001\u001a\u00030\u008d\u0001H\u0016J\u001f\u0010\u008e\u0001\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010$\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\u0018H\u0016J-\u0010\u008f\u0001\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010$\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\u00182\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00180-H\u0016JW\u0010\u0090\u0001\u001a\t\u0012\u0005\u0012\u00030\u0091\u00010\"2\u0007\u0010\u0092\u0001\u001a\u00020~2\u0007\u0010\u0093\u0001\u001a\u00020~2\b\u0010\\\u001a\u0004\u0018\u0001032\b\u0010U\u001a\u0004\u0018\u0001032\t\u0010\u0094\u0001\u001a\u0004\u0018\u00010\u00182\u000e\u0010V\u001a\n\u0012\u0004\u0012\u00020>\u0018\u00010WH\u0016\u00a2\u0006\u0003\u0010\u0095\u0001J\u001f\u0010\u0090\u0001\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020>0-0\"2\b\u0010\u0096\u0001\u001a\u00030\u0097\u0001H\u0016J\u0019\u0010\u0098\u0001\u001a\b\u0012\u0004\u0012\u00020>0\"2\b\u0010\u0096\u0001\u001a\u00030\u0099\u0001H\u0016J=\u0010\u009a\u0001\u001a\b\u0012\u0004\u0012\u00020a0\"2\u0007\u0010\u009b\u0001\u001a\u00020\u00182\u0006\u0010$\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\u00182\u0013\u0010\u009c\u0001\u001a\u000e\u0012\u0004\u0012\u00020s\u0012\u0004\u0012\u00020s0vH\u0016J5\u0010\u009d\u0001\u001a\b\u0012\u0004\u0012\u00020\u00180\"2\u0006\u0010$\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\u00182\b\u0010\u009e\u0001\u001a\u00030\u009f\u00012\n\u0010\u00a0\u0001\u001a\u0005\u0018\u00010\u00a1\u0001H\u0016J5\u0010\u00a2\u0001\u001a\b\u0012\u0004\u0012\u00020\u00180\"2\u0006\u0010$\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\u00182\b\u0010\u009e\u0001\u001a\u00030\u009f\u00012\n\u0010\u00a0\u0001\u001a\u0005\u0018\u00010\u00a1\u0001H\u0016J'\u0010\u00a3\u0001\u001a\b\u0012\u0004\u0012\u00020>0\"2\u0006\u0010$\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\u00182\u0006\u0010&\u001a\u00020>H\u0016J!\u0010\u00a4\u0001\u001a\b\u0012\u0004\u0012\u00020[0\"2\u0007\u0010\u00a5\u0001\u001a\u00020[2\u0007\u0010\u00a6\u0001\u001a\u000206H\u0016J\u0019\u0010\u00a7\u0001\u001a\u00020(2\u0006\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u001f\u0010\u00a8\u0001\u001a\b\u0012\u0004\u0012\u00020(0\"2\u0006\u0010$\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\u0018H\u0016J\u001f\u0010\u00a9\u0001\u001a\b\u0012\u0004\u0012\u00020(0\"2\u0006\u0010$\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\u0018H\u0016J \u0010\u00aa\u0001\u001a\b\u0012\u0004\u0012\u00020>0\"2\u0006\u0010?\u001a\u00020\u00182\u0007\u0010\u00ab\u0001\u001a\u00020\u0018H\u0016J*\u0010\u00ac\u0001\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010$\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\u00182\t\u0010\u00ad\u0001\u001a\u0004\u0018\u00010>H\u0016J/\u0010\u00ae\u0001\u001a\b\u0012\u0004\u0012\u00020(0\"2\u0006\u00101\u001a\u00020\u00182\u0006\u0010$\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\u00182\u0006\u00105\u001a\u000206H\u0016J#\u0010\u00af\u0001\u001a\b\u0012\u0004\u0012\u00020G0\"2\u0012\u0010H\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00180IH\u0002J\u0017\u0010\u00b0\u0001\u001a\b\u0012\u0004\u0012\u00020G0\"2\u0006\u0010?\u001a\u00020\u0018H\u0016J\u0017\u0010\u00b1\u0001\u001a\b\u0012\u0004\u0012\u00020G0\"2\u0006\u0010\u001f\u001a\u00020\u0018H\u0016J\u001f\u0010\u00b2\u0001\u001a\b\u0012\u0004\u0012\u00020(0\"2\u0006\u0010$\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\u0018H\u0016J\u000f\u0010\u00b3\u0001\u001a\b\u0012\u0004\u0012\u00020(0\"H\u0016J\u0017\u0010\u00b4\u0001\u001a\b\u0012\u0004\u0012\u00020(0\"2\u0006\u0010\u001f\u001a\u00020\u0018H\u0016J?\u0010\u00b5\u0001\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010$\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\u00182\u0013\u0010\u009c\u0001\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020s0v2\t\u0010\u00b6\u0001\u001a\u0004\u0018\u00010>H\u0016JA\u0010\u00b7\u0001\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010$\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\u00182\u0012\u0010u\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020s0v2\f\u0010w\u001a\b\u0012\u0004\u0012\u00020\u00180-H\u0016J'\u0010\u00b8\u0001\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010$\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\u00182\u0006\u0010E\u001a\u000203H\u0002J\u0017\u0010\u00b6\u0001\u001a\b\u0012\u0004\u0012\u00020>0\"2\u0006\u0010&\u001a\u00020>H\u0016J$\u0010\u00b9\u0001\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020y0-0\"2\r\u0010\u00ba\u0001\u001a\b\u0012\u0004\u0012\u00020y0-H\u0016J\t\u0010\u00bb\u0001\u001a\u00020(H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\u00020\u00188BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001f\u001a\u00020\u00188BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001a\u00a8\u0006\u00bc\u0001"}, d2={"Lio/getstream/chat/android/client/api2/MoshiChatApi;", "Lio/getstream/chat/android/client/api/ChatApi;", "fileUploader", "Lio/getstream/chat/android/client/uploader/FileUploader;", "userApi", "Lio/getstream/chat/android/client/api2/UserApi;", "guestApi", "Lio/getstream/chat/android/client/api2/GuestApi;", "messageApi", "Lio/getstream/chat/android/client/api2/MessageApi;", "channelApi", "Lio/getstream/chat/android/client/api2/ChannelApi;", "deviceApi", "Lio/getstream/chat/android/client/api2/DeviceApi;", "moderationApi", "Lio/getstream/chat/android/client/api2/ModerationApi;", "generalApi", "Lio/getstream/chat/android/client/api2/GeneralApi;", "configApi", "Lio/getstream/chat/android/client/api2/ConfigApi;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "(Lio/getstream/chat/android/client/uploader/FileUploader;Lio/getstream/chat/android/client/api2/UserApi;Lio/getstream/chat/android/client/api2/GuestApi;Lio/getstream/chat/android/client/api2/MessageApi;Lio/getstream/chat/android/client/api2/ChannelApi;Lio/getstream/chat/android/client/api2/DeviceApi;Lio/getstream/chat/android/client/api2/ModerationApi;Lio/getstream/chat/android/client/api2/GeneralApi;Lio/getstream/chat/android/client/api2/ConfigApi;Lkotlinx/coroutines/CoroutineScope;)V", "connectionId", "", "getConnectionId", "()Ljava/lang/String;", "logger", "Lio/getstream/chat/android/client/logger/TaggedLogger;", "getLogger", "()Lio/getstream/chat/android/client/logger/TaggedLogger;", "userId", "getUserId", "acceptInvite", "Lio/getstream/chat/android/client/call/Call;", "Lio/getstream/chat/android/client/models/Channel;", "channelType", "channelId", "message", "addDevice", "", "device", "Lio/getstream/chat/android/client/models/Device;", "addMembers", "members", "", "appSettings", "Lio/getstream/chat/android/client/models/AppSettings;", "banUser", "targetId", "timeout", "", "reason", "shadow", "", "(Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Z)Lio/getstream/chat/android/client/call/Call;", "deleteChannel", "deleteDevice", "deleteFile", "url", "deleteImage", "deleteMessage", "Lio/getstream/chat/android/client/models/Message;", "messageId", "hard", "deleteReaction", "reactionType", "disableSlowMode", "enableSlowMode", "cooldownTimeInSeconds", "flag", "Lio/getstream/chat/android/client/models/Flag;", "body", "", "flagMessage", "flagUser", "flattenChannel", "response", "Lio/getstream/chat/android/client/api2/model/response/ChannelResponse;", "getDevices", "getGuestUser", "Lio/getstream/chat/android/client/models/GuestUser;", "userName", "getMessage", "getPinnedMessages", "limit", "sort", "Lio/getstream/chat/android/client/api/models/QuerySort;", "pagination", "Lio/getstream/chat/android/client/api/models/PinnedMessagesPagination;", "getReactions", "Lio/getstream/chat/android/client/models/Reaction;", "offset", "getReplies", "getRepliesMore", "firstId", "getSyncHistory", "Lio/getstream/chat/android/client/events/ChatEvent;", "channelIds", "lastSyncAt", "Ljava/util/Date;", "hideChannel", "clearHistory", "markAllRead", "markRead", "muteChannel", "expiration", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;)Lio/getstream/chat/android/client/call/Call;", "muteCurrentUser", "Lio/getstream/chat/android/client/models/Mute;", "muteUser", "(Ljava/lang/String;Ljava/lang/Integer;)Lio/getstream/chat/android/client/call/Call;", "noConnectionIdError", "Lio/getstream/chat/android/client/api/ErrorCall;", "T", "", "partialUpdateMessage", "set", "", "unset", "partialUpdateUser", "Lio/getstream/chat/android/client/models/User;", "id", "queryBannedUsers", "Lio/getstream/chat/android/client/models/BannedUser;", "filter", "Lio/getstream/chat/android/client/api/models/FilterObject;", "Lio/getstream/chat/android/client/models/BannedUsersSort;", "createdAtAfter", "createdAtAfterOrEqual", "createdAtBefore", "createdAtBeforeOrEqual", "(Lio/getstream/chat/android/client/api/models/FilterObject;Lio/getstream/chat/android/client/api/models/QuerySort;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/util/Date;Ljava/util/Date;Ljava/util/Date;Ljava/util/Date;)Lio/getstream/chat/android/client/call/Call;", "queryChannel", "query", "Lio/getstream/chat/android/client/api/models/QueryChannelRequest;", "queryChannels", "Lio/getstream/chat/android/client/api/models/QueryChannelsRequest;", "queryMembers", "Lio/getstream/chat/android/client/models/Member;", "queryUsers", "Lio/getstream/chat/android/client/api/models/QueryUsersRequest;", "rejectInvite", "removeMembers", "searchMessages", "Lio/getstream/chat/android/client/models/SearchMessagesResult;", "channelFilter", "messageFilter", "next", "(Lio/getstream/chat/android/client/api/models/FilterObject;Lio/getstream/chat/android/client/api/models/FilterObject;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/String;Lio/getstream/chat/android/client/api/models/QuerySort;)Lio/getstream/chat/android/client/call/Call;", "request", "Lio/getstream/chat/android/client/api/models/SearchMessagesRequest;", "sendAction", "Lio/getstream/chat/android/client/api/models/SendActionRequest;", "sendEvent", "eventType", "extraData", "sendFile", "file", "Ljava/io/File;", "callback", "Lio/getstream/chat/android/client/utils/ProgressCallback;", "sendImage", "sendMessage", "sendReaction", "reaction", "enforceUnique", "setConnection", "showChannel", "stopWatching", "translate", "language", "truncateChannel", "systemMessage", "unbanUser", "unflag", "unflagMessage", "unflagUser", "unmuteChannel", "unmuteCurrentUser", "unmuteUser", "updateChannel", "updateMessage", "updateChannelPartial", "updateCooldown", "updateUsers", "users", "warmUp", "stream-chat-android-client_release"})
public final class MoshiChatApi
implements ChatApi {
    @NotNull
    private final FileUploader fileUploader;
    @NotNull
    private final UserApi userApi;
    @NotNull
    private final GuestApi guestApi;
    @NotNull
    private final MessageApi messageApi;
    @NotNull
    private final ChannelApi channelApi;
    @NotNull
    private final DeviceApi deviceApi;
    @NotNull
    private final ModerationApi moderationApi;
    @NotNull
    private final GeneralApi generalApi;
    @NotNull
    private final ConfigApi configApi;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final TaggedLogger logger;
    @NotNull
    private String userId;
    @NotNull
    private String connectionId;

    public MoshiChatApi(@NotNull FileUploader fileUploader, @NotNull UserApi userApi, @NotNull GuestApi guestApi, @NotNull MessageApi messageApi, @NotNull ChannelApi channelApi, @NotNull DeviceApi deviceApi, @NotNull ModerationApi moderationApi, @NotNull GeneralApi generalApi, @NotNull ConfigApi configApi, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)fileUploader, (String)"fileUploader");
        Intrinsics.checkNotNullParameter((Object)userApi, (String)"userApi");
        Intrinsics.checkNotNullParameter((Object)guestApi, (String)"guestApi");
        Intrinsics.checkNotNullParameter((Object)messageApi, (String)"messageApi");
        Intrinsics.checkNotNullParameter((Object)channelApi, (String)"channelApi");
        Intrinsics.checkNotNullParameter((Object)deviceApi, (String)"deviceApi");
        Intrinsics.checkNotNullParameter((Object)moderationApi, (String)"moderationApi");
        Intrinsics.checkNotNullParameter((Object)generalApi, (String)"generalApi");
        Intrinsics.checkNotNullParameter((Object)configApi, (String)"configApi");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.fileUploader = fileUploader;
        this.userApi = userApi;
        this.guestApi = guestApi;
        this.messageApi = messageApi;
        this.channelApi = channelApi;
        this.deviceApi = deviceApi;
        this.moderationApi = moderationApi;
        this.generalApi = generalApi;
        this.configApi = configApi;
        this.coroutineScope = coroutineScope;
        this.logger = ChatLogger.Companion.get("MoshiChatApi");
        this.userId = "";
        this.connectionId = "";
    }

    @NotNull
    public final TaggedLogger getLogger() {
        return this.logger;
    }

    private final String getUserId() {
        if (Intrinsics.areEqual((Object)this.userId, (Object)"")) {
            this.logger.logE("userId accessed before being set. Did you forget to call ChatClient.connectUser()?");
        }
        return this.userId;
    }

    private final String getConnectionId() {
        if (Intrinsics.areEqual((Object)this.connectionId, (Object)"")) {
            this.logger.logE("connectionId accessed before being set. Did you forget to call ChatClient.connectUser()?");
        }
        return this.connectionId;
    }

    @Override
    public void setConnection(@NotNull String userId, @NotNull String connectionId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)connectionId, (String)"connectionId");
        this.userId = userId;
        this.connectionId = connectionId;
    }

    @Override
    @NotNull
    public Call<AppSettings> appSettings() {
        return CallKt.map((Call)this.configApi.getAppSettings(), (Function1)appSettings.1.INSTANCE);
    }

    @Override
    @NotNull
    public Call<Message> sendMessage(@NotNull String channelType, @NotNull String channelId, @NotNull Message message) {
        Intrinsics.checkNotNullParameter((Object)channelType, (String)"channelType");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return CallKt.map((Call)this.messageApi.sendMessage(channelType, channelId, this.getConnectionId(), new MessageRequest(MessageMappingKt.toDto(message))), (Function1)sendMessage.1.INSTANCE);
    }

    @Override
    @NotNull
    public Call<Message> updateMessage(@NotNull Message message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return CallKt.map((Call)this.messageApi.updateMessage(message.getId(), this.getConnectionId(), new MessageRequest(MessageMappingKt.toDto(message))), (Function1)updateMessage.1.INSTANCE);
    }

    @Override
    @NotNull
    public Call<Message> partialUpdateMessage(@NotNull String messageId, @NotNull Map<String, ? extends Object> set, @NotNull List<String> unset) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Intrinsics.checkNotNullParameter(set, (String)"set");
        Intrinsics.checkNotNullParameter(unset, (String)"unset");
        return CallKt.map((Call)this.messageApi.partialUpdateMessage(messageId, this.getConnectionId(), new PartialUpdateMessageRequest(set, unset)), (Function1)partialUpdateMessage.1.INSTANCE);
    }

    @Override
    @NotNull
    public Call<Message> getMessage(@NotNull String messageId) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        return CallKt.map((Call)this.messageApi.getMessage(messageId, this.getConnectionId()), (Function1)getMessage.1.INSTANCE);
    }

    @Override
    @NotNull
    public Call<Message> deleteMessage(@NotNull String messageId, boolean hard) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        MessageApi messageApi = this.messageApi;
        String string = this.getConnectionId();
        Boolean bl = hard ? Boolean.valueOf(true) : null;
        return CallKt.map((Call)messageApi.deleteMessage(messageId, bl, string), (Function1)deleteMessage.1.INSTANCE);
    }

    @Override
    @NotNull
    public Call<List<Reaction>> getReactions(@NotNull String messageId, int offset, int limit) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        return CallKt.map((Call)this.messageApi.getReactions(messageId, this.getConnectionId(), offset, limit), (Function1)getReactions.1.INSTANCE);
    }

    @Override
    @NotNull
    public Call<Reaction> sendReaction(@NotNull Reaction reaction, boolean enforceUnique) {
        Intrinsics.checkNotNullParameter((Object)reaction, (String)"reaction");
        return CallKt.map((Call)this.messageApi.sendReaction(reaction.getMessageId(), this.getConnectionId(), new ReactionRequest(ReactionMappingKt.toDto(reaction), enforceUnique)), (Function1)sendReaction.1.INSTANCE);
    }

    @Override
    @NotNull
    public Call<Message> deleteReaction(@NotNull String messageId, @NotNull String reactionType) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Intrinsics.checkNotNullParameter((Object)reactionType, (String)"reactionType");
        return CallKt.map((Call)this.messageApi.deleteReaction(messageId, reactionType, this.getConnectionId()), (Function1)deleteReaction.1.INSTANCE);
    }

    @Override
    @NotNull
    public Call<Unit> addDevice(@NotNull Device device) {
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        return CallKt.toUnitCall((Call)this.deviceApi.addDevices(this.getConnectionId(), new AddDeviceRequest(device.getToken(), device.getPushProvider().getKey$stream_chat_android_client_release())));
    }

    @Override
    @NotNull
    public Call<Unit> deleteDevice(@NotNull Device device) {
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        return CallKt.toUnitCall((Call)this.deviceApi.deleteDevice(device.getToken(), this.getConnectionId()));
    }

    @Override
    @NotNull
    public Call<List<Device>> getDevices() {
        return CallKt.map((Call)this.deviceApi.getDevices(this.getConnectionId()), (Function1)getDevices.1.INSTANCE);
    }

    @Override
    @NotNull
    public Call<Mute> muteCurrentUser() {
        return this.muteUser(this.getUserId(), null);
    }

    @Override
    @NotNull
    public Call<Unit> unmuteCurrentUser() {
        return this.unmuteUser(this.getUserId());
    }

    @Override
    @NotNull
    public Call<Mute> muteUser(@NotNull String userId, @Nullable Integer timeout) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        return CallKt.map((Call)this.moderationApi.muteUser(this.getConnectionId(), new MuteUserRequest(userId, this.getUserId(), timeout)), (Function1)muteUser.1.INSTANCE);
    }

    @Override
    @NotNull
    public Call<Unit> unmuteUser(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        return CallKt.toUnitCall((Call)this.moderationApi.unmuteUser(this.getConnectionId(), new MuteUserRequest(userId, this.getUserId(), null)));
    }

    @Override
    @NotNull
    public Call<Unit> muteChannel(@NotNull String channelType, @NotNull String channelId, @Nullable Integer expiration) {
        Intrinsics.checkNotNullParameter((Object)channelType, (String)"channelType");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        return CallKt.toUnitCall((Call)this.moderationApi.muteChannel(this.getConnectionId(), new MuteChannelRequest(channelType + ':' + channelId, expiration)));
    }

    @Override
    @NotNull
    public Call<Unit> unmuteChannel(@NotNull String channelType, @NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelType, (String)"channelType");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        return CallKt.toUnitCall((Call)this.moderationApi.unmuteChannel(this.getConnectionId(), new MuteChannelRequest(channelType + ':' + channelId, null)));
    }

    @Override
    @NotNull
    public Call<String> sendFile(@NotNull String channelType, @NotNull String channelId, @NotNull File file, @Nullable ProgressCallback callback2) {
        Intrinsics.checkNotNullParameter((Object)channelType, (String)"channelType");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return (Call)new CoroutineCall(this.coroutineScope, (Function2)new Function2<CoroutineScope, Continuation<? super Result<String>>, Object>(callback2, this, channelType, channelId, file, null){
            int label;
            final /* synthetic */ ProgressCallback $callback;
            final /* synthetic */ MoshiChatApi this$0;
            final /* synthetic */ String $channelType;
            final /* synthetic */ String $channelId;
            final /* synthetic */ File $file;
            {
                this.$callback = $callback;
                this.this$0 = $receiver;
                this.$channelType = $channelType;
                this.$channelId = $channelId;
                this.$file = $file;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        return this.$callback != null ? MoshiChatApi.access$getFileUploader$p(this.this$0).sendFile(this.$channelType, this.$channelId, MoshiChatApi.access$getUserId(this.this$0), MoshiChatApi.access$getConnectionId(this.this$0), this.$file, this.$callback) : MoshiChatApi.access$getFileUploader$p(this.this$0).sendFile(this.$channelType, this.$channelId, MoshiChatApi.access$getUserId(this.this$0), MoshiChatApi.access$getConnectionId(this.this$0), this.$file);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Result<String>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    @Override
    @NotNull
    public Call<String> sendImage(@NotNull String channelType, @NotNull String channelId, @NotNull File file, @Nullable ProgressCallback callback2) {
        Intrinsics.checkNotNullParameter((Object)channelType, (String)"channelType");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return (Call)new CoroutineCall(this.coroutineScope, (Function2)new Function2<CoroutineScope, Continuation<? super Result<String>>, Object>(callback2, this, channelType, channelId, file, null){
            int label;
            final /* synthetic */ ProgressCallback $callback;
            final /* synthetic */ MoshiChatApi this$0;
            final /* synthetic */ String $channelType;
            final /* synthetic */ String $channelId;
            final /* synthetic */ File $file;
            {
                this.$callback = $callback;
                this.this$0 = $receiver;
                this.$channelType = $channelType;
                this.$channelId = $channelId;
                this.$file = $file;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        return this.$callback != null ? MoshiChatApi.access$getFileUploader$p(this.this$0).sendImage(this.$channelType, this.$channelId, MoshiChatApi.access$getUserId(this.this$0), MoshiChatApi.access$getConnectionId(this.this$0), this.$file, this.$callback) : MoshiChatApi.access$getFileUploader$p(this.this$0).sendImage(this.$channelType, this.$channelId, MoshiChatApi.access$getUserId(this.this$0), MoshiChatApi.access$getConnectionId(this.this$0), this.$file);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Result<String>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    @Override
    @NotNull
    public Call<Unit> deleteFile(@NotNull String channelType, @NotNull String channelId, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)channelType, (String)"channelType");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return (Call)new CoroutineCall(this.coroutineScope, (Function2)new Function2<CoroutineScope, Continuation<? super Result<Unit>>, Object>(this, channelType, channelId, url, null){
            int label;
            final /* synthetic */ MoshiChatApi this$0;
            final /* synthetic */ String $channelType;
            final /* synthetic */ String $channelId;
            final /* synthetic */ String $url;
            {
                this.this$0 = $receiver;
                this.$channelType = $channelType;
                this.$channelId = $channelId;
                this.$url = $url;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        MoshiChatApi.access$getFileUploader$p(this.this$0).deleteFile(this.$channelType, this.$channelId, MoshiChatApi.access$getUserId(this.this$0), MoshiChatApi.access$getConnectionId(this.this$0), this.$url);
                        return new Result((Object)Unit.INSTANCE);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Result<Unit>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    @Override
    @NotNull
    public Call<Unit> deleteImage(@NotNull String channelType, @NotNull String channelId, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)channelType, (String)"channelType");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return (Call)new CoroutineCall(this.coroutineScope, (Function2)new Function2<CoroutineScope, Continuation<? super Result<Unit>>, Object>(this, channelType, channelId, url, null){
            int label;
            final /* synthetic */ MoshiChatApi this$0;
            final /* synthetic */ String $channelType;
            final /* synthetic */ String $channelId;
            final /* synthetic */ String $url;
            {
                this.this$0 = $receiver;
                this.$channelType = $channelType;
                this.$channelId = $channelId;
                this.$url = $url;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        MoshiChatApi.access$getFileUploader$p(this.this$0).deleteImage(this.$channelType, this.$channelId, MoshiChatApi.access$getUserId(this.this$0), MoshiChatApi.access$getConnectionId(this.this$0), this.$url);
                        return new Result((Object)Unit.INSTANCE);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Result<Unit>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    @Override
    @NotNull
    public Call<Flag> flagUser(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"target_user_id", (Object)userId)};
        return this.flag(MapsKt.mutableMapOf((Pair[])pairArray));
    }

    @Override
    @NotNull
    public Call<Flag> unflagUser(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"target_user_id", (Object)userId)};
        return this.unflag(MapsKt.mutableMapOf((Pair[])pairArray));
    }

    @Override
    @NotNull
    public Call<Flag> flagMessage(@NotNull String messageId) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"target_message_id", (Object)messageId)};
        return this.flag(MapsKt.mutableMapOf((Pair[])pairArray));
    }

    @Override
    @NotNull
    public Call<Flag> unflagMessage(@NotNull String messageId) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"target_message_id", (Object)messageId)};
        return this.unflag(MapsKt.mutableMapOf((Pair[])pairArray));
    }

    private final Call<Flag> flag(Map<String, String> body) {
        return CallKt.map((Call)this.moderationApi.flag(this.getConnectionId(), body), (Function1)flag.1.INSTANCE);
    }

    private final Call<Flag> unflag(Map<String, String> body) {
        return CallKt.map((Call)this.moderationApi.unflag(this.getConnectionId(), body), (Function1)unflag.1.INSTANCE);
    }

    @Override
    @NotNull
    public Call<Unit> banUser(@NotNull String targetId, @Nullable Integer timeout, @Nullable String reason, @NotNull String channelType, @NotNull String channelId, boolean shadow) {
        Intrinsics.checkNotNullParameter((Object)targetId, (String)"targetId");
        Intrinsics.checkNotNullParameter((Object)channelType, (String)"channelType");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        return CallKt.toUnitCall((Call)this.moderationApi.banUser(this.getConnectionId(), new BanUserRequest(targetId, timeout, reason, channelType, channelId, shadow)));
    }

    @Override
    @NotNull
    public Call<Unit> unbanUser(@NotNull String targetId, @NotNull String channelType, @NotNull String channelId, boolean shadow) {
        Intrinsics.checkNotNullParameter((Object)targetId, (String)"targetId");
        Intrinsics.checkNotNullParameter((Object)channelType, (String)"channelType");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        ModerationApi moderationApi = this.moderationApi;
        String string = this.getConnectionId();
        return CallKt.toUnitCall((Call)moderationApi.unbanUser(string, targetId, channelType, channelId, shadow));
    }

    @Override
    @NotNull
    public Call<List<BannedUser>> queryBannedUsers(@NotNull FilterObject filter2, @NotNull QuerySort<BannedUsersSort> sort, @Nullable Integer offset, @Nullable Integer limit, @Nullable Date createdAtAfter, @Nullable Date createdAtAfterOrEqual, @Nullable Date createdAtBefore, @Nullable Date createdAtBeforeOrEqual) {
        Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter");
        Intrinsics.checkNotNullParameter(sort, (String)"sort");
        return CallKt.map((Call)this.moderationApi.queryBannedUsers(this.getConnectionId(), new QueryBannedUsersRequest(FilterObjectToMapKt.toMap(filter2), sort.toDto(), offset, limit, createdAtAfter, createdAtAfterOrEqual, createdAtBefore, createdAtBeforeOrEqual)), (Function1)queryBannedUsers.1.INSTANCE);
    }

    @Override
    @NotNull
    public Call<Channel> enableSlowMode(@NotNull String channelType, @NotNull String channelId, int cooldownTimeInSeconds) {
        Intrinsics.checkNotNullParameter((Object)channelType, (String)"channelType");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        return this.updateCooldown(channelType, channelId, cooldownTimeInSeconds);
    }

    @Override
    @NotNull
    public Call<Channel> disableSlowMode(@NotNull String channelType, @NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelType, (String)"channelType");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        return this.updateCooldown(channelType, channelId, 0);
    }

    private final Call<Channel> updateCooldown(String channelType, String channelId, int cooldownTimeInSeconds) {
        return CallKt.map((Call)this.channelApi.updateCooldown(channelType, channelId, this.getConnectionId(), UpdateCooldownRequest.Companion.create(cooldownTimeInSeconds)), (Function1)((Function1)new Function1<ChannelResponse, Channel>((Object)this){

            @NotNull
            public final Channel invoke(@NotNull ChannelResponse p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return MoshiChatApi.access$flattenChannel((MoshiChatApi)this.receiver, p0);
            }
        }));
    }

    @Override
    @NotNull
    public Call<Unit> stopWatching(@NotNull String channelType, @NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelType, (String)"channelType");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        return CallKt.toUnitCall((Call)this.channelApi.stopWatching(channelType, channelId, this.getConnectionId(), MapsKt.emptyMap()));
    }

    @Override
    @NotNull
    public Call<List<Message>> getPinnedMessages(@NotNull String channelType, @NotNull String channelId, int limit, @NotNull QuerySort<Message> sort, @NotNull PinnedMessagesPagination pagination) {
        Intrinsics.checkNotNullParameter((Object)channelType, (String)"channelType");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter(sort, (String)"sort");
        Intrinsics.checkNotNullParameter((Object)pagination, (String)"pagination");
        return CallKt.map((Call)this.channelApi.getPinnedMessages(channelType, channelId, PinnedMessagesRequest.Companion.create(limit, sort, pagination)), (Function1)getPinnedMessages.1.INSTANCE);
    }

    @Override
    @NotNull
    public Call<Channel> updateChannel(@NotNull String channelType, @NotNull String channelId, @NotNull Map<String, ? extends Object> extraData, @Nullable Message updateMessage2) {
        Intrinsics.checkNotNullParameter((Object)channelType, (String)"channelType");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter(extraData, (String)"extraData");
        Message message = updateMessage2;
        return CallKt.map((Call)this.channelApi.updateChannel(channelType, channelId, this.getConnectionId(), new UpdateChannelRequest(extraData, (UpstreamMessageDto)(message == null ? null : MessageMappingKt.toDto(message)))), (Function1)((Function1)new Function1<ChannelResponse, Channel>((Object)this){

            @NotNull
            public final Channel invoke(@NotNull ChannelResponse p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return MoshiChatApi.access$flattenChannel((MoshiChatApi)this.receiver, p0);
            }
        }));
    }

    @Override
    @NotNull
    public Call<Channel> updateChannelPartial(@NotNull String channelType, @NotNull String channelId, @NotNull Map<String, ? extends Object> set, @NotNull List<String> unset) {
        Intrinsics.checkNotNullParameter((Object)channelType, (String)"channelType");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter(set, (String)"set");
        Intrinsics.checkNotNullParameter(unset, (String)"unset");
        return CallKt.map((Call)this.channelApi.updateChannelPartial(channelType, channelId, this.getConnectionId(), new UpdateChannelPartialRequest(set, unset)), (Function1)((Function1)new Function1<ChannelResponse, Channel>((Object)this){

            @NotNull
            public final Channel invoke(@NotNull ChannelResponse p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return MoshiChatApi.access$flattenChannel((MoshiChatApi)this.receiver, p0);
            }
        }));
    }

    @Override
    @NotNull
    public Call<Unit> showChannel(@NotNull String channelType, @NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelType, (String)"channelType");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        return CallKt.toUnitCall((Call)this.channelApi.showChannel(channelType, channelId, this.getConnectionId(), MapsKt.emptyMap()));
    }

    @Override
    @NotNull
    public Call<Unit> hideChannel(@NotNull String channelType, @NotNull String channelId, boolean clearHistory) {
        Intrinsics.checkNotNullParameter((Object)channelType, (String)"channelType");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        return CallKt.toUnitCall((Call)this.channelApi.hideChannel(channelType, channelId, this.getConnectionId(), new HideChannelRequest(clearHistory)));
    }

    @Override
    @NotNull
    public Call<Channel> truncateChannel(@NotNull String channelType, @NotNull String channelId, @Nullable Message systemMessage) {
        Intrinsics.checkNotNullParameter((Object)channelType, (String)"channelType");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Message message = systemMessage;
        return CallKt.map((Call)this.channelApi.truncateChannel(channelType, channelId, this.getConnectionId(), new TruncateChannelRequest((UpstreamMessageDto)(message == null ? null : MessageMappingKt.toDto(message)))), (Function1)((Function1)new Function1<ChannelResponse, Channel>((Object)this){

            @NotNull
            public final Channel invoke(@NotNull ChannelResponse p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return MoshiChatApi.access$flattenChannel((MoshiChatApi)this.receiver, p0);
            }
        }));
    }

    @Override
    @NotNull
    public Call<Channel> rejectInvite(@NotNull String channelType, @NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelType, (String)"channelType");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        return CallKt.map((Call)this.channelApi.rejectInvite(channelType, channelId, this.getConnectionId(), new RejectInviteRequest(false, 1, null)), (Function1)((Function1)new Function1<ChannelResponse, Channel>((Object)this){

            @NotNull
            public final Channel invoke(@NotNull ChannelResponse p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return MoshiChatApi.access$flattenChannel((MoshiChatApi)this.receiver, p0);
            }
        }));
    }

    @Override
    @NotNull
    public Call<Channel> acceptInvite(@NotNull String channelType, @NotNull String channelId, @Nullable String message) {
        Intrinsics.checkNotNullParameter((Object)channelType, (String)"channelType");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        return CallKt.map((Call)this.channelApi.acceptInvite(channelType, channelId, this.getConnectionId(), AcceptInviteRequest.Companion.create(this.getUserId(), message)), (Function1)((Function1)new Function1<ChannelResponse, Channel>((Object)this){

            @NotNull
            public final Channel invoke(@NotNull ChannelResponse p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return MoshiChatApi.access$flattenChannel((MoshiChatApi)this.receiver, p0);
            }
        }));
    }

    @Override
    @NotNull
    public Call<Channel> deleteChannel(@NotNull String channelType, @NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelType, (String)"channelType");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        return CallKt.map((Call)this.channelApi.deleteChannel(channelType, channelId, this.getConnectionId()), (Function1)((Function1)new Function1<ChannelResponse, Channel>((Object)this){

            @NotNull
            public final Channel invoke(@NotNull ChannelResponse p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return MoshiChatApi.access$flattenChannel((MoshiChatApi)this.receiver, p0);
            }
        }));
    }

    @Override
    @NotNull
    public Call<Unit> markRead(@NotNull String channelType, @NotNull String channelId, @NotNull String messageId) {
        Intrinsics.checkNotNullParameter((Object)channelType, (String)"channelType");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        return CallKt.toUnitCall((Call)this.channelApi.markRead(channelType, channelId, this.getConnectionId(), new MarkReadRequest(messageId)));
    }

    @Override
    @NotNull
    public Call<Unit> markAllRead() {
        return CallKt.toUnitCall((Call)ChannelApi.DefaultImpls.markAllRead$default(this.channelApi, this.getConnectionId(), null, 2, null));
    }

    @Override
    @NotNull
    public Call<Channel> addMembers(@NotNull String channelType, @NotNull String channelId, @NotNull List<String> members) {
        Intrinsics.checkNotNullParameter((Object)channelType, (String)"channelType");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter(members, (String)"members");
        return CallKt.map((Call)this.channelApi.addMembers(channelType, channelId, this.getConnectionId(), new AddMembersRequest(members)), (Function1)((Function1)new Function1<ChannelResponse, Channel>((Object)this){

            @NotNull
            public final Channel invoke(@NotNull ChannelResponse p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return MoshiChatApi.access$flattenChannel((MoshiChatApi)this.receiver, p0);
            }
        }));
    }

    @Override
    @NotNull
    public Call<Channel> removeMembers(@NotNull String channelType, @NotNull String channelId, @NotNull List<String> members) {
        Intrinsics.checkNotNullParameter((Object)channelType, (String)"channelType");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter(members, (String)"members");
        return CallKt.map((Call)this.channelApi.removeMembers(channelType, channelId, this.getConnectionId(), new RemoveMembersRequest(members)), (Function1)((Function1)new Function1<ChannelResponse, Channel>((Object)this){

            @NotNull
            public final Channel invoke(@NotNull ChannelResponse p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return MoshiChatApi.access$flattenChannel((MoshiChatApi)this.receiver, p0);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final Channel flattenChannel(ChannelResponse response) {
        Object v0;
        Channel channel;
        Channel channel2;
        block5: {
            void $this$firstOrNull$iv;
            DownstreamUserDto it;
            Object p0;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Channel $this$flattenChannel_u24lambda_u2d4 = channel2 = ChannelMappingKt.toDomain(response.getChannel());
            boolean bl = false;
            $this$flattenChannel_u24lambda_u2d4.setWatcherCount(response.getWatcher_count());
            Iterable iterable = response.getRead();
            channel = $this$flattenChannel_u24lambda_u2d4;
            boolean $i$f$map = false;
            void var8_9 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                DownstreamChannelUserRead downstreamChannelUserRead = (DownstreamChannelUserRead)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(ChannelUserReadMappingKt.toDomain((DownstreamChannelUserRead)p0));
            }
            channel.setRead((List)destination$iv$iv);
            $this$map$iv = response.getMembers();
            channel = $this$flattenChannel_u24lambda_u2d4;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                p0 = (DownstreamMemberDto)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(MemberMappingKt.toDomain((DownstreamMemberDto)p0));
            }
            channel.setMembers((List)destination$iv$iv);
            $this$map$iv = response.getMessages();
            channel = $this$flattenChannel_u24lambda_u2d4;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                p0 = (DownstreamMessageDto)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl4 = false;
                collection.add(MessageExtensionsKt.enrichWithCid(MessageMappingKt.toDomain((DownstreamMessageDto)((Object)it)), $this$flattenChannel_u24lambda_u2d4.getCid()));
            }
            channel.setMessages((List)destination$iv$iv);
            $this$map$iv = response.getWatchers();
            channel = $this$flattenChannel_u24lambda_u2d4;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (DownstreamUserDto)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl5 = false;
                collection.add(UserMappingKt.toDomain((DownstreamUserDto)p0));
            }
            channel.setWatchers((List)destination$iv$iv);
            $this$flattenChannel_u24lambda_u2d4.setHidden(response.getHidden());
            $this$flattenChannel_u24lambda_u2d4.setHiddenMessagesBefore(response.getHide_messages_before());
            Iterable $i$f$map2 = response.getRead();
            channel = $this$flattenChannel_u24lambda_u2d4;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                DownstreamChannelUserRead it2 = (DownstreamChannelUserRead)element$iv;
                boolean bl6 = false;
                if (!Intrinsics.areEqual((Object)it2.getUser().getId(), (Object)this.getUserId())) continue;
                v0 = element$iv;
                break block5;
            }
            v0 = null;
        }
        DownstreamChannelUserRead downstreamChannelUserRead = v0;
        channel.setUnreadCount(downstreamChannelUserRead == null ? null : Integer.valueOf(downstreamChannelUserRead.getUnread_messages()));
        return channel2;
    }

    @Override
    @NotNull
    public Call<List<Message>> getReplies(@NotNull String messageId, int limit) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        return CallKt.map((Call)this.messageApi.getReplies(messageId, this.getConnectionId(), limit), (Function1)getReplies.1.INSTANCE);
    }

    @Override
    @NotNull
    public Call<List<Message>> getRepliesMore(@NotNull String messageId, @NotNull String firstId, int limit) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Intrinsics.checkNotNullParameter((Object)firstId, (String)"firstId");
        return CallKt.map((Call)this.messageApi.getRepliesMore(messageId, this.getConnectionId(), limit, firstId), (Function1)getRepliesMore.1.INSTANCE);
    }

    @Override
    @NotNull
    public Call<Message> sendAction(@NotNull io.getstream.chat.android.client.api.models.SendActionRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return CallKt.map((Call)this.messageApi.sendAction(request.getMessageId(), this.getConnectionId(), new SendActionRequest(request.getChannelId(), request.getMessageId(), request.getType(), request.getFormData())), (Function1)sendAction.1.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Call<List<User>> updateUsers(@NotNull List<User> users) {
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter(users, (String)"users");
        Iterable $this$associateBy$iv = users;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void p0;
            User user = (User)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            User it = (User)element$iv$iv;
            String string = it.getId();
            boolean bl2 = false;
            UpstreamUserDto upstreamUserDto = UserMappingKt.toDto((User)p0);
            map.put(string, upstreamUserDto);
        }
        Map map = destination$iv$iv;
        return CallKt.map((Call)this.userApi.updateUsers(this.getConnectionId(), new UpdateUsersRequest(map)), (Function1)updateUsers.1.INSTANCE);
    }

    @Override
    @NotNull
    public Call<User> partialUpdateUser(@NotNull String id, @NotNull Map<String, ? extends Object> set, @NotNull List<String> unset) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(set, (String)"set");
        Intrinsics.checkNotNullParameter(unset, (String)"unset");
        return CallKt.map((Call)this.userApi.partialUpdateUsers(this.getConnectionId(), new PartialUpdateUsersRequest(CollectionsKt.listOf((Object)new PartialUpdateUserDto(id, set, unset)))), (Function1)((Function1)new Function1<UpdateUsersResponse, User>(id){
            final /* synthetic */ String $id;
            {
                this.$id = $id;
                super(1);
            }

            @NotNull
            public final User invoke(@NotNull UpdateUsersResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                DownstreamUserDto downstreamUserDto = response.getUsers().get(this.$id);
                Intrinsics.checkNotNull((Object)downstreamUserDto);
                return UserMappingKt.toDomain(downstreamUserDto);
            }
        }));
    }

    @Override
    @NotNull
    public Call<GuestUser> getGuestUser(@NotNull String userId, @NotNull String userName) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)userName, (String)"userName");
        return CallKt.map((Call)this.guestApi.getGuestUser(GuestUserRequest.Companion.create(userId, userName)), (Function1)getGuestUser.1.INSTANCE);
    }

    @Override
    @NotNull
    public Call<Message> translate(@NotNull String messageId, @NotNull String language) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        return CallKt.map((Call)this.messageApi.translate(messageId, this.getConnectionId(), new TranslateMessageRequest(language)), (Function1)translate.1.INSTANCE);
    }

    @Override
    @NotNull
    public Call<List<Message>> searchMessages(@NotNull io.getstream.chat.android.client.api.models.SearchMessagesRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        SearchMessagesRequest newRequest = new SearchMessagesRequest(FilterObjectToMapKt.toMap(request.getChannelFilter()), FilterObjectToMapKt.toMap(request.getMessageFilter()), request.getOffset(), request.getLimit(), request.getNext(), request.getSort());
        return CallKt.map((Call)this.generalApi.searchMessages(this.getConnectionId(), newRequest), (Function1)searchMessages.1.INSTANCE);
    }

    @Override
    @NotNull
    public Call<SearchMessagesResult> searchMessages(@NotNull FilterObject channelFilter, @NotNull FilterObject messageFilter, @Nullable Integer offset, @Nullable Integer limit, @Nullable String next, @Nullable QuerySort<Message> sort) {
        Intrinsics.checkNotNullParameter((Object)channelFilter, (String)"channelFilter");
        Intrinsics.checkNotNullParameter((Object)messageFilter, (String)"messageFilter");
        QuerySort<Message> querySort = sort;
        SearchMessagesRequest newRequest = new SearchMessagesRequest(FilterObjectToMapKt.toMap(channelFilter), FilterObjectToMapKt.toMap(messageFilter), offset, limit, next, (List<? extends Map<String, ? extends Object>>)(querySort == null ? null : querySort.toDto()));
        return CallKt.map((Call)this.generalApi.searchMessages(this.getConnectionId(), newRequest), (Function1)searchMessages.2.INSTANCE);
    }

    @Override
    @NotNull
    public Call<List<Channel>> queryChannels(@NotNull io.getstream.chat.android.client.api.models.QueryChannelsRequest query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        if (((CharSequence)this.getConnectionId()).length() == 0) {
            return this.noConnectionIdError();
        }
        QueryChannelsRequest request = new QueryChannelsRequest(FilterObjectToMapKt.toMap(query.getFilter()), query.getOffset(), query.getLimit(), query.getSort(), query.getMessageLimit(), query.getMemberLimit(), query.getState(), query.getWatch(), query.getPresence());
        return CallKt.map((Call)this.channelApi.queryChannels(this.getConnectionId(), request), (Function1)((Function1)new Function1<QueryChannelsResponse, List<? extends Channel>>(this){
            final /* synthetic */ MoshiChatApi this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<Channel> invoke(@NotNull QueryChannelsResponse response) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                Iterable iterable = response.getChannels();
                MoshiChatApi moshiChatApi = this.this$0;
                boolean $i$f$map = false;
                void var5_5 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void p0;
                    ChannelResponse channelResponse = (ChannelResponse)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(MoshiChatApi.access$flattenChannel(moshiChatApi, (ChannelResponse)p0));
                }
                return (List)destination$iv$iv;
            }
        }));
    }

    @Override
    @NotNull
    public Call<Channel> queryChannel(@NotNull String channelType, @NotNull String channelId, @NotNull io.getstream.chat.android.client.api.models.QueryChannelRequest query) {
        Intrinsics.checkNotNullParameter((Object)channelType, (String)"channelType");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        QueryChannelRequest request = new QueryChannelRequest(query.getState(), query.getWatch(), query.getPresence(), query.getMessages(), query.getWatchers(), query.getMembers(), query.getData());
        return CallKt.map((Call)(((CharSequence)channelId).length() == 0 ? this.channelApi.queryChannel(channelType, this.getConnectionId(), request) : this.channelApi.queryChannel(channelType, channelId, this.getConnectionId(), request)), (Function1)((Function1)new Function1<ChannelResponse, Channel>((Object)this){

            @NotNull
            public final Channel invoke(@NotNull ChannelResponse p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return MoshiChatApi.access$flattenChannel((MoshiChatApi)this.receiver, p0);
            }
        }));
    }

    @Override
    @NotNull
    public Call<List<User>> queryUsers(@NotNull io.getstream.chat.android.client.api.models.QueryUsersRequest queryUsers2) {
        Intrinsics.checkNotNullParameter((Object)queryUsers2, (String)"queryUsers");
        QueryUsersRequest request = new QueryUsersRequest(FilterObjectToMapKt.toMap(queryUsers2.getFilter()), queryUsers2.getOffset(), queryUsers2.getLimit(), queryUsers2.getSort(), queryUsers2.getPresence());
        return CallKt.map((Call)this.userApi.queryUsers(this.getConnectionId(), request), (Function1)queryUsers.1.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Call<List<Member>> queryMembers(@NotNull String channelType, @NotNull String channelId, int offset, int limit, @NotNull FilterObject filter2, @NotNull QuerySort<Member> sort, @NotNull List<Member> members) {
        Collection<UpstreamMemberDto> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)channelType, (String)"channelType");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter");
        Intrinsics.checkNotNullParameter(sort, (String)"sort");
        Intrinsics.checkNotNullParameter(members, (String)"members");
        Iterable iterable = members;
        List<Map<String, Object>> list = sort.toDto();
        int n = limit;
        int n2 = offset;
        Map<String, Object> map = FilterObjectToMapKt.toMap(filter2);
        String string = channelId;
        String string2 = channelType;
        boolean $i$f$map = false;
        void var11_16 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Member member = (Member)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(MemberMappingKt.toDto((Member)p0));
        }
        Collection<UpstreamMemberDto> collection2 = collection = (List)destination$iv$iv;
        List<Map<String, Object>> list2 = list;
        int n3 = n;
        int n4 = n2;
        Map<String, Object> map2 = map;
        String string3 = string;
        String string4 = string2;
        QueryMembersRequest request = new QueryMembersRequest(string4, string3, map2, n4, n3, (List<? extends Map<String, ? extends Object>>)list2, (List<UpstreamMemberDto>)collection2);
        return CallKt.map((Call)this.generalApi.queryMembers(this.getConnectionId(), request), (Function1)queryMembers.1.INSTANCE);
    }

    @Override
    @NotNull
    public Call<ChatEvent> sendEvent(@NotNull String eventType, @NotNull String channelType, @NotNull String channelId, @NotNull Map<Object, ? extends Object> extraData) {
        Intrinsics.checkNotNullParameter((Object)eventType, (String)"eventType");
        Intrinsics.checkNotNullParameter((Object)channelType, (String)"channelType");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter(extraData, (String)"extraData");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"type", (Object)eventType)};
        Map map = MapsKt.mutableMapOf((Pair[])pairArray);
        map.putAll(extraData);
        return CallKt.map((Call)this.channelApi.sendEvent(channelType, channelId, this.getConnectionId(), new SendEventRequest(map)), (Function1)sendEvent.1.INSTANCE);
    }

    @Override
    @NotNull
    public Call<List<ChatEvent>> getSyncHistory(@NotNull List<String> channelIds, @NotNull Date lastSyncAt) {
        Intrinsics.checkNotNullParameter(channelIds, (String)"channelIds");
        Intrinsics.checkNotNullParameter((Object)lastSyncAt, (String)"lastSyncAt");
        return CallKt.map((Call)this.generalApi.getSyncHistory(new SyncHistoryRequest(channelIds, lastSyncAt), this.getConnectionId()), (Function1)getSyncHistory.1.INSTANCE);
    }

    @Override
    public void warmUp() {
        this.generalApi.warmUp().enqueue();
    }

    private final <T> ErrorCall<T> noConnectionIdError() {
        return new ErrorCall(new ChatError("setUser is either not called or not finished", null, 2, null));
    }

    @Override
    @CheckResult
    @NotNull
    public Call<Reaction> sendReaction(@NotNull String messageId, @NotNull String reactionType, boolean enforceUnique) {
        return ChatApi.DefaultImpls.sendReaction(this, messageId, reactionType, enforceUnique);
    }

    public static final /* synthetic */ FileUploader access$getFileUploader$p(MoshiChatApi $this) {
        return $this.fileUploader;
    }

    public static final /* synthetic */ String access$getUserId(MoshiChatApi $this) {
        return $this.getUserId();
    }

    public static final /* synthetic */ String access$getConnectionId(MoshiChatApi $this) {
        return $this.getConnectionId();
    }

    public static final /* synthetic */ Channel access$flattenChannel(MoshiChatApi $this, ChannelResponse response) {
        return $this.flattenChannel(response);
    }
}

