/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.client.socket;

import io.getstream.chat.android.client.ChatClient;
import io.getstream.chat.android.client.logger.ChatLogger;
import io.getstream.chat.android.client.logger.TaggedLogger;
import io.getstream.chat.android.client.models.User;
import io.getstream.chat.android.client.parser.ChatParser;
import io.getstream.chat.android.client.socket.EventsParser;
import io.getstream.chat.android.client.socket.Socket;
import io.getstream.chat.android.client.token.TokenManager;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J(\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J0\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001e\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fJ&\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010J\u0018\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00010\u001b*\u00020\u0010H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lio/getstream/chat/android/client/socket/SocketFactory;", "", "parser", "Lio/getstream/chat/android/client/parser/ChatParser;", "tokenManager", "Lio/getstream/chat/android/client/token/TokenManager;", "(Lio/getstream/chat/android/client/parser/ChatParser;Lio/getstream/chat/android/client/token/TokenManager;)V", "httpClient", "Lokhttp3/OkHttpClient;", "logger", "Lio/getstream/chat/android/client/logger/TaggedLogger;", "buildUrl", "", "endpoint", "apiKey", "user", "Lio/getstream/chat/android/client/models/User;", "isAnonymous", "", "buildUserDetailJson", "create", "Lio/getstream/chat/android/client/socket/Socket;", "eventsParser", "Lio/getstream/chat/android/client/socket/EventsParser;", "createAnonymousSocket", "createNormalSocket", "reduceUserDetails", "", "Companion", "stream-chat-android-client_release"})
public final class SocketFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ChatParser parser;
    @NotNull
    private final TokenManager tokenManager;
    @NotNull
    private final TaggedLogger logger;
    @NotNull
    private final OkHttpClient httpClient;
    @NotNull
    private static final String ANONYMOUS_USER_ID = "anon";

    public SocketFactory(@NotNull ChatParser parser, @NotNull TokenManager tokenManager) {
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        Intrinsics.checkNotNullParameter((Object)tokenManager, (String)"tokenManager");
        this.parser = parser;
        this.tokenManager = tokenManager;
        String string2 = SocketFactory.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"SocketFactory::class.java.simpleName");
        this.logger = ChatLogger.Companion.get(string2);
        this.httpClient = new OkHttpClient();
    }

    @NotNull
    public final Socket createAnonymousSocket(@NotNull EventsParser eventsParser, @NotNull String endpoint, @NotNull String apiKey) {
        Intrinsics.checkNotNullParameter((Object)((Object)eventsParser), (String)"eventsParser");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        return this.create(eventsParser, endpoint, apiKey, new User(ANONYMOUS_USER_ID, null, null, null, false, false, null, false, null, null, null, 0, 0, null, null, null, null, 131070, null), true);
    }

    @NotNull
    public final Socket createNormalSocket(@NotNull EventsParser eventsParser, @NotNull String endpoint, @NotNull String apiKey, @NotNull User user) {
        Intrinsics.checkNotNullParameter((Object)((Object)eventsParser), (String)"eventsParser");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        return this.create(eventsParser, endpoint, apiKey, user, false);
    }

    private final Socket create(EventsParser eventsParser, String endpoint, String apiKey, User user, boolean isAnonymous) {
        String url = this.buildUrl(endpoint, apiKey, user, isAnonymous);
        Request request = new Request.Builder().url(url).build();
        WebSocket newWebSocket = this.httpClient.newWebSocket(request, (WebSocketListener)eventsParser);
        this.logger.logI(Intrinsics.stringPlus((String)"new web socket: ", (Object)url));
        return new Socket(newWebSocket, this.parser);
    }

    private final String buildUrl(String endpoint, String apiKey, User user, boolean isAnonymous) {
        String string2;
        String json = this.buildUserDetailJson(user);
        try {
            String string3;
            string2 = URLEncoder.encode(json, StandardCharsets.UTF_8.name());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"encode(json, StandardCharsets.UTF_8.name())");
            json = string2;
            String baseWsUrl = endpoint + "connect?json=" + json + "&api_key=" + apiKey;
            if (isAnonymous) {
                string3 = Intrinsics.stringPlus((String)baseWsUrl, (Object)"&stream-auth-type=anonymous");
            } else {
                String token = this.tokenManager.getToken();
                string3 = baseWsUrl + "&authorization=" + token + "&stream-auth-type=jwt";
            }
            string2 = string3;
        }
        catch (Throwable throwable) {
            throw new UnsupportedEncodingException(Intrinsics.stringPlus((String)"Unable to encode user details json: ", (Object)json));
        }
        return string2;
    }

    private final String buildUserDetailJson(User user) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"user_details", this.reduceUserDetails(user)), TuplesKt.to((Object)"user_id", (Object)user.getId()), TuplesKt.to((Object)"server_determines_connection_id", (Object)true), TuplesKt.to((Object)"X-Stream-Client", (Object)ChatClient.Companion.instance().buildSdkTrackingHeaders())};
        Map data = MapsKt.mapOf((Pair[])pairArray);
        return this.parser.toJson(data);
    }

    private final Map<String, Object> reduceUserDetails(User $this$reduceUserDetails) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"id", (Object)$this$reduceUserDetails.getId()), TuplesKt.to((Object)"name", (Object)$this$reduceUserDetails.getName()), TuplesKt.to((Object)"image", (Object)$this$reduceUserDetails.getImage()), TuplesKt.to((Object)"role", (Object)$this$reduceUserDetails.getRole()), TuplesKt.to((Object)"banned", (Object)$this$reduceUserDetails.getBanned()), TuplesKt.to((Object)"invisible", (Object)$this$reduceUserDetails.getInvisible()), TuplesKt.to((Object)"teams", $this$reduceUserDetails.getTeams())};
        Map details = MapsKt.mutableMapOf((Pair[])pairArray);
        details.putAll($this$reduceUserDetails.getExtraData());
        return details;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/getstream/chat/android/client/socket/SocketFactory$Companion;", "", "()V", "ANONYMOUS_USER_ID", "", "stream-chat-android-client_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

