/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.client.socket.experimental;

import io.getstream.chat.android.client.LifecycleHandler;
import io.getstream.chat.android.client.StreamLifecycleObserver;
import io.getstream.chat.android.client.clientstate.DisconnectCause;
import io.getstream.chat.android.client.errors.ChatError;
import io.getstream.chat.android.client.errors.ChatErrorCode;
import io.getstream.chat.android.client.errors.ChatNetworkError;
import io.getstream.chat.android.client.events.ChatEvent;
import io.getstream.chat.android.client.events.ConnectedEvent;
import io.getstream.chat.android.client.events.HealthEvent;
import io.getstream.chat.android.client.models.User;
import io.getstream.chat.android.client.network.NetworkStateProvider;
import io.getstream.chat.android.client.scope.UserScope;
import io.getstream.chat.android.client.socket.HealthMonitor;
import io.getstream.chat.android.client.socket.SocketFactory;
import io.getstream.chat.android.client.socket.SocketListener;
import io.getstream.chat.android.client.socket.experimental.ChatSocket;
import io.getstream.chat.android.client.socket.experimental.ChatSocketStateService;
import io.getstream.chat.android.client.socket.experimental.ws.StreamWebSocket;
import io.getstream.chat.android.client.socket.experimental.ws.StreamWebSocketEvent;
import io.getstream.chat.android.client.token.TokenManager;
import io.getstream.chat.android.client.utils.ResultUtilsKt;
import io.getstream.chat.android.core.internal.coroutines.DispatcherProvider;
import io.getstream.logging.Priority;
import io.getstream.logging.StreamLog;
import io.getstream.logging.StreamLogger;
import io.getstream.logging.TaggedLogger;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.TimeoutKt;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00be\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b*\u0002\u0017\u001f\b\u0000\u0018\u0000 U2\u00020\u0001:\u0001UB?\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u000e\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u001bJ\u001d\u0010-\u001a\u00020+2\b\b\u0002\u0010.\u001a\u00020/H\u0080@\u00f8\u0001\u0000\u00a2\u0006\u0004\b0\u00101J'\u00102\u001a\u00020+\"\n\b\u0000\u00103\u0018\u0001*\u0002042\u0006\u0010.\u001a\u00020/H\u0080H\u00f8\u0001\u0000\u00a2\u0006\u0004\b5\u00101J\u001c\u00106\u001a\u00020+2\u0012\u00107\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020+08H\u0002J\u0016\u00109\u001a\u00020+2\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=J\r\u0010>\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b?J\u0006\u0010@\u001a\u00020+J\b\u0010A\u001a\u00020+H\u0002J\u0011\u0010B\u001a\u00020+H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010CJ\u0010\u0010D\u001a\u00020+2\u0006\u0010E\u001a\u00020FH\u0002J\u0010\u0010G\u001a\u00020+2\u0006\u0010H\u001a\u00020IH\u0002J\r\u0010J\u001a\u00020=H\u0000\u00a2\u0006\u0002\bKJ\b\u0010L\u001a\u00020\"H\u0002J\u0010\u0010M\u001a\u00020+2\u0006\u0010E\u001a\u00020NH\u0002J\u0016\u0010O\u001a\u00020+2\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=J\u000e\u0010P\u001a\u00020+2\u0006\u0010,\u001a\u00020\u001bJ\u0015\u0010Q\u001a\u00020=2\u0006\u0010R\u001a\u00020IH\u0000\u00a2\u0006\u0002\bSJ\u0011\u0010T\u001a\u00020+H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010CR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0018R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010 R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u0004\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u0004\u0018\u00010$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010%\u001a\u00020&*\u00020'8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006V"}, d2={"Lio/getstream/chat/android/client/socket/experimental/ChatSocket;", "", "apiKey", "", "wssUrl", "tokenManager", "Lio/getstream/chat/android/client/token/TokenManager;", "socketFactory", "Lio/getstream/chat/android/client/socket/SocketFactory;", "coroutineScope", "Lio/getstream/chat/android/client/scope/UserScope;", "lifecycleObserver", "Lio/getstream/chat/android/client/StreamLifecycleObserver;", "networkStateProvider", "Lio/getstream/chat/android/client/network/NetworkStateProvider;", "(Ljava/lang/String;Ljava/lang/String;Lio/getstream/chat/android/client/token/TokenManager;Lio/getstream/chat/android/client/socket/SocketFactory;Lio/getstream/chat/android/client/scope/UserScope;Lio/getstream/chat/android/client/StreamLifecycleObserver;Lio/getstream/chat/android/client/network/NetworkStateProvider;)V", "chatSocketStateService", "Lio/getstream/chat/android/client/socket/experimental/ChatSocketStateService;", "connectionConf", "Lio/getstream/chat/android/client/socket/SocketFactory$ConnectionConf;", "healthMonitor", "Lio/getstream/chat/android/client/socket/HealthMonitor;", "lifecycleHandler", "io/getstream/chat/android/client/socket/experimental/ChatSocket$lifecycleHandler$1", "Lio/getstream/chat/android/client/socket/experimental/ChatSocket$lifecycleHandler$1;", "listeners", "", "Lio/getstream/chat/android/client/socket/SocketListener;", "logger", "Lio/getstream/logging/TaggedLogger;", "networkStateListener", "io/getstream/chat/android/client/socket/experimental/ChatSocket$networkStateListener$1", "Lio/getstream/chat/android/client/socket/experimental/ChatSocket$networkStateListener$1;", "socketStateObserverJob", "Lkotlinx/coroutines/Job;", "streamWebSocket", "Lio/getstream/chat/android/client/socket/experimental/ws/StreamWebSocket;", "cause", "Lio/getstream/chat/android/client/clientstate/DisconnectCause;", "Lio/getstream/chat/android/client/socket/experimental/ChatSocketStateService$State$Disconnected;", "getCause", "(Lio/getstream/chat/android/client/socket/experimental/ChatSocketStateService$State$Disconnected;)Lio/getstream/chat/android/client/clientstate/DisconnectCause;", "addListener", "", "listener", "awaitConnection", "timeoutInMillis", "", "awaitConnection$stream_chat_android_client_release", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "awaitState", "T", "Lio/getstream/chat/android/client/socket/experimental/ChatSocketStateService$State;", "awaitState$stream_chat_android_client_release", "callListeners", "call", "Lkotlin/Function1;", "connectUser", "user", "Lio/getstream/chat/android/client/models/User;", "isAnonymous", "", "connectionIdOrError", "connectionIdOrError$stream_chat_android_client_release", "disconnect", "disposeNetworkStateObserver", "disposeObservers", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handleError", "error", "Lio/getstream/chat/android/client/errors/ChatError;", "handleEvent", "chatEvent", "Lio/getstream/chat/android/client/events/ChatEvent;", "isConnected", "isConnected$stream_chat_android_client_release", "observeSocketStateService", "onChatNetworkError", "Lio/getstream/chat/android/client/errors/ChatNetworkError;", "reconnectUser", "removeListener", "sendEvent", "event", "sendEvent$stream_chat_android_client_release", "startObservers", "Companion", "stream-chat-android-client_release"})
public final class ChatSocket {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String apiKey;
    @NotNull
    private final String wssUrl;
    @NotNull
    private final TokenManager tokenManager;
    @NotNull
    private final SocketFactory socketFactory;
    @NotNull
    private final UserScope coroutineScope;
    @NotNull
    private final StreamLifecycleObserver lifecycleObserver;
    @NotNull
    private final NetworkStateProvider networkStateProvider;
    @Nullable
    private StreamWebSocket streamWebSocket;
    @NotNull
    private final TaggedLogger logger;
    @Nullable
    private SocketFactory.ConnectionConf connectionConf;
    @NotNull
    private final Set<SocketListener> listeners;
    @NotNull
    private final ChatSocketStateService chatSocketStateService;
    @Nullable
    private Job socketStateObserverJob;
    @NotNull
    private final HealthMonitor healthMonitor;
    @NotNull
    private final lifecycleHandler.1 lifecycleHandler;
    @NotNull
    private final networkStateListener.1 networkStateListener;
    private static final long DEFAULT_CONNECTION_TIMEOUT = 60000L;

    private ChatSocket(String apiKey, String wssUrl, TokenManager tokenManager, SocketFactory socketFactory, UserScope coroutineScope, StreamLifecycleObserver lifecycleObserver2, NetworkStateProvider networkStateProvider2) {
        this.apiKey = apiKey;
        this.wssUrl = wssUrl;
        this.tokenManager = tokenManager;
        this.socketFactory = socketFactory;
        this.coroutineScope = coroutineScope;
        this.lifecycleObserver = lifecycleObserver2;
        this.networkStateProvider = networkStateProvider2;
        this.logger = StreamLog.getLogger((String)"Chat:Experimental-Socket");
        this.listeners = new LinkedHashSet();
        this.chatSocketStateService = new ChatSocketStateService(null, 1, null);
        this.healthMonitor = new HealthMonitor(null, null, this.coroutineScope, (Function0)new Function0<Unit>(this){
            final /* synthetic */ ChatSocket this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                block0: {
                    ChatSocketStateService.State state2 = ChatSocket.access$getChatSocketStateService$p(this.this$0).getCurrentState();
                    Object object = state2 instanceof ChatSocketStateService.State.Connected ? (ChatSocketStateService.State.Connected)state2 : null;
                    if (object == null || (object = ((ChatSocketStateService.State.Connected)object).getEvent()) == null) break block0;
                    Object object2 = object;
                    ChatSocket chatSocket = this.this$0;
                    ChatEvent p0 = (ChatEvent)object2;
                    boolean bl = false;
                    chatSocket.sendEvent$stream_chat_android_client_release(p0);
                }
            }
        }, (Function0)new Function0<Unit>(this){
            final /* synthetic */ ChatSocket this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                ChatSocket.access$getChatSocketStateService$p(this.this$0).onWebSocketEventLost();
            }
        }, 3, null);
        this.lifecycleHandler = new LifecycleHandler(this){
            final /* synthetic */ ChatSocket this$0;
            {
                this.this$0 = $receiver;
            }

            public void resume() {
                ChatSocket.access$getChatSocketStateService$p(this.this$0).onResume();
            }

            public void stopped() {
                ChatSocket.access$getChatSocketStateService$p(this.this$0).onStop();
            }
        };
        this.networkStateListener = new NetworkStateProvider.NetworkStateListener(this){
            final /* synthetic */ ChatSocket this$0;
            {
                this.this$0 = $receiver;
            }

            public void onConnected() {
                ChatSocket.access$getChatSocketStateService$p(this.this$0).onNetworkAvailable();
            }

            public void onDisconnected() {
                ChatSocket.access$getChatSocketStateService$p(this.this$0).onNetworkNotAvailable();
            }
        };
    }

    private final Job observeSocketStateService() {
        Ref.ObjectRef socketListenerJob = new Ref.ObjectRef();
        return BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, (Ref.ObjectRef<Job>)socketListenerJob, null){
            int label;
            final /* synthetic */ ChatSocket this$0;
            final /* synthetic */ Ref.ObjectRef<Job> $socketListenerJob;
            {
                this.this$0 = $receiver;
                this.$socketListenerJob = $socketListenerJob;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = ChatSocket.access$getChatSocketStateService$p(this.this$0).observer((Function1<? super ChatSocketStateService.State, Unit>)((Function1)new Function1<ChatSocketStateService.State, Unit>(this.this$0, this.$socketListenerJob){
                            final /* synthetic */ ChatSocket this$0;
                            final /* synthetic */ Ref.ObjectRef<Job> $socketListenerJob;
                            {
                                this.this$0 = $receiver;
                                this.$socketListenerJob = $socketListenerJob;
                                super(1);
                            }

                            public final void invoke(@NotNull ChatSocketStateService.State state2) {
                                Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
                                ChatSocketStateService.State state3 = state2;
                                if (state3 instanceof ChatSocketStateService.State.RestartConnection) {
                                    SocketFactory.ConnectionConf connectionConf = ChatSocket.access$getConnectionConf$p(this.this$0);
                                    if (connectionConf != null) {
                                        SocketFactory.ConnectionConf connectionConf2 = connectionConf;
                                        ChatSocket chatSocket = this.this$0;
                                        SocketFactory.ConnectionConf it = connectionConf2;
                                        boolean bl = false;
                                        ChatSocket.access$getChatSocketStateService$p(chatSocket).onReconnect(it);
                                    }
                                } else if (state3 instanceof ChatSocketStateService.State.Connected) {
                                    ChatSocket.access$getHealthMonitor$p(this.this$0).ack();
                                    ChatSocket.access$callListeners(this.this$0, (Function1)new Function1<SocketListener, Unit>(state2){
                                        final /* synthetic */ ChatSocketStateService.State $state;
                                        {
                                            this.$state = $state;
                                            super(1);
                                        }

                                        public final void invoke(@NotNull SocketListener listener) {
                                            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
                                            listener.onConnected(((ChatSocketStateService.State.Connected)this.$state).getEvent());
                                        }
                                    });
                                } else if (state3 instanceof ChatSocketStateService.State.Connecting) {
                                    ChatSocket.access$callListeners(this.this$0, observeSocketStateService.3.INSTANCE);
                                    boolean bl = ((ChatSocketStateService.State.Connecting)state2).isReconnection();
                                    if (bl) {
                                        ChatSocket.access$observeSocketStateService$reconnect(this.this$0, this.$socketListenerJob, ((ChatSocketStateService.State.Connecting)state2).getConnectionConf().asReconnectionConf$stream_chat_android_client_release());
                                    } else if (!bl) {
                                        ChatSocket.access$observeSocketStateService$connectUser(this.this$0, this.$socketListenerJob, ((ChatSocketStateService.State.Connecting)state2).getConnectionConf());
                                    }
                                } else if (state3 instanceof ChatSocketStateService.State.Disconnected) {
                                    ChatSocketStateService.State.Disconnected disconnected = (ChatSocketStateService.State.Disconnected)state2;
                                    if (disconnected instanceof ChatSocketStateService.State.Disconnected.DisconnectedByRequest) {
                                        StreamWebSocket streamWebSocket = ChatSocket.access$getStreamWebSocket$p(this.this$0);
                                        if (streamWebSocket != null) {
                                            streamWebSocket.close();
                                        }
                                        ChatSocket.access$getHealthMonitor$p(this.this$0).stop();
                                        BuildersKt.launch$default((CoroutineScope)ChatSocket.access$getCoroutineScope$p(this.this$0), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                                            int label;
                                            final /* synthetic */ ChatSocket this$0;
                                            {
                                                this.this$0 = $receiver;
                                                super(2, $completion);
                                            }

                                            /*
                                             * WARNING - void declaration
                                             * Enabled force condition propagation
                                             * Lifted jumps to return sites
                                             */
                                            @Nullable
                                            public final Object invokeSuspend(@NotNull Object object) {
                                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        ResultKt.throwOnFailure((Object)object);
                                                        this.label = 1;
                                                        Object object3 = ChatSocket.access$disposeObservers(this.this$0, (Continuation)this);
                                                        if (object3 != object2) return Unit.INSTANCE;
                                                        return object2;
                                                    }
                                                    case 1: {
                                                        void $result;
                                                        ResultKt.throwOnFailure((Object)$result);
                                                        Object object3 = $result;
                                                        return Unit.INSTANCE;
                                                    }
                                                }
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            @NotNull
                                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                            }

                                            @Nullable
                                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                            }
                                        }), (int)3, null);
                                    } else if (disconnected instanceof ChatSocketStateService.State.Disconnected.NetworkDisconnected) {
                                        StreamWebSocket streamWebSocket = ChatSocket.access$getStreamWebSocket$p(this.this$0);
                                        if (streamWebSocket != null) {
                                            streamWebSocket.close();
                                        }
                                        ChatSocket.access$getHealthMonitor$p(this.this$0).stop();
                                    } else if (disconnected instanceof ChatSocketStateService.State.Disconnected.Stopped) {
                                        StreamWebSocket streamWebSocket = ChatSocket.access$getStreamWebSocket$p(this.this$0);
                                        if (streamWebSocket != null) {
                                            streamWebSocket.close();
                                        }
                                        ChatSocket.access$getHealthMonitor$p(this.this$0).stop();
                                        ChatSocket.access$disposeNetworkStateObserver(this.this$0);
                                    } else if (disconnected instanceof ChatSocketStateService.State.Disconnected.DisconnectedPermanently) {
                                        StreamWebSocket streamWebSocket = ChatSocket.access$getStreamWebSocket$p(this.this$0);
                                        if (streamWebSocket != null) {
                                            streamWebSocket.close();
                                        }
                                        ChatSocket.access$getHealthMonitor$p(this.this$0).stop();
                                        BuildersKt.launch$default((CoroutineScope)ChatSocket.access$getCoroutineScope$p(this.this$0), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                                            int label;
                                            final /* synthetic */ ChatSocket this$0;
                                            {
                                                this.this$0 = $receiver;
                                                super(2, $completion);
                                            }

                                            /*
                                             * WARNING - void declaration
                                             * Enabled force condition propagation
                                             * Lifted jumps to return sites
                                             */
                                            @Nullable
                                            public final Object invokeSuspend(@NotNull Object object) {
                                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        ResultKt.throwOnFailure((Object)object);
                                                        this.label = 1;
                                                        Object object3 = ChatSocket.access$disposeObservers(this.this$0, (Continuation)this);
                                                        if (object3 != object2) return Unit.INSTANCE;
                                                        return object2;
                                                    }
                                                    case 1: {
                                                        void $result;
                                                        ResultKt.throwOnFailure((Object)$result);
                                                        Object object3 = $result;
                                                        return Unit.INSTANCE;
                                                    }
                                                }
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            @NotNull
                                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                            }

                                            @Nullable
                                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                            }
                                        }), (int)3, null);
                                    } else if (disconnected instanceof ChatSocketStateService.State.Disconnected.DisconnectedTemporarily) {
                                        ChatSocket.access$getHealthMonitor$p(this.this$0).onDisconnected();
                                    } else if (disconnected instanceof ChatSocketStateService.State.Disconnected.WebSocketEventLost) {
                                        StreamWebSocket streamWebSocket = ChatSocket.access$getStreamWebSocket$p(this.this$0);
                                        if (streamWebSocket != null) {
                                            streamWebSocket.close();
                                        }
                                        SocketFactory.ConnectionConf connectionConf = ChatSocket.access$getConnectionConf$p(this.this$0);
                                        if (connectionConf != null) {
                                            SocketFactory.ConnectionConf connectionConf3 = connectionConf;
                                            ChatSocket chatSocket = this.this$0;
                                            SocketFactory.ConnectionConf it = connectionConf3;
                                            boolean bl = false;
                                            ChatSocket.access$getChatSocketStateService$p(chatSocket).onReconnect(it);
                                        }
                                    }
                                    ChatSocket.access$callListeners(this.this$0, (Function1)new Function1<SocketListener, Unit>(this.this$0, state2){
                                        final /* synthetic */ ChatSocket this$0;
                                        final /* synthetic */ ChatSocketStateService.State $state;
                                        {
                                            this.this$0 = $receiver;
                                            this.$state = $state;
                                            super(1);
                                        }

                                        public final void invoke(@NotNull SocketListener listener) {
                                            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
                                            listener.onDisconnected(ChatSocket.access$getCause(this.this$0, (ChatSocketStateService.State.Disconnected)this.$state));
                                        }
                                    });
                                }
                            }
                        }), (Continuation<? super Unit>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public final void connectUser(@NotNull User user, boolean isAnonymous) {
        SocketFactory.ConnectionConf connectionConf;
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Job job = this.socketStateObserverJob;
        if (job != null) {
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
        }
        this.socketStateObserverJob = this.observeSocketStateService();
        boolean bl = isAnonymous;
        if (bl) {
            connectionConf = new SocketFactory.ConnectionConf.AnonymousConnectionConf(this.wssUrl, this.apiKey, user);
        } else if (!bl) {
            connectionConf = new SocketFactory.ConnectionConf.UserConnectionConf(this.wssUrl, this.apiKey, user);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        this.chatSocketStateService.onConnect(connectionConf);
    }

    public final void disconnect() {
        this.connectionConf = null;
        this.chatSocketStateService.onRequiredDisconnect();
    }

    private final void handleEvent(ChatEvent chatEvent) {
        ChatEvent chatEvent2 = chatEvent;
        if (chatEvent2 instanceof ConnectedEvent) {
            this.chatSocketStateService.onConnectionEstablished((ConnectedEvent)chatEvent);
        } else if (chatEvent2 instanceof HealthEvent) {
            this.healthMonitor.ack();
        } else {
            this.callListeners((Function1<? super SocketListener, Unit>)((Function1)new Function1<SocketListener, Unit>(chatEvent){
                final /* synthetic */ ChatEvent $chatEvent;
                {
                    this.$chatEvent = $chatEvent;
                    super(1);
                }

                public final void invoke(@NotNull SocketListener listener) {
                    Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
                    listener.onEvent(this.$chatEvent);
                }
            }));
        }
    }

    /*
     * Unable to fully structure code
     */
    private final Object startObservers(Continuation<? super Unit> var1_1) {
        if (!(var1_1 instanceof startObservers.1)) ** GOTO lbl-1000
        var3_2 = var1_1;
        if ((var3_2.label & -2147483648) != 0) {
            var3_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ ChatSocket this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ChatSocket.access$startObservers(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var4_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = this.lifecycleObserver.observe(this.lifecycleHandler, (Continuation<? super Unit>)$continuation);
                if (v0 == var4_4) {
                    return var4_4;
                }
                ** GOTO lbl22
            }
            case 1: {
                this = (ChatSocket)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                this.networkStateProvider.subscribe(this.networkStateListener);
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object disposeObservers(Continuation<? super Unit> var1_1) {
        if (!(var1_1 instanceof disposeObservers.1)) ** GOTO lbl-1000
        var3_2 = var1_1;
        if ((var3_2.label & -2147483648) != 0) {
            var3_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ ChatSocket this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ChatSocket.access$disposeObservers(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var4_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = this.lifecycleObserver.dispose(this.lifecycleHandler, (Continuation<? super Unit>)$continuation);
                if (v0 == var4_4) {
                    return var4_4;
                }
                ** GOTO lbl22
            }
            case 1: {
                this = (ChatSocket)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                this.disposeNetworkStateObserver();
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void disposeNetworkStateObserver() {
        this.networkStateProvider.unsubscribe(this.networkStateListener);
    }

    private final void handleError(ChatError error) {
        TaggedLogger this_$iv = this.logger;
        boolean $i$f$e = false;
        if (this_$iv.getValidator().isLoggable(Priority.ERROR, this_$iv.getTag())) {
            String string2 = this_$iv.getTag();
            Priority priority = Priority.ERROR;
            StreamLogger streamLogger = this_$iv.getDelegate();
            boolean bl = false;
            String string3 = ResultUtilsKt.stringify(error);
            StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string3, null, (int)8, null);
        }
        if (error instanceof ChatNetworkError) {
            this.onChatNetworkError((ChatNetworkError)error);
        } else {
            this.callListeners((Function1<? super SocketListener, Unit>)((Function1)new Function1<SocketListener, Unit>(error){
                final /* synthetic */ ChatError $error;
                {
                    this.$error = $error;
                    super(1);
                }

                public final void invoke(@NotNull SocketListener it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    it.onError(this.$error);
                }
            }));
        }
    }

    private final void onChatNetworkError(ChatNetworkError error) {
        int n;
        if (ChatErrorCode.Companion.isAuthenticationError(error.getStreamCode())) {
            this.tokenManager.expireToken();
        }
        if ((((n = error.getStreamCode()) == ChatErrorCode.UNDEFINED_TOKEN.getCode() ? true : n == ChatErrorCode.INVALID_TOKEN.getCode()) ? true : n == ChatErrorCode.API_KEY_NOT_FOUND.getCode()) ? true : n == ChatErrorCode.VALIDATION_ERROR.getCode()) {
            TaggedLogger this_$iv = this.logger;
            boolean $i$f$d = false;
            if (this_$iv.getValidator().isLoggable(Priority.DEBUG, this_$iv.getTag())) {
                String string2 = this_$iv.getTag();
                Priority priority = Priority.DEBUG;
                StreamLogger streamLogger = this_$iv.getDelegate();
                boolean bl = false;
                String string3 = "One unrecoverable error happened. Error: " + ResultUtilsKt.stringify(error) + ". Error code: " + error.getStreamCode();
                StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string3, null, (int)8, null);
            }
            this.chatSocketStateService.onUnrecoverableError(error);
        } else {
            this.chatSocketStateService.onNetworkError(error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeListener(@NotNull SocketListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Set<SocketListener> set = this.listeners;
        synchronized (set) {
            boolean bl = false;
            boolean bl2 = this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addListener(@NotNull SocketListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Set<SocketListener> set = this.listeners;
        synchronized (set) {
            boolean bl = false;
            boolean bl2 = this.listeners.add(listener);
        }
    }

    public final boolean sendEvent$stream_chat_android_client_release(@NotNull ChatEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        StreamWebSocket streamWebSocket = this.streamWebSocket;
        return streamWebSocket != null ? streamWebSocket.send(event) : false;
    }

    public final boolean isConnected$stream_chat_android_client_release() {
        return this.chatSocketStateService.getCurrentState() instanceof ChatSocketStateService.State.Connected;
    }

    @Nullable
    public final Object awaitConnection$stream_chat_android_client_release(long timeoutInMillis, @NotNull Continuation<? super Unit> $completion) {
        ChatSocket this_$iv = this;
        boolean $i$f$awaitState$stream_chat_android_client_release = false;
        Object object = TimeoutKt.withTimeout((long)timeoutInMillis, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super ChatSocketStateService.State>, Object>(this_$iv, null){
            int label;
            final /* synthetic */ ChatSocket this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = FlowKt.first((Flow)((Flow)ChatSocket.access$getChatSocketStateService$p(this.this$0).getCurrentStateFlow()), (Function2)((Function2)new Function2<ChatSocketStateService.State, Continuation<? super Boolean>, Object>(null){
                            int label;
                            /* synthetic */ Object L$0;

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        ChatSocketStateService.State it = (ChatSocketStateService.State)this.L$0;
                                        return Boxing.boxBoolean((boolean)(it instanceof ChatSocketStateService.State.Connected));
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                Function2<ChatSocketStateService.State, Continuation<? super Boolean>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                function2.L$0 = value;
                                return (Continuation)function2;
                            }

                            @Nullable
                            public final Object invoke(@NotNull ChatSocketStateService.State p1, @Nullable Continuation<? super Boolean> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        Object object4 = object3;
                        if (object3 != object2) return object4;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object4 = $result;
                        return object4;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super ChatSocketStateService.State> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public static /* synthetic */ Object awaitConnection$stream_chat_android_client_release$default(ChatSocket chatSocket, long l, Continuation continuation, int n, Object object) {
        if ((n & 1) != 0) {
            l = 60000L;
        }
        return chatSocket.awaitConnection$stream_chat_android_client_release(l, (Continuation<? super Unit>)continuation);
    }

    public final /* synthetic */ <T extends ChatSocketStateService.State> Object awaitState$stream_chat_android_client_release(long timeoutInMillis, Continuation<? super Unit> $completion) {
        boolean $i$f$awaitState$stream_chat_android_client_release = false;
        Intrinsics.needClassReification();
        Function2 function2 = (Function2)new Function2<CoroutineScope, Continuation<? super ChatSocketStateService.State>, Object>(this, null){
            int label;
            final /* synthetic */ ChatSocket this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Flow flow = (Flow)ChatSocket.access$getChatSocketStateService$p(this.this$0).getCurrentStateFlow();
                        Intrinsics.needClassReification();
                        this.label = 1;
                        Object object3 = FlowKt.first((Flow)flow, (Function2)((Function2)new Function2<ChatSocketStateService.State, Continuation<? super Boolean>, Object>(null){
                            int label;
                            /* synthetic */ Object L$0;

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        ChatSocketStateService.State it = (ChatSocketStateService.State)this.L$0;
                                        Intrinsics.reifiedOperationMarker((int)3, (String)"T");
                                        return Boxing.boxBoolean((boolean)(it instanceof ChatSocketStateService.State));
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                Function2<ChatSocketStateService.State, Continuation<? super Boolean>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                function2.L$0 = value;
                                return (Continuation)function2;
                            }

                            @Nullable
                            public final Object invoke(@NotNull ChatSocketStateService.State p1, @Nullable Continuation<? super Boolean> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super ChatSocketStateService.State> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        };
        InlineMarker.mark((int)0);
        TimeoutKt.withTimeout((long)timeoutInMillis, (Function2)function2, $completion);
        InlineMarker.mark((int)1);
        return Unit.INSTANCE;
    }

    @NotNull
    public final String connectionIdOrError$stream_chat_android_client_release() {
        ChatSocketStateService.State state2 = this.chatSocketStateService.getCurrentState();
        if (!(state2 instanceof ChatSocketStateService.State.Connected)) {
            throw new IllegalStateException("This state doesn't contain connectionId".toString());
        }
        return ((ChatSocketStateService.State.Connected)state2).getEvent().getConnectionId();
    }

    public final void reconnectUser(@NotNull User user, boolean isAnonymous) {
        SocketFactory.ConnectionConf connectionConf;
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        boolean bl = isAnonymous;
        if (bl) {
            connectionConf = new SocketFactory.ConnectionConf.AnonymousConnectionConf(this.wssUrl, this.apiKey, user);
        } else if (!bl) {
            connectionConf = new SocketFactory.ConnectionConf.UserConnectionConf(this.wssUrl, this.apiKey, user);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        this.chatSocketStateService.onReconnect(connectionConf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void callListeners(Function1<? super SocketListener, Unit> call) {
        Set<SocketListener> set = this.listeners;
        synchronized (set) {
            boolean bl = false;
            Iterable $this$forEach$iv = this.listeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SocketListener listener = (SocketListener)element$iv;
                boolean bl2 = false;
                BuildersKt.launch$default((CoroutineScope)this.coroutineScope, (CoroutineContext)((CoroutineContext)DispatcherProvider.INSTANCE.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(call, listener, null){
                    int label;
                    final /* synthetic */ Function1<SocketListener, Unit> $call;
                    final /* synthetic */ SocketListener $listener;
                    {
                        this.$call = $call;
                        this.$listener = $listener;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.$call.invoke((Object)this.$listener);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final DisconnectCause getCause(ChatSocketStateService.State.Disconnected $this$cause) {
        DisconnectCause disconnectCause;
        ChatSocketStateService.State.Disconnected disconnected = $this$cause;
        if (disconnected instanceof ChatSocketStateService.State.Disconnected.DisconnectedByRequest ? true : disconnected instanceof ChatSocketStateService.State.Disconnected.Stopped) {
            disconnectCause = DisconnectCause.ConnectionReleased.INSTANCE;
        } else if (disconnected instanceof ChatSocketStateService.State.Disconnected.NetworkDisconnected) {
            disconnectCause = DisconnectCause.NetworkNotAvailable.INSTANCE;
        } else if (disconnected instanceof ChatSocketStateService.State.Disconnected.DisconnectedPermanently) {
            disconnectCause = new DisconnectCause.UnrecoverableError(((ChatSocketStateService.State.Disconnected.DisconnectedPermanently)$this$cause).getError());
        } else if (disconnected instanceof ChatSocketStateService.State.Disconnected.DisconnectedTemporarily) {
            disconnectCause = new DisconnectCause.Error(((ChatSocketStateService.State.Disconnected.DisconnectedTemporarily)$this$cause).getError());
        } else if (disconnected instanceof ChatSocketStateService.State.Disconnected.WebSocketEventLost) {
            disconnectCause = DisconnectCause.WebSocketNotAvailable.INSTANCE;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return disconnectCause;
    }

    /*
     * WARNING - void declaration
     */
    private static final void observeSocketStateService$connectUser(ChatSocket this$0, Ref.ObjectRef<Job> socketListenerJob, SocketFactory.ConnectionConf connectionConf) {
        BuildersKt.launch$default((CoroutineScope)this$0.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, null){
            int label;
            final /* synthetic */ ChatSocket this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = ChatSocket.access$startObservers(this.this$0, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        this$0.connectionConf = connectionConf;
        Job job = (Job)socketListenerJob.element;
        if (job != null) {
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
        }
        boolean bl = this$0.networkStateProvider.isConnected();
        if (bl) {
            void $this$observeSocketStateService_u24connectUser_u24lambda_u2d0;
            StreamWebSocket streamWebSocket;
            StreamWebSocket streamWebSocket2 = streamWebSocket = this$0.socketFactory.createSocket(connectionConf);
            ChatSocket chatSocket = this$0;
            boolean bl2 = false;
            socketListenerJob.element = FlowKt.launchIn((Flow)FlowKt.onEach($this$observeSocketStateService_u24connectUser_u24lambda_u2d0.listen(), (Function2)((Function2)new Function2<StreamWebSocketEvent, Continuation<? super Unit>, Object>(this$0, null){
                int label;
                /* synthetic */ Object L$0;
                final /* synthetic */ ChatSocket this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            StreamWebSocketEvent it;
                            ResultKt.throwOnFailure((Object)object);
                            StreamWebSocketEvent streamWebSocketEvent = it = (StreamWebSocketEvent)this.L$0;
                            if (streamWebSocketEvent instanceof StreamWebSocketEvent.Error) {
                                ChatSocket.access$handleError(this.this$0, ((StreamWebSocketEvent.Error)it).getChatError());
                            } else if (streamWebSocketEvent instanceof StreamWebSocketEvent.Message) {
                                ChatSocket.access$handleEvent(this.this$0, ((StreamWebSocketEvent.Message)it).getChatEvent());
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    Function2<StreamWebSocketEvent, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    function2.L$0 = value;
                    return (Continuation)function2;
                }

                @Nullable
                public final Object invoke(@NotNull StreamWebSocketEvent p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            })), (CoroutineScope)this$0.coroutineScope);
            chatSocket.streamWebSocket = streamWebSocket;
        } else if (!bl) {
            this$0.chatSocketStateService.onNetworkNotAvailable();
        }
    }

    private static final void observeSocketStateService$reconnect(ChatSocket this$0, Ref.ObjectRef<Job> socketListenerJob, SocketFactory.ConnectionConf connectionConf) {
        ChatSocket.observeSocketStateService$connectUser(this$0, socketListenerJob, connectionConf.asReconnectionConf$stream_chat_android_client_release());
    }

    public static final /* synthetic */ ChatSocketStateService access$getChatSocketStateService$p(ChatSocket $this) {
        return $this.chatSocketStateService;
    }

    public static final /* synthetic */ SocketFactory.ConnectionConf access$getConnectionConf$p(ChatSocket $this) {
        return $this.connectionConf;
    }

    public static final /* synthetic */ HealthMonitor access$getHealthMonitor$p(ChatSocket $this) {
        return $this.healthMonitor;
    }

    public static final /* synthetic */ void access$callListeners(ChatSocket $this, Function1 call) {
        $this.callListeners((Function1<? super SocketListener, Unit>)call);
    }

    public static final /* synthetic */ void access$observeSocketStateService$reconnect(ChatSocket this$0, Ref.ObjectRef socketListenerJob, SocketFactory.ConnectionConf connectionConf) {
        ChatSocket.observeSocketStateService$reconnect(this$0, (Ref.ObjectRef<Job>)socketListenerJob, connectionConf);
    }

    public static final /* synthetic */ void access$observeSocketStateService$connectUser(ChatSocket this$0, Ref.ObjectRef socketListenerJob, SocketFactory.ConnectionConf connectionConf) {
        ChatSocket.observeSocketStateService$connectUser(this$0, (Ref.ObjectRef<Job>)socketListenerJob, connectionConf);
    }

    public static final /* synthetic */ StreamWebSocket access$getStreamWebSocket$p(ChatSocket $this) {
        return $this.streamWebSocket;
    }

    public static final /* synthetic */ UserScope access$getCoroutineScope$p(ChatSocket $this) {
        return $this.coroutineScope;
    }

    public static final /* synthetic */ Object access$disposeObservers(ChatSocket $this, Continuation $completion) {
        return $this.disposeObservers((Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ void access$disposeNetworkStateObserver(ChatSocket $this) {
        $this.disposeNetworkStateObserver();
    }

    public static final /* synthetic */ DisconnectCause access$getCause(ChatSocket $this, ChatSocketStateService.State.Disconnected $receiver) {
        return $this.getCause($receiver);
    }

    public static final /* synthetic */ Object access$startObservers(ChatSocket $this, Continuation $completion) {
        return $this.startObservers((Continuation<? super Unit>)$completion);
    }

    public /* synthetic */ ChatSocket(String apiKey, String wssUrl, TokenManager tokenManager, SocketFactory socketFactory, UserScope coroutineScope, StreamLifecycleObserver lifecycleObserver2, NetworkStateProvider networkStateProvider2, DefaultConstructorMarker $constructor_marker) {
        this(apiKey, wssUrl, tokenManager, socketFactory, coroutineScope, lifecycleObserver2, networkStateProvider2);
    }

    public static final /* synthetic */ void access$handleError(ChatSocket $this, ChatError error) {
        $this.handleError(error);
    }

    public static final /* synthetic */ void access$handleEvent(ChatSocket $this, ChatEvent chatEvent) {
        $this.handleEvent(chatEvent);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lio/getstream/chat/android/client/socket/experimental/ChatSocket$Companion;", "", "()V", "DEFAULT_CONNECTION_TIMEOUT", "", "create", "Lio/getstream/chat/android/client/socket/experimental/ChatSocket;", "apiKey", "", "wssUrl", "tokenManager", "Lio/getstream/chat/android/client/token/TokenManager;", "socketFactory", "Lio/getstream/chat/android/client/socket/SocketFactory;", "coroutineScope", "Lio/getstream/chat/android/client/scope/UserScope;", "lifecycleObserver", "Lio/getstream/chat/android/client/StreamLifecycleObserver;", "networkStateProvider", "Lio/getstream/chat/android/client/network/NetworkStateProvider;", "stream-chat-android-client_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ChatSocket create(@NotNull String apiKey, @NotNull String wssUrl, @NotNull TokenManager tokenManager, @NotNull SocketFactory socketFactory, @NotNull UserScope coroutineScope, @NotNull StreamLifecycleObserver lifecycleObserver2, @NotNull NetworkStateProvider networkStateProvider2) {
            Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
            Intrinsics.checkNotNullParameter((Object)wssUrl, (String)"wssUrl");
            Intrinsics.checkNotNullParameter((Object)tokenManager, (String)"tokenManager");
            Intrinsics.checkNotNullParameter((Object)socketFactory, (String)"socketFactory");
            Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
            Intrinsics.checkNotNullParameter((Object)lifecycleObserver2, (String)"lifecycleObserver");
            Intrinsics.checkNotNullParameter((Object)networkStateProvider2, (String)"networkStateProvider");
            return new ChatSocket(apiKey, wssUrl, tokenManager, socketFactory, coroutineScope, lifecycleObserver2, networkStateProvider2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

