/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.client.network;

import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.NetworkRequest;
import android.os.Build;
import io.getstream.chat.android.client.network.NetworkStateProvider;
import io.getstream.logging.Priority;
import io.getstream.logging.StreamLog;
import io.getstream.logging.StreamLogger;
import io.getstream.logging.TaggedLogger;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000?\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005*\u0001\u0006\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\b\u001a\u00020\tJ\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u000e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u000eJ\u000e\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u000eR\u0010\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lio/getstream/chat/android/client/network/NetworkStateProvider;", "", "connectivityManager", "Landroid/net/ConnectivityManager;", "(Landroid/net/ConnectivityManager;)V", "callback", "io/getstream/chat/android/client/network/NetworkStateProvider$callback$1", "Lio/getstream/chat/android/client/network/NetworkStateProvider$callback$1;", "isConnected", "", "isRegistered", "Ljava/util/concurrent/atomic/AtomicBoolean;", "listeners", "", "Lio/getstream/chat/android/client/network/NetworkStateProvider$NetworkStateListener;", "lock", "logger", "Lio/getstream/logging/TaggedLogger;", "notifyListenersIfNetworkStateChanged", "", "subscribe", "listener", "unsubscribe", "NetworkStateListener", "stream-chat-android-client_release"})
public final class NetworkStateProvider {
    @NotNull
    private final ConnectivityManager connectivityManager;
    @NotNull
    private final TaggedLogger logger;
    @NotNull
    private final Object lock;
    @NotNull
    private final callback.1 callback;
    private volatile boolean isConnected;
    @NotNull
    private volatile Set<? extends NetworkStateListener> listeners;
    @NotNull
    private final AtomicBoolean isRegistered;

    public NetworkStateProvider(@NotNull ConnectivityManager connectivityManager) {
        Intrinsics.checkNotNullParameter((Object)connectivityManager, (String)"connectivityManager");
        this.connectivityManager = connectivityManager;
        this.logger = StreamLog.getLogger((String)"Chat:NetworkStateProvider");
        this.lock = new Object();
        this.callback = new ConnectivityManager.NetworkCallback(this){
            final /* synthetic */ NetworkStateProvider this$0;
            {
                this.this$0 = $receiver;
            }

            public void onAvailable(@NotNull Network network) {
                Intrinsics.checkNotNullParameter((Object)network, (String)"network");
                NetworkStateProvider.access$notifyListenersIfNetworkStateChanged(this.this$0);
            }

            public void onCapabilitiesChanged(@NotNull Network network, @NotNull NetworkCapabilities networkCapabilities) {
                Intrinsics.checkNotNullParameter((Object)network, (String)"network");
                Intrinsics.checkNotNullParameter((Object)networkCapabilities, (String)"networkCapabilities");
                NetworkStateProvider.access$notifyListenersIfNetworkStateChanged(this.this$0);
            }

            public void onLost(@NotNull Network network) {
                Intrinsics.checkNotNullParameter((Object)network, (String)"network");
                NetworkStateProvider.access$notifyListenersIfNetworkStateChanged(this.this$0);
            }
        };
        this.isConnected = this.isConnected();
        this.listeners = SetsKt.emptySet();
        this.isRegistered = new AtomicBoolean(false);
    }

    private final void notifyListenersIfNetworkStateChanged() {
        block5: {
            boolean isNowConnected;
            block4: {
                isNowConnected = this.isConnected();
                if (this.isConnected || !isNowConnected) break block4;
                TaggedLogger this_$iv = this.logger;
                boolean $i$f$i = false;
                if (this_$iv.getValidator().isLoggable(Priority.INFO, this_$iv.getTag())) {
                    String string = this_$iv.getTag();
                    Priority priority = Priority.INFO;
                    StreamLogger streamLogger = this_$iv.getDelegate();
                    boolean bl = false;
                    String string2 = "Network connected.";
                    StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string, (String)string2, null, (int)8, null);
                }
                this.isConnected = true;
                Iterable $this$forEach$iv = this.listeners;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    NetworkStateListener it = (NetworkStateListener)element$iv;
                    boolean bl = false;
                    it.onConnected();
                }
                break block5;
            }
            if (!this.isConnected || isNowConnected) break block5;
            TaggedLogger this_$iv = this.logger;
            boolean $i$f$i = false;
            if (this_$iv.getValidator().isLoggable(Priority.INFO, this_$iv.getTag())) {
                String string = this_$iv.getTag();
                Priority priority = Priority.INFO;
                StreamLogger streamLogger = this_$iv.getDelegate();
                boolean bl = false;
                String string3 = "Network disconnected.";
                StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string, (String)string3, null, (int)8, null);
            }
            this.isConnected = false;
            Iterable $this$forEach$iv = this.listeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                NetworkStateListener it = (NetworkStateListener)element$iv;
                boolean bl = false;
                it.onDisconnected();
            }
        }
    }

    public final boolean isConnected() {
        boolean bl;
        if (Build.VERSION.SDK_INT >= 23) {
            Object object;
            Object object2 = this;
            try {
                Boolean bl2;
                NetworkStateProvider $this$isConnected_u24lambda_u2d6 = object2;
                boolean bl3 = false;
                ConnectivityManager $this$isConnected_u24lambda_u2d6_u24lambda_u2d5 = $this$isConnected_u24lambda_u2d6.connectivityManager;
                boolean bl4 = false;
                NetworkCapabilities networkCapabilities = $this$isConnected_u24lambda_u2d6_u24lambda_u2d5.getNetworkCapabilities($this$isConnected_u24lambda_u2d6_u24lambda_u2d5.getActiveNetwork());
                if (networkCapabilities != null) {
                    NetworkCapabilities $this$isConnected_u24lambda_u2d6_u24lambda_u2d5_u24lambda_u2d4 = networkCapabilities;
                    boolean bl5 = false;
                    bl2 = $this$isConnected_u24lambda_u2d6_u24lambda_u2d5_u24lambda_u2d4.hasCapability(12) && $this$isConnected_u24lambda_u2d6_u24lambda_u2d5_u24lambda_u2d4.hasCapability(16);
                } else {
                    bl2 = null;
                }
                object = Result.constructor-impl(bl2);
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            object2 = object;
            Boolean bl6 = (Boolean)(Result.isFailure-impl((Object)object2) ? null : object2);
            bl = bl6 != null ? bl6 : false;
        } else {
            NetworkInfo networkInfo = this.connectivityManager.getActiveNetworkInfo();
            bl = networkInfo != null ? networkInfo.isConnected() : false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void subscribe(@NotNull NetworkStateListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.listeners = SetsKt.plus(this.listeners, (Object)listener);
            if (this.isRegistered.compareAndSet(false, true)) {
                this.connectivityManager.registerNetworkCallback(new NetworkRequest.Builder().build(), (ConnectivityManager.NetworkCallback)this.callback);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void unsubscribe(@NotNull NetworkStateListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Object object = this.lock;
        synchronized (object) {
            void it;
            Set set;
            boolean bl = false;
            Set set2 = set = SetsKt.minus(this.listeners, (Object)listener);
            NetworkStateProvider networkStateProvider2 = this;
            boolean bl2 = false;
            if (it.isEmpty() && this.isRegistered.compareAndSet(true, false)) {
                this.connectivityManager.unregisterNetworkCallback((ConnectivityManager.NetworkCallback)this.callback);
            }
            networkStateProvider2.listeners = set;
            Unit unit = Unit.INSTANCE;
        }
    }

    public static final /* synthetic */ void access$notifyListenersIfNetworkStateChanged(NetworkStateProvider $this) {
        $this.notifyListenersIfNetworkStateChanged();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\b\u0010\u0004\u001a\u00020\u0003H&\u00a8\u0006\u0005"}, d2={"Lio/getstream/chat/android/client/network/NetworkStateProvider$NetworkStateListener;", "", "onConnected", "", "onDisconnected", "stream-chat-android-client_release"})
    public static interface NetworkStateListener {
        public void onConnected();

        public void onDisconnected();
    }
}

