/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.client.api.interceptor;

import io.getstream.chat.android.core.internal.StreamHandsOff;
import io.getstream.logging.Priority;
import io.getstream.logging.SilentStreamLogger;
import io.getstream.logging.StreamLog;
import io.getstream.logging.StreamLogger;
import io.getstream.logging.TaggedLogger;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import okhttp3.Connection;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.http.HttpHeaders;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.GzipSource;
import okio.Source;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0003J\f\u0010\u0013\u001a\u00020\u0006*\u00020\u0010H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lio/getstream/chat/android/client/api/interceptor/HttpLoggingInterceptor;", "Lokhttp3/Interceptor;", "()V", "logger", "Lio/getstream/logging/TaggedLogger;", "bodyHasUnknownEncoding", "", "headers", "Lokhttp3/Headers;", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "logRequestBody", "", "buffer", "Lokio/Buffer;", "charset", "Ljava/nio/charset/Charset;", "isProbablyUtf8", "stream-chat-android-client_release"})
public final class HttpLoggingInterceptor
implements Interceptor {
    @NotNull
    private final TaggedLogger logger = StreamLog.getLogger((String)"Chat:Http");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        Object object;
        String string;
        StreamLogger streamLogger;
        Priority priority;
        String string2;
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Request request = chain.request();
        boolean $i$f$inspect = false;
        StreamLogger it = StreamLog.INSTANCE.getInternalLogger();
        boolean bl = false;
        boolean noLoggerSet = it instanceof SilentStreamLogger;
        if (noLoggerSet) {
            return chain.proceed(request);
        }
        RequestBody requestBody = request.body();
        Connection connection = chain.connection();
        String requestStartMessage = null;
        requestStartMessage = "--> " + request.method() + ' ' + request.url() + (connection != null ? "" + ' ' + connection.protocol() : "");
        if (requestBody != null) {
            requestStartMessage = requestStartMessage + " (" + requestBody.contentLength() + "-byte body)";
        }
        TaggedLogger this_$iv = this.logger;
        boolean $i$f$i = false;
        if (this_$iv.getValidator().isLoggable(Priority.INFO, this_$iv.getTag())) {
            string2 = this_$iv.getTag();
            priority = Priority.INFO;
            streamLogger = this_$iv.getDelegate();
            boolean bl2 = false;
            string = requestStartMessage;
            StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string, null, (int)8, null);
        }
        if (requestBody == null) {
            this_$iv = this.logger;
            $i$f$i = false;
            if (this_$iv.getValidator().isLoggable(Priority.INFO, this_$iv.getTag())) {
                string2 = this_$iv.getTag();
                priority = Priority.INFO;
                streamLogger = this_$iv.getDelegate();
                boolean bl3 = false;
                string = "--> END " + request.method();
                StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string, null, (int)8, null);
            }
        } else if (this.bodyHasUnknownEncoding(request.headers())) {
            this_$iv = this.logger;
            $i$f$i = false;
            if (this_$iv.getValidator().isLoggable(Priority.INFO, this_$iv.getTag())) {
                string2 = this_$iv.getTag();
                priority = Priority.INFO;
                streamLogger = this_$iv.getDelegate();
                boolean bl4 = false;
                string = "--> END " + request.method() + " (encoded body omitted)";
                StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string, null, (int)8, null);
            }
        } else if (requestBody.isDuplex()) {
            this_$iv = this.logger;
            $i$f$i = false;
            if (this_$iv.getValidator().isLoggable(Priority.INFO, this_$iv.getTag())) {
                string2 = this_$iv.getTag();
                priority = Priority.INFO;
                streamLogger = this_$iv.getDelegate();
                boolean bl5 = false;
                string = "--> END " + request.method() + " (duplex request body omitted)";
                StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string, null, (int)8, null);
            }
        } else if (requestBody.isOneShot()) {
            this_$iv = this.logger;
            $i$f$i = false;
            if (this_$iv.getValidator().isLoggable(Priority.INFO, this_$iv.getTag())) {
                string2 = this_$iv.getTag();
                priority = Priority.INFO;
                streamLogger = this_$iv.getDelegate();
                boolean bl6 = false;
                string = "--> END " + request.method() + " (one-shot body omitted)";
                StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string, null, (int)8, null);
            }
        } else {
            Buffer buffer = new Buffer();
            requestBody.writeTo((BufferedSink)buffer);
            MediaType contentType = requestBody.contentType();
            Object object2 = contentType;
            if (object2 == null || (object2 = object2.charset(StandardCharsets.UTF_8)) == null) {
                Charset charset = StandardCharsets.UTF_8;
                object2 = charset;
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            }
            Object charset = object2;
            TaggedLogger this_$iv2 = this.logger;
            boolean $i$f$i2 = false;
            if (this_$iv2.getValidator().isLoggable(Priority.INFO, this_$iv2.getTag())) {
                string2 = this_$iv2.getTag();
                priority = Priority.INFO;
                streamLogger = this_$iv2.getDelegate();
                boolean bl7 = false;
                string = "";
                StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string, null, (int)8, null);
            }
            if (this.isProbablyUtf8(buffer)) {
                this.logRequestBody(buffer, (Charset)charset);
                this_$iv2 = this.logger;
                $i$f$i2 = false;
                if (this_$iv2.getValidator().isLoggable(Priority.INFO, this_$iv2.getTag())) {
                    string2 = this_$iv2.getTag();
                    priority = Priority.INFO;
                    streamLogger = this_$iv2.getDelegate();
                    boolean bl8 = false;
                    string = "--> END " + request.method() + " (" + requestBody.contentLength() + "-byte body)";
                    StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string, null, (int)8, null);
                }
            } else {
                this_$iv2 = this.logger;
                $i$f$i2 = false;
                if (this_$iv2.getValidator().isLoggable(Priority.INFO, this_$iv2.getTag())) {
                    string2 = this_$iv2.getTag();
                    priority = Priority.INFO;
                    streamLogger = this_$iv2.getDelegate();
                    boolean bl9 = false;
                    string = "--> END " + request.method() + " (binary " + requestBody.contentLength() + "-byte body omitted)";
                    StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string, null, (int)8, null);
                }
            }
        }
        long startNs = System.nanoTime();
        Response response = null;
        try {
            response = chain.proceed(request);
        }
        catch (Exception e) {
            TaggedLogger this_$iv3 = this.logger;
            boolean $i$f$i3 = false;
            if (this_$iv3.getValidator().isLoggable(Priority.INFO, this_$iv3.getTag())) {
                string2 = this_$iv3.getTag();
                priority = Priority.INFO;
                streamLogger = this_$iv3.getDelegate();
                boolean bl10 = false;
                string = "<-- HTTP FAILED: " + e;
                StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string, null, (int)8, null);
            }
            throw e;
        }
        long tookMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNs);
        ResponseBody responseBody = response.body();
        Intrinsics.checkNotNull((Object)responseBody);
        ResponseBody responseBody2 = responseBody;
        long contentLength = responseBody2.contentLength();
        String bodySize = contentLength != -1L ? contentLength + "-byte" : "unknown-length";
        TaggedLogger this_$iv4 = this.logger;
        boolean $i$f$i4 = false;
        if (this_$iv4.getValidator().isLoggable(Priority.INFO, this_$iv4.getTag())) {
            String string3;
            string2 = this_$iv4.getTag();
            priority = Priority.INFO;
            streamLogger = this_$iv4.getDelegate();
            boolean bl11 = false;
            StringBuilder stringBuilder = new StringBuilder().append("<-- ").append(response.code());
            if (((CharSequence)response.message()).length() == 0) {
                string3 = "";
            } else {
                char c = ' ';
                object = response.message();
                string3 = c + (String)object;
            }
            string = stringBuilder.append(string3).append(' ').append(response.request().url()).append(" (").append(tookMs).append("ms, ").append(bodySize).append(" body)").toString();
            StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string, null, (int)8, null);
        }
        if (!HttpHeaders.promisesBody((Response)response)) {
            this_$iv4 = this.logger;
            $i$f$i4 = false;
            if (this_$iv4.getValidator().isLoggable(Priority.INFO, this_$iv4.getTag())) {
                string2 = this_$iv4.getTag();
                priority = Priority.INFO;
                streamLogger = this_$iv4.getDelegate();
                boolean bl12 = false;
                string = "<-- END HTTP";
                StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string, null, (int)8, null);
            }
        } else if (this.bodyHasUnknownEncoding(response.headers())) {
            this_$iv4 = this.logger;
            $i$f$i4 = false;
            if (this_$iv4.getValidator().isLoggable(Priority.INFO, this_$iv4.getTag())) {
                string2 = this_$iv4.getTag();
                priority = Priority.INFO;
                streamLogger = this_$iv4.getDelegate();
                boolean bl13 = false;
                string = "<-- END HTTP (encoded body omitted)";
                StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string, null, (int)8, null);
            }
        } else {
            BufferedSource source = responseBody2.source();
            source.request(Long.MAX_VALUE);
            Buffer buffer = null;
            buffer = source.getBuffer();
            Long gzippedLength = null;
            if (StringsKt.equals((String)response.headers().get("Content-Encoding"), (String)"gzip", (boolean)true)) {
                gzippedLength = buffer.size();
                Closeable closeable = (Closeable)new GzipSource((Source)buffer.clone());
                object = null;
                try {
                    GzipSource gzippedResponseBody22 = (GzipSource)closeable;
                    boolean bl14 = false;
                    buffer = new Buffer();
                    long gzippedResponseBody22 = buffer.writeAll((Source)gzippedResponseBody22);
                }
                catch (Throwable gzippedResponseBody22) {
                    object = gzippedResponseBody22;
                    throw gzippedResponseBody22;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
                }
            }
            if (!this.isProbablyUtf8(buffer)) {
                TaggedLogger this_$iv5 = this.logger;
                boolean $i$f$i5 = false;
                if (this_$iv5.getValidator().isLoggable(Priority.INFO, this_$iv5.getTag())) {
                    string2 = this_$iv5.getTag();
                    priority = Priority.INFO;
                    streamLogger = this_$iv5.getDelegate();
                    boolean bl15 = false;
                    string = "";
                    StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string, null, (int)8, null);
                }
                this_$iv5 = this.logger;
                $i$f$i5 = false;
                if (this_$iv5.getValidator().isLoggable(Priority.INFO, this_$iv5.getTag())) {
                    string2 = this_$iv5.getTag();
                    priority = Priority.INFO;
                    streamLogger = this_$iv5.getDelegate();
                    boolean bl16 = false;
                    string = "<-- END HTTP (binary " + buffer.size() + "-byte body omitted)";
                    StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string, null, (int)8, null);
                }
                return response;
            }
            if (gzippedLength != null) {
                TaggedLogger this_$iv6 = this.logger;
                boolean $i$f$i6 = false;
                if (this_$iv6.getValidator().isLoggable(Priority.INFO, this_$iv6.getTag())) {
                    string2 = this_$iv6.getTag();
                    priority = Priority.INFO;
                    streamLogger = this_$iv6.getDelegate();
                    boolean bl17 = false;
                    string = "<-- END HTTP (" + buffer.size() + "-byte, " + gzippedLength + "-gzipped-byte body omitted)";
                    StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string, null, (int)8, null);
                }
            } else {
                TaggedLogger this_$iv7 = this.logger;
                boolean $i$f$i7 = false;
                if (this_$iv7.getValidator().isLoggable(Priority.INFO, this_$iv7.getTag())) {
                    string2 = this_$iv7.getTag();
                    priority = Priority.INFO;
                    streamLogger = this_$iv7.getDelegate();
                    boolean bl18 = false;
                    string = "<-- END HTTP (" + buffer.size() + "-byte body omitted)";
                    StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string, null, (int)8, null);
                }
            }
        }
        return response;
    }

    @StreamHandsOff(reason="Request body shouldn't be log entirely as it might produce OutOfMemory exceptions when sending big files. The log will be limited to 1048576 bytes.")
    private final void logRequestBody(Buffer buffer, Charset charset) {
        TaggedLogger this_$iv = this.logger;
        boolean $i$f$i = false;
        if (this_$iv.getValidator().isLoggable(Priority.INFO, this_$iv.getTag())) {
            String string = this_$iv.getTag();
            Priority priority = Priority.INFO;
            StreamLogger streamLogger = this_$iv.getDelegate();
            boolean bl = false;
            String string2 = buffer.readString(Math.min(buffer.size(), 0x100000L), charset);
            StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string, (String)string2, null, (int)8, null);
        }
    }

    private final boolean bodyHasUnknownEncoding(Headers headers) {
        String string = headers.get("Content-Encoding");
        if (string == null) {
            return false;
        }
        String contentEncoding = string;
        return !StringsKt.equals((String)contentEncoding, (String)"identity", (boolean)true) && !StringsKt.equals((String)contentEncoding, (String)"gzip", (boolean)true);
    }

    private final boolean isProbablyUtf8(Buffer $this$isProbablyUtf8) {
        try {
            Buffer prefix = new Buffer();
            long byteCount = RangesKt.coerceAtMost((long)$this$isProbablyUtf8.size(), (long)64L);
            $this$isProbablyUtf8.copyTo(prefix, 0L, byteCount);
            for (int i = 0; i < 16 && !prefix.exhausted(); ++i) {
                int codePoint = prefix.readUtf8CodePoint();
                if (!Character.isISOControl(codePoint) || Character.isWhitespace(codePoint)) continue;
                return false;
            }
            return true;
        }
        catch (EOFException _) {
            return false;
        }
    }
}

