/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.client.interceptor.message.internal;

import io.getstream.chat.android.client.extensions.AttachmentExtensionsKt;
import io.getstream.chat.android.client.extensions.MessageExtensionsKt;
import io.getstream.chat.android.client.interceptor.message.PrepareMessageLogic;
import io.getstream.chat.android.client.models.Attachment;
import io.getstream.chat.android.client.models.Message;
import io.getstream.chat.android.client.models.User;
import io.getstream.chat.android.client.setup.state.ClientState;
import io.getstream.chat.android.client.utils.SyncStatus;
import io.getstream.chat.android.client.utils.internal.MessageUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J\b\u0010\b\u001a\u00020\u0006H\u0002J(\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lio/getstream/chat/android/client/interceptor/message/internal/PrepareMessageLogicImpl;", "Lio/getstream/chat/android/client/interceptor/message/PrepareMessageLogic;", "clientState", "Lio/getstream/chat/android/client/setup/state/ClientState;", "(Lio/getstream/chat/android/client/setup/state/ClientState;)V", "generateMessageId", "", "userId", "generateUploadId", "prepareMessage", "Lio/getstream/chat/android/client/models/Message;", "message", "channelId", "channelType", "user", "Lio/getstream/chat/android/client/models/User;", "stream-chat-android-client_release"})
public final class PrepareMessageLogicImpl
implements PrepareMessageLogic {
    @NotNull
    private final ClientState clientState;

    public PrepareMessageLogicImpl(@NotNull ClientState clientState) {
        Intrinsics.checkNotNullParameter((Object)clientState, (String)"clientState");
        this.clientState = clientState;
    }

    @Override
    @NotNull
    public Message prepareMessage(@NotNull Message message, @NotNull String channelId, @NotNull String channelType, @NotNull User user) {
        Attachment attachment;
        Message message2;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)channelType, (String)"channelType");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Message $this$prepareMessage_u24lambda_u2d3 = message2 = Message.copy$default(message, null, null, null, null, null, null, null, null, null, 0, null, null, null, null, null, null, null, null, null, null, null, null, null, null, false, false, null, false, null, null, null, false, null, null, null, null, -1, 15, null);
        boolean bl = false;
        if (((CharSequence)$this$prepareMessage_u24lambda_u2d3.getId()).length() == 0) {
            $this$prepareMessage_u24lambda_u2d3.setId(this.generateMessageId(user.getId()));
        }
        if (((CharSequence)$this$prepareMessage_u24lambda_u2d3.getCid()).length() == 0) {
            MessageExtensionsKt.enrichWithCid($this$prepareMessage_u24lambda_u2d3, channelType + ':' + channelId);
        }
        $this$prepareMessage_u24lambda_u2d3.setUser(user);
        Iterable $this$partition$iv = $this$prepareMessage_u24lambda_u2d3.getAttachments();
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            Attachment it = (Attachment)element$iv;
            boolean bl2 = false;
            if (it.getUpload() != null) {
                first$iv.add(element$iv);
                continue;
            }
            second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List attachmentsToUpload = (List)pair.component1();
        List nonFileAttachments = (List)pair.component2();
        Iterable $this$forEach$iv = attachmentsToUpload;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            attachment = (Attachment)element$iv;
            boolean bl3 = false;
            if (AttachmentExtensionsKt.getUploadId(attachment) == null) {
                AttachmentExtensionsKt.setUploadId(attachment, this.generateUploadId());
            }
            attachment.setUploadState(Attachment.UploadState.Idle.INSTANCE);
        }
        $this$forEach$iv = nonFileAttachments;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            attachment = (Attachment)element$iv;
            boolean bl4 = false;
            attachment.setUploadState(Attachment.UploadState.Success.INSTANCE);
        }
        $this$prepareMessage_u24lambda_u2d3.setType(MessageUtilsKt.getMessageType(message));
        Date date = $this$prepareMessage_u24lambda_u2d3.getCreatedAt();
        if (date == null && (date = $this$prepareMessage_u24lambda_u2d3.getCreatedLocallyAt()) == null) {
            date = new Date();
        }
        $this$prepareMessage_u24lambda_u2d3.setCreatedLocallyAt(date);
        $this$prepareMessage_u24lambda_u2d3.setSyncStatus(!((Collection)attachmentsToUpload).isEmpty() ? SyncStatus.AWAITING_ATTACHMENTS : (this.clientState.isNetworkAvailable() ? SyncStatus.IN_PROGRESS : SyncStatus.SYNC_NEEDED));
        return message2;
    }

    private final String generateMessageId(String userId) {
        return userId + '-' + UUID.randomUUID();
    }

    private final String generateUploadId() {
        return "upload_id_" + UUID.randomUUID();
    }
}

