/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.client.plugins.requests;

import io.getstream.chat.android.client.plugins.requests.ApiRequestsAnalyser;
import io.getstream.chat.android.client.plugins.requests.ApiRequestsDumper;
import io.getstream.chat.android.client.plugins.requests.RequestData;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0007H\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0007H\u0016J\b\u0010\u0012\u001a\u00020\u0007H\u0016J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0007H\u0016J$\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00072\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0016H\u0016J\u0016\u0010\u0017\u001a\u00060\u0018j\u0002`\u0019*\b\u0012\u0004\u0012\u00020\t0\u001aH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lio/getstream/chat/android/client/plugins/requests/ApiRequestsDumper;", "Lio/getstream/chat/android/client/plugins/requests/ApiRequestsAnalyser;", "dateFormat", "Ljava/text/DateFormat;", "(Ljava/text/DateFormat;)V", "requestsDataMap", "", "", "", "Lio/getstream/chat/android/client/plugins/requests/RequestData;", "clearAll", "", "clearRequestContaining", "queryText", "countAllRequests", "", "countRequestContaining", "requestName", "dumpAll", "dumpRequestByName", "registerRequest", "data", "", "toHumanReadableStringBuilder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "", "stream-chat-android-client_release"})
public final class ApiRequestsDumper
implements ApiRequestsAnalyser {
    @NotNull
    private final DateFormat dateFormat;
    @NotNull
    private final Map<String, List<RequestData>> requestsDataMap;

    public ApiRequestsDumper(@NotNull DateFormat dateFormat2) {
        Intrinsics.checkNotNullParameter((Object)dateFormat2, (String)"dateFormat");
        this.dateFormat = dateFormat2;
        this.requestsDataMap = new LinkedHashMap();
    }

    public /* synthetic */ ApiRequestsDumper(DateFormat dateFormat2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            dateFormat2 = new SimpleDateFormat("HH:mm:ss.SSS", Locale.getDefault());
        }
        this(dateFormat2);
    }

    @Override
    public void registerRequest(@NotNull String requestName, @NotNull Map<String, String> data) {
        Intrinsics.checkNotNullParameter((Object)requestName, (String)"requestName");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        RequestData requestData = new RequestData(requestName, new Date(), data);
        List<RequestData> requestDataList = this.requestsDataMap.get(requestName);
        if (requestDataList != null) {
            requestDataList.add(requestData);
        } else {
            Map<String, List<RequestData>> map = this.requestsDataMap;
            Object object = new RequestData[]{requestData};
            object = CollectionsKt.mutableListOf((Object[])object);
            map.put(requestName, (List<RequestData>)object);
        }
    }

    @Override
    @NotNull
    public String dumpRequestByName(@NotNull String requestName) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)requestName, (String)"requestName");
        List<RequestData> list = this.requestsDataMap.get(requestName);
        String string2 = list != null && (stringBuilder = this.toHumanReadableStringBuilder(list)) != null ? stringBuilder.toString() : null;
        return string2 == null ? "not found" : string2;
    }

    @Override
    @NotNull
    public String dumpAll() {
        StringBuilder stringBuilder;
        StringBuilder $this$dumpAll_u24lambda_u2d1 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Iterable $this$forEach$iv = this.requestsDataMap.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List requestDataList = (List)element$iv;
            boolean bl2 = false;
            $this$dumpAll_u24lambda_u2d1.append((CharSequence)this.toHumanReadableStringBuilder(requestDataList));
            Intrinsics.checkNotNullExpressionValue((Object)$this$dumpAll_u24lambda_u2d1.append('\n'), (String)"append('\\n')");
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    @Override
    public void clearAll() {
        this.requestsDataMap.clear();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void clearRequestContaining(@NotNull String queryText) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)queryText, (String)"queryText");
        Iterable $this$filter$iv = this.requestsDataMap.keySet();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String key = (String)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.contains$default((CharSequence)key, (CharSequence)queryText, (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List keys = (List)destination$iv$iv;
        $this$filter$iv = keys;
        Map<String, List<RequestData>> map = this.requestsDataMap;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String p0 = (String)element$iv;
            boolean bl = false;
            map.remove(p0);
        }
    }

    @Override
    public int countRequestContaining(@NotNull String requestName) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)requestName, (String)"requestName");
            Iterable iterable = this.requestsDataMap.keySet();
            for (Object t : iterable) {
                String key = (String)t;
                boolean bl = false;
                if (!StringsKt.contains$default((CharSequence)key, (CharSequence)requestName, (boolean)false, (int)2, null)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        String matchKey = v0;
        List<RequestData> list = this.requestsDataMap.get(matchKey);
        return list != null ? ((Collection)list).size() : -1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int countAllRequests() {
        void $this$fold$iv;
        Iterable iterable = this.requestsDataMap.values();
        int initial$iv = 0;
        boolean $i$f$fold = false;
        int accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void list;
            List list2 = (List)element$iv;
            int acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = acc + ((Collection)list).size();
        }
        return accumulator$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final StringBuilder toHumanReadableStringBuilder(List<RequestData> $this$toHumanReadableStringBuilder) {
        StringBuilder stringBuilder;
        List<RequestData> dataList = $this$toHumanReadableStringBuilder;
        String requestName = ((RequestData)CollectionsKt.first($this$toHumanReadableStringBuilder)).getName();
        int count = ((Collection)$this$toHumanReadableStringBuilder).size();
        StringBuilder $this$toHumanReadableStringBuilder_u24lambda_u2d6 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Iterable $this$forEachIndexed$iv = dataList;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void requestData;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            RequestData requestData2 = (RequestData)item$iv;
            int i = n;
            boolean bl2 = false;
            String time = this.dateFormat.format(requestData.getTime());
            String params2 = CollectionsKt.joinToString$default((Iterable)requestData.getExtraData().entrySet(), null, null, null, (int)0, null, (Function1)toHumanReadableStringBuilder.extraDataBuilder.1.1.params.1.INSTANCE, (int)31, null);
            StringBuilder stringBuilder2 = $this$toHumanReadableStringBuilder_u24lambda_u2d6.append("Call " + i + ". Time: " + time + ". Params: " + params2);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
        }
        StringBuilder extraDataBuilder2 = stringBuilder;
        StringBuilder $this$toHumanReadableStringBuilder_u24lambda_u2d7 = stringBuilder = new StringBuilder();
        boolean bl3 = false;
        StringBuilder stringBuilder3 = $this$toHumanReadableStringBuilder_u24lambda_u2d7.append("Request: " + requestName + ". Count: " + count);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append('\\n')");
        $this$toHumanReadableStringBuilder_u24lambda_u2d7.append((CharSequence)extraDataBuilder2);
        return stringBuilder;
    }

    public ApiRequestsDumper() {
        this(null, 1, null);
    }
}

