/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.client.notifications;

import android.content.Context;
import io.getstream.chat.android.client.ChatClient;
import io.getstream.chat.android.client.events.NewMessageEvent;
import io.getstream.chat.android.client.logger.ChatLogger;
import io.getstream.chat.android.client.logger.TaggedLogger;
import io.getstream.chat.android.client.models.Channel;
import io.getstream.chat.android.client.models.Device;
import io.getstream.chat.android.client.models.Message;
import io.getstream.chat.android.client.models.PushMessage;
import io.getstream.chat.android.client.models.User;
import io.getstream.chat.android.client.notifications.ChatNotifications;
import io.getstream.chat.android.client.notifications.LoadNotificationDataWorker;
import io.getstream.chat.android.client.notifications.PushNotificationReceivedListener;
import io.getstream.chat.android.client.notifications.PushTokenUpdateHandler;
import io.getstream.chat.android.client.notifications.handler.NotificationConfig;
import io.getstream.chat.android.client.notifications.handler.NotificationHandler;
import io.getstream.chat.android.client.notifications.handler.PushDeviceGenerator;
import io.getstream.chat.android.core.internal.coroutines.DispatcherProvider;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0011H\u0016J\u0018\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020 H\u0002J \u0010!\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020\u0011H\u0002J\b\u0010#\u001a\u00020\u0013H\u0016J\u0010\u0010$\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\u001eH\u0016J\u0018\u0010&\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020 2\u0006\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020\u0013H\u0016J\b\u0010*\u001a\u00020\u0013H\u0002J\u0010\u0010+\u001a\u00020\u00132\u0006\u0010,\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020/2\u0006\u0010\"\u001a\u00020\u0011H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lio/getstream/chat/android/client/notifications/ChatNotificationsImpl;", "Lio/getstream/chat/android/client/notifications/ChatNotifications;", "handler", "Lio/getstream/chat/android/client/notifications/handler/NotificationHandler;", "notificationConfig", "Lio/getstream/chat/android/client/notifications/handler/NotificationConfig;", "context", "Landroid/content/Context;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "(Lio/getstream/chat/android/client/notifications/handler/NotificationHandler;Lio/getstream/chat/android/client/notifications/handler/NotificationConfig;Landroid/content/Context;Lkotlinx/coroutines/CoroutineScope;)V", "logger", "Lio/getstream/chat/android/client/logger/TaggedLogger;", "pushTokenUpdateHandler", "Lio/getstream/chat/android/client/notifications/PushTokenUpdateHandler;", "showedMessages", "", "", "cancelLoadDataWork", "", "dismissChannelNotifications", "channelType", "channelId", "displayNotification", "channel", "Lio/getstream/chat/android/client/models/Channel;", "message", "Lio/getstream/chat/android/client/models/Message;", "handleEvent", "event", "Lio/getstream/chat/android/client/events/NewMessageEvent;", "handlePushMessage", "Lio/getstream/chat/android/client/models/PushMessage;", "obtainNotifactionData", "messageId", "onLogout", "onNewMessageEvent", "newMessageEvent", "onPushMessage", "pushNotificationReceivedListener", "Lio/getstream/chat/android/client/notifications/PushNotificationReceivedListener;", "onSetUser", "removeStoredDevice", "setDevice", "device", "Lio/getstream/chat/android/client/models/Device;", "wasNotificationDisplayed", "", "stream-chat-android-client_release"})
public final class ChatNotificationsImpl
implements ChatNotifications {
    @NotNull
    private final NotificationHandler handler;
    @NotNull
    private final NotificationConfig notificationConfig;
    @NotNull
    private final Context context;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final TaggedLogger logger;
    @NotNull
    private final PushTokenUpdateHandler pushTokenUpdateHandler;
    @NotNull
    private final Set<String> showedMessages;

    public ChatNotificationsImpl(@NotNull NotificationHandler handler2, @NotNull NotificationConfig notificationConfig, @NotNull Context context, @NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)handler2, (String)"handler");
        Intrinsics.checkNotNullParameter((Object)notificationConfig, (String)"notificationConfig");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.handler = handler2;
        this.notificationConfig = notificationConfig;
        this.context = context;
        this.scope = scope;
        this.logger = ChatLogger.Companion.get("ChatNotifications");
        this.pushTokenUpdateHandler = new PushTokenUpdateHandler(this.context);
        this.showedMessages = new LinkedHashSet();
    }

    public /* synthetic */ ChatNotificationsImpl(NotificationHandler notificationHandler, NotificationConfig notificationConfig, Context context, CoroutineScope coroutineScope, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)DispatcherProvider.INSTANCE.getIO()));
        }
        this(notificationHandler, notificationConfig, context, coroutineScope);
    }

    @Override
    public void onSetUser() {
        Object v0;
        block2: {
            Iterable $this$firstOrNull$iv = this.notificationConfig.getPushDeviceGenerators();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PushDeviceGenerator it = (PushDeviceGenerator)element$iv;
                boolean bl = false;
                if (!it.isValidForThisDevice(this.context)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        PushDeviceGenerator pushDeviceGenerator = v0;
        if (pushDeviceGenerator != null) {
            PushDeviceGenerator it = pushDeviceGenerator;
            boolean bl = false;
            it.onPushDeviceGeneratorSelected();
            it.asyncGenerateDevice((Function1<? super Device, Unit>)((Function1)new Function1<Device, Unit>((Object)this){

                public final void invoke(@NotNull Device p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    ((ChatNotificationsImpl)this.receiver).setDevice(p0);
                }
            }));
        }
    }

    @Override
    public void setDevice(@NotNull Device device) {
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, device, null){
            int label;
            final /* synthetic */ ChatNotificationsImpl this$0;
            final /* synthetic */ Device $device;
            {
                this.this$0 = $receiver;
                this.$device = $device;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = ChatNotificationsImpl.access$getPushTokenUpdateHandler$p(this.this$0).updateDeviceIfNecessary(this.$device, (Continuation<? super Unit>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Override
    public void onPushMessage(@NotNull PushMessage message, @NotNull PushNotificationReceivedListener pushNotificationReceivedListener) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)pushNotificationReceivedListener, (String)"pushNotificationReceivedListener");
        this.logger.logI(Intrinsics.stringPlus((String)"onReceivePushMessage: ", (Object)message));
        pushNotificationReceivedListener.onPushNotificationReceived(message.getChannelType(), message.getChannelId());
        if (((Boolean)this.notificationConfig.getShouldShowNotificationOnPush().invoke()).booleanValue() && !this.handler.onPushMessage(message)) {
            this.handlePushMessage(message);
        }
    }

    @Override
    public void onNewMessageEvent(@NotNull NewMessageEvent newMessageEvent) {
        String currentUserId;
        Intrinsics.checkNotNullParameter((Object)newMessageEvent, (String)"newMessageEvent");
        User user = ChatClient.Companion.instance().getCurrentUser();
        String string = currentUserId = user == null ? null : user.getId();
        if (Intrinsics.areEqual((Object)newMessageEvent.getMessage().getUser().getId(), (Object)currentUserId)) {
            return;
        }
        this.logger.logD(Intrinsics.stringPlus((String)"Handling ", (Object)newMessageEvent));
        if (!this.handler.onChatEvent(newMessageEvent)) {
            this.logger.logI("Handling " + newMessageEvent + " internally");
            this.handleEvent(newMessageEvent);
        }
    }

    @Override
    public void onLogout() {
        this.handler.dismissAllNotifications();
        this.removeStoredDevice();
        this.cancelLoadDataWork();
    }

    private final void cancelLoadDataWork() {
        LoadNotificationDataWorker.Companion.cancel(this.context);
    }

    @Override
    public void dismissChannelNotifications(@NotNull String channelType, @NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelType, (String)"channelType");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        this.handler.dismissChannelNotifications(channelType, channelId);
    }

    private final void handlePushMessage(PushMessage message) {
        this.obtainNotifactionData(message.getChannelId(), message.getChannelType(), message.getMessageId());
    }

    private final void obtainNotifactionData(String channelId, String channelType, String messageId) {
        LoadNotificationDataWorker.Companion.start(this.context, channelId, channelType, messageId);
    }

    private final void handleEvent(NewMessageEvent event) {
        this.obtainNotifactionData(event.getChannelId(), event.getChannelType(), event.getMessage().getId());
    }

    private final boolean wasNotificationDisplayed(String messageId) {
        return this.showedMessages.contains(messageId);
    }

    @Override
    public void displayNotification(@NotNull Channel channel, @NotNull Message message) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.logger.logD("Showing notification with loaded data");
        if (!this.wasNotificationDisplayed(message.getId())) {
            this.showedMessages.add(message.getId());
            this.handler.showNotification(channel, message);
        }
    }

    private final void removeStoredDevice() {
        BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ ChatNotificationsImpl this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = ChatNotificationsImpl.access$getPushTokenUpdateHandler$p(this.this$0).removeStoredDevice((Continuation<? super Unit>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public static final /* synthetic */ PushTokenUpdateHandler access$getPushTokenUpdateHandler$p(ChatNotificationsImpl $this) {
        return $this.pushTokenUpdateHandler;
    }
}

