/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.client.utils.observable;

import io.getstream.chat.android.client.ChatEventListener;
import io.getstream.chat.android.client.clientstate.DisconnectCause;
import io.getstream.chat.android.client.errors.ChatError;
import io.getstream.chat.android.client.events.ChatEvent;
import io.getstream.chat.android.client.events.ConnectedEvent;
import io.getstream.chat.android.client.events.ConnectingEvent;
import io.getstream.chat.android.client.events.DisconnectedEvent;
import io.getstream.chat.android.client.events.ErrorEvent;
import io.getstream.chat.android.client.logger.ChatLogger;
import io.getstream.chat.android.client.logger.TaggedLogger;
import io.getstream.chat.android.client.models.ConnectionData;
import io.getstream.chat.android.client.socket.ChatSocket;
import io.getstream.chat.android.client.socket.SocketListener;
import io.getstream.chat.android.client.utils.Result;
import io.getstream.chat.android.client.utils.observable.ChatEventsObservable;
import io.getstream.chat.android.client.utils.observable.Disposable;
import io.getstream.chat.android.client.utils.observable.EventSubscription;
import io.getstream.chat.android.client.utils.observable.SubscriptionImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.FlowCollector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\"B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0011H\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J*\u0010\u001b\u001a\u00020\u00132\u0014\b\u0002\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001e0\u001d2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00190 J*\u0010!\u001a\u00020\u00132\u0014\b\u0002\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001e0\u001d2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00190 R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lio/getstream/chat/android/client/utils/observable/ChatEventsObservable;", "", "socket", "Lio/getstream/chat/android/client/socket/ChatSocket;", "waitConnection", "Lkotlinx/coroutines/flow/FlowCollector;", "Lio/getstream/chat/android/client/utils/Result;", "Lio/getstream/chat/android/client/models/ConnectionData;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "(Lio/getstream/chat/android/client/socket/ChatSocket;Lkotlinx/coroutines/flow/FlowCollector;Lkotlinx/coroutines/CoroutineScope;)V", "eventsMapper", "Lio/getstream/chat/android/client/utils/observable/ChatEventsObservable$EventsMapper;", "logger", "Lio/getstream/chat/android/client/logger/TaggedLogger;", "subscriptions", "", "Lio/getstream/chat/android/client/utils/observable/EventSubscription;", "addSubscription", "Lio/getstream/chat/android/client/utils/observable/Disposable;", "subscription", "checkIfEmpty", "", "emitConnectionEvents", "event", "Lio/getstream/chat/android/client/events/ChatEvent;", "onNext", "subscribe", "filter", "Lkotlin/Function1;", "", "listener", "Lio/getstream/chat/android/client/ChatEventListener;", "subscribeSingle", "EventsMapper", "stream-chat-android-client_release"})
public final class ChatEventsObservable {
    @NotNull
    private final ChatSocket socket;
    @NotNull
    private final FlowCollector<Result<ConnectionData>> waitConnection;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final TaggedLogger logger;
    @NotNull
    private Set<? extends EventSubscription> subscriptions;
    @NotNull
    private EventsMapper eventsMapper;

    public ChatEventsObservable(@NotNull ChatSocket socket, @NotNull FlowCollector<? super Result<ConnectionData>> waitConnection, @NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
        Intrinsics.checkNotNullParameter(waitConnection, (String)"waitConnection");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.socket = socket;
        this.waitConnection = waitConnection;
        this.scope = scope;
        this.logger = ChatLogger.Companion.get("EventsObservable");
        this.subscriptions = SetsKt.emptySet();
        this.eventsMapper = new EventsMapper(this);
    }

    /*
     * WARNING - void declaration
     */
    private final void onNext(ChatEvent event) {
        void $this$filterNotTo$iv$iv;
        void $this$filterNot$iv;
        Iterable $this$forEach$iv = this.subscriptions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EventSubscription subscription = (EventSubscription)element$iv;
            boolean bl = false;
            if (subscription.isDisposed()) continue;
            subscription.onNext(event);
        }
        this.emitConnectionEvents(event);
        $this$forEach$iv = this.subscriptions;
        ChatEventsObservable chatEventsObservable = this;
        boolean $i$f$filterNot = false;
        Iterator iterator = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            Disposable p0 = (Disposable)element$iv$iv;
            boolean bl = false;
            if (p0.isDisposed()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        chatEventsObservable.subscriptions = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        this.checkIfEmpty();
    }

    private final void emitConnectionEvents(ChatEvent event) {
        BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(event, this, null){
            int label;
            final /* synthetic */ ChatEvent $event;
            final /* synthetic */ ChatEventsObservable this$0;
            {
                this.$event = $event;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                void $result;
                ChatEvent chatEvent;
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        chatEvent = this.$event;
                        if (!(chatEvent instanceof ConnectedEvent)) break;
                        this.label = 1;
                        Object object3 = ChatEventsObservable.access$getWaitConnection$p(this.this$0).emit((Object)Result.Companion.success((Object)new ConnectionData(((ConnectedEvent)this.$event).getMe(), ((ConnectedEvent)this.$event).getConnectionId())), (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                if (!(chatEvent instanceof ErrorEvent)) return Unit.INSTANCE;
                this.label = 2;
                Object object4 = ChatEventsObservable.access$getWaitConnection$p(this.this$0).emit((Object)Result.Companion.error(((ErrorEvent)this.$event).getError()), (Continuation)this);
                if (object4 != object2) return Unit.INSTANCE;
                return object2;
                {
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        object4 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void checkIfEmpty() {
        if (this.subscriptions.isEmpty()) {
            this.socket.removeListener(this.eventsMapper);
        }
    }

    @NotNull
    public final Disposable subscribe(@NotNull Function1<? super ChatEvent, Boolean> filter2, @NotNull ChatEventListener<ChatEvent> listener) {
        Intrinsics.checkNotNullParameter(filter2, (String)"filter");
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        return this.addSubscription(new SubscriptionImpl(filter2, listener));
    }

    public static /* synthetic */ Disposable subscribe$default(ChatEventsObservable chatEventsObservable, Function1 function1, ChatEventListener chatEventListener, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = subscribe.1.INSTANCE;
        }
        return chatEventsObservable.subscribe((Function1<? super ChatEvent, Boolean>)function1, chatEventListener);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Disposable subscribeSingle(@NotNull Function1<? super ChatEvent, Boolean> filter2, @NotNull ChatEventListener<ChatEvent> listener) {
        void $this$subscribeSingle_u24lambda_u2d1;
        SubscriptionImpl subscriptionImpl;
        Intrinsics.checkNotNullParameter(filter2, (String)"filter");
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        SubscriptionImpl subscriptionImpl2 = subscriptionImpl = new SubscriptionImpl(filter2, listener);
        ChatEventsObservable chatEventsObservable = this;
        boolean bl = false;
        $this$subscribeSingle_u24lambda_u2d1.setAfterEventDelivered((Function0<Unit>)((Function0)new Function0<Unit>((Object)$this$subscribeSingle_u24lambda_u2d1){

            public final void invoke() {
                ((SubscriptionImpl)this.receiver).dispose();
            }
        }));
        return chatEventsObservable.addSubscription(subscriptionImpl);
    }

    public static /* synthetic */ Disposable subscribeSingle$default(ChatEventsObservable chatEventsObservable, Function1 function1, ChatEventListener chatEventListener, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = subscribeSingle.1.INSTANCE;
        }
        return chatEventsObservable.subscribeSingle((Function1<? super ChatEvent, Boolean>)function1, chatEventListener);
    }

    private final Disposable addSubscription(EventSubscription subscription) {
        if (this.subscriptions.isEmpty()) {
            this.socket.addListener(this.eventsMapper);
        }
        this.subscriptions = SetsKt.plus(this.subscriptions, (Object)subscription);
        return subscription;
    }

    public static final /* synthetic */ FlowCollector access$getWaitConnection$p(ChatEventsObservable $this) {
        return $this.waitConnection;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\u0006H\u0016J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/getstream/chat/android/client/utils/observable/ChatEventsObservable$EventsMapper;", "Lio/getstream/chat/android/client/socket/SocketListener;", "observable", "Lio/getstream/chat/android/client/utils/observable/ChatEventsObservable;", "(Lio/getstream/chat/android/client/utils/observable/ChatEventsObservable;)V", "onConnected", "", "event", "Lio/getstream/chat/android/client/events/ConnectedEvent;", "onConnecting", "onDisconnected", "cause", "Lio/getstream/chat/android/client/clientstate/DisconnectCause;", "onError", "error", "Lio/getstream/chat/android/client/errors/ChatError;", "onEvent", "Lio/getstream/chat/android/client/events/ChatEvent;", "stream-chat-android-client_release"})
    private static final class EventsMapper
    extends SocketListener {
        @NotNull
        private final ChatEventsObservable observable;

        public EventsMapper(@NotNull ChatEventsObservable observable2) {
            Intrinsics.checkNotNullParameter((Object)observable2, (String)"observable");
            this.observable = observable2;
        }

        @Override
        public void onConnecting() {
            this.observable.onNext(new ConnectingEvent("connection.connecting", new Date()));
        }

        @Override
        public void onConnected(@NotNull ConnectedEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.observable.onNext(event);
        }

        @Override
        public void onDisconnected(@NotNull DisconnectCause cause) {
            Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
            this.observable.onNext(new DisconnectedEvent("connection.disconnected", new Date(), cause));
        }

        @Override
        public void onEvent(@NotNull ChatEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.observable.onNext(event);
        }

        @Override
        public void onError(@NotNull ChatError error) {
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            this.observable.onNext(new ErrorEvent("connection.error", new Date(), error));
        }
    }
}

