/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.client.parser;

import io.getstream.chat.android.client.errors.ChatError;
import io.getstream.chat.android.client.errors.ChatErrorCode;
import io.getstream.chat.android.client.errors.ChatNetworkError;
import io.getstream.chat.android.client.logger.ChatLogger;
import io.getstream.chat.android.client.socket.ErrorResponse;
import io.getstream.chat.android.client.utils.Result;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import retrofit2.Retrofit;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b`\u0018\u00002\u00020\u0001J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H&J-\u0010\u0007\u001a\u0002H\b\"\b\b\u0000\u0010\b*\u00020\u00012\u0006\u0010\t\u001a\u00020\u00032\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\b0\u000bH&\u00a2\u0006\u0002\u0010\fJ.\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\b0\u000e\"\b\b\u0000\u0010\b*\u00020\u00012\u0006\u0010\t\u001a\u00020\u00032\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\b0\u000bH\u0016J\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0001H&R\u000b\u0010\u0002\u001a\u00020\u00038BX\u0082\u0004\u00a8\u0006\u0019"}, d2={"Lio/getstream/chat/android/client/parser/ChatParser;", "", "tag", "", "configRetrofit", "Lretrofit2/Retrofit$Builder;", "builder", "fromJson", "T", "raw", "clazz", "Ljava/lang/Class;", "(Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;", "fromJsonOrError", "Lio/getstream/chat/android/client/utils/Result;", "moreInfoTemplate", "moreInfo", "toError", "Lio/getstream/chat/android/client/errors/ChatNetworkError;", "okHttpResponse", "Lokhttp3/Response;", "errorResponseBody", "Lokhttp3/ResponseBody;", "toJson", "any", "stream-chat-android-client_release"})
public interface ChatParser {
    @NotNull
    public String toJson(@NotNull Object var1);

    @NotNull
    public <T> T fromJson(@NotNull String var1, @NotNull Class<T> var2);

    @NotNull
    public Retrofit.Builder configRetrofit(@NotNull Retrofit.Builder var1);

    @NotNull
    public <T> Result<T> fromJsonOrError(@NotNull String var1, @NotNull Class<T> var2);

    @NotNull
    public ChatNetworkError toError(@NotNull Response var1);

    @NotNull
    public ChatNetworkError toError(@NotNull ResponseBody var1);

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        private static String getTag(ChatParser this_) {
            String string2 = ChatParser.class.getSimpleName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"ChatParser::class.java.simpleName");
            return string2;
        }

        @NotNull
        public static <T> Result<T> fromJsonOrError(@NotNull ChatParser this_, @NotNull String raw, @NotNull Class<T> clazz) {
            Result result2;
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
            try {
                result2 = new Result(this_.fromJson(raw, clazz));
            }
            catch (Throwable expected) {
                result2 = new Result(new ChatError("fromJsonOrError error parsing of " + clazz + " into " + raw, expected));
            }
            return result2;
        }

        @NotNull
        public static ChatNetworkError toError(@NotNull ChatParser this_, @NotNull Response okHttpResponse) {
            ChatNetworkError chatNetworkError;
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)okHttpResponse, (String)"okHttpResponse");
            int statusCode = okHttpResponse.code();
            try {
                ChatNetworkError chatNetworkError2;
                String body = okHttpResponse.peekBody(Long.MAX_VALUE).string();
                if (((CharSequence)body).length() == 0) {
                    chatNetworkError2 = ChatNetworkError.Companion.create$default(ChatNetworkError.Companion, ChatErrorCode.NO_ERROR_BODY, null, statusCode, 2, null);
                } else {
                    ErrorResponse errorResponse;
                    try {
                        errorResponse = this_.fromJson(body, ErrorResponse.class);
                    }
                    catch (Throwable _) {
                        ErrorResponse errorResponse2;
                        ErrorResponse $this$toError_u24lambda_u2d0 = errorResponse2 = new ErrorResponse(0, null, 0, null, null, 31, null);
                        boolean bl = false;
                        $this$toError_u24lambda_u2d0.setMessage(body);
                        errorResponse = errorResponse2;
                    }
                    ErrorResponse error = errorResponse;
                    chatNetworkError2 = ChatNetworkError.Companion.create$default(ChatNetworkError.Companion, error.getCode(), Intrinsics.stringPlus((String)error.getMessage(), (Object)DefaultImpls.moreInfoTemplate(this_, error.getMoreInfo())), statusCode, null, 8, null);
                }
                chatNetworkError = chatNetworkError2;
            }
            catch (Throwable expected) {
                ChatLogger.Companion.getInstance().logE((Object)DefaultImpls.getTag(this_), expected);
                chatNetworkError = ChatNetworkError.Companion.create(ChatErrorCode.NETWORK_FAILED, expected, statusCode);
            }
            return chatNetworkError;
        }

        @NotNull
        public static ChatNetworkError toError(@NotNull ChatParser this_, @NotNull ResponseBody errorResponseBody) {
            ChatNetworkError chatNetworkError;
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)errorResponseBody, (String)"errorResponseBody");
            try {
                ErrorResponse errorResponse = this_.fromJson(errorResponseBody.string(), ErrorResponse.class);
                int code = errorResponse.component1();
                String message = errorResponse.component2();
                int statusCode = errorResponse.component3();
                String moreInfo = errorResponse.component5();
                chatNetworkError = ChatNetworkError.Companion.create$default(ChatNetworkError.Companion, code, Intrinsics.stringPlus((String)message, (Object)DefaultImpls.moreInfoTemplate(this_, moreInfo)), statusCode, null, 8, null);
            }
            catch (Throwable expected) {
                ChatLogger.Companion.getInstance().logE((Object)DefaultImpls.getTag(this_), expected);
                chatNetworkError = ChatNetworkError.Companion.create(ChatErrorCode.NETWORK_FAILED, expected, -1);
            }
            return chatNetworkError;
        }

        private static String moreInfoTemplate(ChatParser this_, String moreInfo) {
            return !StringsKt.isBlank((CharSequence)moreInfo) ? Intrinsics.stringPlus((String)"\nMore information available at ", (Object)moreInfo) : "";
        }
    }
}

