/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.client.socket;

import android.os.Handler;
import android.os.Looper;
import androidx.annotation.VisibleForTesting;
import io.getstream.chat.android.client.clientstate.DisconnectCause;
import io.getstream.chat.android.client.errors.ChatError;
import io.getstream.chat.android.client.errors.ChatErrorCode;
import io.getstream.chat.android.client.errors.ChatNetworkError;
import io.getstream.chat.android.client.events.ChatEvent;
import io.getstream.chat.android.client.events.ConnectedEvent;
import io.getstream.chat.android.client.logger.ChatLogger;
import io.getstream.chat.android.client.logger.TaggedLogger;
import io.getstream.chat.android.client.models.User;
import io.getstream.chat.android.client.network.NetworkStateProvider;
import io.getstream.chat.android.client.parser.ChatParser;
import io.getstream.chat.android.client.socket.ChatSocket;
import io.getstream.chat.android.client.socket.EventsParser;
import io.getstream.chat.android.client.socket.HealthMonitor;
import io.getstream.chat.android.client.socket.Socket;
import io.getstream.chat.android.client.socket.SocketFactory;
import io.getstream.chat.android.client.socket.SocketListener;
import io.getstream.chat.android.client.token.TokenManager;
import io.getstream.chat.android.core.internal.coroutines.DispatcherProvider;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.Delegates;
import kotlin.properties.ObservableProperty;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00af\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f*\u0001\u001e\b\u0010\u0018\u0000 P2\u00020\u0001:\u0002PQB=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0010\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u001aH\u0016J\u001c\u00104\u001a\u0002022\u0012\u00105\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020206H\u0002J\u0010\u00107\u001a\u0002022\u0006\u00108\u001a\u000209H\u0016J\u0010\u00107\u001a\u0002022\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010:\u001a\u000202H\u0016J\b\u0010;\u001a\u00020\u0015H\u0002J\b\u0010<\u001a\u000202H\u0016J\u0010\u0010=\u001a\u0002022\u0006\u0010>\u001a\u00020?H\u0002J\u0010\u0010@\u001a\u0002022\u0006\u0010A\u001a\u00020BH\u0016J\u0010\u0010C\u001a\u0002022\u0006\u0010A\u001a\u00020DH\u0016J\u0010\u0010E\u001a\u0002022\u0006\u0010>\u001a\u00020FH\u0016J\u0012\u0010G\u001a\u0002022\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\u0006\u0010H\u001a\u000202J\u000e\u0010I\u001a\u0002022\u0006\u00108\u001a\u000209J\b\u0010J\u001a\u000202H\u0016J\u0010\u0010K\u001a\u0002022\u0006\u00103\u001a\u00020\u001aH\u0016J\u0015\u0010L\u001a\u0002022\u0006\u0010A\u001a\u00020DH\u0010\u00a2\u0006\u0002\bMJ\u0012\u0010N\u001a\u0002022\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\b\u0010O\u001a\u000202H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001fR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010$\u001a\u0004\u0018\u00010%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R1\u0010(\u001a\u00020'2\u0006\u0010&\u001a\u00020'8@@BX\u0081\u008e\u0002\u00a2\u0006\u0018\n\u0004\b/\u00100\u0012\u0004\b)\u0010*\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006R"}, d2={"Lio/getstream/chat/android/client/socket/ChatSocket;", "", "apiKey", "", "wssUrl", "tokenManager", "Lio/getstream/chat/android/client/token/TokenManager;", "socketFactory", "Lio/getstream/chat/android/client/socket/SocketFactory;", "networkStateProvider", "Lio/getstream/chat/android/client/network/NetworkStateProvider;", "parser", "Lio/getstream/chat/android/client/parser/ChatParser;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "(Ljava/lang/String;Ljava/lang/String;Lio/getstream/chat/android/client/token/TokenManager;Lio/getstream/chat/android/client/socket/SocketFactory;Lio/getstream/chat/android/client/network/NetworkStateProvider;Lio/getstream/chat/android/client/parser/ChatParser;Lkotlinx/coroutines/CoroutineScope;)V", "connectionConf", "Lio/getstream/chat/android/client/socket/SocketFactory$ConnectionConf;", "eventUiHandler", "Landroid/os/Handler;", "eventsParser", "Lio/getstream/chat/android/client/socket/EventsParser;", "healthMonitor", "Lio/getstream/chat/android/client/socket/HealthMonitor;", "listeners", "", "Lio/getstream/chat/android/client/socket/SocketListener;", "logger", "Lio/getstream/chat/android/client/logger/TaggedLogger;", "networkStateListener", "io/getstream/chat/android/client/socket/ChatSocket$networkStateListener$1", "Lio/getstream/chat/android/client/socket/ChatSocket$networkStateListener$1;", "reconnectionAttempts", "", "socket", "Lio/getstream/chat/android/client/socket/Socket;", "socketConnectionJob", "Lkotlinx/coroutines/Job;", "<set-?>", "Lio/getstream/chat/android/client/socket/ChatSocket$State;", "state", "getState$stream_chat_android_client_release$annotations", "()V", "getState$stream_chat_android_client_release", "()Lio/getstream/chat/android/client/socket/ChatSocket$State;", "setState", "(Lio/getstream/chat/android/client/socket/ChatSocket$State;)V", "state$delegate", "Lkotlin/properties/ReadWriteProperty;", "addListener", "", "listener", "callListeners", "call", "Lkotlin/Function1;", "connect", "user", "Lio/getstream/chat/android/client/models/User;", "connectAnonymously", "createNewEventsParser", "disconnect", "onChatNetworkError", "error", "Lio/getstream/chat/android/client/errors/ChatNetworkError;", "onConnectionResolved", "event", "Lio/getstream/chat/android/client/events/ConnectedEvent;", "onEvent", "Lio/getstream/chat/android/client/events/ChatEvent;", "onSocketError", "Lio/getstream/chat/android/client/errors/ChatError;", "reconnect", "reconnectAnonymously", "reconnectUser", "releaseConnection", "removeListener", "sendEvent", "sendEvent$stream_chat_android_client_release", "setupSocket", "shutdownSocketConnection", "Companion", "State", "stream-chat-android-client_release"})
public class ChatSocket {
    @NotNull
    private static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final String apiKey;
    @NotNull
    private final String wssUrl;
    @NotNull
    private final TokenManager tokenManager;
    @NotNull
    private final SocketFactory socketFactory;
    @NotNull
    private final NetworkStateProvider networkStateProvider;
    @NotNull
    private final ChatParser parser;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final TaggedLogger logger;
    @Nullable
    private SocketFactory.ConnectionConf connectionConf;
    @Nullable
    private Socket socket;
    @Nullable
    private EventsParser eventsParser;
    @Nullable
    private Job socketConnectionJob;
    @NotNull
    private final Set<SocketListener> listeners;
    @NotNull
    private final Handler eventUiHandler;
    @NotNull
    private final HealthMonitor healthMonitor;
    @NotNull
    private final networkStateListener.1 networkStateListener;
    private int reconnectionAttempts;
    @NotNull
    private final ReadWriteProperty state$delegate;
    @Deprecated
    private static final int RETRY_LIMIT = 3;
    @Deprecated
    private static final int DEFAULT_DELAY = 500;

    /*
     * WARNING - void declaration
     */
    public ChatSocket(@NotNull String apiKey, @NotNull String wssUrl, @NotNull TokenManager tokenManager, @NotNull SocketFactory socketFactory, @NotNull NetworkStateProvider networkStateProvider, @NotNull ChatParser parser, @NotNull CoroutineScope coroutineScope) {
        void initialValue$iv;
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        Intrinsics.checkNotNullParameter((Object)wssUrl, (String)"wssUrl");
        Intrinsics.checkNotNullParameter((Object)tokenManager, (String)"tokenManager");
        Intrinsics.checkNotNullParameter((Object)socketFactory, (String)"socketFactory");
        Intrinsics.checkNotNullParameter((Object)networkStateProvider, (String)"networkStateProvider");
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.apiKey = apiKey;
        this.wssUrl = wssUrl;
        this.tokenManager = tokenManager;
        this.socketFactory = socketFactory;
        this.networkStateProvider = networkStateProvider;
        this.parser = parser;
        this.coroutineScope = coroutineScope;
        this.logger = ChatLogger.Companion.get("ChatSocket");
        this.listeners = new LinkedHashSet();
        this.eventUiHandler = new Handler(Looper.getMainLooper());
        this.healthMonitor = new HealthMonitor(new HealthMonitor.HealthCallback(this){
            final /* synthetic */ ChatSocket this$0;
            {
                this.this$0 = $receiver;
            }

            public void reconnect() {
                if (this.this$0.getState$stream_chat_android_client_release() instanceof State.DisconnectedTemporarily) {
                    ChatSocket.access$reconnect(this.this$0, ChatSocket.access$getConnectionConf$p(this.this$0));
                }
            }

            public void check() {
                State state2 = this.this$0.getState$stream_chat_android_client_release();
                State.Connected connected = state2 instanceof State.Connected ? (State.Connected)state2 : null;
                if (connected != null) {
                    state2 = connected;
                    ChatSocket chatSocket = this.this$0;
                    State it = state2;
                    boolean bl = false;
                    chatSocket.sendEvent$stream_chat_android_client_release(((State.Connected)it).getEvent());
                }
            }
        });
        this.networkStateListener = new NetworkStateProvider.NetworkStateListener(this){
            final /* synthetic */ ChatSocket this$0;
            {
                this.this$0 = $receiver;
            }

            public void onConnected() {
                ChatSocket.access$getLogger$p(this.this$0).logI(Intrinsics.stringPlus((String)"Network connected. Socket state: ", (Object)this.this$0.getState$stream_chat_android_client_release().getClass().getSimpleName()));
                if (this.this$0.getState$stream_chat_android_client_release() instanceof State.DisconnectedTemporarily || Intrinsics.areEqual((Object)this.this$0.getState$stream_chat_android_client_release(), (Object)State.NetworkDisconnected.INSTANCE)) {
                    ChatSocket.access$getLogger$p(this.this$0).logI("network connected, reconnecting socket");
                    ChatSocket.access$reconnect(this.this$0, ChatSocket.access$getConnectionConf$p(this.this$0));
                }
            }

            public void onDisconnected() {
                ChatSocket.access$getLogger$p(this.this$0).logI(Intrinsics.stringPlus((String)"Network disconnected. Socket state: ", (Object)this.this$0.getState$stream_chat_android_client_release().getClass().getSimpleName()));
                ChatSocket.access$getHealthMonitor$p(this.this$0).stop();
                if (this.this$0.getState$stream_chat_android_client_release() instanceof State.Connected || this.this$0.getState$stream_chat_android_client_release() instanceof State.Connecting) {
                    ChatSocket.access$setState(this.this$0, State.NetworkDisconnected.INSTANCE);
                }
            }
        };
        Delegates delegates = Delegates.INSTANCE;
        State state2 = new State.DisconnectedTemporarily(null);
        boolean $i$f$observable = false;
        this.state$delegate = (ReadWriteProperty)new ObservableProperty<State>((Object)initialValue$iv, this){
            final /* synthetic */ Object $initialValue;
            final /* synthetic */ ChatSocket this$0;
            {
                this.$initialValue = $initialValue;
                this.this$0 = chatSocket;
                super($initialValue);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            protected void afterChange(@NotNull KProperty property, Object oldValue, Object newValue) {
                void newState;
                void oldState;
                Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                State state2 = (State)newValue;
                State state3 = (State)oldValue;
                KProperty $noName_0 = property;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)oldState, (Object)newState)) {
                    ChatSocket.access$getLogger$p(this.this$0).logI(Intrinsics.stringPlus((String)"updateState: ", (Object)newState.getClass().getSimpleName()));
                    void var8_8 = newState;
                    if (var8_8 instanceof State.Connecting) {
                        ChatSocket.access$getHealthMonitor$p(this.this$0).stop();
                        ChatSocket.access$callListeners(this.this$0, state.2.1.INSTANCE);
                    } else if (var8_8 instanceof State.Connected) {
                        ChatSocket.access$getHealthMonitor$p(this.this$0).start();
                        ChatSocket.access$callListeners(this.this$0, (Function1)new Function1<SocketListener, Unit>((State)newState){
                            final /* synthetic */ State $newState;
                            {
                                this.$newState = $newState;
                                super(1);
                            }

                            public final void invoke(@NotNull SocketListener it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                it.onConnected(((State.Connected)this.$newState).getEvent());
                            }
                        });
                    } else if (var8_8 instanceof State.NetworkDisconnected) {
                        ChatSocket.access$shutdownSocketConnection(this.this$0);
                        ChatSocket.access$getHealthMonitor$p(this.this$0).stop();
                        ChatSocket.access$callListeners(this.this$0, state.2.3.INSTANCE);
                    } else if (var8_8 instanceof State.DisconnectedByRequest) {
                        ChatSocket.access$shutdownSocketConnection(this.this$0);
                        ChatSocket.access$getHealthMonitor$p(this.this$0).stop();
                        ChatSocket.access$callListeners(this.this$0, state.2.4.INSTANCE);
                    } else if (var8_8 instanceof State.DisconnectedTemporarily) {
                        ChatSocket.access$shutdownSocketConnection(this.this$0);
                        ChatSocket.access$getHealthMonitor$p(this.this$0).onDisconnected();
                        ChatSocket.access$callListeners(this.this$0, (Function1)new Function1<SocketListener, Unit>((State)newState){
                            final /* synthetic */ State $newState;
                            {
                                this.$newState = $newState;
                                super(1);
                            }

                            public final void invoke(@NotNull SocketListener it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                it.onDisconnected(new DisconnectCause.Error(((State.DisconnectedTemporarily)this.$newState).getError()));
                            }
                        });
                    } else if (var8_8 instanceof State.DisconnectedPermanently) {
                        ChatSocket.access$shutdownSocketConnection(this.this$0);
                        ChatSocket.access$setConnectionConf$p(this.this$0, null);
                        ChatSocket.access$getNetworkStateProvider$p(this.this$0).unsubscribe(ChatSocket.access$getNetworkStateListener$p(this.this$0));
                        ChatSocket.access$getHealthMonitor$p(this.this$0).stop();
                        ChatSocket.access$callListeners(this.this$0, (Function1)new Function1<SocketListener, Unit>((State)newState){
                            final /* synthetic */ State $newState;
                            {
                                this.$newState = $newState;
                                super(1);
                            }

                            public final void invoke(@NotNull SocketListener it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                it.onDisconnected(new DisconnectCause.UnrecoverableError(((State.DisconnectedPermanently)this.$newState).getError()));
                            }
                        });
                    }
                }
            }
        };
    }

    @NotNull
    public final State getState$stream_chat_android_client_release() {
        return (State)this.state$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    private final void setState(State state2) {
        this.state$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)state2);
    }

    @VisibleForTesting
    public static /* synthetic */ void getState$stream_chat_android_client_release$annotations() {
    }

    public void onSocketError(@NotNull ChatError error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        if (!(this.getState$stream_chat_android_client_release() instanceof State.DisconnectedPermanently)) {
            this.logger.logE(error);
            this.callListeners((Function1<? super SocketListener, Unit>)((Function1)new Function1<SocketListener, Unit>(error){
                final /* synthetic */ ChatError $error;
                {
                    this.$error = $error;
                    super(1);
                }

                public final void invoke(@NotNull SocketListener it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    it.onError(this.$error);
                }
            }));
            ChatNetworkError chatNetworkError = error instanceof ChatNetworkError ? (ChatNetworkError)error : null;
            if (chatNetworkError != null) {
                ChatNetworkError p0 = chatNetworkError;
                boolean bl = false;
                this.onChatNetworkError(p0);
            }
        }
    }

    private final void onChatNetworkError(ChatNetworkError error) {
        int n;
        if (ChatErrorCode.Companion.isAuthenticationError(error.getStreamCode())) {
            this.tokenManager.expireToken();
        }
        if (((((n = error.getStreamCode()) == ChatErrorCode.PARSER_ERROR.getCode() ? true : n == ChatErrorCode.CANT_PARSE_CONNECTION_EVENT.getCode()) ? true : n == ChatErrorCode.CANT_PARSE_EVENT.getCode()) ? true : n == ChatErrorCode.UNABLE_TO_PARSE_SOCKET_EVENT.getCode()) ? true : n == ChatErrorCode.NO_ERROR_BODY.getCode()) {
            if (this.reconnectionAttempts < 3) {
                BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                    int label;
                    final /* synthetic */ ChatSocket this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object var1_1) {
                        var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                this.label = 1;
                                v0 = DelayKt.delay((long)((long)500 * (long)Math.pow(ChatSocket.access$getReconnectionAttempts$p(this.this$0), 2.0)), (Continuation)((Continuation)this));
                                if (v0 == var3_2) {
                                    return var3_2;
                                }
                                ** GOTO lbl13
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl13:
                                // 2 sources

                                ChatSocket.access$reconnect(this.this$0, ChatSocket.access$getConnectionConf$p(this.this$0));
                                var2_3 = this.this$0;
                                ChatSocket.access$setReconnectionAttempts$p(var2_3, ChatSocket.access$getReconnectionAttempts$p(var2_3) + 1);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            }
        } else if (((n == ChatErrorCode.UNDEFINED_TOKEN.getCode() ? true : n == ChatErrorCode.INVALID_TOKEN.getCode()) ? true : n == ChatErrorCode.API_KEY_NOT_FOUND.getCode()) ? true : n == ChatErrorCode.VALIDATION_ERROR.getCode()) {
            this.setState(new State.DisconnectedPermanently(error));
        } else {
            this.setState(new State.DisconnectedTemporarily(error));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(@NotNull SocketListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Set<SocketListener> set = this.listeners;
        synchronized (set) {
            boolean bl = false;
            boolean bl2 = this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(@NotNull SocketListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Set<SocketListener> set = this.listeners;
        synchronized (set) {
            boolean bl = false;
            boolean bl2 = this.listeners.add(listener);
        }
    }

    public void connectAnonymously() {
        this.connect(new SocketFactory.ConnectionConf.AnonymousConnectionConf(this.wssUrl, this.apiKey));
    }

    public final void reconnectAnonymously() {
        this.reconnect(new SocketFactory.ConnectionConf.AnonymousConnectionConf(this.wssUrl, this.apiKey));
    }

    public void connect(@NotNull User user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        this.connect(new SocketFactory.ConnectionConf.UserConnectionConf(this.wssUrl, this.apiKey, user));
    }

    public final void reconnectUser(@NotNull User user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        this.reconnect(new SocketFactory.ConnectionConf.UserConnectionConf(this.wssUrl, this.apiKey, user));
    }

    private final void connect(SocketFactory.ConnectionConf connectionConf) {
        boolean isNetworkConnected = this.networkStateProvider.isConnected();
        this.logger.logI(Intrinsics.stringPlus((String)"Connect. Network available: ", (Object)isNetworkConnected));
        this.connectionConf = connectionConf;
        if (isNetworkConnected) {
            this.setupSocket(connectionConf);
        } else {
            this.setState(State.NetworkDisconnected.INSTANCE);
        }
        this.networkStateProvider.subscribe(this.networkStateListener);
    }

    public void disconnect() {
        this.reconnectionAttempts = 0;
        this.setState(new State.DisconnectedPermanently(null));
    }

    public void releaseConnection() {
        this.setState(State.DisconnectedByRequest.INSTANCE);
    }

    public void onConnectionResolved(@NotNull ConnectedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.setState(new State.Connected(event));
    }

    public void onEvent(@NotNull ChatEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.healthMonitor.ack();
        this.callListeners((Function1<? super SocketListener, Unit>)((Function1)new Function1<SocketListener, Unit>(event){
            final /* synthetic */ ChatEvent $event;
            {
                this.$event = $event;
                super(1);
            }

            public final void invoke(@NotNull SocketListener listener) {
                Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
                listener.onEvent(this.$event);
            }
        }));
    }

    public void sendEvent$stream_chat_android_client_release(@NotNull ChatEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Socket socket = this.socket;
        if (socket != null) {
            socket.send(event);
        }
    }

    private final void reconnect(SocketFactory.ConnectionConf connectionConf) {
        this.shutdownSocketConnection();
        SocketFactory.ConnectionConf connectionConf2 = connectionConf;
        this.setupSocket((SocketFactory.ConnectionConf)(connectionConf2 == null ? null : connectionConf2.asReconnectionConf$stream_chat_android_client_release()));
    }

    private final void setupSocket(SocketFactory.ConnectionConf connectionConf) {
        State state2;
        this.logger.logI("setupSocket");
        SocketFactory.ConnectionConf connectionConf2 = connectionConf;
        if (connectionConf2 == null) {
            state2 = new State.DisconnectedPermanently(null);
        } else if (connectionConf2 instanceof SocketFactory.ConnectionConf.AnonymousConnectionConf ? true : connectionConf2 instanceof SocketFactory.ConnectionConf.UserConnectionConf) {
            this.socketConnectionJob = BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, connectionConf, null){
                int label;
                final /* synthetic */ ChatSocket this$0;
                final /* synthetic */ SocketFactory.ConnectionConf $connectionConf;
                {
                    this.this$0 = $receiver;
                    this.$connectionConf = $connectionConf;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            ChatSocket.access$getTokenManager$p(this.this$0).ensureTokenLoaded();
                            this.label = 1;
                            Object object3 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)DispatcherProvider.INSTANCE.getMain()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$connectionConf, null){
                                int label;
                                final /* synthetic */ ChatSocket this$0;
                                final /* synthetic */ SocketFactory.ConnectionConf $connectionConf;
                                {
                                    this.this$0 = $receiver;
                                    this.$connectionConf = $connectionConf;
                                    super(2, $completion);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            ChatSocket.access$setSocket$p(this.this$0, ChatSocket.access$getSocketFactory$p(this.this$0).createSocket(ChatSocket.access$createNewEventsParser(this.this$0), this.$connectionConf));
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)((Continuation)this));
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
            state2 = State.Connecting.INSTANCE;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        this.setState(state2);
    }

    private final EventsParser createNewEventsParser() {
        EventsParser eventsParser;
        EventsParser it = eventsParser = new EventsParser(this.parser, this);
        boolean bl = false;
        this.eventsParser = it;
        return eventsParser;
    }

    private final void shutdownSocketConnection() {
        Job job = this.socketConnectionJob;
        if (job != null) {
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
        }
        EventsParser eventsParser = this.eventsParser;
        if (eventsParser != null) {
            eventsParser.closeByClient$stream_chat_android_client_release();
        }
        this.eventsParser = null;
        Socket socket = this.socket;
        if (socket != null) {
            socket.close(1000, "Connection close by client");
        }
        this.socket = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void callListeners(Function1<? super SocketListener, Unit> call) {
        Set<SocketListener> set = this.listeners;
        synchronized (set) {
            boolean bl = false;
            Iterable $this$forEach$iv = this.listeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SocketListener listener = (SocketListener)element$iv;
                boolean bl2 = false;
                this.eventUiHandler.post(() -> ChatSocket.callListeners$lambda-6$lambda-5$lambda-4(call, listener));
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private static final void callListeners$lambda-6$lambda-5$lambda-4(Function1 $call, SocketListener $listener) {
        Intrinsics.checkNotNullParameter((Object)$call, (String)"$call");
        Intrinsics.checkNotNullParameter((Object)$listener, (String)"$listener");
        $call.invoke((Object)$listener);
    }

    public static final /* synthetic */ int access$getReconnectionAttempts$p(ChatSocket $this) {
        return $this.reconnectionAttempts;
    }

    public static final /* synthetic */ void access$reconnect(ChatSocket $this, SocketFactory.ConnectionConf connectionConf) {
        $this.reconnect(connectionConf);
    }

    public static final /* synthetic */ SocketFactory.ConnectionConf access$getConnectionConf$p(ChatSocket $this) {
        return $this.connectionConf;
    }

    public static final /* synthetic */ void access$setReconnectionAttempts$p(ChatSocket $this, int n) {
        $this.reconnectionAttempts = n;
    }

    public static final /* synthetic */ TokenManager access$getTokenManager$p(ChatSocket $this) {
        return $this.tokenManager;
    }

    public static final /* synthetic */ void access$setSocket$p(ChatSocket $this, Socket socket) {
        $this.socket = socket;
    }

    public static final /* synthetic */ SocketFactory access$getSocketFactory$p(ChatSocket $this) {
        return $this.socketFactory;
    }

    public static final /* synthetic */ EventsParser access$createNewEventsParser(ChatSocket $this) {
        return $this.createNewEventsParser();
    }

    public static final /* synthetic */ TaggedLogger access$getLogger$p(ChatSocket $this) {
        return $this.logger;
    }

    public static final /* synthetic */ HealthMonitor access$getHealthMonitor$p(ChatSocket $this) {
        return $this.healthMonitor;
    }

    public static final /* synthetic */ void access$callListeners(ChatSocket $this, Function1 call) {
        $this.callListeners((Function1<? super SocketListener, Unit>)call);
    }

    public static final /* synthetic */ void access$shutdownSocketConnection(ChatSocket $this) {
        $this.shutdownSocketConnection();
    }

    public static final /* synthetic */ void access$setConnectionConf$p(ChatSocket $this, SocketFactory.ConnectionConf connectionConf) {
        $this.connectionConf = connectionConf;
    }

    public static final /* synthetic */ NetworkStateProvider access$getNetworkStateProvider$p(ChatSocket $this) {
        return $this.networkStateProvider;
    }

    public static final /* synthetic */ networkStateListener.1 access$getNetworkStateListener$p(ChatSocket $this) {
        return $this.networkStateListener;
    }

    public static final /* synthetic */ void access$setState(ChatSocket $this, State state2) {
        $this.setState(state2);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(ChatSocket.class, "state", "getState$stream_chat_android_client_release()Lio/getstream/chat/android/client/socket/ChatSocket$State;", 0)))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/getstream/chat/android/client/socket/ChatSocket$Companion;", "", "()V", "DEFAULT_DELAY", "", "RETRY_LIMIT", "stream-chat-android-client_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b1\u0018\u00002\u00020\u0001:\u0006\u0003\u0004\u0005\u0006\u0007\bB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0006\t\n\u000b\f\r\u000e\u00a8\u0006\u000f"}, d2={"Lio/getstream/chat/android/client/socket/ChatSocket$State;", "", "()V", "Connected", "Connecting", "DisconnectedByRequest", "DisconnectedPermanently", "DisconnectedTemporarily", "NetworkDisconnected", "Lio/getstream/chat/android/client/socket/ChatSocket$State$Connecting;", "Lio/getstream/chat/android/client/socket/ChatSocket$State$Connected;", "Lio/getstream/chat/android/client/socket/ChatSocket$State$NetworkDisconnected;", "Lio/getstream/chat/android/client/socket/ChatSocket$State$DisconnectedTemporarily;", "Lio/getstream/chat/android/client/socket/ChatSocket$State$DisconnectedPermanently;", "Lio/getstream/chat/android/client/socket/ChatSocket$State$DisconnectedByRequest;", "stream-chat-android-client_release"})
    @VisibleForTesting
    public static abstract class State {
        private State() {
        }

        public /* synthetic */ State(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lio/getstream/chat/android/client/socket/ChatSocket$State$Connecting;", "Lio/getstream/chat/android/client/socket/ChatSocket$State;", "()V", "stream-chat-android-client_release"})
        public static final class Connecting
        extends State {
            @NotNull
            public static final Connecting INSTANCE = new Connecting();

            private Connecting() {
                super(null);
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lio/getstream/chat/android/client/socket/ChatSocket$State$Connected;", "Lio/getstream/chat/android/client/socket/ChatSocket$State;", "event", "Lio/getstream/chat/android/client/events/ConnectedEvent;", "(Lio/getstream/chat/android/client/events/ConnectedEvent;)V", "getEvent", "()Lio/getstream/chat/android/client/events/ConnectedEvent;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "stream-chat-android-client_release"})
        public static final class Connected
        extends State {
            @NotNull
            private final ConnectedEvent event;

            public Connected(@NotNull ConnectedEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                super(null);
                this.event = event;
            }

            @NotNull
            public final ConnectedEvent getEvent() {
                return this.event;
            }

            @NotNull
            public final ConnectedEvent component1() {
                return this.event;
            }

            @NotNull
            public final Connected copy(@NotNull ConnectedEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                return new Connected(event);
            }

            public static /* synthetic */ Connected copy$default(Connected connected, ConnectedEvent connectedEvent, int n, Object object) {
                if ((n & 1) != 0) {
                    connectedEvent = connected.event;
                }
                return connected.copy(connectedEvent);
            }

            @NotNull
            public String toString() {
                return "Connected(event=" + this.event + ')';
            }

            public int hashCode() {
                return this.event.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Connected)) {
                    return false;
                }
                Connected connected = (Connected)other;
                return Intrinsics.areEqual((Object)this.event, (Object)connected.event);
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lio/getstream/chat/android/client/socket/ChatSocket$State$NetworkDisconnected;", "Lio/getstream/chat/android/client/socket/ChatSocket$State;", "()V", "stream-chat-android-client_release"})
        public static final class NetworkDisconnected
        extends State {
            @NotNull
            public static final NetworkDisconnected INSTANCE = new NetworkDisconnected();

            private NetworkDisconnected() {
                super(null);
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lio/getstream/chat/android/client/socket/ChatSocket$State$DisconnectedTemporarily;", "Lio/getstream/chat/android/client/socket/ChatSocket$State;", "error", "Lio/getstream/chat/android/client/errors/ChatNetworkError;", "(Lio/getstream/chat/android/client/errors/ChatNetworkError;)V", "getError", "()Lio/getstream/chat/android/client/errors/ChatNetworkError;", "stream-chat-android-client_release"})
        public static final class DisconnectedTemporarily
        extends State {
            @Nullable
            private final ChatNetworkError error;

            public DisconnectedTemporarily(@Nullable ChatNetworkError error) {
                super(null);
                this.error = error;
            }

            @Nullable
            public final ChatNetworkError getError() {
                return this.error;
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lio/getstream/chat/android/client/socket/ChatSocket$State$DisconnectedPermanently;", "Lio/getstream/chat/android/client/socket/ChatSocket$State;", "error", "Lio/getstream/chat/android/client/errors/ChatNetworkError;", "(Lio/getstream/chat/android/client/errors/ChatNetworkError;)V", "getError", "()Lio/getstream/chat/android/client/errors/ChatNetworkError;", "stream-chat-android-client_release"})
        public static final class DisconnectedPermanently
        extends State {
            @Nullable
            private final ChatNetworkError error;

            public DisconnectedPermanently(@Nullable ChatNetworkError error) {
                super(null);
                this.error = error;
            }

            @Nullable
            public final ChatNetworkError getError() {
                return this.error;
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lio/getstream/chat/android/client/socket/ChatSocket$State$DisconnectedByRequest;", "Lio/getstream/chat/android/client/socket/ChatSocket$State;", "()V", "stream-chat-android-client_release"})
        public static final class DisconnectedByRequest
        extends State {
            @NotNull
            public static final DisconnectedByRequest INSTANCE = new DisconnectedByRequest();

            private DisconnectedByRequest() {
                super(null);
            }
        }
    }
}

