/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.client.socket;

import io.getstream.chat.android.client.ChatClient;
import io.getstream.chat.android.client.logger.ChatLogger;
import io.getstream.chat.android.client.logger.TaggedLogger;
import io.getstream.chat.android.client.models.User;
import io.getstream.chat.android.client.parser.ChatParser;
import io.getstream.chat.android.client.socket.EventsParser;
import io.getstream.chat.android.client.socket.Socket;
import io.getstream.chat.android.client.token.TokenManager;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00162\u00020\u0001:\u0002\u0016\u0017B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000eJ\u0018\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00010\u0015*\u00020\u000eH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lio/getstream/chat/android/client/socket/SocketFactory;", "", "parser", "Lio/getstream/chat/android/client/parser/ChatParser;", "tokenManager", "Lio/getstream/chat/android/client/token/TokenManager;", "httpClient", "Lokhttp3/OkHttpClient;", "(Lio/getstream/chat/android/client/parser/ChatParser;Lio/getstream/chat/android/client/token/TokenManager;Lokhttp3/OkHttpClient;)V", "logger", "Lio/getstream/chat/android/client/logger/TaggedLogger;", "buildUrl", "", "connectionConf", "Lio/getstream/chat/android/client/socket/SocketFactory$ConnectionConf;", "buildUserDetailJson", "createSocket", "Lio/getstream/chat/android/client/socket/Socket;", "eventsParser", "Lio/getstream/chat/android/client/socket/EventsParser;", "reduceUserDetails", "", "Companion", "ConnectionConf", "stream-chat-android-client_release"})
public final class SocketFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ChatParser parser;
    @NotNull
    private final TokenManager tokenManager;
    @NotNull
    private final OkHttpClient httpClient;
    @NotNull
    private final TaggedLogger logger;
    @NotNull
    private static final String ANONYMOUS_USER_ID = "anon";

    public SocketFactory(@NotNull ChatParser parser, @NotNull TokenManager tokenManager, @NotNull OkHttpClient httpClient) {
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        Intrinsics.checkNotNullParameter((Object)tokenManager, (String)"tokenManager");
        Intrinsics.checkNotNullParameter((Object)httpClient, (String)"httpClient");
        this.parser = parser;
        this.tokenManager = tokenManager;
        this.httpClient = httpClient;
        String string2 = SocketFactory.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"SocketFactory::class.java.simpleName");
        this.logger = ChatLogger.Companion.get(string2);
    }

    public /* synthetic */ SocketFactory(ChatParser chatParser, TokenManager tokenManager, OkHttpClient okHttpClient, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            okHttpClient = new OkHttpClient();
        }
        this(chatParser, tokenManager, okHttpClient);
    }

    @NotNull
    public final Socket createSocket(@NotNull EventsParser eventsParser, @NotNull ConnectionConf connectionConf) throws UnsupportedEncodingException {
        Intrinsics.checkNotNullParameter((Object)((Object)eventsParser), (String)"eventsParser");
        Intrinsics.checkNotNullParameter((Object)connectionConf, (String)"connectionConf");
        String url = this.buildUrl(connectionConf);
        Request request = new Request.Builder().url(url).build();
        WebSocket newWebSocket = this.httpClient.newWebSocket(request, (WebSocketListener)eventsParser);
        this.logger.logI(Intrinsics.stringPlus((String)"new web socket: ", (Object)url));
        return new Socket(newWebSocket, this.parser);
    }

    private final String buildUrl(ConnectionConf connectionConf) throws UnsupportedEncodingException {
        String string2;
        String json = this.buildUserDetailJson(connectionConf);
        try {
            String string3;
            string2 = URLEncoder.encode(json, StandardCharsets.UTF_8.name());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"encode(json, StandardCharsets.UTF_8.name())");
            json = string2;
            String baseWsUrl = connectionConf.getEndpoint() + "connect?json=" + json + "&api_key=" + connectionConf.getApiKey();
            ConnectionConf connectionConf2 = connectionConf;
            if (connectionConf2 instanceof ConnectionConf.AnonymousConnectionConf) {
                string3 = Intrinsics.stringPlus((String)baseWsUrl, (Object)"&stream-auth-type=anonymous");
            } else if (connectionConf2 instanceof ConnectionConf.UserConnectionConf) {
                String token = this.tokenManager.getToken();
                string3 = baseWsUrl + "&authorization=" + token + "&stream-auth-type=jwt";
            } else {
                throw new NoWhenBranchMatchedException();
            }
            string2 = string3;
        }
        catch (Throwable _) {
            throw new UnsupportedEncodingException(Intrinsics.stringPlus((String)"Unable to encode user details json: ", (Object)json));
        }
        return string2;
    }

    private final String buildUserDetailJson(ConnectionConf connectionConf) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"user_details", this.reduceUserDetails(connectionConf)), TuplesKt.to((Object)"user_id", (Object)connectionConf.getUser().getId()), TuplesKt.to((Object)"server_determines_connection_id", (Object)true), TuplesKt.to((Object)"X-Stream-Client", (Object)ChatClient.Companion.buildSdkTrackingHeaders$stream_chat_android_client_release())};
        Map data = MapsKt.mapOf((Pair[])pairArray);
        return this.parser.toJson(data);
    }

    private final Map<String, Object> reduceUserDetails(ConnectionConf $this$reduceUserDetails) {
        Object object = new Pair[]{TuplesKt.to((Object)"id", (Object)$this$reduceUserDetails.getUser().getId())};
        Object $this$reduceUserDetails_u24lambda_u2d0 = object = MapsKt.mutableMapOf((Pair[])object);
        boolean bl = false;
        if (!$this$reduceUserDetails.isReconnection()) {
            $this$reduceUserDetails_u24lambda_u2d0.put("role", $this$reduceUserDetails.getUser().getRole());
            $this$reduceUserDetails_u24lambda_u2d0.put("banned", $this$reduceUserDetails.getUser().getBanned());
            $this$reduceUserDetails_u24lambda_u2d0.put("invisible", $this$reduceUserDetails.getUser().getInvisible());
            $this$reduceUserDetails_u24lambda_u2d0.put("teams", $this$reduceUserDetails.getUser().getTeams());
            if (!StringsKt.isBlank((CharSequence)$this$reduceUserDetails.getUser().getImage())) {
                $this$reduceUserDetails_u24lambda_u2d0.put("image", $this$reduceUserDetails.getUser().getImage());
            }
            if (!StringsKt.isBlank((CharSequence)$this$reduceUserDetails.getUser().getName())) {
                $this$reduceUserDetails_u24lambda_u2d0.put("name", $this$reduceUserDetails.getUser().getName());
            }
            $this$reduceUserDetails_u24lambda_u2d0.putAll($this$reduceUserDetails.getUser().getExtraData());
        }
        return object;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/getstream/chat/android/client/socket/SocketFactory$Companion;", "", "()V", "ANONYMOUS_USER_ID", "", "stream-chat-android-client_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001:\u0002\u0013\u0014B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\r\u0010\u0011\u001a\u00020\u0000H\u0000\u00a2\u0006\u0002\b\u0012R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u001e\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0012\u0010\r\u001a\u00020\u000eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u0082\u0001\u0002\u0015\u0016\u00a8\u0006\u0017"}, d2={"Lio/getstream/chat/android/client/socket/SocketFactory$ConnectionConf;", "", "()V", "apiKey", "", "getApiKey", "()Ljava/lang/String;", "endpoint", "getEndpoint", "<set-?>", "", "isReconnection", "()Z", "user", "Lio/getstream/chat/android/client/models/User;", "getUser", "()Lio/getstream/chat/android/client/models/User;", "asReconnectionConf", "asReconnectionConf$stream_chat_android_client_release", "AnonymousConnectionConf", "UserConnectionConf", "Lio/getstream/chat/android/client/socket/SocketFactory$ConnectionConf$AnonymousConnectionConf;", "Lio/getstream/chat/android/client/socket/SocketFactory$ConnectionConf$UserConnectionConf;", "stream-chat-android-client_release"})
    public static abstract class ConnectionConf {
        private boolean isReconnection;

        private ConnectionConf() {
        }

        public final boolean isReconnection() {
            return this.isReconnection;
        }

        @NotNull
        public abstract String getEndpoint();

        @NotNull
        public abstract String getApiKey();

        @NotNull
        public abstract User getUser();

        @NotNull
        public final ConnectionConf asReconnectionConf$stream_chat_android_client_release() {
            ConnectionConf connectionConf;
            ConnectionConf it = connectionConf = this;
            boolean bl = false;
            this.isReconnection = true;
            return connectionConf;
        }

        public /* synthetic */ ConnectionConf(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lio/getstream/chat/android/client/socket/SocketFactory$ConnectionConf$AnonymousConnectionConf;", "Lio/getstream/chat/android/client/socket/SocketFactory$ConnectionConf;", "endpoint", "", "apiKey", "(Ljava/lang/String;Ljava/lang/String;)V", "getApiKey", "()Ljava/lang/String;", "getEndpoint", "user", "Lio/getstream/chat/android/client/models/User;", "getUser", "()Lio/getstream/chat/android/client/models/User;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "stream-chat-android-client_release"})
        public static final class AnonymousConnectionConf
        extends ConnectionConf {
            @NotNull
            private final String endpoint;
            @NotNull
            private final String apiKey;
            @NotNull
            private final User user;

            public AnonymousConnectionConf(@NotNull String endpoint, @NotNull String apiKey) {
                Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
                Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
                super(null);
                this.endpoint = endpoint;
                this.apiKey = apiKey;
                this.user = new User(SocketFactory.ANONYMOUS_USER_ID, null, null, null, false, false, null, false, null, null, null, 0, 0, null, null, null, null, 131070, null);
            }

            @Override
            @NotNull
            public String getEndpoint() {
                return this.endpoint;
            }

            @Override
            @NotNull
            public String getApiKey() {
                return this.apiKey;
            }

            @Override
            @NotNull
            public User getUser() {
                return this.user;
            }

            @NotNull
            public final String component1() {
                return this.getEndpoint();
            }

            @NotNull
            public final String component2() {
                return this.getApiKey();
            }

            @NotNull
            public final AnonymousConnectionConf copy(@NotNull String endpoint, @NotNull String apiKey) {
                Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
                Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
                return new AnonymousConnectionConf(endpoint, apiKey);
            }

            public static /* synthetic */ AnonymousConnectionConf copy$default(AnonymousConnectionConf anonymousConnectionConf, String string2, String string3, int n, Object object) {
                if ((n & 1) != 0) {
                    string2 = anonymousConnectionConf.getEndpoint();
                }
                if ((n & 2) != 0) {
                    string3 = anonymousConnectionConf.getApiKey();
                }
                return anonymousConnectionConf.copy(string2, string3);
            }

            @NotNull
            public String toString() {
                return "AnonymousConnectionConf(endpoint=" + this.getEndpoint() + ", apiKey=" + this.getApiKey() + ')';
            }

            public int hashCode() {
                int result2 = this.getEndpoint().hashCode();
                result2 = result2 * 31 + this.getApiKey().hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof AnonymousConnectionConf)) {
                    return false;
                }
                AnonymousConnectionConf anonymousConnectionConf = (AnonymousConnectionConf)other;
                if (!Intrinsics.areEqual((Object)this.getEndpoint(), (Object)anonymousConnectionConf.getEndpoint())) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.getApiKey(), (Object)anonymousConnectionConf.getApiKey());
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Lio/getstream/chat/android/client/socket/SocketFactory$ConnectionConf$UserConnectionConf;", "Lio/getstream/chat/android/client/socket/SocketFactory$ConnectionConf;", "endpoint", "", "apiKey", "user", "Lio/getstream/chat/android/client/models/User;", "(Ljava/lang/String;Ljava/lang/String;Lio/getstream/chat/android/client/models/User;)V", "getApiKey", "()Ljava/lang/String;", "getEndpoint", "getUser", "()Lio/getstream/chat/android/client/models/User;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "stream-chat-android-client_release"})
        public static final class UserConnectionConf
        extends ConnectionConf {
            @NotNull
            private final String endpoint;
            @NotNull
            private final String apiKey;
            @NotNull
            private final User user;

            public UserConnectionConf(@NotNull String endpoint, @NotNull String apiKey, @NotNull User user) {
                Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
                Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
                Intrinsics.checkNotNullParameter((Object)user, (String)"user");
                super(null);
                this.endpoint = endpoint;
                this.apiKey = apiKey;
                this.user = user;
            }

            @Override
            @NotNull
            public String getEndpoint() {
                return this.endpoint;
            }

            @Override
            @NotNull
            public String getApiKey() {
                return this.apiKey;
            }

            @Override
            @NotNull
            public User getUser() {
                return this.user;
            }

            @NotNull
            public final String component1() {
                return this.getEndpoint();
            }

            @NotNull
            public final String component2() {
                return this.getApiKey();
            }

            @NotNull
            public final User component3() {
                return this.getUser();
            }

            @NotNull
            public final UserConnectionConf copy(@NotNull String endpoint, @NotNull String apiKey, @NotNull User user) {
                Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
                Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
                Intrinsics.checkNotNullParameter((Object)user, (String)"user");
                return new UserConnectionConf(endpoint, apiKey, user);
            }

            public static /* synthetic */ UserConnectionConf copy$default(UserConnectionConf userConnectionConf, String string2, String string3, User user, int n, Object object) {
                if ((n & 1) != 0) {
                    string2 = userConnectionConf.getEndpoint();
                }
                if ((n & 2) != 0) {
                    string3 = userConnectionConf.getApiKey();
                }
                if ((n & 4) != 0) {
                    user = userConnectionConf.getUser();
                }
                return userConnectionConf.copy(string2, string3, user);
            }

            @NotNull
            public String toString() {
                return "UserConnectionConf(endpoint=" + this.getEndpoint() + ", apiKey=" + this.getApiKey() + ", user=" + this.getUser() + ')';
            }

            public int hashCode() {
                int result2 = this.getEndpoint().hashCode();
                result2 = result2 * 31 + this.getApiKey().hashCode();
                result2 = result2 * 31 + this.getUser().hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof UserConnectionConf)) {
                    return false;
                }
                UserConnectionConf userConnectionConf = (UserConnectionConf)other;
                if (!Intrinsics.areEqual((Object)this.getEndpoint(), (Object)userConnectionConf.getEndpoint())) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.getApiKey(), (Object)userConnectionConf.getApiKey())) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.getUser(), (Object)userConnectionConf.getUser());
            }
        }
    }
}

