/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.client.experimental.socket.ws;

import io.getstream.chat.android.client.events.ChatEvent;
import io.getstream.chat.android.client.experimental.socket.Event;
import io.getstream.chat.android.client.experimental.socket.ShutdownReason;
import io.getstream.chat.android.client.experimental.socket.ws.OkHttpWebSocket;
import io.getstream.chat.android.client.experimental.socket.ws.WebSocketEventObserver;
import io.getstream.chat.android.client.parser.ChatParser;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import okhttp3.WebSocket;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\b\u0010\u000f\u001a\u00020\nH\u0002J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u0014J\u000e\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0016J\u000e\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0018R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lio/getstream/chat/android/client/experimental/socket/ws/OkHttpWebSocket;", "", "eventsObserver", "Lio/getstream/chat/android/client/experimental/socket/ws/WebSocketEventObserver;", "parser", "Lio/getstream/chat/android/client/parser/ChatParser;", "(Lio/getstream/chat/android/client/experimental/socket/ws/WebSocketEventObserver;Lio/getstream/chat/android/client/parser/ChatParser;)V", "webSocket", "Lokhttp3/WebSocket;", "cancel", "", "close", "", "shutdownReason", "Lio/getstream/chat/android/client/experimental/socket/ShutdownReason;", "handleConnectionShutdown", "handleWebSocketEvent", "event", "Lio/getstream/chat/android/client/experimental/socket/Event$WebSocket;", "open", "Lkotlinx/coroutines/flow/Flow;", "send", "Lio/getstream/chat/android/client/events/ChatEvent;", "bytes", "Lokio/ByteString;", "stream-chat-android-client_release"})
public final class OkHttpWebSocket {
    @NotNull
    private final WebSocketEventObserver eventsObserver;
    @NotNull
    private final ChatParser parser;
    @Nullable
    private WebSocket webSocket;

    public OkHttpWebSocket(@NotNull WebSocketEventObserver eventsObserver, @NotNull ChatParser parser) {
        Intrinsics.checkNotNullParameter((Object)((Object)eventsObserver), (String)"eventsObserver");
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        this.eventsObserver = eventsObserver;
        this.parser = parser;
    }

    @NotNull
    public final Flow<Event.WebSocket> open() {
        return FlowKt.onEach((Flow)((Flow)this.eventsObserver.getEventsFlow()), (Function2)((Function2)new Function2<Event.WebSocket, Continuation<? super Unit>, Object>((Object)this){

            @Nullable
            public final Object invoke(@NotNull Event.WebSocket p0, @NotNull Continuation<? super Unit> $completion) {
                return OkHttpWebSocket.access$open$handleWebSocketEvent((OkHttpWebSocket)open.1.access$getReceiver$p(this), p0, $completion);
            }

            public static final /* synthetic */ Object access$getReceiver$p(open.1 $this) {
                return $this.receiver;
            }
        }));
    }

    public final boolean send(@NotNull ChatEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        WebSocket webSocket = this.webSocket;
        return webSocket != null ? webSocket.send(this.parser.toJson(event)) : false;
    }

    public final boolean send(@NotNull ByteString bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        WebSocket webSocket = this.webSocket;
        return webSocket != null ? webSocket.send(bytes) : false;
    }

    public final boolean close(@NotNull ShutdownReason shutdownReason) {
        Intrinsics.checkNotNullParameter((Object)shutdownReason, (String)"shutdownReason");
        int code = shutdownReason.component1();
        String reasonText = shutdownReason.component2();
        WebSocket webSocket = this.webSocket;
        return webSocket != null ? webSocket.close(code, reasonText) : false;
    }

    private final void handleConnectionShutdown() {
        this.webSocket = null;
        this.eventsObserver.terminate();
    }

    public final void cancel() {
        Unit unit;
        WebSocket webSocket = this.webSocket;
        if (webSocket != null) {
            webSocket.cancel();
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            // empty if block
        }
    }

    private final void handleWebSocketEvent(Event.WebSocket event) {
        block1: {
            Event.WebSocket webSocket;
            block2: {
                block0: {
                    webSocket = event;
                    if (!(webSocket instanceof Event.WebSocket.OnConnectionOpened)) break block0;
                    Object WEB_SOCKET = ((Event.WebSocket.OnConnectionOpened)event).getWebSocket();
                    Intrinsics.checkNotNull(WEB_SOCKET, (String)"null cannot be cast to non-null type okhttp3.WebSocket");
                    this.webSocket = (WebSocket)WEB_SOCKET;
                    break block1;
                }
                if (!(webSocket instanceof Event.WebSocket.OnConnectionClosing)) break block2;
                this.close(ShutdownReason.GRACEFUL);
                break block1;
            }
            if (!(webSocket instanceof Event.WebSocket.OnConnectionClosed ? true : webSocket instanceof Event.WebSocket.OnConnectionFailed)) break block1;
            this.handleConnectionShutdown();
        }
    }

    private static final /* synthetic */ Object open$handleWebSocketEvent(OkHttpWebSocket $this$open_u24handleWebSocketEvent, Event.WebSocket p0, Continuation $completion) {
        $this$open_u24handleWebSocketEvent.handleWebSocketEvent(p0);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Object access$open$handleWebSocketEvent(OkHttpWebSocket $receiver, Event.WebSocket p0, Continuation $completion) {
        return OkHttpWebSocket.open$handleWebSocketEvent($receiver, p0, $completion);
    }
}

