/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.client.notifications.handler;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Build;
import android.service.notification.StatusBarNotification;
import androidx.annotation.RequiresApi;
import androidx.core.app.NotificationCompat;
import io.getstream.chat.android.client.ChatClient;
import io.getstream.chat.android.client.R;
import io.getstream.chat.android.client.events.NewMessageEvent;
import io.getstream.chat.android.client.models.Channel;
import io.getstream.chat.android.client.models.Message;
import io.getstream.chat.android.client.models.PushMessage;
import io.getstream.chat.android.client.models.User;
import io.getstream.chat.android.client.notifications.handler.MessagingStyleNotificationHandlerKt;
import io.getstream.chat.android.client.notifications.handler.NotificationHandler;
import io.getstream.chat.android.client.receivers.NotificationMessageReceiver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u0000 22\u00020\u0001:\u00012Bh\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012K\u0010\u0004\u001aG\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\n\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\f0\u0005\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002J\u0018\u0010&\u001a\u00020\u001f2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J\b\u0010'\u001a\u00020\u001dH\u0016J\u0018\u0010(\u001a\u00020\u001d2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J\u0010\u0010)\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010*\u001a\u00020\u0006H\u0002J\u000e\u0010+\u001a\b\u0012\u0004\u0012\u00020\u001f0,H\u0002J\u0010\u0010-\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0012\u0010.\u001a\u0004\u0018\u00010!2\u0006\u0010$\u001a\u00020%H\u0002J\u0018\u0010/\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020%2\u0006\u00100\u001a\u000201H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000RS\u0010\u0004\u001aG\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\n\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\f0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0011\u001a\u00020\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014R\u001b\u0010\u0017\u001a\u00020\u00188BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0016\u001a\u0004\b\u0019\u0010\u001a\u00a8\u00063"}, d2={"Lio/getstream/chat/android/client/notifications/handler/MessagingStyleNotificationHandler;", "Lio/getstream/chat/android/client/notifications/handler/NotificationHandler;", "context", "Landroid/content/Context;", "newMessageIntent", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "messageId", "channelType", "channelId", "Landroid/content/Intent;", "notificationChannel", "Lkotlin/Function0;", "Landroid/app/NotificationChannel;", "(Landroid/content/Context;Lkotlin/jvm/functions/Function3;Lkotlin/jvm/functions/Function0;)V", "notificationManager", "Landroid/app/NotificationManager;", "getNotificationManager", "()Landroid/app/NotificationManager;", "notificationManager$delegate", "Lkotlin/Lazy;", "sharedPreferences", "Landroid/content/SharedPreferences;", "getSharedPreferences", "()Landroid/content/SharedPreferences;", "sharedPreferences$delegate", "addNotificationId", "", "notificationId", "", "createMessagingStyle", "Landroidx/core/app/NotificationCompat$MessagingStyle;", "currentUser", "Lio/getstream/chat/android/client/models/User;", "channel", "Lio/getstream/chat/android/client/models/Channel;", "createNotificationId", "dismissAllNotifications", "dismissChannelNotifications", "dismissNotification", "getNotificationChannelId", "getShownNotifications", "", "removeNotificationId", "restoreMessagingStyle", "showNotification", "message", "Lio/getstream/chat/android/client/models/Message;", "Companion", "stream-chat-android-client_release"})
@RequiresApi(value=23)
public final class MessagingStyleNotificationHandler
implements NotificationHandler {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final Function3<String, String, String, Intent> newMessageIntent;
    @NotNull
    private final Function0<NotificationChannel> notificationChannel;
    @NotNull
    private final Lazy sharedPreferences$delegate;
    @NotNull
    private final Lazy notificationManager$delegate;
    @Deprecated
    @NotNull
    private static final String SHARED_PREFERENCES_NAME = "stream_notifications.sp";
    @Deprecated
    @NotNull
    private static final String KEY_NOTIFICATIONS_SHOWN = "KEY_NOTIFICATIONS_SHOWN";

    public MessagingStyleNotificationHandler(@NotNull Context context, @NotNull Function3<? super String, ? super String, ? super String, ? extends Intent> newMessageIntent, @NotNull Function0<NotificationChannel> notificationChannel) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(newMessageIntent, (String)"newMessageIntent");
        Intrinsics.checkNotNullParameter(notificationChannel, (String)"notificationChannel");
        this.context = context;
        this.newMessageIntent = newMessageIntent;
        this.notificationChannel = notificationChannel;
        this.sharedPreferences$delegate = LazyKt.lazy((Function0)((Function0)new Function0<SharedPreferences>(this){
            final /* synthetic */ MessagingStyleNotificationHandler this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final SharedPreferences invoke() {
                return MessagingStyleNotificationHandler.access$getContext$p(this.this$0).getSharedPreferences("stream_notifications.sp", 0);
            }
        }));
        this.notificationManager$delegate = LazyKt.lazy((Function0)((Function0)new Function0<NotificationManager>(this){
            final /* synthetic */ MessagingStyleNotificationHandler this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final NotificationManager invoke() {
                Object object = MessagingStyleNotificationHandler.access$getContext$p(this.this$0).getSystemService("notification");
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.app.NotificationManager");
                NotificationManager notificationManager2 = (NotificationManager)object;
                MessagingStyleNotificationHandler messagingStyleNotificationHandler = this.this$0;
                NotificationManager notificationManager3 = notificationManager2;
                boolean bl = false;
                if (Build.VERSION.SDK_INT >= 26) {
                    notificationManager3.createNotificationChannel((NotificationChannel)MessagingStyleNotificationHandler.access$getNotificationChannel$p(messagingStyleNotificationHandler).invoke());
                }
                return notificationManager2;
            }
        }));
    }

    private final SharedPreferences getSharedPreferences() {
        Lazy lazy = this.sharedPreferences$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-sharedPreferences>(...)");
        return (SharedPreferences)object;
    }

    private final NotificationManager getNotificationManager() {
        Lazy lazy = this.notificationManager$delegate;
        return (NotificationManager)lazy.getValue();
    }

    @Override
    public void showNotification(@NotNull Channel channel, @NotNull Message message) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        User user = ChatClient.Companion.instance().getCurrentUser();
        if (user == null && (user = ChatClient.Companion.instance().getStoredUser$stream_chat_android_client_release()) == null) {
            return;
        }
        User currentUser = user;
        int notificationId = this.createNotificationId(channel.getType(), channel.getId());
        PendingIntent contentPendingIntent = PendingIntent.getActivity((Context)this.context, (int)notificationId, (Intent)((Intent)this.newMessageIntent.invoke((Object)message.getId(), (Object)channel.getType(), (Object)channel.getId())), (int)0xC000000);
        NotificationCompat.MessagingStyle messagingStyle = this.restoreMessagingStyle(channel);
        if (messagingStyle == null) {
            messagingStyle = this.createMessagingStyle(currentUser, channel);
        }
        NotificationCompat.MessagingStyle initialMessagingStyle = messagingStyle;
        Notification notification = new NotificationCompat.Builder(this.context, this.getNotificationChannelId()).setSmallIcon(R.drawable.stream_ic_notification).setStyle((NotificationCompat.Style)initialMessagingStyle.addMessage(MessagingStyleNotificationHandlerKt.access$toMessagingStyleMessage(message, this.context))).setContentIntent(contentPendingIntent).addAction(NotificationMessageReceiver.Companion.createReadAction$stream_chat_android_client_release(this.context, notificationId, channel, message)).addAction(NotificationMessageReceiver.Companion.createReplyAction$stream_chat_android_client_release(this.context, notificationId, channel)).build();
        Intrinsics.checkNotNullExpressionValue((Object)notification, (String)"Builder(context, getNoti\u2026el))\n            .build()");
        Notification notification2 = notification;
        this.addNotificationId(notificationId);
        this.getNotificationManager().notify(notificationId, notification2);
    }

    @Override
    public void dismissChannelNotifications(@NotNull String channelType, @NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelType, (String)"channelType");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        this.dismissNotification(this.createNotificationId(channelType, channelId));
    }

    @Override
    public void dismissAllNotifications() {
        Iterable $this$forEach$iv = this.getShownNotifications();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int p0 = ((Number)element$iv).intValue();
            boolean bl = false;
            this.dismissNotification(p0);
        }
    }

    private final void dismissNotification(int notificationId) {
        this.removeNotificationId(notificationId);
        this.getNotificationManager().cancel(notificationId);
    }

    /*
     * WARNING - void declaration
     */
    private final void addNotificationId(int notificationId) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences();
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$addNotificationId_u24lambda_u2d1 = editor$iv;
        boolean bl = false;
        Iterable iterable = SetsKt.plus(this.getShownNotifications(), (Object)notificationId);
        String string2 = KEY_NOTIFICATIONS_SHOWN;
        SharedPreferences.Editor editor = $this$addNotificationId_u24lambda_u2d1;
        boolean $i$f$map = false;
        void var12_12 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            int n = ((Number)item$iv$iv).intValue();
            collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(String.valueOf((int)p0));
        }
        collection = (List)destination$iv$iv;
        editor.putStringSet(string2, CollectionsKt.toSet((Iterable)collection));
        editor$iv.apply();
    }

    /*
     * WARNING - void declaration
     */
    private final void removeNotificationId(int notificationId) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences();
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$removeNotificationId_u24lambda_u2d3 = editor$iv;
        boolean bl = false;
        Iterable iterable = SetsKt.minus(this.getShownNotifications(), (Object)notificationId);
        String string2 = KEY_NOTIFICATIONS_SHOWN;
        SharedPreferences.Editor editor = $this$removeNotificationId_u24lambda_u2d3;
        boolean $i$f$map = false;
        void var12_12 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            int n = ((Number)item$iv$iv).intValue();
            collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(String.valueOf((int)p0));
        }
        collection = (List)destination$iv$iv;
        editor.putStringSet(string2, CollectionsKt.toSet((Iterable)collection));
        editor$iv.apply();
    }

    /*
     * WARNING - void declaration
     */
    private final Set<Integer> getShownNotifications() {
        void $this$mapTo$iv$iv;
        Set set = this.getSharedPreferences().getStringSet(KEY_NOTIFICATIONS_SHOWN, null);
        if (set == null) {
            set = SetsKt.emptySet();
        }
        Iterable $this$map$iv = set;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Integer.parseInt((String)p0));
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    private final int createNotificationId(String channelType, String channelId) {
        return (channelType + ':' + channelId).hashCode();
    }

    private final NotificationCompat.MessagingStyle restoreMessagingStyle(Channel channel) {
        NotificationCompat.MessagingStyle messagingStyle;
        Notification notification;
        Object object;
        block3: {
            StatusBarNotification[] statusBarNotificationArray = this.getNotificationManager().getActiveNotifications();
            Intrinsics.checkNotNullExpressionValue((Object)statusBarNotificationArray, (String)"notificationManager.activeNotifications");
            Object[] $this$firstOrNull$iv = statusBarNotificationArray;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                StatusBarNotification it = (StatusBarNotification)element$iv;
                boolean bl = false;
                if (!(it.getId() == this.createNotificationId(channel.getType(), channel.getId()))) continue;
                object = element$iv;
                break block3;
            }
            object = null;
        }
        StatusBarNotification statusBarNotification = (StatusBarNotification)object;
        if (statusBarNotification != null && (notification = statusBarNotification.getNotification()) != null) {
            Notification p0 = notification;
            boolean bl = false;
            messagingStyle = NotificationCompat.MessagingStyle.extractMessagingStyleFromNotification((Notification)p0);
        } else {
            messagingStyle = null;
        }
        return messagingStyle;
    }

    private final NotificationCompat.MessagingStyle createMessagingStyle(User currentUser, Channel channel) {
        NotificationCompat.MessagingStyle messagingStyle = new NotificationCompat.MessagingStyle(MessagingStyleNotificationHandlerKt.access$toPerson(currentUser, this.context)).setConversationTitle((CharSequence)channel.getName()).setGroupConversation(!StringsKt.isBlank((CharSequence)channel.getName()));
        Intrinsics.checkNotNullExpressionValue((Object)messagingStyle, (String)"MessagingStyle(currentUs\u2026hannel.name.isNotBlank())");
        return messagingStyle;
    }

    private final String getNotificationChannelId() {
        String string2;
        if (Build.VERSION.SDK_INT >= 26) {
            String string3 = ((NotificationChannel)this.notificationChannel.invoke()).getId();
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"{\n            notificationChannel().id\n        }");
        } else {
            string2 = "";
        }
        return string2;
    }

    @Override
    public boolean onChatEvent(@NotNull NewMessageEvent event) {
        return NotificationHandler.DefaultImpls.onChatEvent(this, event);
    }

    @Override
    public boolean onPushMessage(@NotNull PushMessage message) {
        return NotificationHandler.DefaultImpls.onPushMessage(this, message);
    }

    public static final /* synthetic */ Context access$getContext$p(MessagingStyleNotificationHandler $this) {
        return $this.context;
    }

    public static final /* synthetic */ Function0 access$getNotificationChannel$p(MessagingStyleNotificationHandler $this) {
        return $this.notificationChannel;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/getstream/chat/android/client/notifications/handler/MessagingStyleNotificationHandler$Companion;", "", "()V", "KEY_NOTIFICATIONS_SHOWN", "", "SHARED_PREFERENCES_NAME", "stream-chat-android-client_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

