/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.client.uploader;

import io.getstream.chat.android.client.api.RetrofitCdnApi;
import io.getstream.chat.android.client.extensions.FileExtensionsKt;
import io.getstream.chat.android.client.models.UploadedFile;
import io.getstream.chat.android.client.models.UploadedImage;
import io.getstream.chat.android.client.uploader.FileUploader;
import io.getstream.chat.android.client.uploader.StreamFileUploader;
import io.getstream.chat.android.client.utils.ProgressCallback;
import io.getstream.chat.android.client.utils.Result;
import io.getstream.chat.android.client.utils.ResultKt;
import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J6\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\tH\u0016J6\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\tH\u0016J6\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J>\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J6\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J>\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lio/getstream/chat/android/client/uploader/StreamFileUploader;", "Lio/getstream/chat/android/client/uploader/FileUploader;", "retrofitCdnApi", "Lio/getstream/chat/android/client/api/RetrofitCdnApi;", "(Lio/getstream/chat/android/client/api/RetrofitCdnApi;)V", "deleteFile", "Lio/getstream/chat/android/client/utils/Result;", "", "channelType", "", "channelId", "userId", "connectionId", "url", "deleteImage", "sendFile", "Lio/getstream/chat/android/client/models/UploadedFile;", "file", "Ljava/io/File;", "callback", "Lio/getstream/chat/android/client/utils/ProgressCallback;", "sendImage", "Lio/getstream/chat/android/client/models/UploadedImage;", "stream-chat-android-client_release"})
public final class StreamFileUploader
implements FileUploader {
    @NotNull
    private final RetrofitCdnApi retrofitCdnApi;

    public StreamFileUploader(@NotNull RetrofitCdnApi retrofitCdnApi) {
        Intrinsics.checkNotNullParameter((Object)retrofitCdnApi, (String)"retrofitCdnApi");
        this.retrofitCdnApi = retrofitCdnApi;
    }

    @Override
    @NotNull
    public Result<UploadedFile> sendFile(@NotNull String channelType, @NotNull String channelId, @NotNull String userId, @NotNull String connectionId, @NotNull File file, @NotNull ProgressCallback callback2) {
        Intrinsics.checkNotNullParameter((Object)channelType, (String)"channelType");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)connectionId, (String)"connectionId");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
        RequestBody body = RequestBody.Companion.create(file, FileExtensionsKt.getMediaType(file));
        MultipartBody.Part part = MultipartBody.Part.Companion.createFormData("file", file.getName(), body);
        return ResultKt.map(this.retrofitCdnApi.sendFile(channelType, channelId, part, connectionId, callback2).execute(), (Function1)sendFile.1.INSTANCE);
    }

    @Override
    @NotNull
    public Result<UploadedFile> sendFile(@NotNull String channelType, @NotNull String channelId, @NotNull String userId, @NotNull String connectionId, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)channelType, (String)"channelType");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)connectionId, (String)"connectionId");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        RequestBody body = RequestBody.Companion.create(file, FileExtensionsKt.getMediaType(file));
        MultipartBody.Part part = MultipartBody.Part.Companion.createFormData("file", file.getName(), body);
        return ResultKt.map(this.retrofitCdnApi.sendFile(channelType, channelId, part, connectionId, null).execute(), (Function1)sendFile.2.INSTANCE);
    }

    @Override
    @NotNull
    public Result<UploadedImage> sendImage(@NotNull String channelType, @NotNull String channelId, @NotNull String userId, @NotNull String connectionId, @NotNull File file, @NotNull ProgressCallback callback2) {
        Intrinsics.checkNotNullParameter((Object)channelType, (String)"channelType");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)connectionId, (String)"connectionId");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
        RequestBody body = RequestBody.Companion.create(file, FileExtensionsKt.getMediaType(file));
        MultipartBody.Part part = MultipartBody.Part.Companion.createFormData("file", file.getName(), body);
        return ResultKt.map(this.retrofitCdnApi.sendImage(channelType, channelId, part, connectionId, callback2).execute(), (Function1)sendImage.1.INSTANCE);
    }

    @Override
    @NotNull
    public Result<UploadedImage> sendImage(@NotNull String channelType, @NotNull String channelId, @NotNull String userId, @NotNull String connectionId, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)channelType, (String)"channelType");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)connectionId, (String)"connectionId");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        RequestBody body = RequestBody.Companion.create(file, FileExtensionsKt.getMediaType(file));
        MultipartBody.Part part = MultipartBody.Part.Companion.createFormData("file", file.getName(), body);
        return ResultKt.map(this.retrofitCdnApi.sendImage(channelType, channelId, part, connectionId, null).execute(), (Function1)sendImage.2.INSTANCE);
    }

    @Override
    @NotNull
    public Result<Unit> deleteFile(@NotNull String channelType, @NotNull String channelId, @NotNull String userId, @NotNull String connectionId, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)channelType, (String)"channelType");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)connectionId, (String)"connectionId");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return ResultKt.toUnitResult(this.retrofitCdnApi.deleteFile(channelType, channelId, connectionId, url).execute());
    }

    @Override
    @NotNull
    public Result<Unit> deleteImage(@NotNull String channelType, @NotNull String channelId, @NotNull String userId, @NotNull String connectionId, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)channelType, (String)"channelType");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)connectionId, (String)"connectionId");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return ResultKt.toUnitResult(this.retrofitCdnApi.deleteImage(channelType, channelId, connectionId, url).execute());
    }
}

