/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.client.utils.internal;

import io.getstream.chat.android.client.utils.Result;
import io.getstream.chat.android.core.internal.InternalStreamChatApi;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u001a\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u00072\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"cidPattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "validateCid", "", "cid", "validateCidWithResult", "Lio/getstream/chat/android/client/utils/Result;", "stream-chat-android-client_release"})
public final class ValidationKt {
    private static final Pattern cidPattern = Pattern.compile("^([a-zA-z0-9]|!|-)+:([a-zA-z0-9]|!|-)+$");

    @InternalStreamChatApi
    @NotNull
    public static final String validateCid(@NotNull String cid) throws IllegalArgumentException {
        String string2;
        Intrinsics.checkNotNullParameter((Object)cid, (String)"cid");
        String $this$validateCid_u24lambda_u2d3 = string2 = cid;
        boolean bl = false;
        if (!(((CharSequence)cid).length() > 0)) {
            boolean $i$a$-require-ValidationKt$validateCid$1$42 = false;
            String $i$a$-require-ValidationKt$validateCid$1$42 = "cid can not be empty";
            throw new IllegalArgumentException($i$a$-require-ValidationKt$validateCid$1$42.toString());
        }
        if (!(!StringsKt.isBlank((CharSequence)cid))) {
            boolean $i$a$-require-ValidationKt$validateCid$1$52 = false;
            String $i$a$-require-ValidationKt$validateCid$1$52 = "cid can not be blank";
            throw new IllegalArgumentException($i$a$-require-ValidationKt$validateCid$1$52.toString());
        }
        if (!cidPattern.matcher(cid).matches()) {
            boolean bl2 = false;
            String string3 = "cid needs to be in the format channelType:channelId. For example, messaging:123";
            throw new IllegalArgumentException(string3.toString());
        }
        return string2;
    }

    @InternalStreamChatApi
    @NotNull
    public static final Result<String> validateCidWithResult(@NotNull String cid) {
        Result result;
        Intrinsics.checkNotNullParameter((Object)cid, (String)"cid");
        try {
            result = Result.Companion.success((Object)ValidationKt.validateCid(cid));
        }
        catch (IllegalArgumentException exception) {
            result = Result.Companion.error((Throwable)exception);
        }
        return result;
    }
}

