/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.client.api.interceptor;

import io.getstream.chat.android.client.errors.ChatError;
import io.getstream.chat.android.client.errors.ChatErrorCode;
import io.getstream.chat.android.client.errors.ChatRequestError;
import io.getstream.chat.android.client.parser.ChatParser;
import io.getstream.chat.android.client.token.TokenManager;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B%\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/getstream/chat/android/client/api/interceptor/TokenAuthInterceptor;", "Lokhttp3/Interceptor;", "tokenManager", "Lio/getstream/chat/android/client/token/TokenManager;", "parser", "Lio/getstream/chat/android/client/parser/ChatParser;", "isAnonymous", "Lkotlin/Function0;", "", "(Lio/getstream/chat/android/client/token/TokenManager;Lio/getstream/chat/android/client/parser/ChatParser;Lkotlin/jvm/functions/Function0;)V", "addTokenHeader", "Lokhttp3/Request;", "request", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "Companion", "stream-chat-android-client_release"})
public final class TokenAuthInterceptor
implements Interceptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TokenManager tokenManager;
    @NotNull
    private final ChatParser parser;
    @NotNull
    private final Function0<Boolean> isAnonymous;
    @NotNull
    public static final String AUTH_HEADER = "Authorization";

    public TokenAuthInterceptor(@NotNull TokenManager tokenManager, @NotNull ChatParser parser, @NotNull Function0<Boolean> isAnonymous) {
        Intrinsics.checkNotNullParameter((Object)tokenManager, (String)"tokenManager");
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        Intrinsics.checkNotNullParameter(isAnonymous, (String)"isAnonymous");
        this.tokenManager = tokenManager;
        this.parser = parser;
        this.isAnonymous = isAnonymous;
    }

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) {
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        if (((Boolean)this.isAnonymous.invoke()).booleanValue()) {
            return chain.proceed(chain.request());
        }
        if (!this.tokenManager.hasTokenProvider()) {
            String description = ChatErrorCode.UNDEFINED_TOKEN.getDescription();
            int code = ChatErrorCode.UNDEFINED_TOKEN.getCode();
            throw new ChatRequestError(description, code, -1, null, 8, null);
        }
        this.tokenManager.ensureTokenLoaded();
        Request request = this.addTokenHeader(chain.request());
        Response response = chain.proceed(request);
        if (!response.isSuccessful()) {
            ChatError.NetworkError err = this.parser.toError(response);
            if (err.getStreamCode() == ChatErrorCode.TOKEN_EXPIRED.getCode()) {
                this.tokenManager.expireToken();
                this.tokenManager.loadSync();
                response.close();
                response = chain.proceed(request);
            } else {
                throw new ChatRequestError(err.getMessage(), err.getStreamCode(), err.getStatusCode(), err.getCause());
            }
        }
        return response;
    }

    private final Request addTokenHeader(Request request) {
        Request request2;
        String token = this.tokenManager.getToken();
        boolean bl = false;
        try {
            request2 = request.newBuilder().header(AUTH_HEADER, token).build();
        }
        catch (IllegalArgumentException e) {
            throw new ChatRequestError(ChatErrorCode.INVALID_TOKEN.getDescription() + ": '" + token + '\'', ChatErrorCode.INVALID_TOKEN.getCode(), -1, e);
        }
        return request2;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/getstream/chat/android/client/api/interceptor/TokenAuthInterceptor$Companion;", "", "()V", "AUTH_HEADER", "", "stream-chat-android-client_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

