/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.client.helpers;

import io.getstream.chat.android.client.utils.TimeProvider;
import io.getstream.chat.android.core.internal.InternalStreamChatApi;
import io.getstream.chat.android.models.Attachment;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import okhttp3.HttpUrl;
import org.jetbrains.annotations.NotNull;

@InternalStreamChatApi
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lio/getstream/chat/android/client/helpers/AttachmentHelper;", "", "timeProvider", "Lio/getstream/chat/android/client/utils/TimeProvider;", "(Lio/getstream/chat/android/client/utils/TimeProvider;)V", "hasStreamImageUrl", "", "attachment", "Lio/getstream/chat/android/models/Attachment;", "hasValidImageUrl", "Companion", "stream-chat-android-client_release"})
public final class AttachmentHelper {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final TimeProvider timeProvider;
    @Deprecated
    @NotNull
    private static final String QUERY_KEY_NAME_EXPIRES = "Expires";
    @Deprecated
    @NotNull
    private static final Regex STREAM_CDN_HOST_PATTERN = new Regex("stream-chat-+.+\\.imgix.net$|.+\\.stream-io-cdn.com$", RegexOption.IGNORE_CASE);

    public AttachmentHelper(@NotNull TimeProvider timeProvider) {
        Intrinsics.checkNotNullParameter((Object)timeProvider, (String)"timeProvider");
        this.timeProvider = timeProvider;
    }

    public /* synthetic */ AttachmentHelper(TimeProvider timeProvider, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            timeProvider = TimeProvider.INSTANCE;
        }
        this(timeProvider);
    }

    public final boolean hasValidImageUrl(@NotNull Attachment attachment) {
        Intrinsics.checkNotNullParameter((Object)attachment, (String)"attachment");
        String string = attachment.getImageUrl();
        if (string == null || (string = HttpUrl.Companion.parse(string)) == null) {
            return false;
        }
        String url = string;
        if (!url.queryParameterNames().contains(QUERY_KEY_NAME_EXPIRES)) {
            return true;
        }
        Object object = url.queryParameter(QUERY_KEY_NAME_EXPIRES);
        if (object == null || (object = StringsKt.toLongOrNull((String)object)) == null) {
            return false;
        }
        long timestamp = (Long)object;
        return timestamp > this.timeProvider.provideCurrentTimeInSeconds();
    }

    public final boolean hasStreamImageUrl(@NotNull Attachment attachment) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)attachment, (String)"attachment");
        String string = attachment.getImageUrl();
        if (string != null && (string = HttpUrl.Companion.parse(string)) != null && (string = string.host()) != null) {
            String string2 = string;
            Regex regex = STREAM_CDN_HOST_PATTERN;
            CharSequence p0 = string2;
            boolean bl2 = false;
            bl = regex.matches(p0);
        } else {
            bl = false;
        }
        return bl;
    }

    public AttachmentHelper() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lio/getstream/chat/android/client/helpers/AttachmentHelper$Companion;", "", "()V", "QUERY_KEY_NAME_EXPIRES", "", "STREAM_CDN_HOST_PATTERN", "Lkotlin/text/Regex;", "stream-chat-android-client_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

