/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.client.interceptor.message.internal;

import io.getstream.chat.android.client.channel.ChannelMessagesUpdateLogic;
import io.getstream.chat.android.client.channel.state.ChannelStateLogicProvider;
import io.getstream.chat.android.client.extensions.AttachmentExtensionsKt;
import io.getstream.chat.android.client.extensions.MessageExtensionsKt;
import io.getstream.chat.android.client.extensions.internal.MessageKt;
import io.getstream.chat.android.client.interceptor.message.PrepareMessageLogic;
import io.getstream.chat.android.client.setup.state.ClientState;
import io.getstream.chat.android.client.utils.internal.MessageUtilsKt;
import io.getstream.chat.android.models.Attachment;
import io.getstream.chat.android.models.Channel;
import io.getstream.chat.android.models.Message;
import io.getstream.chat.android.models.SyncStatus;
import io.getstream.chat.android.models.User;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002J\b\u0010\n\u001a\u00020\bH\u0002J(\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/getstream/chat/android/client/interceptor/message/internal/PrepareMessageLogicImpl;", "Lio/getstream/chat/android/client/interceptor/message/PrepareMessageLogic;", "clientState", "Lio/getstream/chat/android/client/setup/state/ClientState;", "channelStateLogicProvider", "Lio/getstream/chat/android/client/channel/state/ChannelStateLogicProvider;", "(Lio/getstream/chat/android/client/setup/state/ClientState;Lio/getstream/chat/android/client/channel/state/ChannelStateLogicProvider;)V", "generateMessageId", "", "userId", "generateUploadId", "prepareMessage", "Lio/getstream/chat/android/models/Message;", "message", "channelId", "channelType", "user", "Lio/getstream/chat/android/models/User;", "stream-chat-android-client_release"})
public final class PrepareMessageLogicImpl
implements PrepareMessageLogic {
    @NotNull
    private final ClientState clientState;
    @Nullable
    private final ChannelStateLogicProvider channelStateLogicProvider;

    public PrepareMessageLogicImpl(@NotNull ClientState clientState, @Nullable ChannelStateLogicProvider channelStateLogicProvider) {
        Intrinsics.checkNotNullParameter((Object)clientState, (String)"clientState");
        this.clientState = clientState;
        this.channelStateLogicProvider = channelStateLogicProvider;
    }

    @Override
    @NotNull
    public Message prepareMessage(@NotNull Message message, @NotNull String channelId, @NotNull String channelType, @NotNull User user) {
        Message message2;
        block10: {
            Attachment attachment;
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
            Intrinsics.checkNotNullParameter((Object)channelType, (String)"channelType");
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            ChannelStateLogicProvider channelStateLogicProvider = this.channelStateLogicProvider;
            ChannelMessagesUpdateLogic channel = channelStateLogicProvider != null ? channelStateLogicProvider.channelStateLogic(channelType, channelId) : null;
            Message $this$prepareMessage_u24lambda_u243 = message2 = Message.copy$default((Message)message, null, null, null, null, null, null, null, null, null, (int)0, null, null, null, null, null, null, null, null, null, null, null, null, null, null, (boolean)false, (boolean)false, null, (boolean)false, null, null, null, (boolean)false, null, null, null, null, (int)-1, (int)15, null);
            boolean bl = false;
            if (((CharSequence)$this$prepareMessage_u24lambda_u243.getId()).length() == 0) {
                $this$prepareMessage_u24lambda_u243.setId(this.generateMessageId(user.getId()));
            }
            if (((CharSequence)$this$prepareMessage_u24lambda_u243.getCid()).length() == 0) {
                MessageExtensionsKt.enrichWithCid($this$prepareMessage_u24lambda_u243, channelType + ':' + channelId);
            }
            $this$prepareMessage_u24lambda_u243.setUser(user);
            Iterable $this$partition$iv = $this$prepareMessage_u24lambda_u243.getAttachments();
            boolean $i$f$partition = false;
            ArrayList first$iv = new ArrayList();
            ArrayList second$iv = new ArrayList();
            for (Object element$iv : $this$partition$iv) {
                Attachment it = (Attachment)element$iv;
                boolean bl2 = false;
                if (it.getUpload() != null) {
                    first$iv.add(element$iv);
                    continue;
                }
                second$iv.add(element$iv);
            }
            Pair pair = new Pair(first$iv, second$iv);
            List attachmentsToUpload = (List)pair.component1();
            List nonFileAttachments = (List)pair.component2();
            Iterable $this$forEach$iv = attachmentsToUpload;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                attachment = (Attachment)element$iv;
                boolean bl3 = false;
                if (AttachmentExtensionsKt.getUploadId(attachment) == null) {
                    AttachmentExtensionsKt.setUploadId(attachment, this.generateUploadId());
                }
                attachment.setUploadState((Attachment.UploadState)Attachment.UploadState.Idle.INSTANCE);
            }
            $this$forEach$iv = nonFileAttachments;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                attachment = (Attachment)element$iv;
                boolean bl4 = false;
                attachment.setUploadState((Attachment.UploadState)Attachment.UploadState.Success.INSTANCE);
            }
            $this$prepareMessage_u24lambda_u243.setType(MessageUtilsKt.getMessageType(message));
            Date date = $this$prepareMessage_u24lambda_u243.getCreatedAt();
            if (date == null && (date = $this$prepareMessage_u24lambda_u243.getCreatedLocallyAt()) == null) {
                date = new Date();
            }
            $this$prepareMessage_u24lambda_u243.setCreatedLocallyAt(date);
            $this$prepareMessage_u24lambda_u243.setSyncStatus(!((Collection)attachmentsToUpload).isEmpty() ? SyncStatus.AWAITING_ATTACHMENTS : (this.clientState.isNetworkAvailable() ? SyncStatus.IN_PROGRESS : SyncStatus.SYNC_NEEDED));
            Object object = channel;
            if (object != null && (object = object.listenForChannelState()) != null && (object = object.toChannel()) != null) {
                Object p0 = object;
                boolean bl5 = false;
                MessageKt.populateMentions(message, (Channel)p0);
            }
            Message preparedMessage = message2;
            boolean bl6 = false;
            if (preparedMessage.getReplyMessageId() == null) break block10;
            ChannelMessagesUpdateLogic channelMessagesUpdateLogic = channel;
            if (channelMessagesUpdateLogic != null) {
                channelMessagesUpdateLogic.replyMessage(null);
            }
        }
        return message2;
    }

    private final String generateMessageId(String userId) {
        return userId + '-' + UUID.randomUUID();
    }

    private final String generateUploadId() {
        return "upload_id_" + UUID.randomUUID();
    }
}

