/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.client.notifications;

import android.content.Context;
import io.getstream.android.push.PushDevice;
import io.getstream.android.push.PushDeviceGenerator;
import io.getstream.chat.android.client.ChatClient;
import io.getstream.chat.android.client.events.NewMessageEvent;
import io.getstream.chat.android.client.notifications.ChatNotifications;
import io.getstream.chat.android.client.notifications.ChatPushDelegateKt;
import io.getstream.chat.android.client.notifications.LoadNotificationDataWorker;
import io.getstream.chat.android.client.notifications.PushNotificationReceivedListener;
import io.getstream.chat.android.client.notifications.PushTokenUpdateHandler;
import io.getstream.chat.android.client.notifications.handler.NotificationConfig;
import io.getstream.chat.android.client.notifications.handler.NotificationHandler;
import io.getstream.chat.android.client.notifications.permissions.NotificationPermissionManager;
import io.getstream.chat.android.client.notifications.permissions.NotificationPermissionManagerImpl;
import io.getstream.chat.android.client.notifications.permissions.NotificationPermissionStatus;
import io.getstream.chat.android.core.internal.coroutines.DispatcherProvider;
import io.getstream.chat.android.models.Channel;
import io.getstream.chat.android.models.Device;
import io.getstream.chat.android.models.Message;
import io.getstream.chat.android.models.PushMessage;
import io.getstream.chat.android.models.User;
import io.getstream.log.Priority;
import io.getstream.log.StreamLog;
import io.getstream.log.StreamLogger;
import io.getstream.log.TaggedLogger;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0013H\u0016J\u0018\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\"H\u0002J \u0010#\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010$\u001a\u00020\u0013H\u0002J\u0019\u0010%\u001a\u00020\u00152\u0006\u0010&\u001a\u00020'H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010(J\u0010\u0010)\u001a\u00020\u00152\u0006\u0010*\u001a\u00020 H\u0016J\u0018\u0010+\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\"2\u0006\u0010,\u001a\u00020-H\u0016J\b\u0010.\u001a\u00020\u0015H\u0016J\u0011\u0010/\u001a\u00020\u0015H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00100J\u0010\u00101\u001a\u00020\u00152\u0006\u00102\u001a\u000203H\u0016J\u0010\u00104\u001a\u00020'2\u0006\u0010$\u001a\u00020\u0013H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00065"}, d2={"Lio/getstream/chat/android/client/notifications/ChatNotificationsImpl;", "Lio/getstream/chat/android/client/notifications/ChatNotifications;", "handler", "Lio/getstream/chat/android/client/notifications/handler/NotificationHandler;", "notificationConfig", "Lio/getstream/chat/android/client/notifications/handler/NotificationConfig;", "context", "Landroid/content/Context;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "(Lio/getstream/chat/android/client/notifications/handler/NotificationHandler;Lio/getstream/chat/android/client/notifications/handler/NotificationConfig;Landroid/content/Context;Lkotlinx/coroutines/CoroutineScope;)V", "logger", "Lio/getstream/log/TaggedLogger;", "permissionManager", "Lio/getstream/chat/android/client/notifications/permissions/NotificationPermissionManager;", "pushTokenUpdateHandler", "Lio/getstream/chat/android/client/notifications/PushTokenUpdateHandler;", "showedMessages", "", "", "cancelLoadDataWork", "", "dismissChannelNotifications", "channelType", "channelId", "displayNotification", "channel", "Lio/getstream/chat/android/models/Channel;", "message", "Lio/getstream/chat/android/models/Message;", "handleEvent", "event", "Lio/getstream/chat/android/client/events/NewMessageEvent;", "handlePushMessage", "Lio/getstream/chat/android/models/PushMessage;", "obtainNotificationData", "messageId", "onLogout", "flushPersistence", "", "(ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "onNewMessageEvent", "newMessageEvent", "onPushMessage", "pushNotificationReceivedListener", "Lio/getstream/chat/android/client/notifications/PushNotificationReceivedListener;", "onSetUser", "removeStoredDevice", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "setDevice", "device", "Lio/getstream/chat/android/models/Device;", "wasNotificationDisplayed", "stream-chat-android-client_release"})
public final class ChatNotificationsImpl
implements ChatNotifications {
    @NotNull
    private final NotificationHandler handler;
    @NotNull
    private final NotificationConfig notificationConfig;
    @NotNull
    private final Context context;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final TaggedLogger logger;
    @NotNull
    private final PushTokenUpdateHandler pushTokenUpdateHandler;
    @NotNull
    private final Set<String> showedMessages;
    @NotNull
    private final NotificationPermissionManager permissionManager;

    public ChatNotificationsImpl(@NotNull NotificationHandler handler, @NotNull NotificationConfig notificationConfig, @NotNull Context context, @NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Intrinsics.checkNotNullParameter((Object)notificationConfig, (String)"notificationConfig");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.handler = handler;
        this.notificationConfig = notificationConfig;
        this.context = context;
        this.scope = scope;
        this.logger = StreamLog.getLogger((String)"Chat:Notifications");
        this.pushTokenUpdateHandler = new PushTokenUpdateHandler(this.context);
        this.showedMessages = new LinkedHashSet();
        this.permissionManager = new NotificationPermissionManagerImpl(this.context, this.notificationConfig.getRequestPermissionOnAppLaunch(), (Function1<? super NotificationPermissionStatus, Unit>)((Function1)new Function1<NotificationPermissionStatus, Unit>(this){
            final /* synthetic */ ChatNotificationsImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull NotificationPermissionStatus status) {
                Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
                TaggedLogger this_$iv = ChatNotificationsImpl.access$getLogger$p(this.this$0);
                boolean $i$f$i = false;
                if (this_$iv.getValidator().isLoggable(Priority.INFO, this_$iv.getTag())) {
                    String string = this_$iv.getTag();
                    Priority priority = Priority.INFO;
                    StreamLogger streamLogger = this_$iv.getDelegate();
                    boolean bl = false;
                    String string2 = "[onPermissionStatus] status: " + (Object)((Object)status);
                    StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string, (String)string2, null, (int)8, null);
                }
                ChatNotificationsImpl.access$getHandler$p(this.this$0).onNotificationPermissionStatus(status);
            }
        }));
        TaggedLogger this_$iv = this.logger;
        boolean $i$f$i = false;
        if (this_$iv.getValidator().isLoggable(Priority.INFO, this_$iv.getTag())) {
            String string = this_$iv.getTag();
            Priority priority = Priority.INFO;
            StreamLogger streamLogger = this_$iv.getDelegate();
            boolean bl = false;
            String string2 = "<init> no args";
            StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string, (String)string2, null, (int)8, null);
        }
    }

    public /* synthetic */ ChatNotificationsImpl(NotificationHandler notificationHandler, NotificationConfig notificationConfig, Context context, CoroutineScope coroutineScope, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)DispatcherProvider.INSTANCE.getIO()));
        }
        this(notificationHandler, notificationConfig, context, coroutineScope);
    }

    @Override
    public void onSetUser() {
        block3: {
            Object v0;
            block2: {
                TaggedLogger this_$iv = this.logger;
                boolean $i$f$i = false;
                if (this_$iv.getValidator().isLoggable(Priority.INFO, this_$iv.getTag())) {
                    String string = this_$iv.getTag();
                    Priority priority = Priority.INFO;
                    StreamLogger streamLogger = this_$iv.getDelegate();
                    boolean bl = false;
                    String string2 = "[onSetUser] no args";
                    StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string, (String)string2, null, (int)8, null);
                }
                this.permissionManager.start();
                Iterable $this$firstOrNull$iv = this.notificationConfig.getPushDeviceGenerators();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    PushDeviceGenerator it = (PushDeviceGenerator)element$iv;
                    boolean bl = false;
                    if (!it.isValidForThisDevice(this.context)) continue;
                    v0 = element$iv;
                    break block2;
                }
                v0 = null;
            }
            PushDeviceGenerator pushDeviceGenerator = v0;
            if (pushDeviceGenerator == null) break block3;
            PushDeviceGenerator it = pushDeviceGenerator;
            boolean bl = false;
            it.onPushDeviceGeneratorSelected();
            it.asyncGeneratePushDevice((Function1)new Function1<PushDevice, Unit>(this){
                final /* synthetic */ ChatNotificationsImpl this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull PushDevice it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    this.this$0.setDevice(ChatPushDelegateKt.toDevice(it));
                }
            });
        }
    }

    @Override
    public void setDevice(@NotNull Device device) {
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        TaggedLogger this_$iv = this.logger;
        boolean $i$f$i = false;
        if (this_$iv.getValidator().isLoggable(Priority.INFO, this_$iv.getTag())) {
            String string = this_$iv.getTag();
            Priority priority = Priority.INFO;
            StreamLogger streamLogger = this_$iv.getDelegate();
            boolean bl = false;
            String string2 = "[setDevice] device: " + device;
            StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string, (String)string2, null, (int)8, null);
        }
        BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, device, null){
            int label;
            final /* synthetic */ ChatNotificationsImpl this$0;
            final /* synthetic */ Device $device;
            {
                this.this$0 = $receiver;
                this.$device = $device;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = ChatNotificationsImpl.access$getPushTokenUpdateHandler$p(this.this$0).updateDeviceIfNecessary(this.$device, (Continuation<? super Unit>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Override
    public void onPushMessage(@NotNull PushMessage message, @NotNull PushNotificationReceivedListener pushNotificationReceivedListener) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)pushNotificationReceivedListener, (String)"pushNotificationReceivedListener");
        TaggedLogger this_$iv = this.logger;
        boolean $i$f$i = false;
        if (this_$iv.getValidator().isLoggable(Priority.INFO, this_$iv.getTag())) {
            String string = this_$iv.getTag();
            Priority priority = Priority.INFO;
            StreamLogger streamLogger = this_$iv.getDelegate();
            boolean bl = false;
            String string2 = "[onReceivePushMessage] message: " + message;
            StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string, (String)string2, null, (int)8, null);
        }
        pushNotificationReceivedListener.onPushNotificationReceived(message.getChannelType(), message.getChannelId());
        if (((Boolean)this.notificationConfig.getShouldShowNotificationOnPush().invoke()).booleanValue() && !this.handler.onPushMessage(message)) {
            this.handlePushMessage(message);
        }
    }

    @Override
    public void onNewMessageEvent(@NotNull NewMessageEvent newMessageEvent) {
        String string;
        StreamLogger streamLogger;
        Priority priority;
        String string2;
        String currentUserId;
        Intrinsics.checkNotNullParameter((Object)newMessageEvent, (String)"newMessageEvent");
        User user = ChatClient.Companion.instance().getCurrentUser();
        String string3 = currentUserId = user != null ? user.getId() : null;
        if (Intrinsics.areEqual((Object)newMessageEvent.getMessage().getUser().getId(), (Object)currentUserId)) {
            return;
        }
        TaggedLogger this_$iv = this.logger;
        boolean $i$f$d = false;
        if (this_$iv.getValidator().isLoggable(Priority.DEBUG, this_$iv.getTag())) {
            string2 = this_$iv.getTag();
            priority = Priority.DEBUG;
            streamLogger = this_$iv.getDelegate();
            boolean bl = false;
            string = "[onNewMessageEvent] event: " + newMessageEvent;
            StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string, null, (int)8, null);
        }
        if (!this.handler.onChatEvent(newMessageEvent)) {
            this_$iv = this.logger;
            boolean $i$f$i = false;
            if (this_$iv.getValidator().isLoggable(Priority.INFO, this_$iv.getTag())) {
                string2 = this_$iv.getTag();
                priority = Priority.INFO;
                streamLogger = this_$iv.getDelegate();
                boolean bl = false;
                string = "[onNewMessageEvent] handle event internally";
                StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string, null, (int)8, null);
            }
            this.handleEvent(newMessageEvent);
        }
    }

    @Override
    @Nullable
    public Object onLogout(boolean flushPersistence, @NotNull Continuation<? super Unit> $completion) {
        TaggedLogger this_$iv = this.logger;
        boolean $i$f$i = false;
        if (this_$iv.getValidator().isLoggable(Priority.INFO, this_$iv.getTag())) {
            String string = this_$iv.getTag();
            Priority priority = Priority.INFO;
            StreamLogger streamLogger = this_$iv.getDelegate();
            boolean bl = false;
            String string2 = "[onLogout] no args";
            StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string, (String)string2, null, (int)8, null);
        }
        this.permissionManager.stop();
        this.handler.dismissAllNotifications();
        this.cancelLoadDataWork();
        if (flushPersistence) {
            Object object = this.removeStoredDevice($completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    private final void cancelLoadDataWork() {
        LoadNotificationDataWorker.Companion.cancel(this.context);
    }

    @Override
    public void dismissChannelNotifications(@NotNull String channelType, @NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelType, (String)"channelType");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        this.handler.dismissChannelNotifications(channelType, channelId);
    }

    private final void handlePushMessage(PushMessage message) {
        this.obtainNotificationData(message.getChannelId(), message.getChannelType(), message.getMessageId());
    }

    private final void obtainNotificationData(String channelId, String channelType, String messageId) {
        TaggedLogger this_$iv = this.logger;
        boolean $i$f$d = false;
        if (this_$iv.getValidator().isLoggable(Priority.DEBUG, this_$iv.getTag())) {
            String string = this_$iv.getTag();
            Priority priority = Priority.DEBUG;
            StreamLogger streamLogger = this_$iv.getDelegate();
            boolean bl = false;
            String string2 = "[obtainNotificationData] channelCid: " + channelId + ':' + channelType + ", messageId: " + messageId;
            StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string, (String)string2, null, (int)8, null);
        }
        LoadNotificationDataWorker.Companion.start(this.context, channelId, channelType, messageId);
    }

    private final void handleEvent(NewMessageEvent event) {
        this.obtainNotificationData(event.getChannelId(), event.getChannelType(), event.getMessage().getId());
    }

    private final boolean wasNotificationDisplayed(String messageId) {
        return this.showedMessages.contains(messageId);
    }

    @Override
    public void displayNotification(@NotNull Channel channel, @NotNull Message message) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        TaggedLogger this_$iv = this.logger;
        boolean $i$f$d = false;
        if (this_$iv.getValidator().isLoggable(Priority.DEBUG, this_$iv.getTag())) {
            String string = this_$iv.getTag();
            Priority priority = Priority.DEBUG;
            StreamLogger streamLogger = this_$iv.getDelegate();
            boolean bl = false;
            String string2 = "[displayNotification] channel.cid: " + channel.getCid() + ", message.cid: " + message.getCid();
            StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string, (String)string2, null, (int)8, null);
        }
        if (!this.wasNotificationDisplayed(message.getId())) {
            this.showedMessages.add(message.getId());
            this.handler.showNotification(channel, message);
        }
    }

    private final Object removeStoredDevice(Continuation<? super Unit> $completion) {
        Object object = this.pushTokenUpdateHandler.removeStoredDevice($completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ PushTokenUpdateHandler access$getPushTokenUpdateHandler$p(ChatNotificationsImpl $this) {
        return $this.pushTokenUpdateHandler;
    }

    public static final /* synthetic */ Object access$removeStoredDevice(ChatNotificationsImpl $this, Continuation $completion) {
        return $this.removeStoredDevice((Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ TaggedLogger access$getLogger$p(ChatNotificationsImpl $this) {
        return $this.logger;
    }

    public static final /* synthetic */ NotificationHandler access$getHandler$p(ChatNotificationsImpl $this) {
        return $this.handler;
    }
}

