/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.client.notifications.permissions;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.widget.Toast;
import io.getstream.chat.android.client.R;
import io.getstream.chat.android.client.notifications.permissions.ActivityLifecycleCallbacks;
import io.getstream.chat.android.client.notifications.permissions.NotificationPermissionHandler;
import io.getstream.log.Priority;
import io.getstream.log.StreamLog;
import io.getstream.log.StreamLogger;
import io.getstream.log.TaggedLogger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0004J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0007H\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0007H\u0016J\b\u0010\u000f\u001a\u00020\u000bH\u0016J\f\u0010\u0010\u001a\u00020\u000b*\u00020\u0007H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lio/getstream/chat/android/client/notifications/permissions/DefaultNotificationPermissionHandler;", "Lio/getstream/chat/android/client/notifications/permissions/NotificationPermissionHandler;", "Lio/getstream/chat/android/client/notifications/permissions/ActivityLifecycleCallbacks;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "currentActivity", "Landroid/app/Activity;", "logger", "Lio/getstream/log/TaggedLogger;", "finalize", "", "onActivityStarted", "activity", "onLastActivityStopped", "onPermissionDenied", "showNotificationBlocked", "stream-chat-android-client_release"})
public final class DefaultNotificationPermissionHandler
extends ActivityLifecycleCallbacks
implements NotificationPermissionHandler {
    @NotNull
    private final Context context;
    @NotNull
    private final TaggedLogger logger;
    @Nullable
    private Activity currentActivity;

    public DefaultNotificationPermissionHandler(@NotNull Context context) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this.context = context;
            this.logger = StreamLog.getLogger((String)"Chat:Default-NPH");
            Context context2 = this.context.getApplicationContext();
            Application application = context2 instanceof Application ? (Application)context2 : null;
            if (application == null) break block0;
            Context it = context2 = application;
            boolean bl = false;
            it.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        }
    }

    protected final void finalize() {
        block0: {
            Context context = this.context.getApplicationContext();
            Application application = context instanceof Application ? (Application)context : null;
            if (application == null) break block0;
            Context it = context = application;
            boolean bl = false;
            it.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        }
    }

    @Override
    public void onActivityStarted(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        super.onActivityStarted(activity);
        this.currentActivity = activity;
    }

    @Override
    public void onLastActivityStopped(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        super.onLastActivityStopped(activity);
        this.currentActivity = null;
    }

    @Override
    public void onPermissionDenied() {
        block1: {
            TaggedLogger this_$iv = this.logger;
            boolean $i$f$i = false;
            if (this_$iv.getValidator().isLoggable(Priority.INFO, this_$iv.getTag())) {
                String string2 = this_$iv.getTag();
                Priority priority = Priority.INFO;
                StreamLogger streamLogger = this_$iv.getDelegate();
                boolean bl = false;
                String string3 = "[onPermissionDenied] currentActivity: " + this.currentActivity;
                StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string3, null, (int)8, null);
            }
            Activity activity = this.currentActivity;
            if (activity == null) break block1;
            this.showNotificationBlocked(activity);
        }
    }

    private final void showNotificationBlocked(Activity $this$showNotificationBlocked) {
        Toast.makeText((Context)((Context)$this$showNotificationBlocked), (int)R.string.stream_ui_message_input_permission_notifications_message, (int)1).show();
    }

    @Override
    public void onPermissionRequested() {
        NotificationPermissionHandler.DefaultImpls.onPermissionRequested(this);
    }

    @Override
    public void onPermissionGranted() {
        NotificationPermissionHandler.DefaultImpls.onPermissionGranted(this);
    }

    @Override
    public void onPermissionRationale() {
        NotificationPermissionHandler.DefaultImpls.onPermissionRationale(this);
    }
}

