/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.client.notifications.permissions;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import android.view.ViewGroup;
import androidx.activity.ComponentActivity;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.annotation.RequiresApi;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import io.getstream.chat.android.client.R;
import io.getstream.chat.android.client.notifications.permissions.ActivityLifecycleCallbacks;
import io.getstream.chat.android.client.notifications.permissions.NotificationPermissionManager;
import io.getstream.chat.android.client.notifications.permissions.NotificationPermissionStatus;
import io.getstream.log.Priority;
import io.getstream.log.StreamLog;
import io.getstream.log.StreamLogger;
import io.getstream.log.TaggedLogger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0017\u001a\u00020\u000bH\u0004J\u001a\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000e2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000eH\u0016J\u0010\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000eH\u0016J\u0010\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000eH\u0016J\u0010\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000eH\u0016J\b\u0010 \u001a\u00020\u000bH\u0016J\b\u0010!\u001a\u00020\u000bH\u0016J\u0014\u0010\"\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010#*\u00020%H\u0002J\u001a\u0010&\u001a\u00020\u000b*\u00020%2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020$0#H\u0002J\f\u0010(\u001a\u00020\u000b*\u00020\u000eH\u0002J\f\u0010)\u001a\u00020\u000b*\u00020\u000eH\u0003J\f\u0010*\u001a\u00020\u000b*\u00020\u000eH\u0002J\f\u0010+\u001a\u00020\u000b*\u00020\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lio/getstream/chat/android/client/notifications/permissions/NotificationPermissionManagerImpl;", "Lio/getstream/chat/android/client/notifications/permissions/NotificationPermissionManager;", "Lio/getstream/chat/android/client/notifications/permissions/ActivityLifecycleCallbacks;", "context", "Landroid/content/Context;", "requestPermissionOnAppLaunch", "Lkotlin/Function0;", "", "onPermissionStatus", "Lkotlin/Function1;", "Lio/getstream/chat/android/client/notifications/permissions/NotificationPermissionStatus;", "", "(Landroid/content/Context;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;)V", "currentActivity", "Landroid/app/Activity;", "handler", "Landroid/os/Handler;", "logger", "Lio/getstream/log/TaggedLogger;", "permissionContract", "Landroidx/activity/result/contract/ActivityResultContracts$RequestPermission;", "permissionRequested", "started", "finalize", "onActivityCreated", "activity", "bunlde", "Landroid/os/Bundle;", "onActivityStarted", "onActivityStopped", "onFirstActivityStarted", "onLastActivityStopped", "start", "stop", "getActivityResultLauncher", "Landroidx/activity/result/ActivityResultLauncher;", "", "Landroid/view/View;", "putActivityResultLauncher", "launcher", "registerPermissionCallback", "requestPermission", "requestPermissionIfPossible", "unregisterPermissionCallback", "stream-chat-android-client_release"})
public final class NotificationPermissionManagerImpl
extends ActivityLifecycleCallbacks
implements NotificationPermissionManager {
    @NotNull
    private final Context context;
    @NotNull
    private final Function0<Boolean> requestPermissionOnAppLaunch;
    @NotNull
    private final Function1<NotificationPermissionStatus, Unit> onPermissionStatus;
    @NotNull
    private final TaggedLogger logger;
    @NotNull
    private final Handler handler;
    @NotNull
    private final ActivityResultContracts.RequestPermission permissionContract;
    private boolean started;
    private boolean permissionRequested;
    @Nullable
    private Activity currentActivity;

    public NotificationPermissionManagerImpl(@NotNull Context context, @NotNull Function0<Boolean> requestPermissionOnAppLaunch, @NotNull Function1<? super NotificationPermissionStatus, Unit> onPermissionStatus) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter(requestPermissionOnAppLaunch, (String)"requestPermissionOnAppLaunch");
            Intrinsics.checkNotNullParameter(onPermissionStatus, (String)"onPermissionStatus");
            this.context = context;
            this.requestPermissionOnAppLaunch = requestPermissionOnAppLaunch;
            this.onPermissionStatus = onPermissionStatus;
            this.logger = StreamLog.getLogger((String)"Chat:Notifications-PM");
            this.handler = new Handler(Looper.getMainLooper());
            this.permissionContract = new ActivityResultContracts.RequestPermission();
            Context context2 = this.context.getApplicationContext();
            Application application = context2 instanceof Application ? (Application)context2 : null;
            if (application == null) break block0;
            Context it = context2 = application;
            boolean bl = false;
            it.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        }
    }

    protected final void finalize() {
        block0: {
            Context context = this.context.getApplicationContext();
            Application application = context instanceof Application ? (Application)context : null;
            if (application == null) break block0;
            Context it = context = application;
            boolean bl = false;
            it.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        }
    }

    @Override
    public void start() {
        TaggedLogger this_$iv = this.logger;
        boolean $i$f$d = false;
        if (this_$iv.getValidator().isLoggable(Priority.DEBUG, this_$iv.getTag())) {
            String string2 = this_$iv.getTag();
            Priority priority = Priority.DEBUG;
            StreamLogger streamLogger = this_$iv.getDelegate();
            boolean bl = false;
            String string3 = "[start] no args";
            StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string3, null, (int)8, null);
        }
        this.handler.post(() -> NotificationPermissionManagerImpl.start$lambda$3(this));
    }

    @Override
    public void stop() {
        TaggedLogger this_$iv = this.logger;
        boolean $i$f$d = false;
        if (this_$iv.getValidator().isLoggable(Priority.DEBUG, this_$iv.getTag())) {
            String string2 = this_$iv.getTag();
            Priority priority = Priority.DEBUG;
            StreamLogger streamLogger = this_$iv.getDelegate();
            boolean bl = false;
            String string3 = "[stop] no args";
            StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string3, null, (int)8, null);
        }
        this.handler.post(() -> NotificationPermissionManagerImpl.stop$lambda$5(this));
    }

    @Override
    public void onActivityCreated(@NotNull Activity activity, @Nullable Bundle bunlde) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        TaggedLogger this_$iv = this.logger;
        boolean $i$f$v = false;
        if (this_$iv.getValidator().isLoggable(Priority.VERBOSE, this_$iv.getTag())) {
            String string2 = this_$iv.getTag();
            Priority priority = Priority.VERBOSE;
            StreamLogger streamLogger = this_$iv.getDelegate();
            boolean bl = false;
            String string3 = "[onActivityCreated] activity: " + activity;
            StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string3, null, (int)8, null);
        }
        super.onActivityCreated(activity, bunlde);
        this.currentActivity = activity;
    }

    @Override
    public void onActivityStarted(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        TaggedLogger this_$iv = this.logger;
        boolean $i$f$v = false;
        if (this_$iv.getValidator().isLoggable(Priority.VERBOSE, this_$iv.getTag())) {
            String string2 = this_$iv.getTag();
            Priority priority = Priority.VERBOSE;
            StreamLogger streamLogger = this_$iv.getDelegate();
            boolean bl = false;
            String string3 = "[onActivityStarted] activity: " + activity;
            StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string3, null, (int)8, null);
        }
        this.registerPermissionCallback(activity);
        super.onActivityStarted(activity);
        this.currentActivity = activity;
    }

    @Override
    public void onFirstActivityStarted(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        super.onFirstActivityStarted(activity);
        TaggedLogger this_$iv = this.logger;
        boolean $i$f$i = false;
        if (this_$iv.getValidator().isLoggable(Priority.INFO, this_$iv.getTag())) {
            String string2 = this_$iv.getTag();
            Priority priority = Priority.INFO;
            StreamLogger streamLogger = this_$iv.getDelegate();
            boolean bl = false;
            String string3 = "[onFirstActivityStarted] activity: " + activity;
            StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string3, null, (int)8, null);
        }
        this.requestPermissionIfPossible(activity);
    }

    @Override
    public void onActivityStopped(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        TaggedLogger this_$iv = this.logger;
        boolean $i$f$v = false;
        if (this_$iv.getValidator().isLoggable(Priority.VERBOSE, this_$iv.getTag())) {
            String string2 = this_$iv.getTag();
            Priority priority = Priority.VERBOSE;
            StreamLogger streamLogger = this_$iv.getDelegate();
            boolean bl = false;
            String string3 = "[onActivityStopped] activity: " + activity;
            StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string3, null, (int)8, null);
        }
        this.unregisterPermissionCallback(activity);
        super.onActivityStopped(activity);
    }

    @Override
    public void onLastActivityStopped(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        super.onLastActivityStopped(activity);
        TaggedLogger this_$iv = this.logger;
        boolean $i$f$i = false;
        if (this_$iv.getValidator().isLoggable(Priority.INFO, this_$iv.getTag())) {
            String string2 = this_$iv.getTag();
            Priority priority = Priority.INFO;
            StreamLogger streamLogger = this_$iv.getDelegate();
            boolean bl = false;
            String string3 = "[onLastActivityStopped] activity: " + activity;
            StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string3, null, (int)8, null);
        }
        this.permissionRequested = false;
        this.currentActivity = null;
    }

    private final void registerPermissionCallback(Activity $this$registerPermissionCallback) {
        String string2;
        StreamLogger streamLogger;
        Priority priority;
        String string3;
        if (!($this$registerPermissionCallback instanceof ComponentActivity)) {
            return;
        }
        if (Build.VERSION.SDK_INT < 33) {
            return;
        }
        TaggedLogger this_$iv = this.logger;
        boolean $i$f$i = false;
        if (this_$iv.getValidator().isLoggable(Priority.INFO, this_$iv.getTag())) {
            string3 = this_$iv.getTag();
            priority = Priority.INFO;
            streamLogger = this_$iv.getDelegate();
            boolean bl = false;
            string2 = "[registerPermissionCallback] activity: " + Reflection.getOrCreateKotlinClass($this$registerPermissionCallback.getClass()).getSimpleName();
            StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string3, (String)string2, null, (int)8, null);
        }
        ActivityResultLauncher activityResultLauncher = ((ComponentActivity)$this$registerPermissionCallback).registerForActivityResult((ActivityResultContract)this.permissionContract, arg_0 -> NotificationPermissionManagerImpl.registerPermissionCallback$lambda$13(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)activityResultLauncher, (String)"registerForActivityResul\u2026)\n            }\n        }");
        ActivityResultLauncher launcher = activityResultLauncher;
        TaggedLogger this_$iv2 = this.logger;
        boolean $i$f$v = false;
        if (this_$iv2.getValidator().isLoggable(Priority.VERBOSE, this_$iv2.getTag())) {
            string3 = this_$iv2.getTag();
            priority = Priority.VERBOSE;
            streamLogger = this_$iv2.getDelegate();
            boolean bl = false;
            string2 = "[registerPermissionCallback] launcher: " + launcher;
            StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string3, (String)string2, null, (int)8, null);
        }
        ViewGroup contentLayout = (ViewGroup)$this$registerPermissionCallback.findViewById(0x1020002);
        Intrinsics.checkNotNullExpressionValue((Object)contentLayout, (String)"contentLayout");
        this.putActivityResultLauncher((View)contentLayout, (ActivityResultLauncher<String>)launcher);
    }

    private final void unregisterPermissionCallback(Activity $this$unregisterPermissionCallback) {
        block3: {
            String string2;
            StreamLogger streamLogger;
            Priority priority;
            String string3;
            if (!($this$unregisterPermissionCallback instanceof ComponentActivity)) {
                return;
            }
            TaggedLogger this_$iv = this.logger;
            boolean $i$f$i = false;
            if (this_$iv.getValidator().isLoggable(Priority.INFO, this_$iv.getTag())) {
                string3 = this_$iv.getTag();
                priority = Priority.INFO;
                streamLogger = this_$iv.getDelegate();
                boolean bl = false;
                string2 = "[unregisterPermissionCallback] activity: " + Reflection.getOrCreateKotlinClass($this$unregisterPermissionCallback.getClass()).getSimpleName();
                StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string3, (String)string2, null, (int)8, null);
            }
            ViewGroup contentLayout = (ViewGroup)$this$unregisterPermissionCallback.findViewById(0x1020002);
            Intrinsics.checkNotNullExpressionValue((Object)contentLayout, (String)"contentLayout");
            ActivityResultLauncher<String> launcher = this.getActivityResultLauncher((View)contentLayout);
            TaggedLogger this_$iv2 = this.logger;
            boolean $i$f$v = false;
            if (this_$iv2.getValidator().isLoggable(Priority.VERBOSE, this_$iv2.getTag())) {
                string3 = this_$iv2.getTag();
                priority = Priority.VERBOSE;
                streamLogger = this_$iv2.getDelegate();
                boolean bl = false;
                string2 = "[unregisterPermissionCallback] found launcher: " + launcher;
                StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string3, (String)string2, null, (int)8, null);
            }
            ActivityResultLauncher<String> activityResultLauncher = launcher;
            if (activityResultLauncher == null) break block3;
            activityResultLauncher.unregister();
        }
    }

    private final void requestPermissionIfPossible(Activity $this$requestPermissionIfPossible) {
        boolean requestPermissionOnAppLaunch = (Boolean)this.requestPermissionOnAppLaunch.invoke();
        TaggedLogger this_$iv = this.logger;
        boolean $i$f$i = false;
        if (this_$iv.getValidator().isLoggable(Priority.INFO, this_$iv.getTag())) {
            String string2 = this_$iv.getTag();
            Priority priority = Priority.INFO;
            StreamLogger streamLogger = this_$iv.getDelegate();
            boolean bl = false;
            String string3 = "[requestPermissionIfPossible] started: " + this.started + ", permissionRequested: " + this.permissionRequested + ", requestPermissionOnAppLaunch: " + requestPermissionOnAppLaunch + ", ";
            StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string3, null, (int)8, null);
        }
        if (Build.VERSION.SDK_INT >= 33 && this.started && !this.permissionRequested && requestPermissionOnAppLaunch) {
            this.requestPermission($this$requestPermissionIfPossible);
            this.permissionRequested = true;
        }
    }

    @RequiresApi(value=33)
    private final void requestPermission(Activity $this$requestPermission) {
        String string2;
        StreamLogger streamLogger;
        Priority priority;
        String string3;
        TaggedLogger this_$iv = this.logger;
        boolean $i$f$d = false;
        if (this_$iv.getValidator().isLoggable(Priority.DEBUG, this_$iv.getTag())) {
            string3 = this_$iv.getTag();
            priority = Priority.DEBUG;
            streamLogger = this_$iv.getDelegate();
            boolean bl = false;
            string2 = "[requestPermission] no args";
            StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string3, (String)string2, null, (int)8, null);
        }
        if (Build.VERSION.SDK_INT < 33) {
            return;
        }
        if (ContextCompat.checkSelfPermission((Context)((Context)$this$requestPermission), (String)"android.permission.POST_NOTIFICATIONS") == 0) {
            this_$iv = this.logger;
            boolean $i$f$v = false;
            if (this_$iv.getValidator().isLoggable(Priority.VERBOSE, this_$iv.getTag())) {
                string3 = this_$iv.getTag();
                priority = Priority.VERBOSE;
                streamLogger = this_$iv.getDelegate();
                boolean bl = false;
                string2 = "[requestPermission] already granted";
                StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string3, (String)string2, null, (int)8, null);
            }
        } else if (ActivityCompat.shouldShowRequestPermissionRationale((Activity)$this$requestPermission, (String)"android.permission.POST_NOTIFICATIONS")) {
            this_$iv = this.logger;
            boolean $i$f$i = false;
            if (this_$iv.getValidator().isLoggable(Priority.INFO, this_$iv.getTag())) {
                string3 = this_$iv.getTag();
                priority = Priority.INFO;
                streamLogger = this_$iv.getDelegate();
                boolean bl = false;
                string2 = "[requestPermission] rationale requested";
                StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string3, (String)string2, null, (int)8, null);
            }
            this.onPermissionStatus.invoke((Object)NotificationPermissionStatus.RATIONALE_NEEDED);
        } else {
            ViewGroup contentLayout = (ViewGroup)$this$requestPermission.findViewById(0x1020002);
            Intrinsics.checkNotNullExpressionValue((Object)contentLayout, (String)"contentLayout");
            ActivityResultLauncher<String> launcher = this.getActivityResultLauncher((View)contentLayout);
            TaggedLogger this_$iv2 = this.logger;
            boolean $i$f$i = false;
            if (this_$iv2.getValidator().isLoggable(Priority.INFO, this_$iv2.getTag())) {
                string3 = this_$iv2.getTag();
                priority = Priority.INFO;
                streamLogger = this_$iv2.getDelegate();
                boolean bl = false;
                string2 = "[requestPermission] launcher: " + launcher;
                StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string3, (String)string2, null, (int)8, null);
            }
            ActivityResultLauncher<String> activityResultLauncher = launcher;
            if (activityResultLauncher != null) {
                activityResultLauncher.launch((Object)"android.permission.POST_NOTIFICATIONS");
            }
            this.onPermissionStatus.invoke((Object)NotificationPermissionStatus.REQUESTED);
        }
    }

    private final ActivityResultLauncher<String> getActivityResultLauncher(View $this$getActivityResultLauncher) {
        Object object = $this$getActivityResultLauncher.getTag(R.id.stream_post_notifications_permission);
        return object instanceof ActivityResultLauncher ? (ActivityResultLauncher)object : null;
    }

    private final void putActivityResultLauncher(View $this$putActivityResultLauncher, ActivityResultLauncher<String> launcher) {
        $this$putActivityResultLauncher.setTag(R.id.stream_post_notifications_permission, launcher);
    }

    private static final void start$lambda$3(NotificationPermissionManagerImpl this$0) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            this$0.started = true;
            Activity activity = this$0.currentActivity;
            if (activity == null) break block0;
            this$0.requestPermissionIfPossible(activity);
        }
    }

    private static final void stop$lambda$5(NotificationPermissionManagerImpl this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.started = false;
    }

    private static final void registerPermissionCallback$lambda$13(NotificationPermissionManagerImpl this$0, boolean isGranted) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        TaggedLogger this_$iv = this$0.logger;
        boolean $i$f$v = false;
        if (this_$iv.getValidator().isLoggable(Priority.VERBOSE, this_$iv.getTag())) {
            String string2 = this_$iv.getTag();
            Priority priority = Priority.VERBOSE;
            StreamLogger streamLogger = this_$iv.getDelegate();
            boolean bl = false;
            String string3 = "[registerPermissionCallback] completed: " + isGranted;
            StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string3, null, (int)8, null);
        }
        if (isGranted) {
            this$0.onPermissionStatus.invoke((Object)NotificationPermissionStatus.GRANTED);
        } else {
            this$0.onPermissionStatus.invoke((Object)NotificationPermissionStatus.DENIED);
        }
    }
}

