/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.client.parser;

import io.getstream.chat.android.client.errors.ChatError;
import io.getstream.chat.android.client.errors.ChatErrorCode;
import io.getstream.chat.android.client.errors.cause.MessageModerationFailedException;
import io.getstream.chat.android.client.socket.ErrorDetail;
import io.getstream.chat.android.client.socket.ErrorResponse;
import io.getstream.chat.android.client.utils.Result;
import io.getstream.log.Priority;
import io.getstream.log.StreamLog;
import io.getstream.log.StreamLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import retrofit2.Retrofit;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\u0018\u0002\n\u0000\b`\u0018\u00002\u00020\u0001J\u0016\u0010\u0004\u001a\u00020\u00032\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH&J-\u0010\u000b\u001a\u0002H\f\"\b\b\u0000\u0010\f*\u00020\u00012\u0006\u0010\r\u001a\u00020\u00032\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\f0\u000fH&\u00a2\u0006\u0002\u0010\u0010J.\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\f0\u0012\"\b\b\u0000\u0010\f*\u00020\u00012\u0006\u0010\r\u001a\u00020\u00032\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\f0\u000fH\u0016J\u0010\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0003H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u0001H&J\u000e\u0010\u001d\u001a\u0004\u0018\u00010\u001e*\u00020\u001fH\u0002R\u000b\u0010\u0002\u001a\u00020\u00038BX\u0082\u0004\u00a8\u0006 "}, d2={"Lio/getstream/chat/android/client/parser/ChatParser;", "", "tag", "", "buildDetailsTemplate", "details", "", "Lio/getstream/chat/android/client/socket/ErrorDetail;", "configRetrofit", "Lretrofit2/Retrofit$Builder;", "builder", "fromJson", "T", "raw", "clazz", "Ljava/lang/Class;", "(Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;", "fromJsonOrError", "Lio/getstream/chat/android/client/utils/Result;", "moreInfoTemplate", "moreInfo", "toError", "Lio/getstream/chat/android/client/errors/ChatError$NetworkError;", "okHttpResponse", "Lokhttp3/Response;", "errorResponseBody", "Lokhttp3/ResponseBody;", "toJson", "any", "extractCause", "", "Lio/getstream/chat/android/client/socket/ErrorResponse;", "stream-chat-android-client_release"})
public interface ChatParser {
    @NotNull
    public String toJson(@NotNull Object var1);

    @NotNull
    public <T> T fromJson(@NotNull String var1, @NotNull Class<T> var2);

    @NotNull
    public Retrofit.Builder configRetrofit(@NotNull Retrofit.Builder var1);

    @NotNull
    public <T> Result<T> fromJsonOrError(@NotNull String var1, @NotNull Class<T> var2);

    @NotNull
    public ChatError.NetworkError toError(@NotNull Response var1);

    @NotNull
    public ChatError.NetworkError toError(@NotNull ResponseBody var1);

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        private static String getTag(ChatParser $this) {
            return "Chat:ChatParser";
        }

        @NotNull
        public static <T> Result<T> fromJsonOrError(@NotNull ChatParser $this, @NotNull String raw, @NotNull Class<T> clazz) {
            Result result;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
            try {
                result = (Result)new Result.Success($this.fromJson(raw, clazz));
            }
            catch (Throwable expected) {
                result = (Result)new Result.Failure((ChatError)new ChatError.ThrowableError("fromJsonOrError error parsing of " + clazz + " into " + raw, expected));
            }
            return result;
        }

        @NotNull
        public static ChatError.NetworkError toError(@NotNull ChatParser $this, @NotNull Response okHttpResponse) {
            ChatError.NetworkError networkError;
            Intrinsics.checkNotNullParameter((Object)okHttpResponse, (String)"okHttpResponse");
            int statusCode = okHttpResponse.code();
            try {
                ChatError.NetworkError networkError2;
                String body = okHttpResponse.peekBody(Long.MAX_VALUE).string();
                if (((CharSequence)body).length() == 0) {
                    networkError2 = ChatError.NetworkError.Companion.fromChatErrorCode$default((ChatError.NetworkError.Companion)ChatError.NetworkError.Companion, (ChatErrorCode)ChatErrorCode.NO_ERROR_BODY, (int)statusCode, null, (int)4, null);
                } else {
                    Object object;
                    ErrorResponse errorResponse;
                    try {
                        errorResponse = $this.fromJson(body, ErrorResponse.class);
                    }
                    catch (Throwable _) {
                        object = new ErrorResponse(0, null, 0, null, null, null, 63, null);
                        ErrorResponse $this$toError_u24lambda_u240 = object;
                        boolean bl = false;
                        $this$toError_u24lambda_u240.setMessage(body);
                        errorResponse = object;
                    }
                    ErrorResponse error = errorResponse;
                    Throwable cause = DefaultImpls.extractCause($this, error);
                    int _ = error.getCode();
                    object = error.getMessage() + DefaultImpls.moreInfoTemplate($this, error.getMoreInfo()) + DefaultImpls.buildDetailsTemplate($this, error.getDetails());
                    networkError2 = new ChatError.NetworkError((String)object, _, statusCode, cause);
                }
                networkError = networkError2;
            }
            catch (Throwable expected) {
                String tag$iv = DefaultImpls.getTag($this);
                boolean $i$f$e = false;
                if (StreamLog.INSTANCE.getInternalValidator().isLoggable(Priority.ERROR, tag$iv)) {
                    String string2 = tag$iv;
                    Priority priority = Priority.ERROR;
                    StreamLogger streamLogger = StreamLog.INSTANCE.getInternalLogger();
                    boolean bl = false;
                    String string3 = "[toError] failed";
                    streamLogger.log(priority, string2, string3, expected);
                }
                ChatError.NetworkError.Companion companion = ChatError.NetworkError.Companion;
                ChatErrorCode chatErrorCode = ChatErrorCode.NETWORK_FAILED;
                networkError = companion.fromChatErrorCode(chatErrorCode, statusCode, expected);
            }
            return networkError;
        }

        @NotNull
        public static ChatError.NetworkError toError(@NotNull ChatParser $this, @NotNull ResponseBody errorResponseBody) {
            ChatError.NetworkError networkError;
            Intrinsics.checkNotNullParameter((Object)errorResponseBody, (String)"errorResponseBody");
            try {
                ErrorResponse errorResponse = $this.fromJson(errorResponseBody.string(), ErrorResponse.class);
                int code = errorResponse.component1();
                String message = errorResponse.component2();
                int statusCode = errorResponse.component3();
                String moreInfo = errorResponse.component5();
                String string2 = message + DefaultImpls.moreInfoTemplate($this, moreInfo);
                networkError = new ChatError.NetworkError(string2, code, statusCode, null, 8, null);
            }
            catch (Throwable expected) {
                String tag$iv = DefaultImpls.getTag($this);
                boolean $i$f$e = false;
                if (StreamLog.INSTANCE.getInternalValidator().isLoggable(Priority.ERROR, tag$iv)) {
                    String string3 = tag$iv;
                    Priority priority = Priority.ERROR;
                    StreamLogger streamLogger = StreamLog.INSTANCE.getInternalLogger();
                    boolean bl = false;
                    String string4 = "[toError] failed";
                    streamLogger.log(priority, string3, string4, expected);
                }
                networkError = ChatError.NetworkError.Companion.fromChatErrorCode$default((ChatError.NetworkError.Companion)ChatError.NetworkError.Companion, (ChatErrorCode)ChatErrorCode.NETWORK_FAILED, (int)0, (Throwable)expected, (int)2, null);
            }
            return networkError;
        }

        private static String moreInfoTemplate(ChatParser $this, String moreInfo) {
            return !StringsKt.isBlank((CharSequence)moreInfo) ? "\nMore information available at " + moreInfo : "";
        }

        private static String buildDetailsTemplate(ChatParser $this, List<ErrorDetail> details) {
            return !((Collection)details).isEmpty() ? "\nError details: " + details : "";
        }

        /*
         * WARNING - void declaration
         */
        private static Throwable extractCause(ChatParser $this, ErrorResponse $receiver) {
            if ($receiver.getCode() == ChatErrorCode.MESSAGE_MODERATION_FAILED.getCode()) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = $receiver.getDetails();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void detail;
                    ErrorDetail errorDetail = (ErrorDetail)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(new MessageModerationFailedException.Detail(detail.getCode(), detail.getMessages()));
                }
                String string2 = $receiver.getMessage();
                List list = (List)destination$iv$iv;
                return new MessageModerationFailedException(list, string2);
            }
            return null;
        }
    }
}

