/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.client.setup.state.internal;

import io.getstream.chat.android.client.network.NetworkStateProvider;
import io.getstream.chat.android.client.setup.state.ClientMutableState;
import io.getstream.chat.android.models.ConnectionState;
import io.getstream.chat.android.models.InitializationState;
import io.getstream.log.Priority;
import io.getstream.log.StreamLog;
import io.getstream.log.StreamLogger;
import io.getstream.log.TaggedLogger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\n\u001a\u00020\u0007H\u0016J\u0010\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\tH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0012R\u0014\u0010\u0014\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u0014\u0010\u0015\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0012R\u0014\u0010\u0016\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0012R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lio/getstream/chat/android/client/setup/state/internal/ClientStateImpl;", "Lio/getstream/chat/android/client/setup/state/ClientMutableState;", "networkStateProvider", "Lio/getstream/chat/android/client/network/NetworkStateProvider;", "(Lio/getstream/chat/android/client/network/NetworkStateProvider;)V", "_connectionState", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lio/getstream/chat/android/models/ConnectionState;", "_initializationState", "Lio/getstream/chat/android/models/InitializationState;", "connectionState", "Lkotlinx/coroutines/flow/StateFlow;", "getConnectionState", "()Lkotlinx/coroutines/flow/StateFlow;", "initializationState", "getInitializationState", "isConnecting", "", "()Z", "isInitialized", "isNetworkAvailable", "isOffline", "isOnline", "logger", "Lio/getstream/log/TaggedLogger;", "clearState", "", "setConnectionState", "setInitializationState", "state", "stream-chat-android-client_release"})
public final class ClientStateImpl
implements ClientMutableState {
    @NotNull
    private final NetworkStateProvider networkStateProvider;
    @NotNull
    private final TaggedLogger logger;
    @NotNull
    private final MutableStateFlow<InitializationState> _initializationState;
    @NotNull
    private final MutableStateFlow<ConnectionState> _connectionState;
    @NotNull
    private final StateFlow<ConnectionState> connectionState;

    public ClientStateImpl(@NotNull NetworkStateProvider networkStateProvider2) {
        Intrinsics.checkNotNullParameter((Object)networkStateProvider2, (String)"networkStateProvider");
        this.networkStateProvider = networkStateProvider2;
        this.logger = StreamLog.getLogger((String)"Chat:ClientState");
        this._initializationState = StateFlowKt.MutableStateFlow((Object)InitializationState.NOT_INITIALIZED);
        this._connectionState = StateFlowKt.MutableStateFlow((Object)ConnectionState.OFFLINE);
        this.connectionState = (StateFlow)this._connectionState;
    }

    @Override
    public boolean isOnline() {
        return this._connectionState.getValue() == ConnectionState.CONNECTED;
    }

    @Override
    public boolean isOffline() {
        return this._connectionState.getValue() == ConnectionState.OFFLINE;
    }

    @Override
    public boolean isConnecting() {
        return this._connectionState.getValue() == ConnectionState.CONNECTING;
    }

    @Override
    public boolean isInitialized() {
        return this._initializationState.getValue() == InitializationState.COMPLETE;
    }

    @Override
    @NotNull
    public StateFlow<InitializationState> getInitializationState() {
        return (StateFlow)this._initializationState;
    }

    @Override
    @NotNull
    public StateFlow<ConnectionState> getConnectionState() {
        return this.connectionState;
    }

    @Override
    public boolean isNetworkAvailable() {
        return this.networkStateProvider.isConnected();
    }

    @Override
    public void clearState() {
        TaggedLogger this_$iv = this.logger;
        boolean $i$f$d = false;
        if (this_$iv.getValidator().isLoggable(Priority.DEBUG, this_$iv.getTag())) {
            String string2 = this_$iv.getTag();
            Priority priority = Priority.DEBUG;
            StreamLogger streamLogger = this_$iv.getDelegate();
            boolean bl = false;
            String string3 = "[clearState] no args";
            StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string3, null, (int)8, null);
        }
        this._initializationState.setValue((Object)InitializationState.NOT_INITIALIZED);
        this._connectionState.setValue((Object)ConnectionState.OFFLINE);
    }

    @Override
    public void setConnectionState(@NotNull ConnectionState connectionState) {
        Intrinsics.checkNotNullParameter((Object)connectionState, (String)"connectionState");
        TaggedLogger this_$iv = this.logger;
        boolean $i$f$d = false;
        if (this_$iv.getValidator().isLoggable(Priority.DEBUG, this_$iv.getTag())) {
            String string2 = this_$iv.getTag();
            Priority priority = Priority.DEBUG;
            StreamLogger streamLogger = this_$iv.getDelegate();
            boolean bl = false;
            String string3 = "[setConnectionState] state: " + connectionState;
            StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string3, null, (int)8, null);
        }
        this._connectionState.setValue((Object)connectionState);
    }

    @Override
    public void setInitializationState(@NotNull InitializationState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this._initializationState.setValue((Object)state);
    }
}

