/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.client.socket;

import io.getstream.chat.android.client.errors.ChatError;
import io.getstream.chat.android.client.events.ConnectedEvent;
import io.getstream.chat.android.client.socket.ChatSocketStateService;
import io.getstream.chat.android.client.socket.SocketFactory;
import io.getstream.chat.android.core.internal.fsm.FiniteStateMachine;
import io.getstream.chat.android.core.internal.fsm.builder.FSMBuilder;
import io.getstream.chat.android.core.internal.fsm.builder.StateHandlerBuilder;
import io.getstream.log.Priority;
import io.getstream.log.StreamLog;
import io.getstream.log.StreamLogger;
import io.getstream.log.TaggedLogger;
import java.util.Map;
import kotlin.Function;
import kotlin.KotlinNothingValueException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.FunctionReferenceImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.reflect.KClass;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u00002\u00020\u0001:\u0002+,B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J%\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00160\u0018H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0019J\u000e\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020\u0016J\u000e\u0010!\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020#J\u0006\u0010$\u001a\u00020\u0016J\u000e\u0010%\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010&\u001a\u00020\u0016J\u0006\u0010'\u001a\u00020\u0016J\u0006\u0010(\u001a\u00020\u0016J\u000e\u0010)\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020#J\u0006\u0010*\u001a\u00020\u0016R\u0011\u0010\u0005\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R'\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00100\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006-"}, d2={"Lio/getstream/chat/android/client/socket/ChatSocketStateService;", "", "initialState", "Lio/getstream/chat/android/client/socket/ChatSocketStateService$State;", "(Lio/getstream/chat/android/client/socket/ChatSocketStateService$State;)V", "currentState", "getCurrentState", "()Lio/getstream/chat/android/client/socket/ChatSocketStateService$State;", "currentStateFlow", "Lkotlinx/coroutines/flow/StateFlow;", "getCurrentStateFlow", "()Lkotlinx/coroutines/flow/StateFlow;", "logger", "Lio/getstream/log/TaggedLogger;", "stateMachine", "Lio/getstream/chat/android/core/internal/fsm/FiniteStateMachine;", "Lio/getstream/chat/android/client/socket/ChatSocketStateService$Event;", "getStateMachine", "()Lio/getstream/chat/android/core/internal/fsm/FiniteStateMachine;", "stateMachine$delegate", "Lkotlin/Lazy;", "observer", "", "onNewState", "Lkotlin/Function1;", "(Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "onConnect", "connectionConf", "Lio/getstream/chat/android/client/socket/SocketFactory$ConnectionConf;", "onConnectionEstablished", "connectedEvent", "Lio/getstream/chat/android/client/events/ConnectedEvent;", "onNetworkAvailable", "onNetworkError", "error", "Lio/getstream/chat/android/client/errors/ChatError$NetworkError;", "onNetworkNotAvailable", "onReconnect", "onRequiredDisconnect", "onResume", "onStop", "onUnrecoverableError", "onWebSocketEventLost", "Event", "State", "stream-chat-android-client_release"})
public final class ChatSocketStateService {
    @NotNull
    private final TaggedLogger logger;
    @NotNull
    private final Lazy stateMachine$delegate;

    public ChatSocketStateService(@NotNull State initialState) {
        Intrinsics.checkNotNullParameter((Object)initialState, (String)"initialState");
        this.logger = StreamLog.getLogger((String)"Chat:SocketState");
        this.stateMachine$delegate = LazyKt.lazy((Function0)((Function0)new Function0<FiniteStateMachine<State, Event>>(initialState, this){
            final /* synthetic */ State $initialState;
            final /* synthetic */ ChatSocketStateService this$0;
            {
                this.$initialState = $initialState;
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final FiniteStateMachine<State, Event> invoke() {
                return FiniteStateMachine.Companion.invoke((Function1)new Function1<FSMBuilder<State, Event>, Unit>(this.$initialState, this.this$0){
                    final /* synthetic */ State $initialState;
                    final /* synthetic */ ChatSocketStateService this$0;
                    {
                        this.$initialState = $initialState;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull FSMBuilder<State, Event> $this$invoke) {
                        StateHandlerBuilder this_$iv;
                        Object object;
                        Intrinsics.checkNotNullParameter($this$invoke, (String)"$this$invoke");
                        $this$invoke.initialState((Object)this.$initialState);
                        $this$invoke.defaultHandler((Function2)new Function2<State, Event, State>(this.this$0){
                            final /* synthetic */ ChatSocketStateService this$0;
                            {
                                this.this$0 = $receiver;
                                super(2);
                            }

                            @NotNull
                            public final State invoke(@NotNull State state, @NotNull Event event) {
                                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                                TaggedLogger this_$iv = ChatSocketStateService.access$getLogger$p(this.this$0);
                                boolean $i$f$e = false;
                                if (this_$iv.getValidator().isLoggable(Priority.ERROR, this_$iv.getTag())) {
                                    String string2 = this_$iv.getTag();
                                    Priority priority = Priority.ERROR;
                                    StreamLogger streamLogger = this_$iv.getDelegate();
                                    boolean bl = false;
                                    String string3 = "Cannot handle event " + event + " while being in inappropriate state " + state;
                                    StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string3, null, (int)8, null);
                                }
                                return state;
                            }
                        });
                        FSMBuilder<State, Event> this_$iv2 = $this$invoke;
                        boolean $i$f$state = false;
                        Map map = this_$iv2.getStateFunctions();
                        KClass kClass = Reflection.getOrCreateKotlinClass(State.RestartConnection.class);
                        StateHandlerBuilder $this$invoke_u24lambda_u240 = object = new StateHandlerBuilder();
                        boolean bl = false;
                        StateHandlerBuilder stateHandlerBuilder = $this$invoke_u24lambda_u240;
                        Function2 func$iv = stateMachine.2.1.INSTANCE;
                        boolean $i$f$onEvent = false;
                        this_$iv.getEventHandlers().put(Reflection.getOrCreateKotlinClass(Event.Connect.class), (Function2)TypeIntrinsics.beforeCheckcastToFunctionOfArity((Object)func$iv, (int)2));
                        this_$iv = $this$invoke_u24lambda_u240;
                        func$iv = stateMachine.2.2.INSTANCE;
                        $i$f$onEvent = false;
                        this_$iv.getEventHandlers().put(Reflection.getOrCreateKotlinClass(Event.ConnectionEstablished.class), (Function2)TypeIntrinsics.beforeCheckcastToFunctionOfArity((Object)func$iv, (int)2));
                        this_$iv = $this$invoke_u24lambda_u240;
                        func$iv = stateMachine.2.3.INSTANCE;
                        $i$f$onEvent = false;
                        this_$iv.getEventHandlers().put(Reflection.getOrCreateKotlinClass(Event.WebSocketEventLost.class), (Function2)TypeIntrinsics.beforeCheckcastToFunctionOfArity((Object)func$iv, (int)2));
                        this_$iv = $this$invoke_u24lambda_u240;
                        func$iv = stateMachine.2.4.INSTANCE;
                        $i$f$onEvent = false;
                        this_$iv.getEventHandlers().put(Reflection.getOrCreateKotlinClass(Event.NetworkNotAvailable.class), (Function2)TypeIntrinsics.beforeCheckcastToFunctionOfArity((Object)func$iv, (int)2));
                        this_$iv = $this$invoke_u24lambda_u240;
                        func$iv = stateMachine.2.5.INSTANCE;
                        $i$f$onEvent = false;
                        this_$iv.getEventHandlers().put(Reflection.getOrCreateKotlinClass(Event.UnrecoverableError.class), (Function2)TypeIntrinsics.beforeCheckcastToFunctionOfArity((Object)func$iv, (int)2));
                        this_$iv = $this$invoke_u24lambda_u240;
                        func$iv = stateMachine.2.6.INSTANCE;
                        $i$f$onEvent = false;
                        this_$iv.getEventHandlers().put(Reflection.getOrCreateKotlinClass(Event.NetworkError.class), (Function2)TypeIntrinsics.beforeCheckcastToFunctionOfArity((Object)func$iv, (int)2));
                        this_$iv = $this$invoke_u24lambda_u240;
                        func$iv = stateMachine.2.7.INSTANCE;
                        $i$f$onEvent = false;
                        this_$iv.getEventHandlers().put(Reflection.getOrCreateKotlinClass(Event.RequiredDisconnection.class), (Function2)TypeIntrinsics.beforeCheckcastToFunctionOfArity((Object)func$iv, (int)2));
                        this_$iv = $this$invoke_u24lambda_u240;
                        func$iv = stateMachine.2.8.INSTANCE;
                        $i$f$onEvent = false;
                        this_$iv.getEventHandlers().put(Reflection.getOrCreateKotlinClass(Event.Stop.class), (Function2)TypeIntrinsics.beforeCheckcastToFunctionOfArity((Object)func$iv, (int)2));
                        object = object.get();
                        map.put(kClass, object);
                        this_$iv2 = $this$invoke;
                        $i$f$state = false;
                        map = this_$iv2.getStateFunctions();
                        kClass = Reflection.getOrCreateKotlinClass(State.Connecting.class);
                        Object $this$invoke_u24lambda_u241 = object = new StateHandlerBuilder();
                        boolean bl2 = false;
                        this_$iv = $this$invoke_u24lambda_u241;
                        func$iv = stateMachine.3.1.INSTANCE;
                        $i$f$onEvent = false;
                        this_$iv.getEventHandlers().put(Reflection.getOrCreateKotlinClass(Event.Connect.class), (Function2)TypeIntrinsics.beforeCheckcastToFunctionOfArity((Object)func$iv, (int)2));
                        this_$iv = $this$invoke_u24lambda_u241;
                        func$iv = stateMachine.3.2.INSTANCE;
                        $i$f$onEvent = false;
                        this_$iv.getEventHandlers().put(Reflection.getOrCreateKotlinClass(Event.ConnectionEstablished.class), (Function2)TypeIntrinsics.beforeCheckcastToFunctionOfArity((Object)func$iv, (int)2));
                        this_$iv = $this$invoke_u24lambda_u241;
                        func$iv = stateMachine.3.3.INSTANCE;
                        $i$f$onEvent = false;
                        this_$iv.getEventHandlers().put(Reflection.getOrCreateKotlinClass(Event.WebSocketEventLost.class), (Function2)TypeIntrinsics.beforeCheckcastToFunctionOfArity((Object)func$iv, (int)2));
                        this_$iv = $this$invoke_u24lambda_u241;
                        func$iv = stateMachine.3.4.INSTANCE;
                        $i$f$onEvent = false;
                        this_$iv.getEventHandlers().put(Reflection.getOrCreateKotlinClass(Event.NetworkNotAvailable.class), (Function2)TypeIntrinsics.beforeCheckcastToFunctionOfArity((Object)func$iv, (int)2));
                        this_$iv = $this$invoke_u24lambda_u241;
                        func$iv = stateMachine.3.5.INSTANCE;
                        $i$f$onEvent = false;
                        this_$iv.getEventHandlers().put(Reflection.getOrCreateKotlinClass(Event.UnrecoverableError.class), (Function2)TypeIntrinsics.beforeCheckcastToFunctionOfArity((Object)func$iv, (int)2));
                        this_$iv = $this$invoke_u24lambda_u241;
                        func$iv = stateMachine.3.6.INSTANCE;
                        $i$f$onEvent = false;
                        this_$iv.getEventHandlers().put(Reflection.getOrCreateKotlinClass(Event.NetworkError.class), (Function2)TypeIntrinsics.beforeCheckcastToFunctionOfArity((Object)func$iv, (int)2));
                        this_$iv = $this$invoke_u24lambda_u241;
                        func$iv = stateMachine.3.7.INSTANCE;
                        $i$f$onEvent = false;
                        this_$iv.getEventHandlers().put(Reflection.getOrCreateKotlinClass(Event.RequiredDisconnection.class), (Function2)TypeIntrinsics.beforeCheckcastToFunctionOfArity((Object)func$iv, (int)2));
                        this_$iv = $this$invoke_u24lambda_u241;
                        func$iv = stateMachine.3.8.INSTANCE;
                        $i$f$onEvent = false;
                        this_$iv.getEventHandlers().put(Reflection.getOrCreateKotlinClass(Event.Stop.class), (Function2)TypeIntrinsics.beforeCheckcastToFunctionOfArity((Object)func$iv, (int)2));
                        object = object.get();
                        map.put(kClass, object);
                        this_$iv2 = $this$invoke;
                        $i$f$state = false;
                        map = this_$iv2.getStateFunctions();
                        kClass = Reflection.getOrCreateKotlinClass(State.Connected.class);
                        Object $this$invoke_u24lambda_u242 = object = new StateHandlerBuilder();
                        boolean bl3 = false;
                        this_$iv = $this$invoke_u24lambda_u242;
                        func$iv = stateMachine.4.1.INSTANCE;
                        $i$f$onEvent = false;
                        this_$iv.getEventHandlers().put(Reflection.getOrCreateKotlinClass(Event.ConnectionEstablished.class), (Function2)TypeIntrinsics.beforeCheckcastToFunctionOfArity((Object)func$iv, (int)2));
                        this_$iv = $this$invoke_u24lambda_u242;
                        func$iv = stateMachine.4.2.INSTANCE;
                        $i$f$onEvent = false;
                        this_$iv.getEventHandlers().put(Reflection.getOrCreateKotlinClass(Event.WebSocketEventLost.class), (Function2)TypeIntrinsics.beforeCheckcastToFunctionOfArity((Object)func$iv, (int)2));
                        this_$iv = $this$invoke_u24lambda_u242;
                        func$iv = stateMachine.4.3.INSTANCE;
                        $i$f$onEvent = false;
                        this_$iv.getEventHandlers().put(Reflection.getOrCreateKotlinClass(Event.NetworkNotAvailable.class), (Function2)TypeIntrinsics.beforeCheckcastToFunctionOfArity((Object)func$iv, (int)2));
                        this_$iv = $this$invoke_u24lambda_u242;
                        func$iv = stateMachine.4.4.INSTANCE;
                        $i$f$onEvent = false;
                        this_$iv.getEventHandlers().put(Reflection.getOrCreateKotlinClass(Event.UnrecoverableError.class), (Function2)TypeIntrinsics.beforeCheckcastToFunctionOfArity((Object)func$iv, (int)2));
                        this_$iv = $this$invoke_u24lambda_u242;
                        func$iv = stateMachine.4.5.INSTANCE;
                        $i$f$onEvent = false;
                        this_$iv.getEventHandlers().put(Reflection.getOrCreateKotlinClass(Event.NetworkError.class), (Function2)TypeIntrinsics.beforeCheckcastToFunctionOfArity((Object)func$iv, (int)2));
                        this_$iv = $this$invoke_u24lambda_u242;
                        func$iv = stateMachine.4.6.INSTANCE;
                        $i$f$onEvent = false;
                        this_$iv.getEventHandlers().put(Reflection.getOrCreateKotlinClass(Event.RequiredDisconnection.class), (Function2)TypeIntrinsics.beforeCheckcastToFunctionOfArity((Object)func$iv, (int)2));
                        this_$iv = $this$invoke_u24lambda_u242;
                        func$iv = stateMachine.4.7.INSTANCE;
                        $i$f$onEvent = false;
                        this_$iv.getEventHandlers().put(Reflection.getOrCreateKotlinClass(Event.Stop.class), (Function2)TypeIntrinsics.beforeCheckcastToFunctionOfArity((Object)func$iv, (int)2));
                        object = object.get();
                        map.put(kClass, object);
                        this_$iv2 = $this$invoke;
                        $i$f$state = false;
                        map = this_$iv2.getStateFunctions();
                        kClass = Reflection.getOrCreateKotlinClass(State.Disconnected.Stopped.class);
                        Object $this$invoke_u24lambda_u243 = object = new StateHandlerBuilder();
                        boolean bl4 = false;
                        this_$iv = $this$invoke_u24lambda_u243;
                        func$iv = stateMachine.5.1.INSTANCE;
                        $i$f$onEvent = false;
                        this_$iv.getEventHandlers().put(Reflection.getOrCreateKotlinClass(Event.Connect.class), (Function2)TypeIntrinsics.beforeCheckcastToFunctionOfArity((Object)func$iv, (int)2));
                        this_$iv = $this$invoke_u24lambda_u243;
                        func$iv = stateMachine.5.2.INSTANCE;
                        $i$f$onEvent = false;
                        this_$iv.getEventHandlers().put(Reflection.getOrCreateKotlinClass(Event.Resume.class), (Function2)TypeIntrinsics.beforeCheckcastToFunctionOfArity((Object)func$iv, (int)2));
                        object = object.get();
                        map.put(kClass, object);
                        this_$iv2 = $this$invoke;
                        $i$f$state = false;
                        map = this_$iv2.getStateFunctions();
                        kClass = Reflection.getOrCreateKotlinClass(State.Disconnected.NetworkDisconnected.class);
                        Object $this$invoke_u24lambda_u244 = object = new StateHandlerBuilder();
                        boolean bl5 = false;
                        this_$iv = $this$invoke_u24lambda_u244;
                        func$iv = stateMachine.6.1.INSTANCE;
                        $i$f$onEvent = false;
                        this_$iv.getEventHandlers().put(Reflection.getOrCreateKotlinClass(Event.Connect.class), (Function2)TypeIntrinsics.beforeCheckcastToFunctionOfArity((Object)func$iv, (int)2));
                        this_$iv = $this$invoke_u24lambda_u244;
                        func$iv = stateMachine.6.2.INSTANCE;
                        $i$f$onEvent = false;
                        this_$iv.getEventHandlers().put(Reflection.getOrCreateKotlinClass(Event.ConnectionEstablished.class), (Function2)TypeIntrinsics.beforeCheckcastToFunctionOfArity((Object)func$iv, (int)2));
                        this_$iv = $this$invoke_u24lambda_u244;
                        func$iv = stateMachine.6.3.INSTANCE;
                        $i$f$onEvent = false;
                        this_$iv.getEventHandlers().put(Reflection.getOrCreateKotlinClass(Event.UnrecoverableError.class), (Function2)TypeIntrinsics.beforeCheckcastToFunctionOfArity((Object)func$iv, (int)2));
                        this_$iv = $this$invoke_u24lambda_u244;
                        func$iv = stateMachine.6.4.INSTANCE;
                        $i$f$onEvent = false;
                        this_$iv.getEventHandlers().put(Reflection.getOrCreateKotlinClass(Event.NetworkError.class), (Function2)TypeIntrinsics.beforeCheckcastToFunctionOfArity((Object)func$iv, (int)2));
                        this_$iv = $this$invoke_u24lambda_u244;
                        func$iv = stateMachine.6.5.INSTANCE;
                        $i$f$onEvent = false;
                        this_$iv.getEventHandlers().put(Reflection.getOrCreateKotlinClass(Event.RequiredDisconnection.class), (Function2)TypeIntrinsics.beforeCheckcastToFunctionOfArity((Object)func$iv, (int)2));
                        this_$iv = $this$invoke_u24lambda_u244;
                        func$iv = stateMachine.6.6.INSTANCE;
                        $i$f$onEvent = false;
                        this_$iv.getEventHandlers().put(Reflection.getOrCreateKotlinClass(Event.Stop.class), (Function2)TypeIntrinsics.beforeCheckcastToFunctionOfArity((Object)func$iv, (int)2));
                        this_$iv = $this$invoke_u24lambda_u244;
                        func$iv = stateMachine.6.7.INSTANCE;
                        $i$f$onEvent = false;
                        this_$iv.getEventHandlers().put(Reflection.getOrCreateKotlinClass(Event.NetworkAvailable.class), (Function2)TypeIntrinsics.beforeCheckcastToFunctionOfArity((Object)func$iv, (int)2));
                        object = object.get();
                        map.put(kClass, object);
                        this_$iv2 = $this$invoke;
                        $i$f$state = false;
                        map = this_$iv2.getStateFunctions();
                        kClass = Reflection.getOrCreateKotlinClass(State.Disconnected.WebSocketEventLost.class);
                        Object $this$invoke_u24lambda_u245 = object = new StateHandlerBuilder();
                        boolean bl6 = false;
                        this_$iv = $this$invoke_u24lambda_u245;
                        func$iv = stateMachine.7.1.INSTANCE;
                        $i$f$onEvent = false;
                        this_$iv.getEventHandlers().put(Reflection.getOrCreateKotlinClass(Event.Connect.class), (Function2)TypeIntrinsics.beforeCheckcastToFunctionOfArity((Object)func$iv, (int)2));
                        this_$iv = $this$invoke_u24lambda_u245;
                        func$iv = stateMachine.7.2.INSTANCE;
                        $i$f$onEvent = false;
                        this_$iv.getEventHandlers().put(Reflection.getOrCreateKotlinClass(Event.ConnectionEstablished.class), (Function2)TypeIntrinsics.beforeCheckcastToFunctionOfArity((Object)func$iv, (int)2));
                        this_$iv = $this$invoke_u24lambda_u245;
                        func$iv = stateMachine.7.3.INSTANCE;
                        $i$f$onEvent = false;
                        this_$iv.getEventHandlers().put(Reflection.getOrCreateKotlinClass(Event.NetworkNotAvailable.class), (Function2)TypeIntrinsics.beforeCheckcastToFunctionOfArity((Object)func$iv, (int)2));
                        this_$iv = $this$invoke_u24lambda_u245;
                        func$iv = stateMachine.7.4.INSTANCE;
                        $i$f$onEvent = false;
                        this_$iv.getEventHandlers().put(Reflection.getOrCreateKotlinClass(Event.UnrecoverableError.class), (Function2)TypeIntrinsics.beforeCheckcastToFunctionOfArity((Object)func$iv, (int)2));
                        this_$iv = $this$invoke_u24lambda_u245;
                        func$iv = stateMachine.7.5.INSTANCE;
                        $i$f$onEvent = false;
                        this_$iv.getEventHandlers().put(Reflection.getOrCreateKotlinClass(Event.NetworkError.class), (Function2)TypeIntrinsics.beforeCheckcastToFunctionOfArity((Object)func$iv, (int)2));
                        this_$iv = $this$invoke_u24lambda_u245;
                        func$iv = stateMachine.7.6.INSTANCE;
                        $i$f$onEvent = false;
                        this_$iv.getEventHandlers().put(Reflection.getOrCreateKotlinClass(Event.RequiredDisconnection.class), (Function2)TypeIntrinsics.beforeCheckcastToFunctionOfArity((Object)func$iv, (int)2));
                        this_$iv = $this$invoke_u24lambda_u245;
                        func$iv = stateMachine.7.7.INSTANCE;
                        $i$f$onEvent = false;
                        this_$iv.getEventHandlers().put(Reflection.getOrCreateKotlinClass(Event.Stop.class), (Function2)TypeIntrinsics.beforeCheckcastToFunctionOfArity((Object)func$iv, (int)2));
                        object = object.get();
                        map.put(kClass, object);
                        this_$iv2 = $this$invoke;
                        $i$f$state = false;
                        map = this_$iv2.getStateFunctions();
                        kClass = Reflection.getOrCreateKotlinClass(State.Disconnected.DisconnectedByRequest.class);
                        Object $this$invoke_u24lambda_u246 = object = new StateHandlerBuilder();
                        boolean bl7 = false;
                        this_$iv = $this$invoke_u24lambda_u246;
                        func$iv = stateMachine.8.1.INSTANCE;
                        $i$f$onEvent = false;
                        this_$iv.getEventHandlers().put(Reflection.getOrCreateKotlinClass(Event.Connect.class), (Function2)TypeIntrinsics.beforeCheckcastToFunctionOfArity((Object)func$iv, (int)2));
                        object = object.get();
                        map.put(kClass, object);
                        this_$iv2 = $this$invoke;
                        $i$f$state = false;
                        map = this_$iv2.getStateFunctions();
                        kClass = Reflection.getOrCreateKotlinClass(State.Disconnected.DisconnectedTemporarily.class);
                        Object $this$invoke_u24lambda_u247 = object = new StateHandlerBuilder();
                        boolean bl8 = false;
                        this_$iv = $this$invoke_u24lambda_u247;
                        func$iv = stateMachine.9.1.INSTANCE;
                        $i$f$onEvent = false;
                        this_$iv.getEventHandlers().put(Reflection.getOrCreateKotlinClass(Event.Connect.class), (Function2)TypeIntrinsics.beforeCheckcastToFunctionOfArity((Object)func$iv, (int)2));
                        this_$iv = $this$invoke_u24lambda_u247;
                        func$iv = stateMachine.9.2.INSTANCE;
                        $i$f$onEvent = false;
                        this_$iv.getEventHandlers().put(Reflection.getOrCreateKotlinClass(Event.ConnectionEstablished.class), (Function2)TypeIntrinsics.beforeCheckcastToFunctionOfArity((Object)func$iv, (int)2));
                        this_$iv = $this$invoke_u24lambda_u247;
                        func$iv = stateMachine.9.3.INSTANCE;
                        $i$f$onEvent = false;
                        this_$iv.getEventHandlers().put(Reflection.getOrCreateKotlinClass(Event.NetworkNotAvailable.class), (Function2)TypeIntrinsics.beforeCheckcastToFunctionOfArity((Object)func$iv, (int)2));
                        this_$iv = $this$invoke_u24lambda_u247;
                        func$iv = stateMachine.9.4.INSTANCE;
                        $i$f$onEvent = false;
                        this_$iv.getEventHandlers().put(Reflection.getOrCreateKotlinClass(Event.WebSocketEventLost.class), (Function2)TypeIntrinsics.beforeCheckcastToFunctionOfArity((Object)func$iv, (int)2));
                        this_$iv = $this$invoke_u24lambda_u247;
                        func$iv = stateMachine.9.5.INSTANCE;
                        $i$f$onEvent = false;
                        this_$iv.getEventHandlers().put(Reflection.getOrCreateKotlinClass(Event.UnrecoverableError.class), (Function2)TypeIntrinsics.beforeCheckcastToFunctionOfArity((Object)func$iv, (int)2));
                        this_$iv = $this$invoke_u24lambda_u247;
                        func$iv = stateMachine.9.6.INSTANCE;
                        $i$f$onEvent = false;
                        this_$iv.getEventHandlers().put(Reflection.getOrCreateKotlinClass(Event.NetworkError.class), (Function2)TypeIntrinsics.beforeCheckcastToFunctionOfArity((Object)func$iv, (int)2));
                        this_$iv = $this$invoke_u24lambda_u247;
                        func$iv = stateMachine.9.7.INSTANCE;
                        $i$f$onEvent = false;
                        this_$iv.getEventHandlers().put(Reflection.getOrCreateKotlinClass(Event.RequiredDisconnection.class), (Function2)TypeIntrinsics.beforeCheckcastToFunctionOfArity((Object)func$iv, (int)2));
                        this_$iv = $this$invoke_u24lambda_u247;
                        func$iv = stateMachine.9.8.INSTANCE;
                        $i$f$onEvent = false;
                        this_$iv.getEventHandlers().put(Reflection.getOrCreateKotlinClass(Event.Stop.class), (Function2)TypeIntrinsics.beforeCheckcastToFunctionOfArity((Object)func$iv, (int)2));
                        object = object.get();
                        map.put(kClass, object);
                        this_$iv2 = $this$invoke;
                        $i$f$state = false;
                        map = this_$iv2.getStateFunctions();
                        kClass = Reflection.getOrCreateKotlinClass(State.Disconnected.DisconnectedPermanently.class);
                        Object $this$invoke_u24lambda_u248 = object = new StateHandlerBuilder();
                        boolean bl9 = false;
                        this_$iv = $this$invoke_u24lambda_u248;
                        func$iv = stateMachine.10.1.INSTANCE;
                        $i$f$onEvent = false;
                        this_$iv.getEventHandlers().put(Reflection.getOrCreateKotlinClass(Event.Connect.class), (Function2)TypeIntrinsics.beforeCheckcastToFunctionOfArity((Object)func$iv, (int)2));
                        this_$iv = $this$invoke_u24lambda_u248;
                        func$iv = stateMachine.10.2.INSTANCE;
                        $i$f$onEvent = false;
                        this_$iv.getEventHandlers().put(Reflection.getOrCreateKotlinClass(Event.RequiredDisconnection.class), (Function2)TypeIntrinsics.beforeCheckcastToFunctionOfArity((Object)func$iv, (int)2));
                        object = object.get();
                        map.put(kClass, object);
                    }
                });
            }
        }));
    }

    public /* synthetic */ ChatSocketStateService(State state, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            state = State.Disconnected.Stopped.INSTANCE;
        }
        this(state);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object observer(@NotNull Function1<? super State, Unit> var1_1, @NotNull Continuation<? super Unit> var2_2) {
        if (!(var2_2 instanceof observer.1)) ** GOTO lbl-1000
        var4_3 = var2_2;
        if ((var4_3.label & -2147483648) != 0) {
            var4_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                /* synthetic */ Object result;
                final /* synthetic */ ChatSocketStateService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.observer(null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = this.getStateMachine().getStateFlow().collect(new FlowCollector((Function1<? super State, Unit>)onNewState){
                    final /* synthetic */ Function1<State, Unit> $tmp0;
                    {
                        this.$tmp0 = $tmp0;
                    }

                    @Nullable
                    public final Object emit(@NotNull State p0, @NotNull Continuation<? super Unit> $completion) {
                        Object object = ChatSocketStateService.access$observer$suspendConversion0(this.$tmp0, p0, $completion);
                        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                            return object;
                        }
                        return Unit.INSTANCE;
                    }

                    @NotNull
                    public final Function<?> getFunctionDelegate() {
                        return (Function)new FunctionReferenceImpl(2, this.$tmp0, Intrinsics.Kotlin.class, "suspendConversion0", "observer$suspendConversion0(Lkotlin/jvm/functions/Function1;Lio/getstream/chat/android/client/socket/ChatSocketStateService$State;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", 0);
                    }

                    public final boolean equals(@Nullable Object other) {
                        return other instanceof FlowCollector ? (other instanceof FunctionAdapter ? Intrinsics.areEqual(this.getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
                    }

                    public final int hashCode() {
                        return this.getFunctionDelegate().hashCode();
                    }
                }, (Continuation)$continuation);
                if (v0 == var5_5) {
                    return var5_5;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl20:
                // 2 sources

                throw new KotlinNothingValueException();
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public final void onReconnect(@NotNull SocketFactory.ConnectionConf connectionConf) {
        Intrinsics.checkNotNullParameter((Object)connectionConf, (String)"connectionConf");
        TaggedLogger this_$iv = this.logger;
        boolean $i$f$v = false;
        if (this_$iv.getValidator().isLoggable(Priority.VERBOSE, this_$iv.getTag())) {
            String string2 = this_$iv.getTag();
            Priority priority = Priority.VERBOSE;
            StreamLogger streamLogger = this_$iv.getDelegate();
            boolean bl = false;
            String string3 = "[onReconnect] user.id: '" + connectionConf.getUser().getId() + "', isReconnection: " + connectionConf.isReconnection();
            StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string3, null, (int)8, null);
        }
        this.getStateMachine().sendEvent((Object)new Event.Connect(connectionConf, true));
    }

    public final void onConnect(@NotNull SocketFactory.ConnectionConf connectionConf) {
        Intrinsics.checkNotNullParameter((Object)connectionConf, (String)"connectionConf");
        TaggedLogger this_$iv = this.logger;
        boolean $i$f$v = false;
        if (this_$iv.getValidator().isLoggable(Priority.VERBOSE, this_$iv.getTag())) {
            String string2 = this_$iv.getTag();
            Priority priority = Priority.VERBOSE;
            StreamLogger streamLogger = this_$iv.getDelegate();
            boolean bl = false;
            String string3 = "[onConnect] user.id: '" + connectionConf.getUser().getId() + "', isReconnection: " + connectionConf.isReconnection();
            StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string3, null, (int)8, null);
        }
        this.getStateMachine().sendEvent((Object)new Event.Connect(connectionConf, false));
    }

    public final void onNetworkNotAvailable() {
        TaggedLogger this_$iv = this.logger;
        boolean $i$f$w = false;
        if (this_$iv.getValidator().isLoggable(Priority.WARN, this_$iv.getTag())) {
            String string2 = this_$iv.getTag();
            Priority priority = Priority.WARN;
            StreamLogger streamLogger = this_$iv.getDelegate();
            boolean bl = false;
            String string3 = "[onNetworkNotAvailable] no args";
            StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string3, null, (int)8, null);
        }
        this.getStateMachine().sendEvent((Object)Event.NetworkNotAvailable.INSTANCE);
    }

    public final void onConnectionEstablished(@NotNull ConnectedEvent connectedEvent) {
        Intrinsics.checkNotNullParameter((Object)connectedEvent, (String)"connectedEvent");
        TaggedLogger this_$iv = this.logger;
        boolean $i$f$i = false;
        if (this_$iv.getValidator().isLoggable(Priority.INFO, this_$iv.getTag())) {
            String string2 = this_$iv.getTag();
            Priority priority = Priority.INFO;
            StreamLogger streamLogger = this_$iv.getDelegate();
            boolean bl = false;
            String string3 = "[onConnected] user.id: '" + connectedEvent.getMe().getId() + "', connectionId: " + connectedEvent.getConnectionId();
            StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string3, null, (int)8, null);
        }
        this.getStateMachine().sendEvent((Object)new Event.ConnectionEstablished(connectedEvent));
    }

    public final void onUnrecoverableError(@NotNull ChatError.NetworkError error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        TaggedLogger this_$iv = this.logger;
        boolean $i$f$e = false;
        if (this_$iv.getValidator().isLoggable(Priority.ERROR, this_$iv.getTag())) {
            String string2 = this_$iv.getTag();
            Priority priority = Priority.ERROR;
            StreamLogger streamLogger = this_$iv.getDelegate();
            boolean bl = false;
            String string3 = "[onUnrecoverableError] error: " + error;
            StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string3, null, (int)8, null);
        }
        this.getStateMachine().sendEvent((Object)new Event.UnrecoverableError(error));
    }

    public final void onNetworkError(@NotNull ChatError.NetworkError error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        TaggedLogger this_$iv = this.logger;
        boolean $i$f$e = false;
        if (this_$iv.getValidator().isLoggable(Priority.ERROR, this_$iv.getTag())) {
            String string2 = this_$iv.getTag();
            Priority priority = Priority.ERROR;
            StreamLogger streamLogger = this_$iv.getDelegate();
            boolean bl = false;
            String string3 = "[onNetworkError] error: " + error;
            StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string3, null, (int)8, null);
        }
        this.getStateMachine().sendEvent((Object)new Event.NetworkError(error));
    }

    public final void onRequiredDisconnect() {
        TaggedLogger this_$iv = this.logger;
        boolean $i$f$i = false;
        if (this_$iv.getValidator().isLoggable(Priority.INFO, this_$iv.getTag())) {
            String string2 = this_$iv.getTag();
            Priority priority = Priority.INFO;
            StreamLogger streamLogger = this_$iv.getDelegate();
            boolean bl = false;
            String string3 = "[onRequiredDisconnect] no args";
            StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string3, null, (int)8, null);
        }
        this.getStateMachine().sendEvent((Object)Event.RequiredDisconnection.INSTANCE);
    }

    public final void onStop() {
        TaggedLogger this_$iv = this.logger;
        boolean $i$f$i = false;
        if (this_$iv.getValidator().isLoggable(Priority.INFO, this_$iv.getTag())) {
            String string2 = this_$iv.getTag();
            Priority priority = Priority.INFO;
            StreamLogger streamLogger = this_$iv.getDelegate();
            boolean bl = false;
            String string3 = "[onStop] no args";
            StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string3, null, (int)8, null);
        }
        this.getStateMachine().sendEvent((Object)Event.Stop.INSTANCE);
    }

    public final void onWebSocketEventLost() {
        TaggedLogger this_$iv = this.logger;
        boolean $i$f$w = false;
        if (this_$iv.getValidator().isLoggable(Priority.WARN, this_$iv.getTag())) {
            String string2 = this_$iv.getTag();
            Priority priority = Priority.WARN;
            StreamLogger streamLogger = this_$iv.getDelegate();
            boolean bl = false;
            String string3 = "[onWebSocketEventLost] no args";
            StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string3, null, (int)8, null);
        }
        this.getStateMachine().sendEvent((Object)Event.WebSocketEventLost.INSTANCE);
    }

    public final void onNetworkAvailable() {
        TaggedLogger this_$iv = this.logger;
        boolean $i$f$i = false;
        if (this_$iv.getValidator().isLoggable(Priority.INFO, this_$iv.getTag())) {
            String string2 = this_$iv.getTag();
            Priority priority = Priority.INFO;
            StreamLogger streamLogger = this_$iv.getDelegate();
            boolean bl = false;
            String string3 = "[onNetworkAvailable] no args";
            StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string3, null, (int)8, null);
        }
        this.getStateMachine().sendEvent((Object)Event.NetworkAvailable.INSTANCE);
    }

    public final void onResume() {
        TaggedLogger this_$iv = this.logger;
        boolean $i$f$v = false;
        if (this_$iv.getValidator().isLoggable(Priority.VERBOSE, this_$iv.getTag())) {
            String string2 = this_$iv.getTag();
            Priority priority = Priority.VERBOSE;
            StreamLogger streamLogger = this_$iv.getDelegate();
            boolean bl = false;
            String string3 = "[onResume] no args";
            StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string3, null, (int)8, null);
        }
        this.getStateMachine().sendEvent((Object)Event.Resume.INSTANCE);
    }

    @NotNull
    public final State getCurrentState() {
        return (State)this.getStateMachine().getState();
    }

    @NotNull
    public final StateFlow<State> getCurrentStateFlow() {
        return this.getStateMachine().getStateFlow();
    }

    private final FiniteStateMachine<State, Event> getStateMachine() {
        Lazy lazy = this.stateMachine$delegate;
        return (FiniteStateMachine)lazy.getValue();
    }

    private static final /* synthetic */ Object observer$suspendConversion0(Function1 $this$observer_u24suspendConversion0, State p0, Continuation $completion) {
        $this$observer_u24suspendConversion0.invoke((Object)p0);
        return Unit.INSTANCE;
    }

    public ChatSocketStateService() {
        this(null, 1, null);
    }

    public static final /* synthetic */ Object access$observer$suspendConversion0(Function1 $receiver, State p0, Continuation $completion) {
        return ChatSocketStateService.observer$suspendConversion0($receiver, p0, $completion);
    }

    public static final /* synthetic */ TaggedLogger access$getLogger$p(ChatSocketStateService $this) {
        return $this.logger;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\n\u0003\u0004\u0005\u0006\u0007\b\t\n\u000b\fB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\n\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u00a8\u0006\u0017"}, d2={"Lio/getstream/chat/android/client/socket/ChatSocketStateService$Event;", "", "()V", "Connect", "ConnectionEstablished", "NetworkAvailable", "NetworkError", "NetworkNotAvailable", "RequiredDisconnection", "Resume", "Stop", "UnrecoverableError", "WebSocketEventLost", "Lio/getstream/chat/android/client/socket/ChatSocketStateService$Event$Connect;", "Lio/getstream/chat/android/client/socket/ChatSocketStateService$Event$ConnectionEstablished;", "Lio/getstream/chat/android/client/socket/ChatSocketStateService$Event$NetworkAvailable;", "Lio/getstream/chat/android/client/socket/ChatSocketStateService$Event$NetworkError;", "Lio/getstream/chat/android/client/socket/ChatSocketStateService$Event$NetworkNotAvailable;", "Lio/getstream/chat/android/client/socket/ChatSocketStateService$Event$RequiredDisconnection;", "Lio/getstream/chat/android/client/socket/ChatSocketStateService$Event$Resume;", "Lio/getstream/chat/android/client/socket/ChatSocketStateService$Event$Stop;", "Lio/getstream/chat/android/client/socket/ChatSocketStateService$Event$UnrecoverableError;", "Lio/getstream/chat/android/client/socket/ChatSocketStateService$Event$WebSocketEventLost;", "stream-chat-android-client_release"})
    private static abstract class Event {
        private Event() {
        }

        public /* synthetic */ Event(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\t\u00a8\u0006\u0014"}, d2={"Lio/getstream/chat/android/client/socket/ChatSocketStateService$Event$Connect;", "Lio/getstream/chat/android/client/socket/ChatSocketStateService$Event;", "connectionConf", "Lio/getstream/chat/android/client/socket/SocketFactory$ConnectionConf;", "isReconnection", "", "(Lio/getstream/chat/android/client/socket/SocketFactory$ConnectionConf;Z)V", "getConnectionConf", "()Lio/getstream/chat/android/client/socket/SocketFactory$ConnectionConf;", "()Z", "component1", "component2", "copy", "equals", "other", "", "hashCode", "", "toString", "", "stream-chat-android-client_release"})
        public static final class Connect
        extends Event {
            @NotNull
            private final SocketFactory.ConnectionConf connectionConf;
            private final boolean isReconnection;

            public Connect(@NotNull SocketFactory.ConnectionConf connectionConf, boolean isReconnection) {
                Intrinsics.checkNotNullParameter((Object)connectionConf, (String)"connectionConf");
                super(null);
                this.connectionConf = connectionConf;
                this.isReconnection = isReconnection;
            }

            @NotNull
            public final SocketFactory.ConnectionConf getConnectionConf() {
                return this.connectionConf;
            }

            public final boolean isReconnection() {
                return this.isReconnection;
            }

            @NotNull
            public final SocketFactory.ConnectionConf component1() {
                return this.connectionConf;
            }

            public final boolean component2() {
                return this.isReconnection;
            }

            @NotNull
            public final Connect copy(@NotNull SocketFactory.ConnectionConf connectionConf, boolean isReconnection) {
                Intrinsics.checkNotNullParameter((Object)connectionConf, (String)"connectionConf");
                return new Connect(connectionConf, isReconnection);
            }

            public static /* synthetic */ Connect copy$default(Connect connect, SocketFactory.ConnectionConf connectionConf, boolean bl, int n, Object object) {
                if ((n & 1) != 0) {
                    connectionConf = connect.connectionConf;
                }
                if ((n & 2) != 0) {
                    bl = connect.isReconnection;
                }
                return connect.copy(connectionConf, bl);
            }

            @NotNull
            public String toString() {
                return "Connect(connectionConf=" + this.connectionConf + ", isReconnection=" + this.isReconnection + ')';
            }

            public int hashCode() {
                int result = this.connectionConf.hashCode();
                int n = this.isReconnection ? 1 : 0;
                if (n != 0) {
                    n = 1;
                }
                result = result * 31 + n;
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Connect)) {
                    return false;
                }
                Connect connect = (Connect)other;
                if (!Intrinsics.areEqual((Object)this.connectionConf, (Object)connect.connectionConf)) {
                    return false;
                }
                return this.isReconnection == connect.isReconnection;
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lio/getstream/chat/android/client/socket/ChatSocketStateService$Event$ConnectionEstablished;", "Lio/getstream/chat/android/client/socket/ChatSocketStateService$Event;", "connectedEvent", "Lio/getstream/chat/android/client/events/ConnectedEvent;", "(Lio/getstream/chat/android/client/events/ConnectedEvent;)V", "getConnectedEvent", "()Lio/getstream/chat/android/client/events/ConnectedEvent;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "stream-chat-android-client_release"})
        public static final class ConnectionEstablished
        extends Event {
            @NotNull
            private final ConnectedEvent connectedEvent;

            public ConnectionEstablished(@NotNull ConnectedEvent connectedEvent) {
                Intrinsics.checkNotNullParameter((Object)connectedEvent, (String)"connectedEvent");
                super(null);
                this.connectedEvent = connectedEvent;
            }

            @NotNull
            public final ConnectedEvent getConnectedEvent() {
                return this.connectedEvent;
            }

            @NotNull
            public final ConnectedEvent component1() {
                return this.connectedEvent;
            }

            @NotNull
            public final ConnectionEstablished copy(@NotNull ConnectedEvent connectedEvent) {
                Intrinsics.checkNotNullParameter((Object)connectedEvent, (String)"connectedEvent");
                return new ConnectionEstablished(connectedEvent);
            }

            public static /* synthetic */ ConnectionEstablished copy$default(ConnectionEstablished connectionEstablished, ConnectedEvent connectedEvent, int n, Object object) {
                if ((n & 1) != 0) {
                    connectedEvent = connectionEstablished.connectedEvent;
                }
                return connectionEstablished.copy(connectedEvent);
            }

            @NotNull
            public String toString() {
                return "ConnectionEstablished(connectedEvent=" + this.connectedEvent + ')';
            }

            public int hashCode() {
                return this.connectedEvent.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ConnectionEstablished)) {
                    return false;
                }
                ConnectionEstablished connectionEstablished = (ConnectionEstablished)other;
                return Intrinsics.areEqual((Object)this.connectedEvent, (Object)connectionEstablished.connectedEvent);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lio/getstream/chat/android/client/socket/ChatSocketStateService$Event$WebSocketEventLost;", "Lio/getstream/chat/android/client/socket/ChatSocketStateService$Event;", "()V", "stream-chat-android-client_release"})
        public static final class WebSocketEventLost
        extends Event {
            @NotNull
            public static final WebSocketEventLost INSTANCE = new WebSocketEventLost();

            private WebSocketEventLost() {
                super(null);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lio/getstream/chat/android/client/socket/ChatSocketStateService$Event$NetworkNotAvailable;", "Lio/getstream/chat/android/client/socket/ChatSocketStateService$Event;", "()V", "stream-chat-android-client_release"})
        public static final class NetworkNotAvailable
        extends Event {
            @NotNull
            public static final NetworkNotAvailable INSTANCE = new NetworkNotAvailable();

            private NetworkNotAvailable() {
                super(null);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lio/getstream/chat/android/client/socket/ChatSocketStateService$Event$NetworkAvailable;", "Lio/getstream/chat/android/client/socket/ChatSocketStateService$Event;", "()V", "stream-chat-android-client_release"})
        public static final class NetworkAvailable
        extends Event {
            @NotNull
            public static final NetworkAvailable INSTANCE = new NetworkAvailable();

            private NetworkAvailable() {
                super(null);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lio/getstream/chat/android/client/socket/ChatSocketStateService$Event$UnrecoverableError;", "Lio/getstream/chat/android/client/socket/ChatSocketStateService$Event;", "error", "Lio/getstream/chat/android/client/errors/ChatError$NetworkError;", "(Lio/getstream/chat/android/client/errors/ChatError$NetworkError;)V", "getError", "()Lio/getstream/chat/android/client/errors/ChatError$NetworkError;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "stream-chat-android-client_release"})
        public static final class UnrecoverableError
        extends Event {
            @NotNull
            private final ChatError.NetworkError error;

            public UnrecoverableError(@NotNull ChatError.NetworkError error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                super(null);
                this.error = error;
            }

            @NotNull
            public final ChatError.NetworkError getError() {
                return this.error;
            }

            @NotNull
            public final ChatError.NetworkError component1() {
                return this.error;
            }

            @NotNull
            public final UnrecoverableError copy(@NotNull ChatError.NetworkError error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                return new UnrecoverableError(error);
            }

            public static /* synthetic */ UnrecoverableError copy$default(UnrecoverableError unrecoverableError, ChatError.NetworkError networkError, int n, Object object) {
                if ((n & 1) != 0) {
                    networkError = unrecoverableError.error;
                }
                return unrecoverableError.copy(networkError);
            }

            @NotNull
            public String toString() {
                return "UnrecoverableError(error=" + this.error + ')';
            }

            public int hashCode() {
                return this.error.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof UnrecoverableError)) {
                    return false;
                }
                UnrecoverableError unrecoverableError = (UnrecoverableError)other;
                return Intrinsics.areEqual((Object)this.error, (Object)unrecoverableError.error);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lio/getstream/chat/android/client/socket/ChatSocketStateService$Event$NetworkError;", "Lio/getstream/chat/android/client/socket/ChatSocketStateService$Event;", "error", "Lio/getstream/chat/android/client/errors/ChatError$NetworkError;", "(Lio/getstream/chat/android/client/errors/ChatError$NetworkError;)V", "getError", "()Lio/getstream/chat/android/client/errors/ChatError$NetworkError;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "stream-chat-android-client_release"})
        public static final class NetworkError
        extends Event {
            @NotNull
            private final ChatError.NetworkError error;

            public NetworkError(@NotNull ChatError.NetworkError error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                super(null);
                this.error = error;
            }

            @NotNull
            public final ChatError.NetworkError getError() {
                return this.error;
            }

            @NotNull
            public final ChatError.NetworkError component1() {
                return this.error;
            }

            @NotNull
            public final NetworkError copy(@NotNull ChatError.NetworkError error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                return new NetworkError(error);
            }

            public static /* synthetic */ NetworkError copy$default(NetworkError networkError, ChatError.NetworkError networkError2, int n, Object object) {
                if ((n & 1) != 0) {
                    networkError2 = networkError.error;
                }
                return networkError.copy(networkError2);
            }

            @NotNull
            public String toString() {
                return "NetworkError(error=" + this.error + ')';
            }

            public int hashCode() {
                return this.error.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof NetworkError)) {
                    return false;
                }
                NetworkError networkError = (NetworkError)other;
                return Intrinsics.areEqual((Object)this.error, (Object)networkError.error);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lio/getstream/chat/android/client/socket/ChatSocketStateService$Event$RequiredDisconnection;", "Lio/getstream/chat/android/client/socket/ChatSocketStateService$Event;", "()V", "stream-chat-android-client_release"})
        public static final class RequiredDisconnection
        extends Event {
            @NotNull
            public static final RequiredDisconnection INSTANCE = new RequiredDisconnection();

            private RequiredDisconnection() {
                super(null);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lio/getstream/chat/android/client/socket/ChatSocketStateService$Event$Stop;", "Lio/getstream/chat/android/client/socket/ChatSocketStateService$Event;", "()V", "stream-chat-android-client_release"})
        public static final class Stop
        extends Event {
            @NotNull
            public static final Stop INSTANCE = new Stop();

            private Stop() {
                super(null);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lio/getstream/chat/android/client/socket/ChatSocketStateService$Event$Resume;", "Lio/getstream/chat/android/client/socket/ChatSocketStateService$Event;", "()V", "stream-chat-android-client_release"})
        public static final class Resume
        extends Event {
            @NotNull
            public static final Resume INSTANCE = new Resume();

            private Resume() {
                super(null);
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001:\u0004\u0003\u0004\u0005\u0006B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0004\u0007\b\t\n\u00a8\u0006\u000b"}, d2={"Lio/getstream/chat/android/client/socket/ChatSocketStateService$State;", "", "()V", "Connected", "Connecting", "Disconnected", "RestartConnection", "Lio/getstream/chat/android/client/socket/ChatSocketStateService$State$Connected;", "Lio/getstream/chat/android/client/socket/ChatSocketStateService$State$Connecting;", "Lio/getstream/chat/android/client/socket/ChatSocketStateService$State$Disconnected;", "Lio/getstream/chat/android/client/socket/ChatSocketStateService$State$RestartConnection;", "stream-chat-android-client_release"})
    public static abstract class State {
        private State() {
        }

        public /* synthetic */ State(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lio/getstream/chat/android/client/socket/ChatSocketStateService$State$RestartConnection;", "Lio/getstream/chat/android/client/socket/ChatSocketStateService$State;", "()V", "toString", "", "stream-chat-android-client_release"})
        public static final class RestartConnection
        extends State {
            @NotNull
            public static final RestartConnection INSTANCE = new RestartConnection();

            private RestartConnection() {
                super(null);
            }

            @NotNull
            public String toString() {
                return "RestartConnection";
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\t\u00a8\u0006\u0014"}, d2={"Lio/getstream/chat/android/client/socket/ChatSocketStateService$State$Connecting;", "Lio/getstream/chat/android/client/socket/ChatSocketStateService$State;", "connectionConf", "Lio/getstream/chat/android/client/socket/SocketFactory$ConnectionConf;", "isReconnection", "", "(Lio/getstream/chat/android/client/socket/SocketFactory$ConnectionConf;Z)V", "getConnectionConf", "()Lio/getstream/chat/android/client/socket/SocketFactory$ConnectionConf;", "()Z", "component1", "component2", "copy", "equals", "other", "", "hashCode", "", "toString", "", "stream-chat-android-client_release"})
        public static final class Connecting
        extends State {
            @NotNull
            private final SocketFactory.ConnectionConf connectionConf;
            private final boolean isReconnection;

            public Connecting(@NotNull SocketFactory.ConnectionConf connectionConf, boolean isReconnection) {
                Intrinsics.checkNotNullParameter((Object)connectionConf, (String)"connectionConf");
                super(null);
                this.connectionConf = connectionConf;
                this.isReconnection = isReconnection;
            }

            @NotNull
            public final SocketFactory.ConnectionConf getConnectionConf() {
                return this.connectionConf;
            }

            public final boolean isReconnection() {
                return this.isReconnection;
            }

            @NotNull
            public final SocketFactory.ConnectionConf component1() {
                return this.connectionConf;
            }

            public final boolean component2() {
                return this.isReconnection;
            }

            @NotNull
            public final Connecting copy(@NotNull SocketFactory.ConnectionConf connectionConf, boolean isReconnection) {
                Intrinsics.checkNotNullParameter((Object)connectionConf, (String)"connectionConf");
                return new Connecting(connectionConf, isReconnection);
            }

            public static /* synthetic */ Connecting copy$default(Connecting connecting, SocketFactory.ConnectionConf connectionConf, boolean bl, int n, Object object) {
                if ((n & 1) != 0) {
                    connectionConf = connecting.connectionConf;
                }
                if ((n & 2) != 0) {
                    bl = connecting.isReconnection;
                }
                return connecting.copy(connectionConf, bl);
            }

            @NotNull
            public String toString() {
                return "Connecting(connectionConf=" + this.connectionConf + ", isReconnection=" + this.isReconnection + ')';
            }

            public int hashCode() {
                int result = this.connectionConf.hashCode();
                int n = this.isReconnection ? 1 : 0;
                if (n != 0) {
                    n = 1;
                }
                result = result * 31 + n;
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Connecting)) {
                    return false;
                }
                Connecting connecting = (Connecting)other;
                if (!Intrinsics.areEqual((Object)this.connectionConf, (Object)connecting.connectionConf)) {
                    return false;
                }
                return this.isReconnection == connecting.isReconnection;
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lio/getstream/chat/android/client/socket/ChatSocketStateService$State$Connected;", "Lio/getstream/chat/android/client/socket/ChatSocketStateService$State;", "event", "Lio/getstream/chat/android/client/events/ConnectedEvent;", "(Lio/getstream/chat/android/client/events/ConnectedEvent;)V", "getEvent", "()Lio/getstream/chat/android/client/events/ConnectedEvent;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "stream-chat-android-client_release"})
        public static final class Connected
        extends State {
            @NotNull
            private final ConnectedEvent event;

            public Connected(@NotNull ConnectedEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                super(null);
                this.event = event;
            }

            @NotNull
            public final ConnectedEvent getEvent() {
                return this.event;
            }

            @NotNull
            public final ConnectedEvent component1() {
                return this.event;
            }

            @NotNull
            public final Connected copy(@NotNull ConnectedEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                return new Connected(event);
            }

            public static /* synthetic */ Connected copy$default(Connected connected, ConnectedEvent connectedEvent, int n, Object object) {
                if ((n & 1) != 0) {
                    connectedEvent = connected.event;
                }
                return connected.copy(connectedEvent);
            }

            @NotNull
            public String toString() {
                return "Connected(event=" + this.event + ')';
            }

            public int hashCode() {
                return this.event.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Connected)) {
                    return false;
                }
                Connected connected = (Connected)other;
                return Intrinsics.areEqual((Object)this.event, (Object)connected.event);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0006\u0003\u0004\u0005\u0006\u0007\bB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0006\t\n\u000b\f\r\u000e\u00a8\u0006\u000f"}, d2={"Lio/getstream/chat/android/client/socket/ChatSocketStateService$State$Disconnected;", "Lio/getstream/chat/android/client/socket/ChatSocketStateService$State;", "()V", "DisconnectedByRequest", "DisconnectedPermanently", "DisconnectedTemporarily", "NetworkDisconnected", "Stopped", "WebSocketEventLost", "Lio/getstream/chat/android/client/socket/ChatSocketStateService$State$Disconnected$DisconnectedByRequest;", "Lio/getstream/chat/android/client/socket/ChatSocketStateService$State$Disconnected$DisconnectedPermanently;", "Lio/getstream/chat/android/client/socket/ChatSocketStateService$State$Disconnected$DisconnectedTemporarily;", "Lio/getstream/chat/android/client/socket/ChatSocketStateService$State$Disconnected$NetworkDisconnected;", "Lio/getstream/chat/android/client/socket/ChatSocketStateService$State$Disconnected$Stopped;", "Lio/getstream/chat/android/client/socket/ChatSocketStateService$State$Disconnected$WebSocketEventLost;", "stream-chat-android-client_release"})
        public static abstract class Disconnected
        extends State {
            private Disconnected() {
                super(null);
            }

            public /* synthetic */ Disconnected(DefaultConstructorMarker $constructor_marker) {
                this();
            }

            @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lio/getstream/chat/android/client/socket/ChatSocketStateService$State$Disconnected$Stopped;", "Lio/getstream/chat/android/client/socket/ChatSocketStateService$State$Disconnected;", "()V", "toString", "", "stream-chat-android-client_release"})
            public static final class Stopped
            extends Disconnected {
                @NotNull
                public static final Stopped INSTANCE = new Stopped();

                private Stopped() {
                    super(null);
                }

                @NotNull
                public String toString() {
                    return "Disconnected.Stopped";
                }
            }

            @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lio/getstream/chat/android/client/socket/ChatSocketStateService$State$Disconnected$NetworkDisconnected;", "Lio/getstream/chat/android/client/socket/ChatSocketStateService$State$Disconnected;", "()V", "toString", "", "stream-chat-android-client_release"})
            public static final class NetworkDisconnected
            extends Disconnected {
                @NotNull
                public static final NetworkDisconnected INSTANCE = new NetworkDisconnected();

                private NetworkDisconnected() {
                    super(null);
                }

                @NotNull
                public String toString() {
                    return "Disconnected.Network";
                }
            }

            @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lio/getstream/chat/android/client/socket/ChatSocketStateService$State$Disconnected$WebSocketEventLost;", "Lio/getstream/chat/android/client/socket/ChatSocketStateService$State$Disconnected;", "()V", "toString", "", "stream-chat-android-client_release"})
            public static final class WebSocketEventLost
            extends Disconnected {
                @NotNull
                public static final WebSocketEventLost INSTANCE = new WebSocketEventLost();

                private WebSocketEventLost() {
                    super(null);
                }

                @NotNull
                public String toString() {
                    return "Disconnected.InactiveWS";
                }
            }

            @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lio/getstream/chat/android/client/socket/ChatSocketStateService$State$Disconnected$DisconnectedByRequest;", "Lio/getstream/chat/android/client/socket/ChatSocketStateService$State$Disconnected;", "()V", "toString", "", "stream-chat-android-client_release"})
            public static final class DisconnectedByRequest
            extends Disconnected {
                @NotNull
                public static final DisconnectedByRequest INSTANCE = new DisconnectedByRequest();

                private DisconnectedByRequest() {
                    super(null);
                }

                @NotNull
                public String toString() {
                    return "Disconnected.ByRequest";
                }
            }

            @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lio/getstream/chat/android/client/socket/ChatSocketStateService$State$Disconnected$DisconnectedTemporarily;", "Lio/getstream/chat/android/client/socket/ChatSocketStateService$State$Disconnected;", "error", "Lio/getstream/chat/android/client/errors/ChatError$NetworkError;", "(Lio/getstream/chat/android/client/errors/ChatError$NetworkError;)V", "getError", "()Lio/getstream/chat/android/client/errors/ChatError$NetworkError;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "stream-chat-android-client_release"})
            public static final class DisconnectedTemporarily
            extends Disconnected {
                @NotNull
                private final ChatError.NetworkError error;

                public DisconnectedTemporarily(@NotNull ChatError.NetworkError error) {
                    Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                    super(null);
                    this.error = error;
                }

                @NotNull
                public final ChatError.NetworkError getError() {
                    return this.error;
                }

                @NotNull
                public final ChatError.NetworkError component1() {
                    return this.error;
                }

                @NotNull
                public final DisconnectedTemporarily copy(@NotNull ChatError.NetworkError error) {
                    Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                    return new DisconnectedTemporarily(error);
                }

                public static /* synthetic */ DisconnectedTemporarily copy$default(DisconnectedTemporarily disconnectedTemporarily, ChatError.NetworkError networkError, int n, Object object) {
                    if ((n & 1) != 0) {
                        networkError = disconnectedTemporarily.error;
                    }
                    return disconnectedTemporarily.copy(networkError);
                }

                @NotNull
                public String toString() {
                    return "DisconnectedTemporarily(error=" + this.error + ')';
                }

                public int hashCode() {
                    return this.error.hashCode();
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof DisconnectedTemporarily)) {
                        return false;
                    }
                    DisconnectedTemporarily disconnectedTemporarily = (DisconnectedTemporarily)other;
                    return Intrinsics.areEqual((Object)this.error, (Object)disconnectedTemporarily.error);
                }
            }

            @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lio/getstream/chat/android/client/socket/ChatSocketStateService$State$Disconnected$DisconnectedPermanently;", "Lio/getstream/chat/android/client/socket/ChatSocketStateService$State$Disconnected;", "error", "Lio/getstream/chat/android/client/errors/ChatError$NetworkError;", "(Lio/getstream/chat/android/client/errors/ChatError$NetworkError;)V", "getError", "()Lio/getstream/chat/android/client/errors/ChatError$NetworkError;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "stream-chat-android-client_release"})
            public static final class DisconnectedPermanently
            extends Disconnected {
                @NotNull
                private final ChatError.NetworkError error;

                public DisconnectedPermanently(@NotNull ChatError.NetworkError error) {
                    Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                    super(null);
                    this.error = error;
                }

                @NotNull
                public final ChatError.NetworkError getError() {
                    return this.error;
                }

                @NotNull
                public final ChatError.NetworkError component1() {
                    return this.error;
                }

                @NotNull
                public final DisconnectedPermanently copy(@NotNull ChatError.NetworkError error) {
                    Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                    return new DisconnectedPermanently(error);
                }

                public static /* synthetic */ DisconnectedPermanently copy$default(DisconnectedPermanently disconnectedPermanently, ChatError.NetworkError networkError, int n, Object object) {
                    if ((n & 1) != 0) {
                        networkError = disconnectedPermanently.error;
                    }
                    return disconnectedPermanently.copy(networkError);
                }

                @NotNull
                public String toString() {
                    return "DisconnectedPermanently(error=" + this.error + ')';
                }

                public int hashCode() {
                    return this.error.hashCode();
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof DisconnectedPermanently)) {
                        return false;
                    }
                    DisconnectedPermanently disconnectedPermanently = (DisconnectedPermanently)other;
                    return Intrinsics.areEqual((Object)this.error, (Object)disconnectedPermanently.error);
                }
            }
        }
    }
}

