/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.client.socket;

import io.getstream.chat.android.client.scope.UserScope;
import io.getstream.chat.android.client.utils.TimeProvider;
import io.getstream.log.Priority;
import io.getstream.log.StreamLog;
import io.getstream.log.StreamLogger;
import io.getstream.log.TaggedLogger;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0002)*B=\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\fJ\u0006\u0010\u0017\u001a\u00020\nJ\b\u0010\u0018\u001a\u00020\u0019H\u0002J\u0006\u0010\u001a\u001a\u00020\nJ\b\u0010\u001b\u001a\u00020\nH\u0002J\b\u0010\u001c\u001a\u00020\nH\u0002J\b\u0010\u001d\u001a\u00020\nH\u0002J\b\u0010\u001e\u001a\u00020\nH\u0002J\u0006\u0010\u001f\u001a\u00020\nJ\b\u0010 \u001a\u00020\nH\u0002JE\u0010!\u001a\u00020\u0010*\u00020\"2\u0006\u0010#\u001a\u00020\u00132'\u0010$\u001a#\b\u0001\u0012\u0004\u0012\u00020\"\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0&\u0012\u0006\u0012\u0004\u0018\u00010\u00010%\u00a2\u0006\u0002\b'H\u0002\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010(R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006+"}, d2={"Lio/getstream/chat/android/client/socket/HealthMonitor;", "", "timeProvider", "Lio/getstream/chat/android/client/utils/TimeProvider;", "retryInterval", "Lio/getstream/chat/android/client/socket/HealthMonitor$RetryInterval;", "userScope", "Lio/getstream/chat/android/client/scope/UserScope;", "checkCallback", "Lkotlin/Function0;", "", "reconnectCallback", "(Lio/getstream/chat/android/client/utils/TimeProvider;Lio/getstream/chat/android/client/socket/HealthMonitor$RetryInterval;Lio/getstream/chat/android/client/scope/UserScope;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "consecutiveFailures", "", "healthCheckJob", "Lkotlinx/coroutines/Job;", "healthMonitorJob", "lastAck", "", "logger", "Lio/getstream/log/TaggedLogger;", "reconnectJob", "ack", "needToReconnect", "", "onDisconnected", "postponeHealthCheck", "postponeHealthMonitor", "postponeReconnect", "resetHealthMonitor", "stop", "stopAllJobs", "launchDelayed", "Lkotlinx/coroutines/CoroutineScope;", "delayMilliseconds", "block", "Lkotlin/Function2;", "Lkotlin/coroutines/Continuation;", "Lkotlin/ExtensionFunctionType;", "(Lkotlinx/coroutines/CoroutineScope;JLkotlin/jvm/functions/Function2;)Lkotlinx/coroutines/Job;", "ExponencialRetryInterval", "RetryInterval", "stream-chat-android-client_release"})
public final class HealthMonitor {
    @NotNull
    private final TimeProvider timeProvider;
    @NotNull
    private final RetryInterval retryInterval;
    @NotNull
    private final UserScope userScope;
    @NotNull
    private final Function0<Unit> checkCallback;
    @NotNull
    private final Function0<Unit> reconnectCallback;
    private int consecutiveFailures;
    private long lastAck;
    @Nullable
    private Job healthMonitorJob;
    @Nullable
    private Job healthCheckJob;
    @Nullable
    private Job reconnectJob;
    @NotNull
    private final TaggedLogger logger;

    public HealthMonitor(@NotNull TimeProvider timeProvider, @NotNull RetryInterval retryInterval, @NotNull UserScope userScope, @NotNull Function0<Unit> checkCallback, @NotNull Function0<Unit> reconnectCallback) {
        Intrinsics.checkNotNullParameter((Object)timeProvider, (String)"timeProvider");
        Intrinsics.checkNotNullParameter((Object)retryInterval, (String)"retryInterval");
        Intrinsics.checkNotNullParameter((Object)userScope, (String)"userScope");
        Intrinsics.checkNotNullParameter(checkCallback, (String)"checkCallback");
        Intrinsics.checkNotNullParameter(reconnectCallback, (String)"reconnectCallback");
        this.timeProvider = timeProvider;
        this.retryInterval = retryInterval;
        this.userScope = userScope;
        this.checkCallback = checkCallback;
        this.reconnectCallback = reconnectCallback;
        this.logger = StreamLog.getLogger((String)"Chat:SocketMonitor");
    }

    public /* synthetic */ HealthMonitor(TimeProvider timeProvider, RetryInterval retryInterval, UserScope userScope, Function0 function0, Function0 function02, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            timeProvider = TimeProvider.INSTANCE;
        }
        if ((n & 2) != 0) {
            retryInterval = ExponencialRetryInterval.INSTANCE;
        }
        this(timeProvider, retryInterval, userScope, (Function0<Unit>)function0, (Function0<Unit>)function02);
    }

    public final void stop() {
        this.stopAllJobs();
    }

    public final void ack() {
        this.resetHealthMonitor();
    }

    public final void onDisconnected() {
        this.stopAllJobs();
        this.lastAck = 0L;
        this.postponeReconnect();
    }

    private final void resetHealthMonitor() {
        this.stopAllJobs();
        this.lastAck = this.timeProvider.provideCurrentTimeInMilliseconds();
        this.consecutiveFailures = 0;
        this.postponeHealthMonitor();
    }

    private final void postponeHealthMonitor() {
        Job job = this.healthMonitorJob;
        if (job != null) {
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
        }
        this.healthMonitorJob = this.launchDelayed(this.userScope, 10000L, (Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ HealthMonitor this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        if (HealthMonitor.access$needToReconnect(this.this$0)) {
                            HealthMonitor.access$postponeReconnect(this.this$0);
                        } else {
                            HealthMonitor.access$postponeHealthCheck(this.this$0);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private final void postponeHealthCheck() {
        Job job = this.healthCheckJob;
        if (job != null) {
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
        }
        this.healthCheckJob = this.launchDelayed(this.userScope, 1000L, (Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ HealthMonitor this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        HealthMonitor.access$getCheckCallback$p(this.this$0).invoke();
                        HealthMonitor.access$postponeHealthMonitor(this.this$0);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private final void postponeReconnect() {
        Job job = this.reconnectJob;
        if (job != null) {
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
        }
        int n = this.consecutiveFailures;
        this.consecutiveFailures = n + 1;
        long retryIntervalTime = this.retryInterval.nextInterval(n);
        TaggedLogger this_$iv = this.logger;
        boolean $i$f$i = false;
        if (this_$iv.getValidator().isLoggable(Priority.INFO, this_$iv.getTag())) {
            String string2 = this_$iv.getTag();
            Priority priority = Priority.INFO;
            StreamLogger streamLogger = this_$iv.getDelegate();
            boolean bl = false;
            String string3 = "Next connection attempt in " + retryIntervalTime + " ms";
            StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string3, null, (int)8, null);
        }
        this.reconnectJob = this.launchDelayed(this.userScope, retryIntervalTime, (Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ HealthMonitor this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        HealthMonitor.access$getReconnectCallback$p(this.this$0).invoke();
                        HealthMonitor.access$postponeHealthMonitor(this.this$0);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private final void stopAllJobs() {
        block2: {
            Job job = this.reconnectJob;
            if (job != null) {
                Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
            }
            Job job2 = this.healthCheckJob;
            if (job2 != null) {
                Job.DefaultImpls.cancel$default((Job)job2, null, (int)1, null);
            }
            Job job3 = this.healthMonitorJob;
            if (job3 == null) break block2;
            Job.DefaultImpls.cancel$default((Job)job3, null, (int)1, null);
        }
    }

    private final boolean needToReconnect() {
        return this.timeProvider.provideCurrentTimeInMilliseconds() - this.lastAck >= 30000L;
    }

    private final Job launchDelayed(CoroutineScope $this$launchDelayed, long delayMilliseconds, Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object> block) {
        return BuildersKt.launch$default((CoroutineScope)$this$launchDelayed, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(delayMilliseconds, block, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ long $delayMilliseconds;
            final /* synthetic */ Function2<CoroutineScope, Continuation<? super Unit>, Object> $block;
            {
                this.$delayMilliseconds = $delayMilliseconds;
                this.$block = $block;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$launch = (CoroutineScope)this.L$0;
                        this.L$0 = $this$launch;
                        this.label = 1;
                        v0 = DelayKt.delay((long)this.$delayMilliseconds, (Continuation)((Continuation)this));
                        if (v0 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl16
                    }
                    case 1: {
                        $this$launch = (CoroutineScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl16:
                        // 2 sources

                        this.L$0 = null;
                        this.label = 2;
                        v1 = this.$block.invoke((Object)$this$launch, (Object)this);
                        if (v1 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl25
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl25:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public static final /* synthetic */ boolean access$needToReconnect(HealthMonitor $this) {
        return $this.needToReconnect();
    }

    public static final /* synthetic */ void access$postponeReconnect(HealthMonitor $this) {
        $this.postponeReconnect();
    }

    public static final /* synthetic */ void access$postponeHealthCheck(HealthMonitor $this) {
        $this.postponeHealthCheck();
    }

    public static final /* synthetic */ Function0 access$getCheckCallback$p(HealthMonitor $this) {
        return $this.checkCallback;
    }

    public static final /* synthetic */ void access$postponeHealthMonitor(HealthMonitor $this) {
        $this.postponeHealthMonitor();
    }

    public static final /* synthetic */ Function0 access$getReconnectCallback$p(HealthMonitor $this) {
        return $this.reconnectCallback;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\b\u00e0\u0080\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lio/getstream/chat/android/client/socket/HealthMonitor$RetryInterval;", "", "nextInterval", "", "consecutiveFailures", "", "stream-chat-android-client_release"})
    public static interface RetryInterval {
        public long nextInterval(int var1);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lio/getstream/chat/android/client/socket/HealthMonitor$ExponencialRetryInterval;", "Lio/getstream/chat/android/client/socket/HealthMonitor$RetryInterval;", "()V", "nextInterval", "", "consecutiveFailures", "", "stream-chat-android-client_release"})
    public static final class ExponencialRetryInterval
    implements RetryInterval {
        @NotNull
        public static final ExponencialRetryInterval INSTANCE = new ExponencialRetryInterval();

        private ExponencialRetryInterval() {
        }

        @Override
        public long nextInterval(int consecutiveFailures) {
            int max = Math.min(500 + consecutiveFailures * 2000, 25000);
            int min = Math.min(Math.max(250, (consecutiveFailures - 1) * 2000), 25000);
            return (long)Math.floor(Math.random() * (double)(max - min) + (double)min);
        }
    }
}

