/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.client.socket;

import io.getstream.chat.android.client.errors.ChatError;
import io.getstream.chat.android.client.errors.ChatErrorCode;
import io.getstream.chat.android.client.errors.ChatErrorKt;
import io.getstream.chat.android.client.events.ChatEvent;
import io.getstream.chat.android.client.parser.ChatParser;
import io.getstream.chat.android.client.socket.ErrorResponse;
import io.getstream.chat.android.client.socket.SocketErrorMessage;
import io.getstream.chat.android.client.socket.StreamWebSocket;
import io.getstream.chat.android.client.socket.StreamWebSocketEvent;
import io.getstream.chat.android.client.utils.Result;
import io.getstream.chat.android.client.utils.ResultKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000O\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u000e\b\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0010\u001a\u00020\u0011J\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0013J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u000e\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0019R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lio/getstream/chat/android/client/socket/StreamWebSocket;", "", "parser", "Lio/getstream/chat/android/client/parser/ChatParser;", "socketCreator", "Lkotlin/Function1;", "Lokhttp3/WebSocketListener;", "Lokhttp3/WebSocket;", "(Lio/getstream/chat/android/client/parser/ChatParser;Lkotlin/jvm/functions/Function1;)V", "eventFlow", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "Lio/getstream/chat/android/client/socket/StreamWebSocketEvent;", "webSocket", "webSocketListener", "io/getstream/chat/android/client/socket/StreamWebSocket$webSocketListener$1", "Lio/getstream/chat/android/client/socket/StreamWebSocket$webSocketListener$1;", "close", "", "listen", "Lkotlinx/coroutines/flow/Flow;", "parseMessage", "text", "", "send", "chatEvent", "Lio/getstream/chat/android/client/events/ChatEvent;", "stream-chat-android-client_release"})
public final class StreamWebSocket {
    @NotNull
    private final ChatParser parser;
    @NotNull
    private final webSocketListener.1 webSocketListener;
    @NotNull
    private final WebSocket webSocket;
    @NotNull
    private final MutableSharedFlow<StreamWebSocketEvent> eventFlow;

    public StreamWebSocket(@NotNull ChatParser parser, @NotNull Function1<? super WebSocketListener, ? extends WebSocket> socketCreator) {
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        Intrinsics.checkNotNullParameter(socketCreator, (String)"socketCreator");
        this.parser = parser;
        this.webSocketListener = new WebSocketListener(this){
            final /* synthetic */ StreamWebSocket this$0;
            {
                this.this$0 = $receiver;
            }

            public void onMessage(@NotNull WebSocket webSocket, @NotNull String text) {
                Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                StreamWebSocket.access$getEventFlow$p(this.this$0).tryEmit((Object)StreamWebSocket.access$parseMessage(this.this$0, text));
            }

            public void onFailure(@NotNull WebSocket webSocket, @NotNull Throwable t, @Nullable Response response) {
                Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                StreamWebSocket.access$getEventFlow$p(this.this$0).tryEmit((Object)new StreamWebSocketEvent.Error((ChatError)ChatError.NetworkError.Companion.fromChatErrorCode$default((ChatError.NetworkError.Companion)ChatError.NetworkError.Companion, (ChatErrorCode)ChatErrorCode.SOCKET_FAILURE, (int)0, (Throwable)t, (int)2, null)));
            }

            public void onClosed(@NotNull WebSocket webSocket, int code, @NotNull String reason) {
                Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
                Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
                if (code != 1000) {
                    StreamWebSocket.access$getEventFlow$p(this.this$0).tryEmit((Object)new StreamWebSocketEvent.Error((ChatError)ChatError.NetworkError.Companion.fromChatErrorCode$default((ChatError.NetworkError.Companion)ChatError.NetworkError.Companion, (ChatErrorCode)ChatErrorCode.SOCKET_CLOSED, (int)0, null, (int)6, null)));
                }
            }
        };
        this.webSocket = (WebSocket)socketCreator.invoke((Object)this.webSocketListener);
        this.eventFlow = SharedFlowKt.MutableSharedFlow$default((int)0, (int)100, null, (int)5, null);
    }

    public final boolean send(@NotNull ChatEvent chatEvent) {
        Intrinsics.checkNotNullParameter((Object)chatEvent, (String)"chatEvent");
        return this.webSocket.send(this.parser.toJson(chatEvent));
    }

    public final boolean close() {
        return this.webSocket.close(1000, "Connection close by client");
    }

    @NotNull
    public final Flow<StreamWebSocketEvent> listen() {
        return (Flow)FlowKt.asSharedFlow(this.eventFlow);
    }

    private final StreamWebSocketEvent parseMessage(String text) {
        Result result;
        Result this_$iv = this.parser.fromJsonOrError(text, ChatEvent.class);
        boolean $i$f$map = false;
        Result $this$flatMap$iv$iv = this_$iv;
        boolean $i$f$flatMap = false;
        Result result2 = $this$flatMap$iv$iv;
        if (result2 instanceof Result.Success) {
            Object it$iv = ((Result.Success)$this$flatMap$iv$iv).getValue();
            boolean bl = false;
            ChatEvent it = (ChatEvent)it$iv;
            boolean bl2 = false;
            StreamWebSocketEvent.Message message = new StreamWebSocketEvent.Message(it);
            result = (Result)new Result.Success((Object)message);
        } else if (result2 instanceof Result.Failure) {
            result = $this$flatMap$iv$iv;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return (StreamWebSocketEvent)ResultKt.recover(result, (Function1)((Function1)new Function1<ChatError, StreamWebSocketEvent>(this, text){
            final /* synthetic */ StreamWebSocket this$0;
            final /* synthetic */ String $text;
            {
                this.this$0 = $receiver;
                this.$text = $text;
                super(1);
            }

            @NotNull
            public final StreamWebSocketEvent invoke(@NotNull ChatError parseChatError) {
                ChatError.NetworkError networkError;
                ErrorResponse errorResponse;
                ErrorResponse errorResponse2;
                Intrinsics.checkNotNullParameter((Object)parseChatError, (String)"parseChatError");
                Result<SocketErrorMessage> chatErrorResult = StreamWebSocket.access$getParser$p(this.this$0).fromJsonOrError(this.$text, SocketErrorMessage.class);
                if (chatErrorResult instanceof Result.Success) {
                    errorResponse2 = ((SocketErrorMessage)((Result.Success)chatErrorResult).getValue()).getError();
                } else if (chatErrorResult instanceof Result.Failure) {
                    errorResponse2 = null;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                ErrorResponse errorResponse3 = errorResponse = errorResponse2;
                if (errorResponse3 != null) {
                    ErrorResponse it = errorResponse3;
                    boolean bl = false;
                    String string2 = it.getMessage();
                    int n = it.getStatusCode();
                    int n2 = it.getCode();
                    networkError = new ChatError.NetworkError(string2, n2, n, null, 8, null);
                } else {
                    networkError = ChatError.NetworkError.Companion.fromChatErrorCode$default((ChatError.NetworkError.Companion)ChatError.NetworkError.Companion, (ChatErrorCode)ChatErrorCode.CANT_PARSE_EVENT, (int)0, (Throwable)ChatErrorKt.extractCause((ChatError)parseChatError), (int)2, null);
                }
                ChatError chatError = (ChatError)networkError;
                return new StreamWebSocketEvent.Error(chatError);
            }
        })).getValue();
    }

    public static final /* synthetic */ ChatParser access$getParser$p(StreamWebSocket $this) {
        return $this.parser;
    }

    public static final /* synthetic */ MutableSharedFlow access$getEventFlow$p(StreamWebSocket $this) {
        return $this.eventFlow;
    }

    public static final /* synthetic */ StreamWebSocketEvent access$parseMessage(StreamWebSocket $this, String text) {
        return $this.parseMessage(text);
    }
}

