/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.client.uploader;

import io.getstream.chat.android.client.api.RetrofitCdnApi;
import io.getstream.chat.android.client.api.models.UploadFileResponse;
import io.getstream.chat.android.client.api2.mapping.UploadFileResponseMappingKt;
import io.getstream.chat.android.client.extensions.FileExtensionsKt;
import io.getstream.chat.android.client.uploader.FileUploader;
import io.getstream.chat.android.client.utils.ProgressCallback;
import io.getstream.chat.android.client.utils.Result;
import io.getstream.chat.android.models.UploadedFile;
import io.getstream.chat.android.models.UploadedImage;
import java.io.File;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J.\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\tH\u0016J.\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\tH\u0016J.\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J6\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J.\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J6\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lio/getstream/chat/android/client/uploader/StreamFileUploader;", "Lio/getstream/chat/android/client/uploader/FileUploader;", "retrofitCdnApi", "Lio/getstream/chat/android/client/api/RetrofitCdnApi;", "(Lio/getstream/chat/android/client/api/RetrofitCdnApi;)V", "deleteFile", "Lio/getstream/chat/android/client/utils/Result;", "", "channelType", "", "channelId", "userId", "url", "deleteImage", "sendFile", "Lio/getstream/chat/android/models/UploadedFile;", "file", "Ljava/io/File;", "callback", "Lio/getstream/chat/android/client/utils/ProgressCallback;", "sendImage", "Lio/getstream/chat/android/models/UploadedImage;", "stream-chat-android-client_release"})
public final class StreamFileUploader
implements FileUploader {
    @NotNull
    private final RetrofitCdnApi retrofitCdnApi;

    public StreamFileUploader(@NotNull RetrofitCdnApi retrofitCdnApi) {
        Intrinsics.checkNotNullParameter((Object)retrofitCdnApi, (String)"retrofitCdnApi");
        this.retrofitCdnApi = retrofitCdnApi;
    }

    @Override
    @NotNull
    public Result<UploadedFile> sendFile(@NotNull String channelType, @NotNull String channelId, @NotNull String userId, @NotNull File file, @NotNull ProgressCallback callback2) {
        Result result;
        Intrinsics.checkNotNullParameter((Object)channelType, (String)"channelType");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
        RequestBody body = RequestBody.Companion.create(file, FileExtensionsKt.getMediaType(file));
        MultipartBody.Part part = MultipartBody.Part.Companion.createFormData("file", file.getName(), body);
        Result this_$iv = this.retrofitCdnApi.sendFile(channelType, channelId, part, callback2).execute();
        boolean $i$f$map = false;
        Result $this$flatMap$iv$iv = this_$iv;
        boolean $i$f$flatMap = false;
        Result result2 = $this$flatMap$iv$iv;
        if (result2 instanceof Result.Success) {
            Object it$iv = ((Result.Success)$this$flatMap$iv$iv).getValue();
            boolean bl = false;
            UploadFileResponse it = (UploadFileResponse)it$iv;
            boolean bl2 = false;
            UploadedFile uploadedFile = UploadFileResponseMappingKt.toUploadedFile(it);
            result = (Result)new Result.Success((Object)uploadedFile);
        } else if (result2 instanceof Result.Failure) {
            result = $this$flatMap$iv$iv;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return result;
    }

    @Override
    @NotNull
    public Result<UploadedFile> sendFile(@NotNull String channelType, @NotNull String channelId, @NotNull String userId, @NotNull File file) {
        Result result;
        Intrinsics.checkNotNullParameter((Object)channelType, (String)"channelType");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        RequestBody body = RequestBody.Companion.create(file, FileExtensionsKt.getMediaType(file));
        MultipartBody.Part part = MultipartBody.Part.Companion.createFormData("file", file.getName(), body);
        Result this_$iv = this.retrofitCdnApi.sendFile(channelType, channelId, part, null).execute();
        boolean $i$f$map = false;
        Result $this$flatMap$iv$iv = this_$iv;
        boolean $i$f$flatMap = false;
        Result result2 = $this$flatMap$iv$iv;
        if (result2 instanceof Result.Success) {
            Object it$iv = ((Result.Success)$this$flatMap$iv$iv).getValue();
            boolean bl = false;
            UploadFileResponse it = (UploadFileResponse)it$iv;
            boolean bl2 = false;
            UploadedFile uploadedFile = UploadFileResponseMappingKt.toUploadedFile(it);
            result = (Result)new Result.Success((Object)uploadedFile);
        } else if (result2 instanceof Result.Failure) {
            result = $this$flatMap$iv$iv;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return result;
    }

    @Override
    @NotNull
    public Result<UploadedImage> sendImage(@NotNull String channelType, @NotNull String channelId, @NotNull String userId, @NotNull File file, @NotNull ProgressCallback callback2) {
        Result result;
        Intrinsics.checkNotNullParameter((Object)channelType, (String)"channelType");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
        RequestBody body = RequestBody.Companion.create(file, FileExtensionsKt.getMediaType(file));
        MultipartBody.Part part = MultipartBody.Part.Companion.createFormData("file", file.getName(), body);
        Result this_$iv = this.retrofitCdnApi.sendImage(channelType, channelId, part, callback2).execute();
        boolean $i$f$map = false;
        Result $this$flatMap$iv$iv = this_$iv;
        boolean $i$f$flatMap = false;
        Result result2 = $this$flatMap$iv$iv;
        if (result2 instanceof Result.Success) {
            Object it$iv = ((Result.Success)$this$flatMap$iv$iv).getValue();
            boolean bl = false;
            UploadFileResponse it = (UploadFileResponse)it$iv;
            boolean bl2 = false;
            UploadedImage uploadedImage = new UploadedImage(it.getFile(), null, 2, null);
            result = (Result)new Result.Success((Object)uploadedImage);
        } else if (result2 instanceof Result.Failure) {
            result = $this$flatMap$iv$iv;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return result;
    }

    @Override
    @NotNull
    public Result<UploadedImage> sendImage(@NotNull String channelType, @NotNull String channelId, @NotNull String userId, @NotNull File file) {
        Result result;
        Intrinsics.checkNotNullParameter((Object)channelType, (String)"channelType");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        RequestBody body = RequestBody.Companion.create(file, FileExtensionsKt.getMediaType(file));
        MultipartBody.Part part = MultipartBody.Part.Companion.createFormData("file", file.getName(), body);
        Result this_$iv = this.retrofitCdnApi.sendImage(channelType, channelId, part, null).execute();
        boolean $i$f$map = false;
        Result $this$flatMap$iv$iv = this_$iv;
        boolean $i$f$flatMap = false;
        Result result2 = $this$flatMap$iv$iv;
        if (result2 instanceof Result.Success) {
            Object it$iv = ((Result.Success)$this$flatMap$iv$iv).getValue();
            boolean bl = false;
            UploadFileResponse it = (UploadFileResponse)it$iv;
            boolean bl2 = false;
            UploadedImage uploadedImage = new UploadedImage(it.getFile(), null, 2, null);
            result = (Result)new Result.Success((Object)uploadedImage);
        } else if (result2 instanceof Result.Failure) {
            result = $this$flatMap$iv$iv;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return result;
    }

    @Override
    @NotNull
    public Result<Unit> deleteFile(@NotNull String channelType, @NotNull String channelId, @NotNull String userId, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)channelType, (String)"channelType");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return this.retrofitCdnApi.deleteFile(channelType, channelId, url).execute().toUnitResult();
    }

    @Override
    @NotNull
    public Result<Unit> deleteImage(@NotNull String channelType, @NotNull String channelId, @NotNull String userId, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)channelType, (String)"channelType");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return this.retrofitCdnApi.deleteImage(channelType, channelId, url).execute().toUnitResult();
    }
}

