/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.client.utils.message;

import io.getstream.chat.android.core.internal.InternalStreamChatApi;
import io.getstream.chat.android.core.utils.date.DateUtils;
import io.getstream.chat.android.models.Message;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010 \n\u0000\u001a\u0014\u0010\u0002\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u001a\n\u0010\u0006\u001a\u00020\u0003*\u00020\u0004\u001a\n\u0010\u0007\u001a\u00020\u0003*\u00020\u0004\u001a\n\u0010\b\u001a\u00020\u0003*\u00020\u0004\u001a\n\u0010\t\u001a\u00020\u0003*\u00020\u0004\u001a\n\u0010\n\u001a\u00020\u0003*\u00020\u0004\u001a\n\u0010\u000b\u001a\u00020\u0003*\u00020\u0004\u001a\n\u0010\f\u001a\u00020\u0003*\u00020\u0004\u001a\n\u0010\r\u001a\u00020\u0003*\u00020\u0004\u001a\n\u0010\u000e\u001a\u00020\u0003*\u00020\u0004\u001a\n\u0010\u000f\u001a\u00020\u0003*\u00020\u0004\u001a\u0014\u0010\u0010\u001a\u0004\u0018\u00010\u0004*\b\u0012\u0004\u0012\u00020\u00040\u0011H\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"ITEM_COUNT_OF_TWO", "", "createdAfter", "", "Lio/getstream/chat/android/models/Message;", "that", "isDeleted", "isEphemeral", "isError", "isGiphy", "isGiphyEphemeral", "isRegular", "isReply", "isSystem", "isThreadReply", "isThreadStart", "latestOrNull", "", "stream-chat-android-client_release"})
@JvmName(name="MessageUtils")
public final class MessageUtils {
    private static final int ITEM_COUNT_OF_TWO = 2;

    /*
     * WARNING - void declaration
     */
    @InternalStreamChatApi
    @Nullable
    public static final Message latestOrNull(@NotNull List<Message> $this$latestOrNull) {
        Object object;
        Intrinsics.checkNotNullParameter($this$latestOrNull, (String)"<this>");
        if ($this$latestOrNull.size() >= 2) {
            void var1_1;
            Message first = (Message)CollectionsKt.first($this$latestOrNull);
            Message last = (Message)CollectionsKt.last($this$latestOrNull);
            object = MessageUtils.createdAfter(last, first) ? last : var1_1;
        } else {
            object = (Message)CollectionsKt.lastOrNull($this$latestOrNull);
        }
        return object;
    }

    @InternalStreamChatApi
    public static final boolean createdAfter(@NotNull Message $this$createdAfter, @NotNull Message that) {
        Date date;
        Date thisDate;
        Intrinsics.checkNotNullParameter((Object)$this$createdAfter, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)that, (String)"that");
        Date date2 = $this$createdAfter.getCreatedAt();
        if (date2 == null) {
            date2 = thisDate = $this$createdAfter.getCreatedLocallyAt();
        }
        if ((date = that.getCreatedAt()) == null) {
            date = that.getCreatedLocallyAt();
        }
        Date thatDate = date;
        return DateUtils.after((Date)thisDate, (Date)thatDate);
    }

    public static final boolean isDeleted(@NotNull Message $this$isDeleted) {
        Intrinsics.checkNotNullParameter((Object)$this$isDeleted, (String)"<this>");
        return $this$isDeleted.getDeletedAt() != null;
    }

    public static final boolean isRegular(@NotNull Message $this$isRegular) {
        Intrinsics.checkNotNullParameter((Object)$this$isRegular, (String)"<this>");
        return Intrinsics.areEqual((Object)$this$isRegular.getType(), (Object)"regular");
    }

    public static final boolean isEphemeral(@NotNull Message $this$isEphemeral) {
        Intrinsics.checkNotNullParameter((Object)$this$isEphemeral, (String)"<this>");
        return Intrinsics.areEqual((Object)$this$isEphemeral.getType(), (Object)"ephemeral");
    }

    public static final boolean isSystem(@NotNull Message $this$isSystem) {
        Intrinsics.checkNotNullParameter((Object)$this$isSystem, (String)"<this>");
        return Intrinsics.areEqual((Object)$this$isSystem.getType(), (Object)"system");
    }

    public static final boolean isError(@NotNull Message $this$isError) {
        Intrinsics.checkNotNullParameter((Object)$this$isError, (String)"<this>");
        return Intrinsics.areEqual((Object)$this$isError.getType(), (Object)"error");
    }

    public static final boolean isGiphy(@NotNull Message $this$isGiphy) {
        Intrinsics.checkNotNullParameter((Object)$this$isGiphy, (String)"<this>");
        return Intrinsics.areEqual((Object)$this$isGiphy.getCommand(), (Object)"giphy");
    }

    public static final boolean isGiphyEphemeral(@NotNull Message $this$isGiphyEphemeral) {
        Intrinsics.checkNotNullParameter((Object)$this$isGiphyEphemeral, (String)"<this>");
        return MessageUtils.isGiphy($this$isGiphyEphemeral) && MessageUtils.isEphemeral($this$isGiphyEphemeral);
    }

    public static final boolean isThreadStart(@NotNull Message $this$isThreadStart) {
        Intrinsics.checkNotNullParameter((Object)$this$isThreadStart, (String)"<this>");
        return !((Collection)$this$isThreadStart.getThreadParticipants()).isEmpty();
    }

    public static final boolean isThreadReply(@NotNull Message $this$isThreadReply) {
        Intrinsics.checkNotNullParameter((Object)$this$isThreadReply, (String)"<this>");
        CharSequence charSequence = $this$isThreadReply.getParentId();
        return !(charSequence == null || charSequence.length() == 0);
    }

    public static final boolean isReply(@NotNull Message $this$isReply) {
        Intrinsics.checkNotNullParameter((Object)$this$isReply, (String)"<this>");
        return $this$isReply.getReplyTo() != null;
    }
}

