/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.offline.repository.database;

import android.content.Context;
import android.os.Build;
import androidx.room.DatabaseConfiguration;
import androidx.room.InvalidationTracker;
import androidx.room.RoomDatabase;
import androidx.room.RoomOpenHelper;
import androidx.room.util.DBUtil;
import androidx.room.util.TableInfo;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import io.getstream.chat.android.offline.repository.database.ChatDatabase;
import io.getstream.chat.android.offline.repository.domain.channel.ChannelDao;
import io.getstream.chat.android.offline.repository.domain.channel.ChannelDao_Impl;
import io.getstream.chat.android.offline.repository.domain.channelconfig.ChannelConfigDao;
import io.getstream.chat.android.offline.repository.domain.channelconfig.ChannelConfigDao_Impl;
import io.getstream.chat.android.offline.repository.domain.message.MessageDao;
import io.getstream.chat.android.offline.repository.domain.message.MessageDao_Impl;
import io.getstream.chat.android.offline.repository.domain.message.attachment.AttachmentDao;
import io.getstream.chat.android.offline.repository.domain.message.attachment.AttachmentDao_Impl;
import io.getstream.chat.android.offline.repository.domain.queryChannels.QueryChannelsDao;
import io.getstream.chat.android.offline.repository.domain.queryChannels.QueryChannelsDao_Impl;
import io.getstream.chat.android.offline.repository.domain.reaction.ReactionDao;
import io.getstream.chat.android.offline.repository.domain.reaction.ReactionDao_Impl;
import io.getstream.chat.android.offline.repository.domain.syncState.SyncStateDao;
import io.getstream.chat.android.offline.repository.domain.syncState.SyncStateDao_Impl;
import io.getstream.chat.android.offline.repository.domain.user.UserDao;
import io.getstream.chat.android.offline.repository.domain.user.UserDao_Impl;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public final class ChatDatabase_Impl
extends ChatDatabase {
    private volatile QueryChannelsDao _queryChannelsDao;
    private volatile UserDao _userDao;
    private volatile ReactionDao _reactionDao;
    private volatile MessageDao _messageDao;
    private volatile ChannelDao _channelDao;
    private volatile ChannelConfigDao _channelConfigDao;
    private volatile SyncStateDao _syncStateDao;
    private volatile AttachmentDao _attachmentDao;

    protected SupportSQLiteOpenHelper createOpenHelper(DatabaseConfiguration configuration) {
        RoomOpenHelper _openCallback = new RoomOpenHelper(configuration, new RoomOpenHelper.Delegate(45){

            public void createAllTables(SupportSQLiteDatabase _db) {
                _db.execSQL("CREATE TABLE IF NOT EXISTS `stream_channel_query` (`id` TEXT NOT NULL, `filter` TEXT NOT NULL, `cids` TEXT NOT NULL, PRIMARY KEY(`id`))");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `channel_sort_inner_entity` (`name` TEXT NOT NULL, `direction` INTEGER NOT NULL, `queryId` TEXT NOT NULL, `id` TEXT NOT NULL, PRIMARY KEY(`id`))");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `stream_chat_message` (`id` TEXT NOT NULL, `cid` TEXT NOT NULL, `userId` TEXT NOT NULL, `text` TEXT NOT NULL, `html` TEXT NOT NULL, `type` TEXT NOT NULL, `syncStatus` INTEGER NOT NULL, `replyCount` INTEGER NOT NULL, `createdAt` INTEGER, `createdLocallyAt` INTEGER, `updatedAt` INTEGER, `updatedLocallyAt` INTEGER, `deletedAt` INTEGER, `mentionedUsersId` TEXT NOT NULL, `reactionCounts` TEXT NOT NULL, `reactionScores` TEXT NOT NULL, `parentId` TEXT, `command` TEXT, `shadowed` INTEGER NOT NULL, `showInChannel` INTEGER NOT NULL, `silent` INTEGER NOT NULL, `extraData` TEXT NOT NULL, `replyToId` TEXT, `threadParticipantsIds` TEXT NOT NULL, PRIMARY KEY(`id`))");
                _db.execSQL("CREATE INDEX IF NOT EXISTS `index_stream_chat_message_cid_createdAt` ON `stream_chat_message` (`cid`, `createdAt`)");
                _db.execSQL("CREATE INDEX IF NOT EXISTS `index_stream_chat_message_syncStatus` ON `stream_chat_message` (`syncStatus`)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `attachment_inner_entity` (`messageId` TEXT NOT NULL, `authorName` TEXT, `titleLink` TEXT, `thumbUrl` TEXT, `imageUrl` TEXT, `assetUrl` TEXT, `ogUrl` TEXT, `mimeType` TEXT, `fileSize` INTEGER NOT NULL, `title` TEXT, `text` TEXT, `type` TEXT, `image` TEXT, `url` TEXT, `name` TEXT, `fallback` TEXT, `uploadFilePath` TEXT, `extraData` TEXT NOT NULL, `id` INTEGER NOT NULL, `statusCode` INTEGER, `errorMessage` TEXT, PRIMARY KEY(`id`), FOREIGN KEY(`messageId`) REFERENCES `stream_chat_message`(`id`) ON UPDATE NO ACTION ON DELETE CASCADE DEFERRABLE INITIALLY DEFERRED)");
                _db.execSQL("CREATE INDEX IF NOT EXISTS `index_attachment_inner_entity_messageId` ON `attachment_inner_entity` (`messageId`)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `stream_chat_user` (`id` TEXT NOT NULL, `originalId` TEXT NOT NULL, `name` TEXT NOT NULL, `role` TEXT NOT NULL, `createdAt` INTEGER, `updatedAt` INTEGER, `lastActive` INTEGER, `invisible` INTEGER NOT NULL, `banned` INTEGER NOT NULL, `mutes` TEXT NOT NULL, `extraData` TEXT NOT NULL, PRIMARY KEY(`id`))");
                _db.execSQL("CREATE INDEX IF NOT EXISTS `index_stream_chat_user_name` ON `stream_chat_user` (`name`)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `stream_chat_reaction` (`messageId` TEXT NOT NULL, `userId` TEXT NOT NULL, `type` TEXT NOT NULL, `score` INTEGER NOT NULL, `createdAt` INTEGER, `updatedAt` INTEGER, `deletedAt` INTEGER, `enforceUnique` INTEGER NOT NULL, `extraData` TEXT NOT NULL, `syncStatus` INTEGER NOT NULL, `id` INTEGER NOT NULL, PRIMARY KEY(`id`), FOREIGN KEY(`messageId`) REFERENCES `stream_chat_message`(`id`) ON UPDATE NO ACTION ON DELETE CASCADE DEFERRABLE INITIALLY DEFERRED)");
                _db.execSQL("CREATE UNIQUE INDEX IF NOT EXISTS `index_stream_chat_reaction_messageId_userId_type` ON `stream_chat_reaction` (`messageId`, `userId`, `type`)");
                _db.execSQL("CREATE INDEX IF NOT EXISTS `index_stream_chat_reaction_syncStatus` ON `stream_chat_reaction` (`syncStatus`)");
                _db.execSQL("CREATE INDEX IF NOT EXISTS `index_stream_chat_reaction_messageId` ON `stream_chat_reaction` (`messageId`)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `stream_chat_channel_state` (`type` TEXT NOT NULL, `channelId` TEXT NOT NULL, `cooldown` INTEGER NOT NULL, `createdByUserId` TEXT NOT NULL, `frozen` INTEGER NOT NULL, `hidden` INTEGER, `hideMessagesBefore` INTEGER, `members` TEXT NOT NULL, `reads` TEXT NOT NULL, `lastMessageAt` INTEGER, `lastMessageId` TEXT, `createdAt` INTEGER, `updatedAt` INTEGER, `deletedAt` INTEGER, `extraData` TEXT NOT NULL, `syncStatus` INTEGER NOT NULL, `team` TEXT NOT NULL, `cid` TEXT NOT NULL, PRIMARY KEY(`cid`))");
                _db.execSQL("CREATE INDEX IF NOT EXISTS `index_stream_chat_channel_state_syncStatus` ON `stream_chat_channel_state` (`syncStatus`)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `stream_chat_channel_config` (`channelType` TEXT NOT NULL, `createdAt` INTEGER, `updatedAt` INTEGER, `name` TEXT NOT NULL, `isTypingEvents` INTEGER NOT NULL, `isReadEvents` INTEGER NOT NULL, `isConnectEvents` INTEGER NOT NULL, `isSearch` INTEGER NOT NULL, `isReactionsEnabled` INTEGER NOT NULL, `isRepliesEnabled` INTEGER NOT NULL, `isMutes` INTEGER NOT NULL, `uploadsEnabled` INTEGER NOT NULL, `urlEnrichmentEnabled` INTEGER NOT NULL, `customEventsEnabled` INTEGER NOT NULL, `pushNotificationsEnabled` INTEGER NOT NULL, `messageRetention` TEXT NOT NULL, `maxMessageLength` INTEGER NOT NULL, `automod` TEXT NOT NULL, `automodBehavior` TEXT NOT NULL, `blocklistBehavior` TEXT NOT NULL, PRIMARY KEY(`channelType`))");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `command_inner_entity` (`name` TEXT NOT NULL, `description` TEXT NOT NULL, `args` TEXT NOT NULL, `set` TEXT NOT NULL, `channelType` TEXT NOT NULL, `id` INTEGER NOT NULL, PRIMARY KEY(`id`), FOREIGN KEY(`channelType`) REFERENCES `stream_chat_channel_config`(`channelType`) ON UPDATE CASCADE ON DELETE CASCADE )");
                _db.execSQL("CREATE INDEX IF NOT EXISTS `index_command_inner_entity_channelType` ON `command_inner_entity` (`channelType`)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `stream_sync_state` (`userId` TEXT NOT NULL, `activeChannelIds` TEXT NOT NULL, `activeQueryIds` TEXT NOT NULL, `lastSyncedAt` INTEGER, `markedAllReadAt` INTEGER, PRIMARY KEY(`userId`))");
                _db.execSQL("CREATE TABLE IF NOT EXISTS room_master_table (id INTEGER PRIMARY KEY,identity_hash TEXT)");
                _db.execSQL("INSERT OR REPLACE INTO room_master_table (id,identity_hash) VALUES(42, 'c342f6bd05b03418085abf01587c2196')");
            }

            public void dropAllTables(SupportSQLiteDatabase _db) {
                _db.execSQL("DROP TABLE IF EXISTS `stream_channel_query`");
                _db.execSQL("DROP TABLE IF EXISTS `channel_sort_inner_entity`");
                _db.execSQL("DROP TABLE IF EXISTS `stream_chat_message`");
                _db.execSQL("DROP TABLE IF EXISTS `attachment_inner_entity`");
                _db.execSQL("DROP TABLE IF EXISTS `stream_chat_user`");
                _db.execSQL("DROP TABLE IF EXISTS `stream_chat_reaction`");
                _db.execSQL("DROP TABLE IF EXISTS `stream_chat_channel_state`");
                _db.execSQL("DROP TABLE IF EXISTS `stream_chat_channel_config`");
                _db.execSQL("DROP TABLE IF EXISTS `command_inner_entity`");
                _db.execSQL("DROP TABLE IF EXISTS `stream_sync_state`");
                if (ChatDatabase_Impl.this.mCallbacks != null) {
                    int _size = ChatDatabase_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)ChatDatabase_Impl.this.mCallbacks.get(_i)).onDestructiveMigration(_db);
                    }
                }
            }

            protected void onCreate(SupportSQLiteDatabase _db) {
                if (ChatDatabase_Impl.this.mCallbacks != null) {
                    int _size = ChatDatabase_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)ChatDatabase_Impl.this.mCallbacks.get(_i)).onCreate(_db);
                    }
                }
            }

            public void onOpen(SupportSQLiteDatabase _db) {
                ChatDatabase_Impl.this.mDatabase = _db;
                _db.execSQL("PRAGMA foreign_keys = ON");
                ChatDatabase_Impl.this.internalInitInvalidationTracker(_db);
                if (ChatDatabase_Impl.this.mCallbacks != null) {
                    int _size = ChatDatabase_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)ChatDatabase_Impl.this.mCallbacks.get(_i)).onOpen(_db);
                    }
                }
            }

            public void onPreMigrate(SupportSQLiteDatabase _db) {
                DBUtil.dropFtsSyncTriggers((SupportSQLiteDatabase)_db);
            }

            public void onPostMigrate(SupportSQLiteDatabase _db) {
            }

            protected RoomOpenHelper.ValidationResult onValidateSchema(SupportSQLiteDatabase _db) {
                HashMap<String, TableInfo.Column> _columnsStreamChannelQuery = new HashMap<String, TableInfo.Column>(3);
                _columnsStreamChannelQuery.put("id", new TableInfo.Column("id", "TEXT", true, 1, null, 1));
                _columnsStreamChannelQuery.put("filter", new TableInfo.Column("filter", "TEXT", true, 0, null, 1));
                _columnsStreamChannelQuery.put("cids", new TableInfo.Column("cids", "TEXT", true, 0, null, 1));
                HashSet _foreignKeysStreamChannelQuery = new HashSet(0);
                HashSet _indicesStreamChannelQuery = new HashSet(0);
                TableInfo _infoStreamChannelQuery = new TableInfo("stream_channel_query", _columnsStreamChannelQuery, _foreignKeysStreamChannelQuery, _indicesStreamChannelQuery);
                TableInfo _existingStreamChannelQuery = TableInfo.read((SupportSQLiteDatabase)_db, (String)"stream_channel_query");
                if (!_infoStreamChannelQuery.equals((Object)_existingStreamChannelQuery)) {
                    return new RoomOpenHelper.ValidationResult(false, "stream_channel_query(io.getstream.chat.android.offline.repository.domain.queryChannels.QueryChannelsEntity).\n Expected:\n" + _infoStreamChannelQuery + "\n Found:\n" + _existingStreamChannelQuery);
                }
                HashMap<String, TableInfo.Column> _columnsChannelSortInnerEntity = new HashMap<String, TableInfo.Column>(4);
                _columnsChannelSortInnerEntity.put("name", new TableInfo.Column("name", "TEXT", true, 0, null, 1));
                _columnsChannelSortInnerEntity.put("direction", new TableInfo.Column("direction", "INTEGER", true, 0, null, 1));
                _columnsChannelSortInnerEntity.put("queryId", new TableInfo.Column("queryId", "TEXT", true, 0, null, 1));
                _columnsChannelSortInnerEntity.put("id", new TableInfo.Column("id", "TEXT", true, 1, null, 1));
                HashSet _foreignKeysChannelSortInnerEntity = new HashSet(0);
                HashSet _indicesChannelSortInnerEntity = new HashSet(0);
                TableInfo _infoChannelSortInnerEntity = new TableInfo("channel_sort_inner_entity", _columnsChannelSortInnerEntity, _foreignKeysChannelSortInnerEntity, _indicesChannelSortInnerEntity);
                TableInfo _existingChannelSortInnerEntity = TableInfo.read((SupportSQLiteDatabase)_db, (String)"channel_sort_inner_entity");
                if (!_infoChannelSortInnerEntity.equals((Object)_existingChannelSortInnerEntity)) {
                    return new RoomOpenHelper.ValidationResult(false, "channel_sort_inner_entity(io.getstream.chat.android.offline.repository.domain.queryChannels.ChannelSortInnerEntity).\n Expected:\n" + _infoChannelSortInnerEntity + "\n Found:\n" + _existingChannelSortInnerEntity);
                }
                HashMap<String, TableInfo.Column> _columnsStreamChatMessage = new HashMap<String, TableInfo.Column>(24);
                _columnsStreamChatMessage.put("id", new TableInfo.Column("id", "TEXT", true, 1, null, 1));
                _columnsStreamChatMessage.put("cid", new TableInfo.Column("cid", "TEXT", true, 0, null, 1));
                _columnsStreamChatMessage.put("userId", new TableInfo.Column("userId", "TEXT", true, 0, null, 1));
                _columnsStreamChatMessage.put("text", new TableInfo.Column("text", "TEXT", true, 0, null, 1));
                _columnsStreamChatMessage.put("html", new TableInfo.Column("html", "TEXT", true, 0, null, 1));
                _columnsStreamChatMessage.put("type", new TableInfo.Column("type", "TEXT", true, 0, null, 1));
                _columnsStreamChatMessage.put("syncStatus", new TableInfo.Column("syncStatus", "INTEGER", true, 0, null, 1));
                _columnsStreamChatMessage.put("replyCount", new TableInfo.Column("replyCount", "INTEGER", true, 0, null, 1));
                _columnsStreamChatMessage.put("createdAt", new TableInfo.Column("createdAt", "INTEGER", false, 0, null, 1));
                _columnsStreamChatMessage.put("createdLocallyAt", new TableInfo.Column("createdLocallyAt", "INTEGER", false, 0, null, 1));
                _columnsStreamChatMessage.put("updatedAt", new TableInfo.Column("updatedAt", "INTEGER", false, 0, null, 1));
                _columnsStreamChatMessage.put("updatedLocallyAt", new TableInfo.Column("updatedLocallyAt", "INTEGER", false, 0, null, 1));
                _columnsStreamChatMessage.put("deletedAt", new TableInfo.Column("deletedAt", "INTEGER", false, 0, null, 1));
                _columnsStreamChatMessage.put("mentionedUsersId", new TableInfo.Column("mentionedUsersId", "TEXT", true, 0, null, 1));
                _columnsStreamChatMessage.put("reactionCounts", new TableInfo.Column("reactionCounts", "TEXT", true, 0, null, 1));
                _columnsStreamChatMessage.put("reactionScores", new TableInfo.Column("reactionScores", "TEXT", true, 0, null, 1));
                _columnsStreamChatMessage.put("parentId", new TableInfo.Column("parentId", "TEXT", false, 0, null, 1));
                _columnsStreamChatMessage.put("command", new TableInfo.Column("command", "TEXT", false, 0, null, 1));
                _columnsStreamChatMessage.put("shadowed", new TableInfo.Column("shadowed", "INTEGER", true, 0, null, 1));
                _columnsStreamChatMessage.put("showInChannel", new TableInfo.Column("showInChannel", "INTEGER", true, 0, null, 1));
                _columnsStreamChatMessage.put("silent", new TableInfo.Column("silent", "INTEGER", true, 0, null, 1));
                _columnsStreamChatMessage.put("extraData", new TableInfo.Column("extraData", "TEXT", true, 0, null, 1));
                _columnsStreamChatMessage.put("replyToId", new TableInfo.Column("replyToId", "TEXT", false, 0, null, 1));
                _columnsStreamChatMessage.put("threadParticipantsIds", new TableInfo.Column("threadParticipantsIds", "TEXT", true, 0, null, 1));
                HashSet _foreignKeysStreamChatMessage = new HashSet(0);
                HashSet<TableInfo.Index> _indicesStreamChatMessage = new HashSet<TableInfo.Index>(2);
                _indicesStreamChatMessage.add(new TableInfo.Index("index_stream_chat_message_cid_createdAt", false, Arrays.asList("cid", "createdAt")));
                _indicesStreamChatMessage.add(new TableInfo.Index("index_stream_chat_message_syncStatus", false, Arrays.asList("syncStatus")));
                TableInfo _infoStreamChatMessage = new TableInfo("stream_chat_message", _columnsStreamChatMessage, _foreignKeysStreamChatMessage, _indicesStreamChatMessage);
                TableInfo _existingStreamChatMessage = TableInfo.read((SupportSQLiteDatabase)_db, (String)"stream_chat_message");
                if (!_infoStreamChatMessage.equals((Object)_existingStreamChatMessage)) {
                    return new RoomOpenHelper.ValidationResult(false, "stream_chat_message(io.getstream.chat.android.offline.repository.domain.message.MessageInnerEntity).\n Expected:\n" + _infoStreamChatMessage + "\n Found:\n" + _existingStreamChatMessage);
                }
                HashMap<String, TableInfo.Column> _columnsAttachmentInnerEntity = new HashMap<String, TableInfo.Column>(21);
                _columnsAttachmentInnerEntity.put("messageId", new TableInfo.Column("messageId", "TEXT", true, 0, null, 1));
                _columnsAttachmentInnerEntity.put("authorName", new TableInfo.Column("authorName", "TEXT", false, 0, null, 1));
                _columnsAttachmentInnerEntity.put("titleLink", new TableInfo.Column("titleLink", "TEXT", false, 0, null, 1));
                _columnsAttachmentInnerEntity.put("thumbUrl", new TableInfo.Column("thumbUrl", "TEXT", false, 0, null, 1));
                _columnsAttachmentInnerEntity.put("imageUrl", new TableInfo.Column("imageUrl", "TEXT", false, 0, null, 1));
                _columnsAttachmentInnerEntity.put("assetUrl", new TableInfo.Column("assetUrl", "TEXT", false, 0, null, 1));
                _columnsAttachmentInnerEntity.put("ogUrl", new TableInfo.Column("ogUrl", "TEXT", false, 0, null, 1));
                _columnsAttachmentInnerEntity.put("mimeType", new TableInfo.Column("mimeType", "TEXT", false, 0, null, 1));
                _columnsAttachmentInnerEntity.put("fileSize", new TableInfo.Column("fileSize", "INTEGER", true, 0, null, 1));
                _columnsAttachmentInnerEntity.put("title", new TableInfo.Column("title", "TEXT", false, 0, null, 1));
                _columnsAttachmentInnerEntity.put("text", new TableInfo.Column("text", "TEXT", false, 0, null, 1));
                _columnsAttachmentInnerEntity.put("type", new TableInfo.Column("type", "TEXT", false, 0, null, 1));
                _columnsAttachmentInnerEntity.put("image", new TableInfo.Column("image", "TEXT", false, 0, null, 1));
                _columnsAttachmentInnerEntity.put("url", new TableInfo.Column("url", "TEXT", false, 0, null, 1));
                _columnsAttachmentInnerEntity.put("name", new TableInfo.Column("name", "TEXT", false, 0, null, 1));
                _columnsAttachmentInnerEntity.put("fallback", new TableInfo.Column("fallback", "TEXT", false, 0, null, 1));
                _columnsAttachmentInnerEntity.put("uploadFilePath", new TableInfo.Column("uploadFilePath", "TEXT", false, 0, null, 1));
                _columnsAttachmentInnerEntity.put("extraData", new TableInfo.Column("extraData", "TEXT", true, 0, null, 1));
                _columnsAttachmentInnerEntity.put("id", new TableInfo.Column("id", "INTEGER", true, 1, null, 1));
                _columnsAttachmentInnerEntity.put("statusCode", new TableInfo.Column("statusCode", "INTEGER", false, 0, null, 1));
                _columnsAttachmentInnerEntity.put("errorMessage", new TableInfo.Column("errorMessage", "TEXT", false, 0, null, 1));
                HashSet<TableInfo.ForeignKey> _foreignKeysAttachmentInnerEntity = new HashSet<TableInfo.ForeignKey>(1);
                _foreignKeysAttachmentInnerEntity.add(new TableInfo.ForeignKey("stream_chat_message", "CASCADE", "NO ACTION", Arrays.asList("messageId"), Arrays.asList("id")));
                HashSet<TableInfo.Index> _indicesAttachmentInnerEntity = new HashSet<TableInfo.Index>(1);
                _indicesAttachmentInnerEntity.add(new TableInfo.Index("index_attachment_inner_entity_messageId", false, Arrays.asList("messageId")));
                TableInfo _infoAttachmentInnerEntity = new TableInfo("attachment_inner_entity", _columnsAttachmentInnerEntity, _foreignKeysAttachmentInnerEntity, _indicesAttachmentInnerEntity);
                TableInfo _existingAttachmentInnerEntity = TableInfo.read((SupportSQLiteDatabase)_db, (String)"attachment_inner_entity");
                if (!_infoAttachmentInnerEntity.equals((Object)_existingAttachmentInnerEntity)) {
                    return new RoomOpenHelper.ValidationResult(false, "attachment_inner_entity(io.getstream.chat.android.offline.repository.domain.message.attachment.AttachmentEntity).\n Expected:\n" + _infoAttachmentInnerEntity + "\n Found:\n" + _existingAttachmentInnerEntity);
                }
                HashMap<String, TableInfo.Column> _columnsStreamChatUser = new HashMap<String, TableInfo.Column>(11);
                _columnsStreamChatUser.put("id", new TableInfo.Column("id", "TEXT", true, 1, null, 1));
                _columnsStreamChatUser.put("originalId", new TableInfo.Column("originalId", "TEXT", true, 0, null, 1));
                _columnsStreamChatUser.put("name", new TableInfo.Column("name", "TEXT", true, 0, null, 1));
                _columnsStreamChatUser.put("role", new TableInfo.Column("role", "TEXT", true, 0, null, 1));
                _columnsStreamChatUser.put("createdAt", new TableInfo.Column("createdAt", "INTEGER", false, 0, null, 1));
                _columnsStreamChatUser.put("updatedAt", new TableInfo.Column("updatedAt", "INTEGER", false, 0, null, 1));
                _columnsStreamChatUser.put("lastActive", new TableInfo.Column("lastActive", "INTEGER", false, 0, null, 1));
                _columnsStreamChatUser.put("invisible", new TableInfo.Column("invisible", "INTEGER", true, 0, null, 1));
                _columnsStreamChatUser.put("banned", new TableInfo.Column("banned", "INTEGER", true, 0, null, 1));
                _columnsStreamChatUser.put("mutes", new TableInfo.Column("mutes", "TEXT", true, 0, null, 1));
                _columnsStreamChatUser.put("extraData", new TableInfo.Column("extraData", "TEXT", true, 0, null, 1));
                HashSet _foreignKeysStreamChatUser = new HashSet(0);
                HashSet<TableInfo.Index> _indicesStreamChatUser = new HashSet<TableInfo.Index>(1);
                _indicesStreamChatUser.add(new TableInfo.Index("index_stream_chat_user_name", false, Arrays.asList("name")));
                TableInfo _infoStreamChatUser = new TableInfo("stream_chat_user", _columnsStreamChatUser, _foreignKeysStreamChatUser, _indicesStreamChatUser);
                TableInfo _existingStreamChatUser = TableInfo.read((SupportSQLiteDatabase)_db, (String)"stream_chat_user");
                if (!_infoStreamChatUser.equals((Object)_existingStreamChatUser)) {
                    return new RoomOpenHelper.ValidationResult(false, "stream_chat_user(io.getstream.chat.android.offline.repository.domain.user.UserEntity).\n Expected:\n" + _infoStreamChatUser + "\n Found:\n" + _existingStreamChatUser);
                }
                HashMap<String, TableInfo.Column> _columnsStreamChatReaction = new HashMap<String, TableInfo.Column>(11);
                _columnsStreamChatReaction.put("messageId", new TableInfo.Column("messageId", "TEXT", true, 0, null, 1));
                _columnsStreamChatReaction.put("userId", new TableInfo.Column("userId", "TEXT", true, 0, null, 1));
                _columnsStreamChatReaction.put("type", new TableInfo.Column("type", "TEXT", true, 0, null, 1));
                _columnsStreamChatReaction.put("score", new TableInfo.Column("score", "INTEGER", true, 0, null, 1));
                _columnsStreamChatReaction.put("createdAt", new TableInfo.Column("createdAt", "INTEGER", false, 0, null, 1));
                _columnsStreamChatReaction.put("updatedAt", new TableInfo.Column("updatedAt", "INTEGER", false, 0, null, 1));
                _columnsStreamChatReaction.put("deletedAt", new TableInfo.Column("deletedAt", "INTEGER", false, 0, null, 1));
                _columnsStreamChatReaction.put("enforceUnique", new TableInfo.Column("enforceUnique", "INTEGER", true, 0, null, 1));
                _columnsStreamChatReaction.put("extraData", new TableInfo.Column("extraData", "TEXT", true, 0, null, 1));
                _columnsStreamChatReaction.put("syncStatus", new TableInfo.Column("syncStatus", "INTEGER", true, 0, null, 1));
                _columnsStreamChatReaction.put("id", new TableInfo.Column("id", "INTEGER", true, 1, null, 1));
                HashSet<TableInfo.ForeignKey> _foreignKeysStreamChatReaction = new HashSet<TableInfo.ForeignKey>(1);
                _foreignKeysStreamChatReaction.add(new TableInfo.ForeignKey("stream_chat_message", "CASCADE", "NO ACTION", Arrays.asList("messageId"), Arrays.asList("id")));
                HashSet<TableInfo.Index> _indicesStreamChatReaction = new HashSet<TableInfo.Index>(3);
                _indicesStreamChatReaction.add(new TableInfo.Index("index_stream_chat_reaction_messageId_userId_type", true, Arrays.asList("messageId", "userId", "type")));
                _indicesStreamChatReaction.add(new TableInfo.Index("index_stream_chat_reaction_syncStatus", false, Arrays.asList("syncStatus")));
                _indicesStreamChatReaction.add(new TableInfo.Index("index_stream_chat_reaction_messageId", false, Arrays.asList("messageId")));
                TableInfo _infoStreamChatReaction = new TableInfo("stream_chat_reaction", _columnsStreamChatReaction, _foreignKeysStreamChatReaction, _indicesStreamChatReaction);
                TableInfo _existingStreamChatReaction = TableInfo.read((SupportSQLiteDatabase)_db, (String)"stream_chat_reaction");
                if (!_infoStreamChatReaction.equals((Object)_existingStreamChatReaction)) {
                    return new RoomOpenHelper.ValidationResult(false, "stream_chat_reaction(io.getstream.chat.android.offline.repository.domain.reaction.ReactionEntity).\n Expected:\n" + _infoStreamChatReaction + "\n Found:\n" + _existingStreamChatReaction);
                }
                HashMap<String, TableInfo.Column> _columnsStreamChatChannelState = new HashMap<String, TableInfo.Column>(18);
                _columnsStreamChatChannelState.put("type", new TableInfo.Column("type", "TEXT", true, 0, null, 1));
                _columnsStreamChatChannelState.put("channelId", new TableInfo.Column("channelId", "TEXT", true, 0, null, 1));
                _columnsStreamChatChannelState.put("cooldown", new TableInfo.Column("cooldown", "INTEGER", true, 0, null, 1));
                _columnsStreamChatChannelState.put("createdByUserId", new TableInfo.Column("createdByUserId", "TEXT", true, 0, null, 1));
                _columnsStreamChatChannelState.put("frozen", new TableInfo.Column("frozen", "INTEGER", true, 0, null, 1));
                _columnsStreamChatChannelState.put("hidden", new TableInfo.Column("hidden", "INTEGER", false, 0, null, 1));
                _columnsStreamChatChannelState.put("hideMessagesBefore", new TableInfo.Column("hideMessagesBefore", "INTEGER", false, 0, null, 1));
                _columnsStreamChatChannelState.put("members", new TableInfo.Column("members", "TEXT", true, 0, null, 1));
                _columnsStreamChatChannelState.put("reads", new TableInfo.Column("reads", "TEXT", true, 0, null, 1));
                _columnsStreamChatChannelState.put("lastMessageAt", new TableInfo.Column("lastMessageAt", "INTEGER", false, 0, null, 1));
                _columnsStreamChatChannelState.put("lastMessageId", new TableInfo.Column("lastMessageId", "TEXT", false, 0, null, 1));
                _columnsStreamChatChannelState.put("createdAt", new TableInfo.Column("createdAt", "INTEGER", false, 0, null, 1));
                _columnsStreamChatChannelState.put("updatedAt", new TableInfo.Column("updatedAt", "INTEGER", false, 0, null, 1));
                _columnsStreamChatChannelState.put("deletedAt", new TableInfo.Column("deletedAt", "INTEGER", false, 0, null, 1));
                _columnsStreamChatChannelState.put("extraData", new TableInfo.Column("extraData", "TEXT", true, 0, null, 1));
                _columnsStreamChatChannelState.put("syncStatus", new TableInfo.Column("syncStatus", "INTEGER", true, 0, null, 1));
                _columnsStreamChatChannelState.put("team", new TableInfo.Column("team", "TEXT", true, 0, null, 1));
                _columnsStreamChatChannelState.put("cid", new TableInfo.Column("cid", "TEXT", true, 1, null, 1));
                HashSet _foreignKeysStreamChatChannelState = new HashSet(0);
                HashSet<TableInfo.Index> _indicesStreamChatChannelState = new HashSet<TableInfo.Index>(1);
                _indicesStreamChatChannelState.add(new TableInfo.Index("index_stream_chat_channel_state_syncStatus", false, Arrays.asList("syncStatus")));
                TableInfo _infoStreamChatChannelState = new TableInfo("stream_chat_channel_state", _columnsStreamChatChannelState, _foreignKeysStreamChatChannelState, _indicesStreamChatChannelState);
                TableInfo _existingStreamChatChannelState = TableInfo.read((SupportSQLiteDatabase)_db, (String)"stream_chat_channel_state");
                if (!_infoStreamChatChannelState.equals((Object)_existingStreamChatChannelState)) {
                    return new RoomOpenHelper.ValidationResult(false, "stream_chat_channel_state(io.getstream.chat.android.offline.repository.domain.channel.ChannelEntity).\n Expected:\n" + _infoStreamChatChannelState + "\n Found:\n" + _existingStreamChatChannelState);
                }
                HashMap<String, TableInfo.Column> _columnsStreamChatChannelConfig = new HashMap<String, TableInfo.Column>(20);
                _columnsStreamChatChannelConfig.put("channelType", new TableInfo.Column("channelType", "TEXT", true, 1, null, 1));
                _columnsStreamChatChannelConfig.put("createdAt", new TableInfo.Column("createdAt", "INTEGER", false, 0, null, 1));
                _columnsStreamChatChannelConfig.put("updatedAt", new TableInfo.Column("updatedAt", "INTEGER", false, 0, null, 1));
                _columnsStreamChatChannelConfig.put("name", new TableInfo.Column("name", "TEXT", true, 0, null, 1));
                _columnsStreamChatChannelConfig.put("isTypingEvents", new TableInfo.Column("isTypingEvents", "INTEGER", true, 0, null, 1));
                _columnsStreamChatChannelConfig.put("isReadEvents", new TableInfo.Column("isReadEvents", "INTEGER", true, 0, null, 1));
                _columnsStreamChatChannelConfig.put("isConnectEvents", new TableInfo.Column("isConnectEvents", "INTEGER", true, 0, null, 1));
                _columnsStreamChatChannelConfig.put("isSearch", new TableInfo.Column("isSearch", "INTEGER", true, 0, null, 1));
                _columnsStreamChatChannelConfig.put("isReactionsEnabled", new TableInfo.Column("isReactionsEnabled", "INTEGER", true, 0, null, 1));
                _columnsStreamChatChannelConfig.put("isRepliesEnabled", new TableInfo.Column("isRepliesEnabled", "INTEGER", true, 0, null, 1));
                _columnsStreamChatChannelConfig.put("isMutes", new TableInfo.Column("isMutes", "INTEGER", true, 0, null, 1));
                _columnsStreamChatChannelConfig.put("uploadsEnabled", new TableInfo.Column("uploadsEnabled", "INTEGER", true, 0, null, 1));
                _columnsStreamChatChannelConfig.put("urlEnrichmentEnabled", new TableInfo.Column("urlEnrichmentEnabled", "INTEGER", true, 0, null, 1));
                _columnsStreamChatChannelConfig.put("customEventsEnabled", new TableInfo.Column("customEventsEnabled", "INTEGER", true, 0, null, 1));
                _columnsStreamChatChannelConfig.put("pushNotificationsEnabled", new TableInfo.Column("pushNotificationsEnabled", "INTEGER", true, 0, null, 1));
                _columnsStreamChatChannelConfig.put("messageRetention", new TableInfo.Column("messageRetention", "TEXT", true, 0, null, 1));
                _columnsStreamChatChannelConfig.put("maxMessageLength", new TableInfo.Column("maxMessageLength", "INTEGER", true, 0, null, 1));
                _columnsStreamChatChannelConfig.put("automod", new TableInfo.Column("automod", "TEXT", true, 0, null, 1));
                _columnsStreamChatChannelConfig.put("automodBehavior", new TableInfo.Column("automodBehavior", "TEXT", true, 0, null, 1));
                _columnsStreamChatChannelConfig.put("blocklistBehavior", new TableInfo.Column("blocklistBehavior", "TEXT", true, 0, null, 1));
                HashSet _foreignKeysStreamChatChannelConfig = new HashSet(0);
                HashSet _indicesStreamChatChannelConfig = new HashSet(0);
                TableInfo _infoStreamChatChannelConfig = new TableInfo("stream_chat_channel_config", _columnsStreamChatChannelConfig, _foreignKeysStreamChatChannelConfig, _indicesStreamChatChannelConfig);
                TableInfo _existingStreamChatChannelConfig = TableInfo.read((SupportSQLiteDatabase)_db, (String)"stream_chat_channel_config");
                if (!_infoStreamChatChannelConfig.equals((Object)_existingStreamChatChannelConfig)) {
                    return new RoomOpenHelper.ValidationResult(false, "stream_chat_channel_config(io.getstream.chat.android.offline.repository.domain.channelconfig.ChannelConfigInnerEntity).\n Expected:\n" + _infoStreamChatChannelConfig + "\n Found:\n" + _existingStreamChatChannelConfig);
                }
                HashMap<String, TableInfo.Column> _columnsCommandInnerEntity = new HashMap<String, TableInfo.Column>(6);
                _columnsCommandInnerEntity.put("name", new TableInfo.Column("name", "TEXT", true, 0, null, 1));
                _columnsCommandInnerEntity.put("description", new TableInfo.Column("description", "TEXT", true, 0, null, 1));
                _columnsCommandInnerEntity.put("args", new TableInfo.Column("args", "TEXT", true, 0, null, 1));
                _columnsCommandInnerEntity.put("set", new TableInfo.Column("set", "TEXT", true, 0, null, 1));
                _columnsCommandInnerEntity.put("channelType", new TableInfo.Column("channelType", "TEXT", true, 0, null, 1));
                _columnsCommandInnerEntity.put("id", new TableInfo.Column("id", "INTEGER", true, 1, null, 1));
                HashSet<TableInfo.ForeignKey> _foreignKeysCommandInnerEntity = new HashSet<TableInfo.ForeignKey>(1);
                _foreignKeysCommandInnerEntity.add(new TableInfo.ForeignKey("stream_chat_channel_config", "CASCADE", "CASCADE", Arrays.asList("channelType"), Arrays.asList("channelType")));
                HashSet<TableInfo.Index> _indicesCommandInnerEntity = new HashSet<TableInfo.Index>(1);
                _indicesCommandInnerEntity.add(new TableInfo.Index("index_command_inner_entity_channelType", false, Arrays.asList("channelType")));
                TableInfo _infoCommandInnerEntity = new TableInfo("command_inner_entity", _columnsCommandInnerEntity, _foreignKeysCommandInnerEntity, _indicesCommandInnerEntity);
                TableInfo _existingCommandInnerEntity = TableInfo.read((SupportSQLiteDatabase)_db, (String)"command_inner_entity");
                if (!_infoCommandInnerEntity.equals((Object)_existingCommandInnerEntity)) {
                    return new RoomOpenHelper.ValidationResult(false, "command_inner_entity(io.getstream.chat.android.offline.repository.domain.channelconfig.CommandInnerEntity).\n Expected:\n" + _infoCommandInnerEntity + "\n Found:\n" + _existingCommandInnerEntity);
                }
                HashMap<String, TableInfo.Column> _columnsStreamSyncState = new HashMap<String, TableInfo.Column>(5);
                _columnsStreamSyncState.put("userId", new TableInfo.Column("userId", "TEXT", true, 1, null, 1));
                _columnsStreamSyncState.put("activeChannelIds", new TableInfo.Column("activeChannelIds", "TEXT", true, 0, null, 1));
                _columnsStreamSyncState.put("activeQueryIds", new TableInfo.Column("activeQueryIds", "TEXT", true, 0, null, 1));
                _columnsStreamSyncState.put("lastSyncedAt", new TableInfo.Column("lastSyncedAt", "INTEGER", false, 0, null, 1));
                _columnsStreamSyncState.put("markedAllReadAt", new TableInfo.Column("markedAllReadAt", "INTEGER", false, 0, null, 1));
                HashSet _foreignKeysStreamSyncState = new HashSet(0);
                HashSet _indicesStreamSyncState = new HashSet(0);
                TableInfo _infoStreamSyncState = new TableInfo("stream_sync_state", _columnsStreamSyncState, _foreignKeysStreamSyncState, _indicesStreamSyncState);
                TableInfo _existingStreamSyncState = TableInfo.read((SupportSQLiteDatabase)_db, (String)"stream_sync_state");
                if (!_infoStreamSyncState.equals((Object)_existingStreamSyncState)) {
                    return new RoomOpenHelper.ValidationResult(false, "stream_sync_state(io.getstream.chat.android.offline.repository.domain.syncState.SyncStateEntity).\n Expected:\n" + _infoStreamSyncState + "\n Found:\n" + _existingStreamSyncState);
                }
                return new RoomOpenHelper.ValidationResult(true, null);
            }
        }, "c342f6bd05b03418085abf01587c2196", "0ca3e34258c4da41212b380d1a785a53");
        SupportSQLiteOpenHelper.Configuration _sqliteConfig = SupportSQLiteOpenHelper.Configuration.builder((Context)configuration.context).name(configuration.name).callback((SupportSQLiteOpenHelper.Callback)_openCallback).build();
        SupportSQLiteOpenHelper _helper = configuration.sqliteOpenHelperFactory.create(_sqliteConfig);
        return _helper;
    }

    protected InvalidationTracker createInvalidationTracker() {
        HashMap _shadowTablesMap = new HashMap(0);
        HashMap _viewTables = new HashMap(0);
        return new InvalidationTracker((RoomDatabase)this, _shadowTablesMap, _viewTables, new String[]{"stream_channel_query", "channel_sort_inner_entity", "stream_chat_message", "attachment_inner_entity", "stream_chat_user", "stream_chat_reaction", "stream_chat_channel_state", "stream_chat_channel_config", "command_inner_entity", "stream_sync_state"});
    }

    public void clearAllTables() {
        super.assertNotMainThread();
        SupportSQLiteDatabase _db = super.getOpenHelper().getWritableDatabase();
        boolean _supportsDeferForeignKeys = Build.VERSION.SDK_INT >= 21;
        try {
            if (!_supportsDeferForeignKeys) {
                _db.execSQL("PRAGMA foreign_keys = FALSE");
            }
            super.beginTransaction();
            if (_supportsDeferForeignKeys) {
                _db.execSQL("PRAGMA defer_foreign_keys = TRUE");
            }
            _db.execSQL("DELETE FROM `stream_channel_query`");
            _db.execSQL("DELETE FROM `channel_sort_inner_entity`");
            _db.execSQL("DELETE FROM `stream_chat_message`");
            _db.execSQL("DELETE FROM `attachment_inner_entity`");
            _db.execSQL("DELETE FROM `stream_chat_user`");
            _db.execSQL("DELETE FROM `stream_chat_reaction`");
            _db.execSQL("DELETE FROM `stream_chat_channel_state`");
            _db.execSQL("DELETE FROM `stream_chat_channel_config`");
            _db.execSQL("DELETE FROM `command_inner_entity`");
            _db.execSQL("DELETE FROM `stream_sync_state`");
            super.setTransactionSuccessful();
        }
        finally {
            super.endTransaction();
            if (!_supportsDeferForeignKeys) {
                _db.execSQL("PRAGMA foreign_keys = TRUE");
            }
            _db.query("PRAGMA wal_checkpoint(FULL)").close();
            if (!_db.inTransaction()) {
                _db.execSQL("VACUUM");
            }
        }
    }

    protected Map<Class<?>, List<Class<?>>> getRequiredTypeConverters() {
        HashMap _typeConvertersMap = new HashMap();
        _typeConvertersMap.put(QueryChannelsDao.class, QueryChannelsDao_Impl.getRequiredConverters());
        _typeConvertersMap.put(UserDao.class, UserDao_Impl.getRequiredConverters());
        _typeConvertersMap.put(ReactionDao.class, ReactionDao_Impl.getRequiredConverters());
        _typeConvertersMap.put(MessageDao.class, MessageDao_Impl.getRequiredConverters());
        _typeConvertersMap.put(ChannelDao.class, ChannelDao_Impl.getRequiredConverters());
        _typeConvertersMap.put(ChannelConfigDao.class, ChannelConfigDao_Impl.getRequiredConverters());
        _typeConvertersMap.put(SyncStateDao.class, SyncStateDao_Impl.getRequiredConverters());
        _typeConvertersMap.put(AttachmentDao.class, AttachmentDao_Impl.getRequiredConverters());
        return _typeConvertersMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryChannelsDao queryChannelsDao() {
        if (this._queryChannelsDao != null) {
            return this._queryChannelsDao;
        }
        ChatDatabase_Impl chatDatabase_Impl = this;
        synchronized (chatDatabase_Impl) {
            if (this._queryChannelsDao == null) {
                this._queryChannelsDao = new QueryChannelsDao_Impl(this);
            }
            return this._queryChannelsDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserDao userDao() {
        if (this._userDao != null) {
            return this._userDao;
        }
        ChatDatabase_Impl chatDatabase_Impl = this;
        synchronized (chatDatabase_Impl) {
            if (this._userDao == null) {
                this._userDao = new UserDao_Impl(this);
            }
            return this._userDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReactionDao reactionDao() {
        if (this._reactionDao != null) {
            return this._reactionDao;
        }
        ChatDatabase_Impl chatDatabase_Impl = this;
        synchronized (chatDatabase_Impl) {
            if (this._reactionDao == null) {
                this._reactionDao = new ReactionDao_Impl(this);
            }
            return this._reactionDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessageDao messageDao() {
        if (this._messageDao != null) {
            return this._messageDao;
        }
        ChatDatabase_Impl chatDatabase_Impl = this;
        synchronized (chatDatabase_Impl) {
            if (this._messageDao == null) {
                this._messageDao = new MessageDao_Impl(this);
            }
            return this._messageDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChannelDao channelStateDao() {
        if (this._channelDao != null) {
            return this._channelDao;
        }
        ChatDatabase_Impl chatDatabase_Impl = this;
        synchronized (chatDatabase_Impl) {
            if (this._channelDao == null) {
                this._channelDao = new ChannelDao_Impl(this);
            }
            return this._channelDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChannelConfigDao channelConfigDao() {
        if (this._channelConfigDao != null) {
            return this._channelConfigDao;
        }
        ChatDatabase_Impl chatDatabase_Impl = this;
        synchronized (chatDatabase_Impl) {
            if (this._channelConfigDao == null) {
                this._channelConfigDao = new ChannelConfigDao_Impl(this);
            }
            return this._channelConfigDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SyncStateDao syncStateDao() {
        if (this._syncStateDao != null) {
            return this._syncStateDao;
        }
        ChatDatabase_Impl chatDatabase_Impl = this;
        synchronized (chatDatabase_Impl) {
            if (this._syncStateDao == null) {
                this._syncStateDao = new SyncStateDao_Impl(this);
            }
            return this._syncStateDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AttachmentDao attachmentDao() {
        if (this._attachmentDao != null) {
            return this._attachmentDao;
        }
        ChatDatabase_Impl chatDatabase_Impl = this;
        synchronized (chatDatabase_Impl) {
            if (this._attachmentDao == null) {
                this._attachmentDao = new AttachmentDao_Impl(this);
            }
            return this._attachmentDao;
        }
    }
}

