package io.getstream.chat.android.offline.usecase

import androidx.annotation.CheckResult
import io.getstream.chat.android.client.call.Call
import io.getstream.chat.android.client.call.CoroutineCall
import io.getstream.chat.android.offline.ChatDomainImpl
import io.getstream.chat.android.offline.utils.validateCid

internal class Keystroke(private val domainImpl: ChatDomainImpl) {
    /**
     * Keystroke should be called whenever a user enters text into the message input
     * It automatically calls stopTyping when the user stops typing after 5 seconds.
     *
     * @param cid The full channel id i. e. messaging:123.
     * @param parentId Set this field to `message.id` to indicate that typing event is happening in a thread.
     *
     * @return True when a typing event was sent, false if it wasn't sent.
     */
    @CheckResult
    operator fun invoke(cid: String, parentId: String? = null): Call<Boolean> {
        validateCid(cid)

        val channelController = domainImpl.channel(cid)
        return CoroutineCall(domainImpl.scope) {
            channelController.keystroke(parentId)
        }
    }
}
