/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.offline.repository.domain.queryChannels;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import io.getstream.chat.android.client.api.models.FilterObject;
import io.getstream.chat.android.offline.repository.database.converter.FilterObjectConverter;
import io.getstream.chat.android.offline.repository.database.converter.ListConverter;
import io.getstream.chat.android.offline.repository.domain.queryChannels.QueryChannelsDao;
import io.getstream.chat.android.offline.repository.domain.queryChannels.QueryChannelsEntity;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

public final class QueryChannelsDao_Impl
extends QueryChannelsDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<QueryChannelsEntity> __insertionAdapterOfQueryChannelsEntity;
    private final FilterObjectConverter __filterObjectConverter = new FilterObjectConverter();
    private final ListConverter __listConverter = new ListConverter();

    public QueryChannelsDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfQueryChannelsEntity = new EntityInsertionAdapter<QueryChannelsEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `stream_channel_query` (`id`,`filter`,`cids`) VALUES (?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, QueryChannelsEntity value) {
                if (value.getId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getId());
                }
                String _tmp = QueryChannelsDao_Impl.this.__filterObjectConverter.objectToString(value.getFilter());
                if (_tmp == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, _tmp);
                }
                String _tmp_1 = QueryChannelsDao_Impl.this.__listConverter.stringListToString(value.getCids());
                if (_tmp_1 == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, _tmp_1);
                }
            }
        };
    }

    @Override
    public Object insert(final QueryChannelsEntity queryChannelsEntity, Continuation<? super Unit> continuation) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                QueryChannelsDao_Impl.this.__db.beginTransaction();
                try {
                    QueryChannelsDao_Impl.this.__insertionAdapterOfQueryChannelsEntity.insert((Object)queryChannelsEntity);
                    QueryChannelsDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    QueryChannelsDao_Impl.this.__db.endTransaction();
                }
            }
        }, continuation);
    }

    @Override
    public Object select(String id, Continuation<? super QueryChannelsEntity> continuation) {
        String _sql = "SELECT * FROM stream_channel_query WHERE stream_channel_query.id=?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM stream_channel_query WHERE stream_channel_query.id=?", (int)1);
        int _argIndex = 1;
        if (id == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, id);
        }
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (CancellationSignal)_cancellationSignal, (Callable)new Callable<QueryChannelsEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public QueryChannelsEntity call() throws Exception {
                QueryChannelsDao_Impl.this.__db.beginTransaction();
                try {
                    QueryChannelsEntity queryChannelsEntity;
                    Cursor _cursor = DBUtil.query((RoomDatabase)QueryChannelsDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                    try {
                        QueryChannelsEntity _result;
                        int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                        int _cursorIndexOfFilter = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"filter");
                        int _cursorIndexOfCids = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cids");
                        if (_cursor.moveToFirst()) {
                            String _tmpId = _cursor.isNull(_cursorIndexOfId) ? null : _cursor.getString(_cursorIndexOfId);
                            String _tmp = _cursor.isNull(_cursorIndexOfFilter) ? null : _cursor.getString(_cursorIndexOfFilter);
                            FilterObject _tmpFilter = QueryChannelsDao_Impl.this.__filterObjectConverter.stringToObject(_tmp);
                            String _tmp_1 = _cursor.isNull(_cursorIndexOfCids) ? null : _cursor.getString(_cursorIndexOfCids);
                            List<String> _tmpCids = QueryChannelsDao_Impl.this.__listConverter.stringToStringList(_tmp_1);
                            _result = new QueryChannelsEntity(_tmpId, _tmpFilter, _tmpCids);
                        } else {
                            _result = null;
                        }
                        QueryChannelsDao_Impl.this.__db.setTransactionSuccessful();
                        queryChannelsEntity = _result;
                    }
                    catch (Throwable throwable) {
                        _cursor.close();
                        _statement.release();
                        throw throwable;
                    }
                    _cursor.close();
                    _statement.release();
                    return queryChannelsEntity;
                }
                finally {
                    QueryChannelsDao_Impl.this.__db.endTransaction();
                }
            }
        }, continuation);
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

