/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.offline.repository.domain.channel;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import io.getstream.chat.android.client.utils.SyncStatus;
import io.getstream.chat.android.offline.repository.database.converter.DateConverter;
import io.getstream.chat.android.offline.repository.database.converter.ExtraDataConverter;
import io.getstream.chat.android.offline.repository.database.converter.ListConverter;
import io.getstream.chat.android.offline.repository.database.converter.MapConverter;
import io.getstream.chat.android.offline.repository.database.converter.SetConverter;
import io.getstream.chat.android.offline.repository.database.converter.SyncStatusConverter;
import io.getstream.chat.android.offline.repository.domain.channel.ChannelDao;
import io.getstream.chat.android.offline.repository.domain.channel.ChannelEntity;
import io.getstream.chat.android.offline.repository.domain.channel.member.MemberEntity;
import io.getstream.chat.android.offline.repository.domain.channel.userread.ChannelUserReadEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

public final class ChannelDao_Impl
implements ChannelDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<ChannelEntity> __insertionAdapterOfChannelEntity;
    private final DateConverter __dateConverter = new DateConverter();
    private final MapConverter __mapConverter = new MapConverter();
    private final ListConverter __listConverter = new ListConverter();
    private final ExtraDataConverter __extraDataConverter = new ExtraDataConverter();
    private final SyncStatusConverter __syncStatusConverter = new SyncStatusConverter();
    private final SetConverter __setConverter = new SetConverter();
    private final SharedSQLiteStatement __preparedStmtOfDelete;
    private final SharedSQLiteStatement __preparedStmtOfSetDeletedAt;
    private final SharedSQLiteStatement __preparedStmtOfSetHidden;
    private final SharedSQLiteStatement __preparedStmtOfSetHidden_1;

    public ChannelDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfChannelEntity = new EntityInsertionAdapter<ChannelEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `stream_chat_channel_state` (`type`,`channelId`,`cooldown`,`createdByUserId`,`frozen`,`hidden`,`hideMessagesBefore`,`members`,`memberCount`,`watcherIds`,`watcherCount`,`reads`,`lastMessageAt`,`lastMessageId`,`createdAt`,`updatedAt`,`deletedAt`,`extraData`,`syncStatus`,`team`,`ownCapabilities`,`cid`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, ChannelEntity value) {
                Integer _tmp_1;
                if (value.getType() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getType());
                }
                if (value.getChannelId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getChannelId());
                }
                stmt.bindLong(3, (long)value.getCooldown());
                if (value.getCreatedByUserId() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getCreatedByUserId());
                }
                int _tmp = value.getFrozen() ? 1 : 0;
                stmt.bindLong(5, (long)_tmp);
                Integer n = value.getHidden() == null ? null : (_tmp_1 = Integer.valueOf(value.getHidden() != false ? 1 : 0));
                if (_tmp_1 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindLong(6, (long)_tmp_1.intValue());
                }
                Long _tmp_2 = ChannelDao_Impl.this.__dateConverter.dateToTimestamp(value.getHideMessagesBefore());
                if (_tmp_2 == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindLong(7, _tmp_2.longValue());
                }
                String _tmp_3 = ChannelDao_Impl.this.__mapConverter.memberMapToString(value.getMembers());
                if (_tmp_3 == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, _tmp_3);
                }
                stmt.bindLong(9, (long)value.getMemberCount());
                String _tmp_4 = ChannelDao_Impl.this.__listConverter.stringListToString(value.getWatcherIds());
                if (_tmp_4 == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindString(10, _tmp_4);
                }
                stmt.bindLong(11, (long)value.getWatcherCount());
                String _tmp_5 = ChannelDao_Impl.this.__mapConverter.readMapToString(value.getReads());
                if (_tmp_5 == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindString(12, _tmp_5);
                }
                Long _tmp_6 = ChannelDao_Impl.this.__dateConverter.dateToTimestamp(value.getLastMessageAt());
                if (_tmp_6 == null) {
                    stmt.bindNull(13);
                } else {
                    stmt.bindLong(13, _tmp_6.longValue());
                }
                if (value.getLastMessageId() == null) {
                    stmt.bindNull(14);
                } else {
                    stmt.bindString(14, value.getLastMessageId());
                }
                Long _tmp_7 = ChannelDao_Impl.this.__dateConverter.dateToTimestamp(value.getCreatedAt());
                if (_tmp_7 == null) {
                    stmt.bindNull(15);
                } else {
                    stmt.bindLong(15, _tmp_7.longValue());
                }
                Long _tmp_8 = ChannelDao_Impl.this.__dateConverter.dateToTimestamp(value.getUpdatedAt());
                if (_tmp_8 == null) {
                    stmt.bindNull(16);
                } else {
                    stmt.bindLong(16, _tmp_8.longValue());
                }
                Long _tmp_9 = ChannelDao_Impl.this.__dateConverter.dateToTimestamp(value.getDeletedAt());
                if (_tmp_9 == null) {
                    stmt.bindNull(17);
                } else {
                    stmt.bindLong(17, _tmp_9.longValue());
                }
                String _tmp_10 = ChannelDao_Impl.this.__extraDataConverter.mapToString(value.getExtraData());
                if (_tmp_10 == null) {
                    stmt.bindNull(18);
                } else {
                    stmt.bindString(18, _tmp_10);
                }
                int _tmp_11 = ChannelDao_Impl.this.__syncStatusConverter.syncStatusToString(value.getSyncStatus());
                stmt.bindLong(19, (long)_tmp_11);
                if (value.getTeam() == null) {
                    stmt.bindNull(20);
                } else {
                    stmt.bindString(20, value.getTeam());
                }
                String _tmp_12 = ChannelDao_Impl.this.__setConverter.sortedSetToString(value.getOwnCapabilities());
                if (_tmp_12 == null) {
                    stmt.bindNull(21);
                } else {
                    stmt.bindString(21, _tmp_12);
                }
                if (value.getCid() == null) {
                    stmt.bindNull(22);
                } else {
                    stmt.bindString(22, value.getCid());
                }
            }
        };
        this.__preparedStmtOfDelete = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from stream_chat_channel_state WHERE cid = ?";
                return "DELETE from stream_chat_channel_state WHERE cid = ?";
            }
        };
        this.__preparedStmtOfSetDeletedAt = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE stream_chat_channel_state SET deletedAt = ? WHERE cid = ?";
                return "UPDATE stream_chat_channel_state SET deletedAt = ? WHERE cid = ?";
            }
        };
        this.__preparedStmtOfSetHidden = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE stream_chat_channel_state SET hidden = ?, hideMessagesBefore = ? WHERE cid = ?";
                return "UPDATE stream_chat_channel_state SET hidden = ?, hideMessagesBefore = ? WHERE cid = ?";
            }
        };
        this.__preparedStmtOfSetHidden_1 = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE stream_chat_channel_state SET hidden = ? WHERE cid = ?";
                return "UPDATE stream_chat_channel_state SET hidden = ? WHERE cid = ?";
            }
        };
    }

    @Override
    public Object insert(final ChannelEntity channelEntity, Continuation<? super Unit> continuation) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                ChannelDao_Impl.this.__db.beginTransaction();
                try {
                    ChannelDao_Impl.this.__insertionAdapterOfChannelEntity.insert((Object)channelEntity);
                    ChannelDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    ChannelDao_Impl.this.__db.endTransaction();
                }
            }
        }, continuation);
    }

    @Override
    public Object insertMany(final List<ChannelEntity> channelEntities, Continuation<? super Unit> continuation) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                ChannelDao_Impl.this.__db.beginTransaction();
                try {
                    ChannelDao_Impl.this.__insertionAdapterOfChannelEntity.insert((Iterable)channelEntities);
                    ChannelDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    ChannelDao_Impl.this.__db.endTransaction();
                }
            }
        }, continuation);
    }

    @Override
    public Object delete(final String cid, Continuation<? super Unit> continuation) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = ChannelDao_Impl.this.__preparedStmtOfDelete.acquire();
                int _argIndex = 1;
                if (cid == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, cid);
                }
                ChannelDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    ChannelDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    ChannelDao_Impl.this.__db.endTransaction();
                    ChannelDao_Impl.this.__preparedStmtOfDelete.release(_stmt);
                }
            }
        }, continuation);
    }

    @Override
    public Object setDeletedAt(final String cid, final Date deletedAt, Continuation<? super Unit> continuation) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = ChannelDao_Impl.this.__preparedStmtOfSetDeletedAt.acquire();
                int _argIndex = 1;
                Long _tmp = ChannelDao_Impl.this.__dateConverter.dateToTimestamp(deletedAt);
                if (_tmp == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindLong(_argIndex, _tmp.longValue());
                }
                _argIndex = 2;
                if (cid == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, cid);
                }
                ChannelDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    ChannelDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    ChannelDao_Impl.this.__db.endTransaction();
                    ChannelDao_Impl.this.__preparedStmtOfSetDeletedAt.release(_stmt);
                }
            }
        }, continuation);
    }

    @Override
    public Object setHidden(final String cid, final boolean hidden, final Date hideMessagesBefore, Continuation<? super Unit> continuation) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = ChannelDao_Impl.this.__preparedStmtOfSetHidden.acquire();
                int _argIndex = 1;
                int _tmp = hidden ? 1 : 0;
                _stmt.bindLong(_argIndex, (long)_tmp);
                _argIndex = 2;
                Long _tmp_1 = ChannelDao_Impl.this.__dateConverter.dateToTimestamp(hideMessagesBefore);
                if (_tmp_1 == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindLong(_argIndex, _tmp_1.longValue());
                }
                _argIndex = 3;
                if (cid == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, cid);
                }
                ChannelDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    ChannelDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    ChannelDao_Impl.this.__db.endTransaction();
                    ChannelDao_Impl.this.__preparedStmtOfSetHidden.release(_stmt);
                }
            }
        }, continuation);
    }

    @Override
    public Object setHidden(final String cid, final boolean hidden, Continuation<? super Unit> continuation) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = ChannelDao_Impl.this.__preparedStmtOfSetHidden_1.acquire();
                int _argIndex = 1;
                int _tmp = hidden ? 1 : 0;
                _stmt.bindLong(_argIndex, (long)_tmp);
                _argIndex = 2;
                if (cid == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, cid);
                }
                ChannelDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    ChannelDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    ChannelDao_Impl.this.__db.endTransaction();
                    ChannelDao_Impl.this.__preparedStmtOfSetHidden_1.release(_stmt);
                }
            }
        }, continuation);
    }

    @Override
    public Object selectAllCids(Continuation<? super List<String>> continuation) {
        String _sql = "SELECT cid FROM stream_chat_channel_state";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT cid FROM stream_chat_channel_state", (int)0);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<String>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<String> call() throws Exception {
                ChannelDao_Impl.this.__db.beginTransaction();
                try {
                    ArrayList<String> arrayList;
                    Cursor _cursor = DBUtil.query((RoomDatabase)ChannelDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                    try {
                        ArrayList<String> _result = new ArrayList<String>(_cursor.getCount());
                        while (_cursor.moveToNext()) {
                            String _item = _cursor.isNull(0) ? null : _cursor.getString(0);
                            _result.add(_item);
                        }
                        ChannelDao_Impl.this.__db.setTransactionSuccessful();
                        arrayList = _result;
                    }
                    catch (Throwable throwable) {
                        _cursor.close();
                        _statement.release();
                        throw throwable;
                    }
                    _cursor.close();
                    _statement.release();
                    return arrayList;
                }
                finally {
                    ChannelDao_Impl.this.__db.endTransaction();
                }
            }
        }, continuation);
    }

    @Override
    public Object selectSyncNeeded(SyncStatus syncStatus, Continuation<? super List<ChannelEntity>> continuation) {
        String _sql = "SELECT * FROM stream_chat_channel_state WHERE stream_chat_channel_state.syncStatus IN (?)";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM stream_chat_channel_state WHERE stream_chat_channel_state.syncStatus IN (?)", (int)1);
        int _argIndex = 1;
        int _tmp = this.__syncStatusConverter.syncStatusToString(syncStatus);
        _statement.bindLong(_argIndex, (long)_tmp);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<ChannelEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<ChannelEntity> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ChannelDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
                    int _cursorIndexOfChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelId");
                    int _cursorIndexOfCooldown = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cooldown");
                    int _cursorIndexOfCreatedByUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdByUserId");
                    int _cursorIndexOfFrozen = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"frozen");
                    int _cursorIndexOfHidden = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hidden");
                    int _cursorIndexOfHideMessagesBefore = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hideMessagesBefore");
                    int _cursorIndexOfMembers = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"members");
                    int _cursorIndexOfMemberCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"memberCount");
                    int _cursorIndexOfWatcherIds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"watcherIds");
                    int _cursorIndexOfWatcherCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"watcherCount");
                    int _cursorIndexOfReads = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reads");
                    int _cursorIndexOfLastMessageAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastMessageAt");
                    int _cursorIndexOfLastMessageId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastMessageId");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfDeletedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deletedAt");
                    int _cursorIndexOfExtraData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"extraData");
                    int _cursorIndexOfSyncStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncStatus");
                    int _cursorIndexOfTeam = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"team");
                    int _cursorIndexOfOwnCapabilities = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ownCapabilities");
                    int _cursorIndexOfCid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cid");
                    ArrayList<ChannelEntity> _result = new ArrayList<ChannelEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        String _tmpType = _cursor.isNull(_cursorIndexOfType) ? null : _cursor.getString(_cursorIndexOfType);
                        String _tmpChannelId = _cursor.isNull(_cursorIndexOfChannelId) ? null : _cursor.getString(_cursorIndexOfChannelId);
                        int _tmpCooldown = _cursor.getInt(_cursorIndexOfCooldown);
                        String _tmpCreatedByUserId = _cursor.isNull(_cursorIndexOfCreatedByUserId) ? null : _cursor.getString(_cursorIndexOfCreatedByUserId);
                        int _tmp_1 = _cursor.getInt(_cursorIndexOfFrozen);
                        boolean _tmpFrozen = _tmp_1 != 0;
                        Integer _tmp_2 = _cursor.isNull(_cursorIndexOfHidden) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfHidden));
                        Boolean _tmpHidden = _tmp_2 == null ? null : Boolean.valueOf(_tmp_2 != 0);
                        Long _tmp_3 = _cursor.isNull(_cursorIndexOfHideMessagesBefore) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfHideMessagesBefore));
                        Date _tmpHideMessagesBefore = ChannelDao_Impl.this.__dateConverter.fromTimestamp(_tmp_3);
                        String _tmp_4 = _cursor.isNull(_cursorIndexOfMembers) ? null : _cursor.getString(_cursorIndexOfMembers);
                        Map<String, MemberEntity> _tmpMembers = ChannelDao_Impl.this.__mapConverter.stringToMemberMap(_tmp_4);
                        int _tmpMemberCount = _cursor.getInt(_cursorIndexOfMemberCount);
                        String _tmp_5 = _cursor.isNull(_cursorIndexOfWatcherIds) ? null : _cursor.getString(_cursorIndexOfWatcherIds);
                        List<String> _tmpWatcherIds = ChannelDao_Impl.this.__listConverter.stringToStringList(_tmp_5);
                        int _tmpWatcherCount = _cursor.getInt(_cursorIndexOfWatcherCount);
                        String _tmp_6 = _cursor.isNull(_cursorIndexOfReads) ? null : _cursor.getString(_cursorIndexOfReads);
                        Map<String, ChannelUserReadEntity> _tmpReads = ChannelDao_Impl.this.__mapConverter.stringToReadMap(_tmp_6);
                        Long _tmp_7 = _cursor.isNull(_cursorIndexOfLastMessageAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfLastMessageAt));
                        Date _tmpLastMessageAt = ChannelDao_Impl.this.__dateConverter.fromTimestamp(_tmp_7);
                        String _tmpLastMessageId = _cursor.isNull(_cursorIndexOfLastMessageId) ? null : _cursor.getString(_cursorIndexOfLastMessageId);
                        Long _tmp_8 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfCreatedAt));
                        Date _tmpCreatedAt = ChannelDao_Impl.this.__dateConverter.fromTimestamp(_tmp_8);
                        Long _tmp_9 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfUpdatedAt));
                        Date _tmpUpdatedAt = ChannelDao_Impl.this.__dateConverter.fromTimestamp(_tmp_9);
                        Long _tmp_10 = _cursor.isNull(_cursorIndexOfDeletedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfDeletedAt));
                        Date _tmpDeletedAt = ChannelDao_Impl.this.__dateConverter.fromTimestamp(_tmp_10);
                        String _tmp_11 = _cursor.isNull(_cursorIndexOfExtraData) ? null : _cursor.getString(_cursorIndexOfExtraData);
                        Map<String, Object> _tmpExtraData = ChannelDao_Impl.this.__extraDataConverter.stringToMap(_tmp_11);
                        int _tmp_12 = _cursor.getInt(_cursorIndexOfSyncStatus);
                        SyncStatus _tmpSyncStatus = ChannelDao_Impl.this.__syncStatusConverter.stringToSyncStatus(_tmp_12);
                        String _tmpTeam = _cursor.isNull(_cursorIndexOfTeam) ? null : _cursor.getString(_cursorIndexOfTeam);
                        String _tmp_13 = _cursor.isNull(_cursorIndexOfOwnCapabilities) ? null : _cursor.getString(_cursorIndexOfOwnCapabilities);
                        Set<String> _tmpOwnCapabilities = ChannelDao_Impl.this.__setConverter.stringToSortedSet(_tmp_13);
                        ChannelEntity _item = new ChannelEntity(_tmpType, _tmpChannelId, _tmpCooldown, _tmpCreatedByUserId, _tmpFrozen, _tmpHidden, _tmpHideMessagesBefore, _tmpMembers, _tmpMemberCount, _tmpWatcherIds, _tmpWatcherCount, _tmpReads, _tmpLastMessageAt, _tmpLastMessageId, _tmpCreatedAt, _tmpUpdatedAt, _tmpDeletedAt, _tmpExtraData, _tmpSyncStatus, _tmpTeam, _tmpOwnCapabilities);
                        String _tmpCid = _cursor.isNull(_cursorIndexOfCid) ? null : _cursor.getString(_cursorIndexOfCid);
                        _item.setCid(_tmpCid);
                        _result.add(_item);
                    }
                    ArrayList<ChannelEntity> arrayList = _result;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, continuation);
    }

    @Override
    public Object select(List<String> cids2, Continuation<? super List<ChannelEntity>> continuation) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT * FROM stream_chat_channel_state WHERE stream_chat_channel_state.cid IN (");
        int _inputSize = cids2.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : cids2) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<ChannelEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<ChannelEntity> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ChannelDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
                    int _cursorIndexOfChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelId");
                    int _cursorIndexOfCooldown = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cooldown");
                    int _cursorIndexOfCreatedByUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdByUserId");
                    int _cursorIndexOfFrozen = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"frozen");
                    int _cursorIndexOfHidden = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hidden");
                    int _cursorIndexOfHideMessagesBefore = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hideMessagesBefore");
                    int _cursorIndexOfMembers = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"members");
                    int _cursorIndexOfMemberCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"memberCount");
                    int _cursorIndexOfWatcherIds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"watcherIds");
                    int _cursorIndexOfWatcherCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"watcherCount");
                    int _cursorIndexOfReads = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reads");
                    int _cursorIndexOfLastMessageAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastMessageAt");
                    int _cursorIndexOfLastMessageId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastMessageId");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfDeletedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deletedAt");
                    int _cursorIndexOfExtraData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"extraData");
                    int _cursorIndexOfSyncStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncStatus");
                    int _cursorIndexOfTeam = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"team");
                    int _cursorIndexOfOwnCapabilities = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ownCapabilities");
                    int _cursorIndexOfCid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cid");
                    ArrayList<ChannelEntity> _result = new ArrayList<ChannelEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        String _tmpType = _cursor.isNull(_cursorIndexOfType) ? null : _cursor.getString(_cursorIndexOfType);
                        String _tmpChannelId = _cursor.isNull(_cursorIndexOfChannelId) ? null : _cursor.getString(_cursorIndexOfChannelId);
                        int _tmpCooldown = _cursor.getInt(_cursorIndexOfCooldown);
                        String _tmpCreatedByUserId = _cursor.isNull(_cursorIndexOfCreatedByUserId) ? null : _cursor.getString(_cursorIndexOfCreatedByUserId);
                        int _tmp = _cursor.getInt(_cursorIndexOfFrozen);
                        boolean _tmpFrozen = _tmp != 0;
                        Integer _tmp_1 = _cursor.isNull(_cursorIndexOfHidden) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfHidden));
                        Boolean _tmpHidden = _tmp_1 == null ? null : Boolean.valueOf(_tmp_1 != 0);
                        Long _tmp_2 = _cursor.isNull(_cursorIndexOfHideMessagesBefore) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfHideMessagesBefore));
                        Date _tmpHideMessagesBefore = ChannelDao_Impl.this.__dateConverter.fromTimestamp(_tmp_2);
                        String _tmp_3 = _cursor.isNull(_cursorIndexOfMembers) ? null : _cursor.getString(_cursorIndexOfMembers);
                        Map<String, MemberEntity> _tmpMembers = ChannelDao_Impl.this.__mapConverter.stringToMemberMap(_tmp_3);
                        int _tmpMemberCount = _cursor.getInt(_cursorIndexOfMemberCount);
                        String _tmp_4 = _cursor.isNull(_cursorIndexOfWatcherIds) ? null : _cursor.getString(_cursorIndexOfWatcherIds);
                        List<String> _tmpWatcherIds = ChannelDao_Impl.this.__listConverter.stringToStringList(_tmp_4);
                        int _tmpWatcherCount = _cursor.getInt(_cursorIndexOfWatcherCount);
                        String _tmp_5 = _cursor.isNull(_cursorIndexOfReads) ? null : _cursor.getString(_cursorIndexOfReads);
                        Map<String, ChannelUserReadEntity> _tmpReads = ChannelDao_Impl.this.__mapConverter.stringToReadMap(_tmp_5);
                        Long _tmp_6 = _cursor.isNull(_cursorIndexOfLastMessageAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfLastMessageAt));
                        Date _tmpLastMessageAt = ChannelDao_Impl.this.__dateConverter.fromTimestamp(_tmp_6);
                        String _tmpLastMessageId = _cursor.isNull(_cursorIndexOfLastMessageId) ? null : _cursor.getString(_cursorIndexOfLastMessageId);
                        Long _tmp_7 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfCreatedAt));
                        Date _tmpCreatedAt = ChannelDao_Impl.this.__dateConverter.fromTimestamp(_tmp_7);
                        Long _tmp_8 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfUpdatedAt));
                        Date _tmpUpdatedAt = ChannelDao_Impl.this.__dateConverter.fromTimestamp(_tmp_8);
                        Long _tmp_9 = _cursor.isNull(_cursorIndexOfDeletedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfDeletedAt));
                        Date _tmpDeletedAt = ChannelDao_Impl.this.__dateConverter.fromTimestamp(_tmp_9);
                        String _tmp_10 = _cursor.isNull(_cursorIndexOfExtraData) ? null : _cursor.getString(_cursorIndexOfExtraData);
                        Map<String, Object> _tmpExtraData = ChannelDao_Impl.this.__extraDataConverter.stringToMap(_tmp_10);
                        int _tmp_11 = _cursor.getInt(_cursorIndexOfSyncStatus);
                        SyncStatus _tmpSyncStatus = ChannelDao_Impl.this.__syncStatusConverter.stringToSyncStatus(_tmp_11);
                        String _tmpTeam = _cursor.isNull(_cursorIndexOfTeam) ? null : _cursor.getString(_cursorIndexOfTeam);
                        String _tmp_12 = _cursor.isNull(_cursorIndexOfOwnCapabilities) ? null : _cursor.getString(_cursorIndexOfOwnCapabilities);
                        Set<String> _tmpOwnCapabilities = ChannelDao_Impl.this.__setConverter.stringToSortedSet(_tmp_12);
                        ChannelEntity _item_1 = new ChannelEntity(_tmpType, _tmpChannelId, _tmpCooldown, _tmpCreatedByUserId, _tmpFrozen, _tmpHidden, _tmpHideMessagesBefore, _tmpMembers, _tmpMemberCount, _tmpWatcherIds, _tmpWatcherCount, _tmpReads, _tmpLastMessageAt, _tmpLastMessageId, _tmpCreatedAt, _tmpUpdatedAt, _tmpDeletedAt, _tmpExtraData, _tmpSyncStatus, _tmpTeam, _tmpOwnCapabilities);
                        String _tmpCid = _cursor.isNull(_cursorIndexOfCid) ? null : _cursor.getString(_cursorIndexOfCid);
                        _item_1.setCid(_tmpCid);
                        _result.add(_item_1);
                    }
                    ArrayList<ChannelEntity> arrayList = _result;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, continuation);
    }

    @Override
    public Object select(String cid, Continuation<? super ChannelEntity> continuation) {
        String _sql = "SELECT * FROM stream_chat_channel_state WHERE stream_chat_channel_state.cid IN (?)";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM stream_chat_channel_state WHERE stream_chat_channel_state.cid IN (?)", (int)1);
        int _argIndex = 1;
        if (cid == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, cid);
        }
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<ChannelEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ChannelEntity call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ChannelDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    ChannelEntity _result;
                    int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
                    int _cursorIndexOfChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelId");
                    int _cursorIndexOfCooldown = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cooldown");
                    int _cursorIndexOfCreatedByUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdByUserId");
                    int _cursorIndexOfFrozen = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"frozen");
                    int _cursorIndexOfHidden = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hidden");
                    int _cursorIndexOfHideMessagesBefore = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hideMessagesBefore");
                    int _cursorIndexOfMembers = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"members");
                    int _cursorIndexOfMemberCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"memberCount");
                    int _cursorIndexOfWatcherIds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"watcherIds");
                    int _cursorIndexOfWatcherCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"watcherCount");
                    int _cursorIndexOfReads = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reads");
                    int _cursorIndexOfLastMessageAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastMessageAt");
                    int _cursorIndexOfLastMessageId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastMessageId");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfDeletedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deletedAt");
                    int _cursorIndexOfExtraData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"extraData");
                    int _cursorIndexOfSyncStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncStatus");
                    int _cursorIndexOfTeam = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"team");
                    int _cursorIndexOfOwnCapabilities = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ownCapabilities");
                    int _cursorIndexOfCid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cid");
                    if (_cursor.moveToFirst()) {
                        String _tmpType = _cursor.isNull(_cursorIndexOfType) ? null : _cursor.getString(_cursorIndexOfType);
                        String _tmpChannelId = _cursor.isNull(_cursorIndexOfChannelId) ? null : _cursor.getString(_cursorIndexOfChannelId);
                        int _tmpCooldown = _cursor.getInt(_cursorIndexOfCooldown);
                        String _tmpCreatedByUserId = _cursor.isNull(_cursorIndexOfCreatedByUserId) ? null : _cursor.getString(_cursorIndexOfCreatedByUserId);
                        int _tmp = _cursor.getInt(_cursorIndexOfFrozen);
                        boolean _tmpFrozen = _tmp != 0;
                        Integer _tmp_1 = _cursor.isNull(_cursorIndexOfHidden) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfHidden));
                        Boolean _tmpHidden = _tmp_1 == null ? null : Boolean.valueOf(_tmp_1 != 0);
                        Long _tmp_2 = _cursor.isNull(_cursorIndexOfHideMessagesBefore) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfHideMessagesBefore));
                        Date _tmpHideMessagesBefore = ChannelDao_Impl.this.__dateConverter.fromTimestamp(_tmp_2);
                        String _tmp_3 = _cursor.isNull(_cursorIndexOfMembers) ? null : _cursor.getString(_cursorIndexOfMembers);
                        Map<String, MemberEntity> _tmpMembers = ChannelDao_Impl.this.__mapConverter.stringToMemberMap(_tmp_3);
                        int _tmpMemberCount = _cursor.getInt(_cursorIndexOfMemberCount);
                        String _tmp_4 = _cursor.isNull(_cursorIndexOfWatcherIds) ? null : _cursor.getString(_cursorIndexOfWatcherIds);
                        List<String> _tmpWatcherIds = ChannelDao_Impl.this.__listConverter.stringToStringList(_tmp_4);
                        int _tmpWatcherCount = _cursor.getInt(_cursorIndexOfWatcherCount);
                        String _tmp_5 = _cursor.isNull(_cursorIndexOfReads) ? null : _cursor.getString(_cursorIndexOfReads);
                        Map<String, ChannelUserReadEntity> _tmpReads = ChannelDao_Impl.this.__mapConverter.stringToReadMap(_tmp_5);
                        Long _tmp_6 = _cursor.isNull(_cursorIndexOfLastMessageAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfLastMessageAt));
                        Date _tmpLastMessageAt = ChannelDao_Impl.this.__dateConverter.fromTimestamp(_tmp_6);
                        String _tmpLastMessageId = _cursor.isNull(_cursorIndexOfLastMessageId) ? null : _cursor.getString(_cursorIndexOfLastMessageId);
                        Long _tmp_7 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfCreatedAt));
                        Date _tmpCreatedAt = ChannelDao_Impl.this.__dateConverter.fromTimestamp(_tmp_7);
                        Long _tmp_8 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfUpdatedAt));
                        Date _tmpUpdatedAt = ChannelDao_Impl.this.__dateConverter.fromTimestamp(_tmp_8);
                        Long _tmp_9 = _cursor.isNull(_cursorIndexOfDeletedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfDeletedAt));
                        Date _tmpDeletedAt = ChannelDao_Impl.this.__dateConverter.fromTimestamp(_tmp_9);
                        String _tmp_10 = _cursor.isNull(_cursorIndexOfExtraData) ? null : _cursor.getString(_cursorIndexOfExtraData);
                        Map<String, Object> _tmpExtraData = ChannelDao_Impl.this.__extraDataConverter.stringToMap(_tmp_10);
                        int _tmp_11 = _cursor.getInt(_cursorIndexOfSyncStatus);
                        SyncStatus _tmpSyncStatus = ChannelDao_Impl.this.__syncStatusConverter.stringToSyncStatus(_tmp_11);
                        String _tmpTeam = _cursor.isNull(_cursorIndexOfTeam) ? null : _cursor.getString(_cursorIndexOfTeam);
                        String _tmp_12 = _cursor.isNull(_cursorIndexOfOwnCapabilities) ? null : _cursor.getString(_cursorIndexOfOwnCapabilities);
                        Set<String> _tmpOwnCapabilities = ChannelDao_Impl.this.__setConverter.stringToSortedSet(_tmp_12);
                        _result = new ChannelEntity(_tmpType, _tmpChannelId, _tmpCooldown, _tmpCreatedByUserId, _tmpFrozen, _tmpHidden, _tmpHideMessagesBefore, _tmpMembers, _tmpMemberCount, _tmpWatcherIds, _tmpWatcherCount, _tmpReads, _tmpLastMessageAt, _tmpLastMessageId, _tmpCreatedAt, _tmpUpdatedAt, _tmpDeletedAt, _tmpExtraData, _tmpSyncStatus, _tmpTeam, _tmpOwnCapabilities);
                        String _tmpCid = _cursor.isNull(_cursorIndexOfCid) ? null : _cursor.getString(_cursorIndexOfCid);
                        _result.setCid(_tmpCid);
                    } else {
                        _result = null;
                    }
                    ChannelEntity channelEntity = _result;
                    return channelEntity;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, continuation);
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

