/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.offline.service.sync;

import android.content.Context;
import androidx.work.Constraints;
import androidx.work.Data;
import androidx.work.ExistingWorkPolicy;
import androidx.work.ListenableWorker;
import androidx.work.NetworkType;
import androidx.work.OneTimeWorkRequest;
import androidx.work.WorkManager;
import androidx.work.WorkRequest;
import androidx.work.Worker;
import androidx.work.WorkerParameters;
import io.getstream.chat.android.client.ChatClient;
import io.getstream.chat.android.client.logger.ChatLogger;
import io.getstream.chat.android.client.logger.TaggedLogger;
import io.getstream.chat.android.client.utils.Result;
import io.getstream.chat.android.offline.extensions.ChatClientExtensions;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lio/getstream/chat/android/offline/service/sync/SyncMessagesWork;", "Landroidx/work/Worker;", "appContext", "Landroid/content/Context;", "workerParams", "Landroidx/work/WorkerParameters;", "(Landroid/content/Context;Landroidx/work/WorkerParameters;)V", "logger", "Lio/getstream/chat/android/client/logger/TaggedLogger;", "doWork", "Landroidx/work/ListenableWorker$Result;", "Companion", "stream-chat-android-offline_release"})
public final class SyncMessagesWork
extends Worker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TaggedLogger logger;
    @NotNull
    private static final String DATA_CID = "DATA_CID";
    @NotNull
    private static final String SYNC_MESSAGES_WORK_NAME = "SYNC_MESSAGES_WORK_NAME";

    public SyncMessagesWork(@NotNull Context appContext, @NotNull WorkerParameters workerParams) {
        Intrinsics.checkNotNullParameter((Object)appContext, (String)"appContext");
        Intrinsics.checkNotNullParameter((Object)workerParams, (String)"workerParams");
        super(appContext, workerParams);
        this.logger = ChatLogger.Companion.get((Object)"SyncMessagesWork");
    }

    @NotNull
    public ListenableWorker.Result doWork() {
        ListenableWorker.Result result2;
        String string = this.getInputData().getString(DATA_CID);
        Intrinsics.checkNotNull((Object)string);
        String string2 = string;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"inputData.getString(DATA_CID)!!");
        String cid = string2;
        Result result3 = ChatClientExtensions.replayEventsForActiveChannels(ChatClient.Companion.instance(), cid).execute();
        if (result3.isSuccess()) {
            this.logger.logD("Sync success.");
            ListenableWorker.Result result4 = ListenableWorker.Result.success();
            Intrinsics.checkNotNullExpressionValue((Object)result4, (String)"{\n            logger.log\u2026esult.success()\n        }");
            result2 = result4;
        } else {
            this.logger.logD("Sync failed.");
            ListenableWorker.Result result5 = ListenableWorker.Result.retry();
            Intrinsics.checkNotNullExpressionValue((Object)result5, (String)"{\n            logger.log\u2026 Result.retry()\n        }");
            result2 = result5;
        }
        return result2;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lio/getstream/chat/android/offline/service/sync/SyncMessagesWork$Companion;", "", "()V", "DATA_CID", "", "SYNC_MESSAGES_WORK_NAME", "cancel", "", "context", "Landroid/content/Context;", "start", "cid", "stream-chat-android-offline_release"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        public final void start(@NotNull Context context, @NotNull String cid) {
            void pairs$iv;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)cid, (String)"cid");
            Constraints constraints = new Constraints.Builder().setRequiredNetworkType(NetworkType.NOT_ROAMING).build();
            Intrinsics.checkNotNullExpressionValue((Object)constraints, (String)"Builder()\n              \u2026\n                .build()");
            Constraints constraints2 = constraints;
            boolean $i$f$OneTimeWorkRequestBuilder22 = false;
            Pair[] $i$f$OneTimeWorkRequestBuilder22 = new Pair[]{TuplesKt.to((Object)SyncMessagesWork.DATA_CID, (Object)cid)};
            OneTimeWorkRequest.Builder builder = (OneTimeWorkRequest.Builder)new OneTimeWorkRequest.Builder(SyncMessagesWork.class).setConstraints(constraints2);
            boolean $i$f$workDataOf = false;
            Data.Builder dataBuilder$iv = new Data.Builder();
            for (void pair$iv : pairs$iv) {
                dataBuilder$iv.put((String)pair$iv.getFirst(), pair$iv.getSecond());
            }
            Data data = dataBuilder$iv.build();
            Intrinsics.checkNotNullExpressionValue((Object)data, (String)"dataBuilder.build()");
            WorkRequest workRequest = ((OneTimeWorkRequest.Builder)builder.setInputData(data)).build();
            Intrinsics.checkNotNullExpressionValue((Object)workRequest, (String)"OneTimeWorkRequestBuilde\u2026\n                .build()");
            OneTimeWorkRequest syncMessagesWork = (OneTimeWorkRequest)workRequest;
            WorkManager.getInstance((Context)context).enqueueUniqueWork(SyncMessagesWork.SYNC_MESSAGES_WORK_NAME, ExistingWorkPolicy.REPLACE, syncMessagesWork);
        }

        public final void cancel(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            WorkManager.getInstance((Context)context).cancelUniqueWork(SyncMessagesWork.SYNC_MESSAGES_WORK_NAME);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

