/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.offline.experimental.channel.thread.logic;

import io.getstream.chat.android.client.errors.ChatError;
import io.getstream.chat.android.client.experimental.plugin.listeners.ThreadQueryListener;
import io.getstream.chat.android.client.logger.ChatLogger;
import io.getstream.chat.android.client.logger.TaggedLogger;
import io.getstream.chat.android.client.models.Message;
import io.getstream.chat.android.client.utils.Result;
import io.getstream.chat.android.core.ExperimentalStreamChatApi;
import io.getstream.chat.android.offline.experimental.channel.logic.ChannelLogic;
import io.getstream.chat.android.offline.experimental.channel.thread.state.ThreadMutableState;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.MutableStateFlow;
import org.jetbrains.annotations.NotNull;

@ExperimentalStreamChatApi
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\b\u0001\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J&\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J \u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J4\u0010\u0012\u001a\u00020\u000b2\u0012\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J,\u0010\u0018\u001a\u00020\u000b2\u0012\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\r\u0010\u0019\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\u001aJ)\u0010\u001b\u001a\u00020\u000b2\u0012\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u001cJ\u0013\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0000\u00a2\u0006\u0002\b\u001eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lio/getstream/chat/android/offline/experimental/channel/thread/logic/ThreadLogic;", "Lio/getstream/chat/android/client/experimental/plugin/listeners/ThreadQueryListener;", "mutableState", "Lio/getstream/chat/android/offline/experimental/channel/thread/state/ThreadMutableState;", "channelLogic", "Lio/getstream/chat/android/offline/experimental/channel/logic/ChannelLogic;", "(Lio/getstream/chat/android/offline/experimental/channel/thread/state/ThreadMutableState;Lio/getstream/chat/android/offline/experimental/channel/logic/ChannelLogic;)V", "logger", "Lio/getstream/chat/android/client/logger/TaggedLogger;", "onGetRepliesMorePrecondition", "Lio/getstream/chat/android/client/utils/Result;", "", "messageId", "", "firstId", "limit", "", "onGetRepliesMoreRequest", "onGetRepliesMoreResult", "result", "", "Lio/getstream/chat/android/client/models/Message;", "onGetRepliesPrecondition", "onGetRepliesRequest", "onGetRepliesResult", "onRequest", "onRequest$stream_chat_android_offline_release", "onResult", "onResult$stream_chat_android_offline_release", "precondition", "precondition$stream_chat_android_offline_release", "stream-chat-android-offline_release"})
public final class ThreadLogic
implements ThreadQueryListener {
    @NotNull
    private final ThreadMutableState mutableState;
    @NotNull
    private final ChannelLogic channelLogic;
    @NotNull
    private final TaggedLogger logger;

    public ThreadLogic(@NotNull ThreadMutableState mutableState, @NotNull ChannelLogic channelLogic) {
        Intrinsics.checkNotNullParameter((Object)mutableState, (String)"mutableState");
        Intrinsics.checkNotNullParameter((Object)channelLogic, (String)"channelLogic");
        this.mutableState = mutableState;
        this.channelLogic = channelLogic;
        this.logger = ChatLogger.Companion.get((Object)"ThreadLogic");
    }

    @NotNull
    public final Result<Unit> precondition$stream_chat_android_offline_release() {
        Result result2;
        if (((Boolean)this.mutableState.getLoadingOlderMessages().getValue()).booleanValue()) {
            String errorMsg = "already loading messages for this thread, ignoring the load more requests.";
            this.logger.logI(errorMsg);
            result2 = new Result(new ChatError(errorMsg, null, 2, null));
        } else {
            result2 = Result.Companion.success((Object)Unit.INSTANCE);
        }
        return result2;
    }

    public final void onRequest$stream_chat_android_offline_release() {
        this.mutableState.get_loadingOlderMessages$stream_chat_android_offline_release().setValue((Object)true);
    }

    public final void onResult$stream_chat_android_offline_release(@NotNull Result<List<Message>> result2, int limit) {
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        if (result2.isSuccess()) {
            List newMessages = (List)result2.data();
            this.channelLogic.upsertMessages$stream_chat_android_offline_release(newMessages);
            this.mutableState.get_endOfOlderMessages$stream_chat_android_offline_release().setValue((Object)(newMessages.size() < limit ? 1 : 0));
            MutableStateFlow<Message> mutableStateFlow = this.mutableState.get_oldestInThread$stream_chat_android_offline_release();
            Iterable $this$sortedBy$iv = newMessages;
            boolean $i$f$sortedBy = false;
            Message message = (Message)CollectionsKt.firstOrNull((List)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Message it = (Message)a;
                    boolean bl = false;
                    Comparable comparable = it.getCreatedAt();
                    it = (Message)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)it.getCreatedAt());
                }
            }));
            if (message == null) {
                message = (Message)this.mutableState.get_oldestInThread$stream_chat_android_offline_release().getValue();
            }
            mutableStateFlow.setValue((Object)message);
        }
        this.mutableState.get_loadingOlderMessages$stream_chat_android_offline_release().setValue((Object)false);
    }

    @NotNull
    public Result<Unit> onGetRepliesPrecondition(@NotNull String messageId, int limit) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        return this.precondition$stream_chat_android_offline_release();
    }

    public void onGetRepliesRequest(@NotNull String messageId, int limit) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        this.onRequest$stream_chat_android_offline_release();
    }

    public void onGetRepliesResult(@NotNull Result<List<Message>> result2, @NotNull String messageId, int limit) {
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        this.onResult$stream_chat_android_offline_release(result2, limit);
    }

    @NotNull
    public Result<Unit> onGetRepliesMorePrecondition(@NotNull String messageId, @NotNull String firstId, int limit) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Intrinsics.checkNotNullParameter((Object)firstId, (String)"firstId");
        return this.precondition$stream_chat_android_offline_release();
    }

    public void onGetRepliesMoreRequest(@NotNull String messageId, @NotNull String firstId, int limit) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Intrinsics.checkNotNullParameter((Object)firstId, (String)"firstId");
        this.onRequest$stream_chat_android_offline_release();
    }

    public void onGetRepliesMoreResult(@NotNull Result<List<Message>> result2, @NotNull String messageId, @NotNull String firstId, int limit) {
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Intrinsics.checkNotNullParameter((Object)firstId, (String)"firstId");
        this.onResult$stream_chat_android_offline_release(result2, limit);
    }
}

